/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBackingFileBuf;
import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcCallback;
import com.insightful.cnkjava.CNKProcCoxReg;
import com.insightful.cnkjava.CNKProcCoxRegPredict;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.SetRolesPanelBase;
import com.insightful.miner.SetSurvivalRolesPanel;
import com.insightful.miner.SortAndShuffle;
import com.insightful.miner.SurvivalDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class CoxRegressionEngineNode
extends EngineNode
implements CNKProcCallback {
    private String m_modelFilePath = null;
    private String[] m_sortedDataFilePath = new String[3];
    private int m_lastPass = 0;
    private String m_baseText = null;
    public static String BEGIN_SURVIVAL_MODEL = "  <SurvivalModel modelName=";
    public static String MODEL_TYPE_COXREGRESSION = "\"coxRegression\"";
    public static String MODEL_TYPE = " modelType=";
    public static String SURV_RESPONSE = "    <SurvResponse";
    public static String END_SURV_RESPONSE = "    </SurvResponse>\n";
    public static String ID_EQ = " id=";
    public static String TIME1_EQ = " stop=";
    public static String TIME2_EQ = " start=";
    public static String EVENT_EQ = " event=";
    public static String EVENT_CODES = "      <EventCodes";
    public static String FAILURE_EQ = " failure=";
    public static String RIGHT_CENSOR_EQ = " rightCensor=";
    public static String WEIGHTS_VALUE = "   <Weights value=";
    public static String STRATA_VALUE = "   <Strata value=";
    public static String BEGIN_LINEAR_MODEL = "   <LinearModel nterms=";
    public static String BEGIN_TERM = "      <Term name=";
    public static String TERMVAR_VALUE = "         <TermVar value=";
    public static String END_TERM = "      </Term>\n";
    public static String END_LINEAR_MODEL = "   </LinearModel>\n";
    public static String END_SURVIVAL_MODEL = " </SurvivalModel>\n";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    private void eraseModelFile() {
        if (this.m_modelFilePath == null) {
            return;
        }
        File modelFile = new File(this.m_modelFilePath);
        if (modelFile.exists()) {
            modelFile.delete();
        }
        this.m_modelFilePath = null;
    }

    private void eraseSortedDataFile(int k) {
        int i = k;
        if (k > 2 || k < 0) {
            i = 0;
            k = 2;
        }
        while (i <= k) {
            if (this.m_sortedDataFilePath[i] != null) {
                File dataFile = new File(this.m_sortedDataFilePath[i]);
                if (dataFile.exists()) {
                    dataFile.delete();
                }
                this.m_sortedDataFilePath[i] = null;
            }
            ++i;
        }
    }

    public void procExtractResults(CNKProc proc) {
        File modelFile;
        if (!(proc instanceof CNKProcCoxReg)) {
            return;
        }
        this.setNodeCache("model", null);
        this.eraseModelFile();
        try {
            modelFile = this.createWorkspaceTempFile("CoxReg", ".xml");
            this.m_modelFilePath = modelFile.getPath();
        }
        catch (IOException ex) {
            this.printlnError("could not create temporary file name: " + ex);
            return;
        }
        ((CNKProcCoxReg)proc).writeModelToFile(this.m_modelFilePath);
        modelFile = new File(this.m_modelFilePath);
        if (!modelFile.exists()) {
            this.eraseModelFile();
            this.printlnDebug("Cox regression xml file " + this.m_modelFilePath + " doesn't exist");
            return;
        }
        long totalBytes = modelFile.length();
        this.printlnInformation("reading Cox regression model xml file " + this.m_modelFilePath + " (" + totalBytes + " bytes)");
        XMLTree xt = null;
        try {
            xt = XMLTree.readFromFile(this.m_modelFilePath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.printlnError("error reading Cox regression model xml file " + this.m_modelFilePath + ": " + ex);
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("out of memory reading cache file " + this.m_modelFilePath + " (" + totalBytes + " bytes)");
        }
        if (xt == null) {
            this.eraseModelFile();
        }
        this.setNodeCache("model", xt);
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector depVars = PredictEngineNode.getDependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVars, indepVars);
        if (PredictEngineNode.propIsTrue("copyInputColumns", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, props) && props.getBoolean("timeDependentCovariates", false)) {
            try {
                XTMetaData md1 = this.getDataDictionayMetaData(md, props);
                Vector varNames = md1.getColumnNames();
                boolean gotId = false;
                boolean gotStart = false;
                for (String varName : varNames) {
                    String specialRole;
                    String roleName = md1.getColumnRole(varName);
                    if (roleName.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                        specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                        gotId |= specialRole.equals(SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG);
                        continue;
                    }
                    if (!roleName.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
                    specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                    gotStart |= specialRole.equals(SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return outputSpecs;
    }

    public static String xmlQuote(String str) {
        String val = "\"";
        StringTokenizer st = new StringTokenizer(str, "\"<>&", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                val = val + "&quot;";
                continue;
            }
            if (tok.equals("<")) {
                val = val + "&lt;";
                continue;
            }
            if (tok.equals(">")) {
                val = val + "&gt;";
                continue;
            }
            if (tok.equals("&")) {
                val = val + "&amp;";
                continue;
            }
            if (tok.equals("'")) {
                val = val + "&apos;";
                continue;
            }
            val = val + tok;
        }
        val = val + "\"";
        return val;
    }

    public String getModelType() {
        return MODEL_TYPE_COXREGRESSION;
    }

    protected String getModelAsString(XTMetaData md, XTProps props) throws Exception {
        String modelXML = this.getDataDictionayMetaData(md, props).writeToString();
        int i = modelXML.indexOf("</IMML>", 0);
        if (i > 0) {
            modelXML = modelXML.substring(0, i - 1);
            modelXML = modelXML + "\n";
        }
        modelXML = modelXML + BEGIN_SURVIVAL_MODEL + "\"" + this.getNodeName() + "\"";
        modelXML = modelXML + MODEL_TYPE + this.getModelType() + ">\n";
        modelXML = modelXML + this.getTermsAsString(md, props);
        modelXML = modelXML + END_SURVIVAL_MODEL;
        modelXML = modelXML + "</IMML>\n";
        return modelXML;
    }

    protected XTMetaData getDataDictionayMetaData(XTMetaData md, XTProps props) throws Exception {
        Vector varNames;
        String weights;
        Vector<String> allNames = new Vector<String>();
        String ID = "";
        String time1 = "";
        String time2 = "";
        String event = "";
        Vector roleVars = props.getSubProperties("columnRoles");
        for (String varName : roleVars) {
            String specialRole;
            String roleName = props.getValue(new String[]{"columnRoles", varName});
            if (roleName == null) continue;
            if (roleName.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                if (!specialRole.equals(SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG)) continue;
                ID = varName;
                continue;
            }
            if (!roleName.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
            if (specialRole.equals(SetSurvivalRolesPanel.EVENT_ROLE_ATTRIBUTE_TAG)) {
                event = varName;
                continue;
            }
            if (specialRole.equals(SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG)) {
                time1 = varName;
                continue;
            }
            if (!specialRole.equals(SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG)) continue;
            time2 = varName;
        }
        String strata = props.getValue("strataColumn");
        if (strata.length() > 0 && strata.charAt(0) != ' ') {
            if (ID.length() > 0 && strata.compareTo(ID) == 0) {
                throw new Exception("ID and strata cannot be the same variable: " + strata);
            }
            if (time1.length() > 0 && strata.compareTo(time1) == 0) {
                throw new Exception("stop time and strata cannot be the same variable: " + strata);
            }
            if (time2.length() > 0 && strata.compareTo(time2) == 0) {
                throw new Exception("start time and strata cannot be the same variable: " + strata);
            }
            if (event.length() > 0 && strata.compareTo(event) == 0) {
                throw new Exception("event and strata cannot be the same variable: " + strata);
            }
            allNames.add(strata);
        }
        if (ID.length() > 0) {
            if (time1.length() > 0 && ID.compareTo(time1) == 0) {
                throw new Exception("stop time and ID cannot be the same variable: " + ID);
            }
            if (time2.length() > 0 && ID.compareTo(time2) == 0) {
                throw new Exception("start time and ID cannot be the same variable: " + ID);
            }
            if (event.length() > 0 && ID.compareTo(event) == 0) {
                throw new Exception("event and ID cannot be the same variable: " + ID);
            }
            allNames.add(ID);
        }
        if (time1.length() > 0) {
            if (time2.length() > 0 && time1.compareTo(time2) == 0) {
                throw new Exception("start time and stop time cannot be the same variable: " + time1);
            }
            if (event.length() > 0 && time1.compareTo(event) == 0) {
                throw new Exception("event and stop time cannot be the same variable: " + time1);
            }
            allNames.add(time1);
        }
        if (time2.length() > 0) {
            if (event.length() > 0 && time2.compareTo(event) == 0) {
                throw new Exception("event and start time cannot be the same variable: " + time2);
            }
            allNames.add(time2);
        }
        if (event.length() > 0) {
            allNames.add(event);
        }
        if ((weights = props.getValue("weightedColumn")).length() > 0 && weights.charAt(0) != ' ') {
            if (ID.length() > 0 && weights.compareTo(ID) == 0) {
                throw new Exception("ID and weights cannot be the same variable: " + weights);
            }
            if (time1.length() > 0 && weights.compareTo(time1) == 0) {
                throw new Exception("stop time and weights cannot be the same variable: " + weights);
            }
            if (time2.length() > 0 && weights.compareTo(time2) == 0) {
                throw new Exception("start time and weights cannot be the same variable: " + weights);
            }
            if (event.length() > 0 && weights.compareTo(event) == 0) {
                throw new Exception("event and weights cannot be the same variable: " + weights);
            }
            allNames.add(weights);
        }
        if ((varNames = PredictEngineNode.getIndependentVars(props, md)).size() > 0) {
            allNames.addAll(varNames);
        }
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (int i = 0; i < varNames.size(); ++i) {
            String vari = (String)varNames.get(i);
            mdModel.setDataFieldRole(vari, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
            if (!mdModel.isCategoricalColumn(vari)) continue;
            Vector sorted = mdModel.getSortedCategoricalDataFieldLevels(vari);
            mdModel.reorderCategoricalLevels(vari, sorted);
        }
        if (ID.length() > 0) {
            mdModel.setDataFieldRole(ID, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG);
        }
        if (time1.length() > 0) {
            mdModel.setDataFieldRole(time1, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
        if (time2.length() > 0) {
            mdModel.setDataFieldRole(time2, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
        if (event.length() > 0) {
            mdModel.setDataFieldRole(event, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
        if (weights.length() > 0) {
            mdModel.setDataFieldRole(weights, "weights");
        }
        if (strata.length() > 0) {
            mdModel.setDataFieldRole(strata, "strata");
        }
        return mdModel;
    }

    public String getDataDictionaryAsString() throws Exception {
        return this.getDataDictionayMetaData(this.getInputMetaData(0), this.getNodeProperties()).writeToString();
    }

    protected String getTermsAsString(XTMetaData md, XTProps props) throws Exception {
        String strata;
        Vector roleVars = props.getSubProperties("columnRoles");
        String modelXML = "";
        Iterator iter = roleVars.iterator();
        modelXML = modelXML + SURV_RESPONSE;
        while (iter.hasNext()) {
            String specialRole;
            String varName = (String)iter.next();
            String roleName = props.getValue(new String[]{"columnRoles", varName});
            if (roleName == null) continue;
            if (roleName.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                if (!specialRole.equals(SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG)) continue;
                modelXML = modelXML + ID_EQ + CoxRegressionEngineNode.xmlQuote(varName);
                continue;
            }
            if (!roleName.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
            if (specialRole.equals(SetSurvivalRolesPanel.EVENT_ROLE_ATTRIBUTE_TAG)) {
                modelXML = modelXML + EVENT_EQ + CoxRegressionEngineNode.xmlQuote(varName);
                continue;
            }
            if (specialRole.equals(SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG)) {
                modelXML = modelXML + TIME1_EQ + CoxRegressionEngineNode.xmlQuote(varName);
                continue;
            }
            if (!specialRole.equals(SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG)) continue;
            modelXML = modelXML + TIME2_EQ + CoxRegressionEngineNode.xmlQuote(varName);
        }
        modelXML = modelXML + ">\n";
        modelXML = modelXML + EVENT_CODES;
        modelXML = modelXML + FAILURE_EQ + CoxRegressionEngineNode.xmlQuote(props.getValue(SurvivalDialog.FAILURE_CODE_ATTRIBUTE_TAG, SurvivalDialog.failureCodeDefault));
        modelXML = modelXML + RIGHT_CENSOR_EQ + CoxRegressionEngineNode.xmlQuote(props.getValue(SurvivalDialog.RIGHT_CENSOR_CODE_ATTRIBUTE_TAG, SurvivalDialog.rightCensorCodeDefault));
        modelXML = modelXML + "/>\n";
        modelXML = modelXML + END_SURV_RESPONSE;
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        Vector terms = props.getSubProperties("interactions");
        Vector excludeVars = SetRolesPanelBase.getVarsWithSpecials(props, "exclude");
        int nterms = varNames.size() + terms.size();
        modelXML = modelXML + BEGIN_LINEAR_MODEL + CoxRegressionEngineNode.xmlQuote(Integer.toString(nterms)) + ">\n";
        for (int i = 0; i < varNames.size(); ++i) {
            int j;
            String vari = (String)varNames.get(i);
            for (j = 0; j < excludeVars.size() && vari.toString().compareTo(excludeVars.get(j).toString()) != 0; ++j) {
            }
            if (j < excludeVars.size()) continue;
            modelXML = modelXML + BEGIN_TERM + CoxRegressionEngineNode.xmlQuote(vari) + ">\n";
            modelXML = modelXML + TERMVAR_VALUE + CoxRegressionEngineNode.xmlQuote((String)varNames.get(i)) + "/>\n";
            modelXML = modelXML + END_TERM;
        }
        String[] path = new String[2];
        path[0] = "interactions";
        for (int i = 0; i < terms.size(); ++i) {
            path[1] = (String)terms.get(i);
            Vector vars = props.getSubProperties(path);
            if (vars.size() < 1) continue;
            Vector order = props.getSubPropertyValues(path);
            modelXML = modelXML + BEGIN_TERM + CoxRegressionEngineNode.xmlQuote((String)terms.get(i)) + ">\n";
            for (int j = 0; j < vars.size(); ++j) {
                int ord = Integer.parseInt((String)order.get(j));
                for (int k = 0; k < ord; ++k) {
                    modelXML = modelXML + TERMVAR_VALUE + CoxRegressionEngineNode.xmlQuote((String)vars.get(j)) + "/>\n";
                }
            }
            modelXML = modelXML + END_TERM;
        }
        String weights = props.getValue("weightedColumn");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            for (int i = 0; i < varNames.size(); ++i) {
                if (weights.compareTo((String)varNames.get(i)) != 0) continue;
                throw new Exception("weights variable cannot also be an indepenent variable: " + weights);
            }
            modelXML = modelXML + WEIGHTS_VALUE + CoxRegressionEngineNode.xmlQuote(weights) + "/>\n";
        }
        if ((strata = props.getValue("strataColumn")).length() > 0 && strata.charAt(0) != ' ') {
            for (int i = 0; i < varNames.size(); ++i) {
                if (strata.compareTo((String)varNames.get(i)) != 0) continue;
                throw new Exception("strata variable cannot also be an indepenent variable: " + strata);
            }
            modelXML = modelXML + STRATA_VALUE + CoxRegressionEngineNode.xmlQuote(strata) + "/>\n";
        }
        modelXML = modelXML + END_LINEAR_MODEL;
        return modelXML;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        CNKBackingFileBuf buf;
        String msg;
        XTMetaData md;
        XTMetaData origMd = md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        XTMetaData md1 = this.getDataDictionayMetaData(md, props);
        Vector varNames = md1.getColumnNames();
        String startVar = null;
        String idVar = null;
        String strataVar = null;
        String stopVar = null;
        String eventVar = null;
        int nvar = 0;
        Vector<String> predictors = new Vector<String>();
        Vector<String> response = new Vector<String>();
        for (String varName : varNames) {
            String specialRole;
            String roleName = md1.getColumnRole(varName);
            String type = md1.getColumnType(varName);
            if (roleName.equals("strata")) {
                if (type.equals("categorical") || type.equals("string")) {
                    this.printlnError("for sorting the strata variable must be continuous");
                    return false;
                }
                strataVar = varName;
                ++nvar;
                continue;
            }
            if (roleName.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                if (!specialRole.equals(SetSurvivalRolesPanel.ID_ROLE_ATTRIBUTE_TAG)) continue;
                if (type.equals("categorical") || type.equals("string")) {
                    this.printlnError("for sorting the ID variable must be continuous");
                    return false;
                }
                idVar = varName;
                continue;
            }
            if (roleName.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                specialRole = props.getValue(new String[]{"columnRoles", "roleSpecials", varName});
                response.add(varName);
                if (specialRole.equals(SetSurvivalRolesPanel.TIME1_ROLE_ATTRIBUTE_TAG)) {
                    stopVar = varName;
                    ++nvar;
                } else if (specialRole.equals(SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG)) {
                    startVar = varName;
                }
                if (!specialRole.equals(SetSurvivalRolesPanel.EVENT_ROLE_ATTRIBUTE_TAG)) continue;
                eventVar = varName;
                ++nvar;
                continue;
            }
            if (!roleName.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            predictors.add(varName);
        }
        if (stopVar == null) {
            this.printlnError("no failure time specified");
            return false;
        }
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, response, predictors);
        int iFile = 0;
        int nInputs = 1;
        if (PredictEngineNode.propIsTrue("copyInputColumns", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, props) && props.getBoolean("timeDependentCovariates", false) && startVar == null) {
            if (idVar == null) {
                this.printlnError("must have an ID variable when no stop time is specified and covariates are time dependent");
                return false;
            }
            iFile = 2;
            ++nInputs;
        } else if (startVar != null) {
            ++nInputs;
            iFile = 1;
        }
        this.m_baseText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        this.eraseSortedDataFile(-1);
        String inputCacheFileName = this.getInputDataCacheFileName(0);
        File unsortedFile = new File(inputCacheFileName);
        boolean ok = true;
        this.m_lastPass = 0;
        while (iFile >= 0) {
            String[] sortColumnOrder = new String[nvar];
            String[] varType = new String[nvar];
            boolean[] sortAscending = new boolean[nvar];
            boolean[] sortNAatTop = new boolean[nvar];
            int k = 0;
            if (iFile == 2) {
                sortAscending[k] = true;
                sortNAatTop[k] = true;
                varType[k] = " ID=";
                sortColumnOrder[k++] = idVar;
            }
            if (strataVar != null) {
                sortAscending[k] = true;
                sortNAatTop[k] = true;
                varType[k] = " strata=";
                sortColumnOrder[k++] = strataVar;
            }
            sortNAatTop[k] = true;
            if (iFile == 1) {
                varType[k] = " start=";
                sortColumnOrder[k++] = startVar;
            } else {
                varType[k] = " stop=";
                sortAscending[k] = iFile == 2;
                sortColumnOrder[k++] = stopVar;
            }
            if (iFile != 2) {
                varType[k] = "event=";
                sortColumnOrder[k] = eventVar;
                String failure = props.getValue(SurvivalDialog.FAILURE_CODE_ATTRIBUTE_TAG, SurvivalDialog.failureCodeDefault);
                String censor = props.getValue(SurvivalDialog.RIGHT_CENSOR_CODE_ATTRIBUTE_TAG, SurvivalDialog.rightCensorCodeDefault);
                String etype = md.getColumnType(eventVar);
                if (failure.equals(censor)) {
                    this.printlnError("failure code cannot equal censor code");
                    return false;
                }
                if (etype.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    try {
                        double df = Double.parseDouble(failure);
                        double dc = Double.parseDouble(censor);
                        if (df < md.getColumnMin(failure) || df > md.getColumnMax(failure)) {
                            throw new Exception("failure code is not in the range of values for column " + failure);
                        }
                        if (dc < md.getColumnMin(censor) || dc > md.getColumnMax(censor)) {
                            throw new Exception("censor code is not in the range of values for column " + censor);
                        }
                        sortAscending[k] = df > dc;
                    }
                    catch (NumberFormatException e) {
                        this.printlnError("invalid censor and/or event codes: " + censor + ", " + failure);
                        return false;
                    }
                    catch (Exception e) {
                        this.printlnError("invalid censor and/or event codes: " + e);
                        return false;
                    }
                } else if (etype.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    Vector levels = md.getCategoricalDataFieldLevels(eventVar);
                    if (levels.indexOf(censor) == -1) {
                        this.printlnError("censor code " + censor + " is not one of the class values of event variable " + eventVar);
                        return false;
                    }
                    if (levels.indexOf(failure) == -1) {
                        this.printlnError("failure code " + failure + " is not one of the class values of event variable " + eventVar);
                        return false;
                    }
                    sortAscending[k] = failure.compareTo(censor) > 0;
                } else {
                    this.printlnError("Invalid type for event variable " + eventVar + ": " + etype);
                    return false;
                }
            }
            boolean alphabetical = false;
            File sortedFile = null;
            try {
                sortedFile = this.createWorkspaceTempFile("CoxReg", ".dcf");
            }
            catch (IOException ex) {
                this.printlnError("failed to create temporary file name: " + ex);
                return false;
            }
            msg = this.m_baseText + ": Sorting on";
            for (int i = 0; i < varType.length; ++i) {
                msg = msg + varType[i] + sortColumnOrder[i];
            }
            if (++this.m_lastPass == 1) {
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{msg});
            } else {
                this.updateProgressIndicator(0, this.m_lastPass, msg);
            }
            int rowChunkSize = this.getMaxRowsPerBlock();
            ok = SortAndShuffle.sortBase(unsortedFile, sortedFile, md, (EngineNode)this, rowChunkSize, sortColumnOrder, sortAscending, sortNAatTop, alphabetical, true, false);
            if (!ok) {
                sortedFile.delete();
                unsortedFile.delete();
                this.printlnError("sorting failed");
                return ok;
            }
            if (iFile == 2) {
                File newFile = null;
                try {
                    newFile = this.createWorkspaceTempFile("CoxReg", ".dcf");
                    XTMetaData newMd = new XTMetaData(md);
                    startVar = new String("_start_");
                    newMd.appendContinousDataField(startVar);
                    newMd.setDataFieldRole(startVar, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                    newMd.appendNumericInfo(startVar, newMd.getColumnMean(stopVar), newMd.getColumnMin(stopVar), newMd.getColumnMax(stopVar), newMd.getColumnStandardDeviation(stopVar), 0.0, CNKBuf.getDoubleNA());
                    newMd.appendCounts(startVar, (long)newMd.getColumnRowCount(stopVar), (long)newMd.getColumnMissingCount(stopVar));
                    msg = this.m_baseText + ": Creating start column for time dependent covariates";
                    this.updateProgressIndicator(0, ++this.m_lastPass, msg);
                    ok = this.createStartColumn(sortedFile, md, newMd, stopVar, startVar, idVar, newFile);
                    md = newMd;
                    props = new XTProps(props);
                    props.set("columnRoles", "_start_", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                    props.set(new String[]{"columnRoles", "roleSpecials", "_start_"}, SetSurvivalRolesPanel.TIME2_ROLE_ATTRIBUTE_TAG);
                    response.add(new String("_start_"));
                    unsortedFile = newFile;
                    this.m_sortedDataFilePath[iFile] = new String(newFile.getPath());
                    sortedFile.delete();
                }
                catch (IOException ex) {
                    this.printlnError("failed to create temporary file name: " + ex);
                    sortedFile.delete();
                    unsortedFile.delete();
                    return false;
                }
                catch (Exception ex) {
                    this.printlnError("failed to create start column");
                    sortedFile.delete();
                    unsortedFile.delete();
                    return false;
                }
            } else {
                this.m_sortedDataFilePath[iFile] = new String(sortedFile.getPath());
            }
            --iFile;
        }
        CNKBackingFileBuf[] inBufs = new CNKBackingFileBuf[nInputs];
        for (int i = 0; i < nInputs; ++i) {
            buf = new CNKBackingFileBuf();
            EngineNetworkManager.setBufColumnDescription(buf, md, this.getNetworkManager().getMaxCategoricalLevels());
            this.printlnDebug("node=" + this.getNodeName() + ", input=0, data cache=" + this.m_sortedDataFilePath[i]);
            buf.setFileName(this.m_sortedDataFilePath[i]);
            buf.setBackingFileRows(md.getNumRows());
            inBufs[i] = buf;
        }
        this.resetProgressDone();
        msg = this.m_baseText + ": Computing parameter estimates";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{msg});
        CNKProcCoxReg proc1 = new CNKProcCoxReg();
        proc1.setModel(this.getModelAsString(md, props));
        proc1.setDataPassCount(this.m_lastPass);
        proc1.setEpsilon(props.getDouble("convergenceTolerance", 1.0E-4));
        proc1.setMaxIterations(props.getInt("maxIterations", 10));
        proc1.setComputeSurvival(props.getBoolean("computeSurvival", true));
        this.printlnVerbose("Cox regression: creating model");
        if (MinerApp.isInteractive()) {
            proc1.setCallback(this);
        }
        ok = this.getNetworkManager().executeCNKProcBase(this.getNodeID(), proc1, inBufs, false);
        boolean bl = this.m_modelFilePath != null;
        proc1.setCallback(null);
        this.procDelete(proc1);
        this.eraseSortedDataFile(2);
        this.eraseSortedDataFile(1);
        if (!(ok &= bl)) {
            this.eraseSortedDataFile(0);
            return false;
        }
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            this.eraseSortedDataFile(0);
            this.eraseModelFile();
            return ok;
        }
        this.printlnVerbose("Cox regression: creating CNKProcCoxPredict");
        msg = this.m_baseText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{msg});
        inBufs = new CNKBackingFileBuf[1];
        buf = new CNKBackingFileBuf();
        EngineNetworkManager.setBufColumnDescription(buf, origMd, this.getNetworkManager().getMaxCategoricalLevels());
        this.printlnDebug("node=" + this.getNodeName() + ", input=0, data cache=" + inputCacheFileName);
        buf.setFileName(inputCacheFileName);
        buf.setBackingFileRows(origMd.getNumRows());
        inBufs[0] = buf;
        CNKProcCoxRegPredict proc2 = new CNKProcCoxRegPredict();
        this.printlnVerbose("Cox regression: calling CNKProcCoxRegPredict.setModel");
        proc2.setModel(this.m_modelFilePath);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        String val = props.getValue(new String[]{"newColumns", "survival"}, props.getValue(new String[]{"newColumns", "survivalType"}, "none"));
        if (val.equals("column")) {
            val = props.getValue(new String[]{"newColumns", "survival", "survivalTimeColumn"}, "");
            if (val.length() > 0) {
                proc2.setSurvivalTimeColumn(val);
            }
        } else if (val.equals("time") && (val = props.getValue(new String[]{"newColumns", "survival", "survivalTime"}, "")).length() > 0) {
            proc2.setSurvivalTime(Double.parseDouble(val));
        }
        this.printlnVerbose("Cox regression: predicting from training data.");
        ok = this.getNetworkManager().executeCNKProcBase(this.getNodeID(), proc2, inBufs, true);
        this.procDelete(proc2);
        this.eraseSortedDataFile(0);
        this.eraseModelFile();
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{this.m_baseText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }

    protected boolean createStartColumn(File inputFile, XTMetaData md, XTMetaData newMd, String stopVar, String startVar, String idVar, File newFile) throws Exception {
        double id;
        int stopCol = md.nameToOrdinal(stopVar);
        int idCol = md.nameToOrdinal(idVar);
        int startCol = newMd.nameToOrdinal(startVar);
        FileInputStream iStream = new FileInputStream(inputFile);
        BufferedInputStream iBuffer = new BufferedInputStream(iStream);
        DataInputStream iDataStream = new DataInputStream(iBuffer);
        FileOutputStream oStream = new FileOutputStream(newFile);
        BufferedOutputStream oBuffer = new BufferedOutputStream(oStream);
        DataOutputStream oDataStream = new DataOutputStream(oBuffer);
        DataCacheRowBuf iRowBuf = new DataCacheRowBuf(md);
        int iRowByteSize = iRowBuf.getBytesPerRow();
        DataCacheRowBuf oRowBuf = new DataCacheRowBuf(newMd);
        int oRowByteSize = oRowBuf.getBytesPerRow();
        byte[] oData = new byte[oRowByteSize];
        long iRowCount = md.getNumRows();
        long curRow = 0L;
        long oRowCount = 0L;
        double start = 0.0;
        iRowBuf.readRow(iDataStream);
        double stop = iRowBuf.getDouble(stopCol);
        double id1 = id = iRowBuf.getDouble(idCol);
        int n1 = 8;
        int n = oRowBuf.getColumnOffset(startCol);
        if (n > iRowByteSize) {
            n = iRowByteSize;
            n1 = oRowByteSize;
        }
        while (curRow < iRowCount) {
            if (id != id1) {
                start = 0.0;
                id1 = id;
            }
            if (!Double.isNaN(stop)) {
                int j;
                int i;
                byte[] iData = iRowBuf.getDataBytes();
                for (i = 0; i < n; ++i) {
                    oData[i] = iData[i];
                }
                for (j = i; j < n1; ++j) {
                    oData[j] = 0;
                }
                while (i < iRowByteSize) {
                    oData[j] = iData[i];
                    ++i;
                    ++j;
                }
                oRowBuf.setData(oData, 0);
                oRowBuf.setDouble(startCol, start);
                oRowBuf.writeRow(oDataStream);
                start = stop;
                ++oRowCount;
            }
            if (++curRow % 200L == 0L) {
                this.updateProgressIndicator((int)(100.0 * ((double)curRow / (double)iRowCount)));
            }
            iRowBuf.readRow(iDataStream);
            stop = iRowBuf.getDouble(stopCol);
            id = iRowBuf.getDouble(idCol);
        }
        newMd.setNumRows(oRowCount);
        iDataStream.close();
        oDataStream.close();
        return true;
    }

    public void doCallback(CNKProc proc) {
        if (proc == null) {
            return;
        }
        if (this.getNetworkManager().isInterruptRequested()) {
            proc.setError("User interrupt requested");
            return;
        }
        XTMetaData md = this.getInputMetaData(0);
        long n = md.getNumRows();
        int npass = proc.getDataPassCount();
        long k = proc.getRowsDone();
        int p = (int)(100.0 * ((double)k / (double)n));
        if (npass > this.m_lastPass) {
            this.m_lastPass = npass;
            this.updateProgressIndicator(p, npass, this.m_baseText);
        } else {
            this.updateProgressIndicator(p);
        }
    }
}

