/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class InsHorizontalDotRenderer
extends HorizontalBarRenderer {
    public Shape drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Rectangle2D.Double result = null;
        Number value = data.getValue(series, category);
        if (value != null) {
            Rectangle2D.Double bar;
            double translatedValue = axis.translateValueToJava2D(value.doubleValue(), dataArea);
            double rectX = Math.min(this.zeroInJava2D, translatedValue);
            double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent();
            int categories = data.getCategoryCount();
            int seriesCount = data.getSeriesCount();
            if (categories > 1) {
                rectY = rectY + (double)categoryIndex * this.categorySpan / (double)categories + (double)categoryIndex * this.categoryGapSpan / (double)(categories - 1) + (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            } else {
                rectY += (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            }
            double rectWidth = Math.abs(translatedValue - this.zeroInJava2D);
            double rectHeight = this.itemWidth;
            double lineStarty = rectY + (double)((int)(rectHeight / 2.0));
            Line2D.Double line = new Line2D.Double(rectX, lineStarty, rectX + rectWidth, lineStarty);
            Paint seriesPaint = plot.getSeriesPaint(series);
            g2.setPaint(seriesPaint);
            g2.draw(line);
            g2.fillArc((int)(rectX + rectWidth) - 3, (int)lineStarty - 3, 6, 6, 0, 360);
            result = bar = new Rectangle2D.Double(rectX, lineStarty - 3.0, rectWidth + 3.0, 6.0);
        }
        return result;
    }
}

