/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MinerPopupMenu
extends JPopupMenu {
    public MinerPopupMenu() {
    }

    public MinerPopupMenu(String s) {
        super(s);
    }

    public void setLocation(int x, int y) {
        Point p = new Point(x, y);
        this.adjustPopupPositionToFit(null, p);
        super.setLocation(p.x, p.y);
    }

    public void show(Component invoker, int x, int y) {
        Point p = new Point(x, y);
        this.adjustPopupPositionToFit(invoker, p);
        super.show(invoker, p.x, p.y);
    }

    private void adjustPopupPositionToFit(Component c, Point p) {
        int scrWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int scrHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        Dimension d = this.getPreferredSize();
        Point cp = new Point(p.x, p.y);
        scrWidth -= 50;
        scrHeight -= 50;
        if (c != null) {
            SwingUtilities.convertPointToScreen(cp, c);
        }
        p.x = cp.x;
        p.y = cp.y;
        if (p.x + d.width > scrWidth) {
            p.x = scrWidth - d.width;
        }
        if (p.y + d.height > scrHeight) {
            p.y = scrHeight - d.height;
        }
        if (c != null) {
            SwingUtilities.convertPointFromScreen(p, c);
        }
    }
}

