/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadDatabaseDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.WorksheetPropertiesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadSplusFileDialog
extends ReadOtherFileDialog {
    private JTextField m_varNameTextField;
    public static String[] m_typeCodeList = new String[]{"splusSDDFile", "splusChapterDirectory"};
    public static String[][] m_extensionList = new String[][]{{".sdd"}, {""}};
    public static String[] m_typeDescriptionList = new String[]{"SPLUS data.dump file (*.sdd)", "SPLUS Chapter Directory"};
    public static String[][] m_SDDextensionList = new String[][]{{".sdd"}};
    public static String[] m_SDDtypeDescriptionList = new String[]{"SPLUS data.dump file (*.sdd)"};
    private static ReadSplusFileDialog m_ReadSplusFileDialog = null;

    public static ReadSplusFileDialog getReadSplusFileDialog() {
        if (m_ReadSplusFileDialog == null) {
            m_ReadSplusFileDialog = new ReadSplusFileDialog();
        }
        return m_ReadSplusFileDialog;
    }

    protected ReadSplusFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        String type = props.getValue("fileType", "splusSDDFile");
        ReadSplusFileDialog.setComboBoxFromTypeString(type, m_typeCodeList, this.m_typeComboBox);
        String currentPath = props.getValue("filePath", "");
        this.m_fileNameTextField.setText(currentPath);
        String varName = props.getValue("splusVarName", "");
        this.m_varNameTextField.setText(varName);
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        props.set("fileType", m_typeCodeList[this.m_typeComboBox.getSelectedIndex()]);
        props.set("splusVarName", this.m_varNameTextField.getText());
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadSplusFileDialog.this.m_fileNameTextField, m_extensionList, ReadSplusFileDialog.this.m_typeComboBox);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadSplusFileDialog.this.m_fileNameTextField, m_extensionList, ReadSplusFileDialog.this.m_typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = WorksheetPropertiesPanel.createLabel(this.m_fileNameTextField, "ReadSplusFileDialog_fileLabel", "ReadSplusFileDialog_fileHotkey");
        JButton browseButton = WorksheetPropertiesPanel.createButton("ReadSplusFileDialog_fileBrowseLabel", "ReadSplusFileDialog_fileBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (ReadSplusFileDialog.this.selectedSDDFile()) {
                    ReadOtherFileDialog.browseReadFileName(ReadSplusFileDialog.this, ReadSplusFileDialog.this.m_fileNameTextField, m_SDDextensionList, m_SDDtypeDescriptionList, null);
                } else {
                    String newPath = WorksheetPropertiesPanel.browseForDirectory(ReadSplusFileDialog.this, ReadSplusFileDialog.this.m_fileNameTextField.getText());
                    if (newPath != null) {
                        ReadSplusFileDialog.this.m_fileNameTextField.setText(newPath);
                    }
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        JLabel typeLabel = WorksheetPropertiesPanel.createLabel(this.m_typeComboBox, "ReadSplusFileDialog_fileTypeLabel", "ReadSplusFileDialog_fileTypeHotkey");
        this.m_varNameTextField = new JTextField(25);
        JLabel varNameLabel = WorksheetPropertiesPanel.createLabel(this.m_varNameTextField, "ReadSplusFileDialog_varNameLabel", "ReadSplusFileDialog_varNameHotkey");
        JButton varNameBrowseButton = WorksheetPropertiesPanel.createButton("ReadSplusFileDialog_varNameBrowseLabel", "ReadSplusFileDialog_varNameBrowseHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (ReadSplusFileDialog.this.m_varNameTextField == null) {
                    return;
                }
                String oldTable = ReadSplusFileDialog.this.m_varNameTextField.getText();
                String newTable = ReadSplusFileDialog.browseDataFrameNames(ReadSplusFileDialog.this, ReadSplusFileDialog.this.getCurrentFileProperties(), oldTable);
                if (newTable != null) {
                    ReadSplusFileDialog.this.m_varNameTextField.setText(newTable);
                }
            }
        });
        Insets none = new Insets(2, 0, 2, 0);
        Insets frontback = new Insets(2, 10, 2, 10);
        int gridy = 0;
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, typeLabel, constraints, 0, gridy, 1, 1, 0.0, 0.0, 18, 0, none);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, this.m_typeComboBox, constraints, 2, gridy, 2, 1, 1.0, 0.0, 18, 2, frontback);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, varNameLabel, constraints, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, none);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, this.m_varNameTextField, constraints, 2, gridy, 2, 1, 1.0, 0.0, 10, 2, frontback);
        WorksheetPropertiesPanel.addGB(moreOptionsPanel, varNameBrowseButton, constraints, 4, gridy, 1, 1, 0.0, 0.0, 12, 0, none);
        ++gridy;
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)this.createPreviewPanel(), "Center");
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        return optionsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String browseDataFrameNames(NodeDialog dialog, XTProps currentFileProps, String currentTableName) {
        String string;
        int numTableNames;
        Vector tableNames;
        block9: {
            if (dialog != null) {
                dialog.setCursor(Cursor.getPredefinedCursor(3));
            }
            XTProps tableNameProps = ReadDatabaseDialog.getDataSourceTableNames(dialog, currentFileProps, 2000);
            tableNames = null;
            String errorString = "";
            numTableNames = 0;
            if (tableNameProps == null) {
                tableNames = new Vector();
                errorString = MinerApp.getText("ReadSplusFileDialog_browseTablesUnknownError");
            } else {
                tableNames = tableNameProps.getSubPropertyValues("tableNames");
                errorString = tableNameProps.getValue("tableNameErrors", "");
                numTableNames = tableNameProps.getInt("tableNameCount", 0);
            }
            if (numTableNames >= true) break block9;
            String fullErrorString = MinerApp.getText("ReadSplusFileDialog_browseTablesCantAccess") + "\n\n" + errorString;
            String errorTitle = MinerApp.getText("ReadSplusFileDialog_browseTablesErrorTitle");
            JOptionPane.showMessageDialog(dialog, fullErrorString, errorTitle, 0);
            String string2 = null;
            Object var14_15 = null;
            if (dialog == null) return string2;
            dialog.setCursor(Cursor.getPredefinedCursor(0));
            return string2;
        }
        try {
            Collections.sort(tableNames);
            int numTablesNamesToDisplay = tableNames.size();
            Object[] possibleValues = new Object[numTablesNamesToDisplay];
            for (int i = 0; i < numTablesNamesToDisplay; ++i) {
                possibleValues[i] = tableNames.get(i);
            }
            String chooserTitle = MinerApp.getText("ReadSplusFileDialog_browseTablesTitle");
            String chooserMessage = MinerApp.getText("ReadSplusFileDialog_browseTablesChooseTableName") + " [" + numTablesNamesToDisplay + (numTablesNamesToDisplay != numTableNames ? "/" + numTableNames : "") + " " + MinerApp.getText("ReadSplusFileDialog_browseTablesTablesListed") + "]";
            Object selectedValue = JOptionPane.showInputDialog(dialog, chooserMessage, chooserTitle, 3, null, possibleValues, currentTableName);
            string = (String)selectedValue;
            Object var14_16 = null;
            if (dialog == null) return string;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                Object var14_17 = null;
                if (dialog == null) return null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (dialog == null) throw throwable;
                dialog.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            dialog.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        dialog.setCursor(Cursor.getPredefinedCursor(0));
        return string;
    }

    public boolean selectedSDDFile() {
        return this.m_typeComboBox.getSelectedIndex() == 0;
    }
}

