/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.CollapsedLink;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.CollapsedNodeDialog;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.MinerTextNode;
import com.insightful.miner.MinerTextNodeDialog;
import com.insightful.miner.PredictorLink;
import com.insightful.miner.PredictorPort;
import com.insightful.miner.Viewable;
import com.insightful.miner.WorksheetDocument;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoGlobal;
import com.nwoods.jgo.JGoGridView;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class WorksheetView
extends JGoGridView
implements JGoViewListener {
    protected Point myCopyOffset = new Point(25, 25);
    protected Point myDefaultLocation = new Point(10, 10);
    protected MinerApp myApp = null;
    protected JInternalFrame myInternalFrame = null;
    protected Point m_popupLocation = new Point(0, 0);
    protected static JPopupMenu m_emptySelectionMenu = new MinerPopupMenu();
    protected static JPopupMenu m_multiSelectionMenu = new MinerPopupMenu();
    protected static JPopupMenu m_activityNodeSelectionMenu = new MinerPopupMenu();
    protected static JPopupMenu m_collapsedNodeSelectionMenu = new MinerPopupMenu();
    protected static JPopupMenu m_textNodeSelectionMenu = new MinerPopupMenu();
    protected static JPopupMenu m_linkSelectionMenu = new MinerPopupMenu();

    public WorksheetView() {
        this.setDragDropEnabled(true);
    }

    public WorksheetView(JGoDocument doc) {
        super(doc);
        this.setDragDropEnabled(true);
    }

    public boolean isDropFlavorAcceptable(DropTargetDragEvent e) {
        DataFlavor[] df = e.getCurrentDataFlavors();
        return WorksheetView.isIMinerDnDFlavor(df);
    }

    public static boolean isIMinerDnDFlavor(DataFlavor[] df) {
        for (int i = 0; i < df.length; ++i) {
            if (!df[i].equals(DragAndDropTree.InvisibleNode.nodeFlavor) && !df[i].equals(WorksheetDocument.getStandardDataFlavor()) && !df[i].equals(WorksheetDocument.getLocalJVMDataFlavor())) continue;
            return true;
        }
        return false;
    }

    public String getToolTipText(MouseEvent evt) {
        if (MinerApp.getMainFrame().getFocusOwner() == null) {
            return null;
        }
        return super.getToolTipText(evt);
    }

    public void initialize(MinerApp app, JInternalFrame frame) {
        this.myApp = app;
        this.myInternalFrame = frame;
        this.addViewListener(this);
        this.setGridWidth(10);
        this.setGridHeight(10);
        this.setSnapMove(1);
        this.updateTitle();
        this.addMouseWheelListener(new MouseWheelListener(){
            private JScrollBar m_vSB = null;

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (this.m_vSB == null) {
                    this.m_vSB = WorksheetView.this.getVerticalScrollBar();
                }
                this.m_vSB.setValue(this.m_vSB.getValue() + e.getUnitsToScroll() * this.m_vSB.getUnitIncrement());
            }
        });
    }

    public JGoDocument createDefaultModel() {
        return new WorksheetDocument(true);
    }

    public void setDocument(JGoDocument doc) {
        JGoView.JGoViewCanvas canvas = this.getCanvas();
        canvas.setIgnoreRepaint(true);
        super.setDocument(doc);
        this.updateViewForNodeChanges();
        canvas.setIgnoreRepaint(false);
        canvas.repaint();
    }

    public WorksheetDocument getDoc() {
        return (WorksheetDocument)this.getDocument();
    }

    MinerApp getApp() {
        return this.myApp;
    }

    public JInternalFrame getInternalFrame() {
        return this.myInternalFrame;
    }

    public JGoHandle pickHandle(Point point) {
        JGoHandle handle = super.pickHandle(point);
        if (handle == null) {
            return null;
        }
        JGoObject obj = handle.getHandleFor();
        if (obj instanceof JGoLink) {
            return null;
        }
        return handle;
    }

    protected void addObjectToDoc(JGoObject object, JGoDocument doc, boolean head) {
        if (head) {
            doc.addObjectAtHead(object);
        } else {
            doc.addObjectAtTail(object);
        }
        if (object instanceof CollapsedNodeArea && doc instanceof WorksheetDocument) {
            ((CollapsedNodeArea)object).hiddenExpandForState((WorksheetDocument)doc);
            ((CollapsedNodeArea)object).addStateVisualCue();
        }
    }

    public void onKeyEvent(KeyEvent evt) {
        int t = evt.getKeyCode();
        if (t == 127) {
            if (this.getDoc().isModifiable()) {
                this.getDoc().startTransaction();
                this.deleteSelection();
                this.updateViewForNodeChanges();
                this.getDoc().endTransaction(this.getEditPresentationName(11));
            }
        } else if (t == 36) {
            this.setViewPosition(0, 0);
        } else if (t == 39) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, this.getGridWidth(), 0, 3);
            }
        } else if (t == 37) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, -this.getGridWidth(), 0, 3);
            }
        } else if (t == 40) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, this.getGridHeight(), 3);
            }
        } else if (t == 38) {
            if (this.getDoc().isModifiable()) {
                this.doMoveSelection(0, 0, -this.getGridHeight(), 3);
            }
        } else if (t == 27) {
            this.getSelection().clearSelection();
        } else {
            super.onKeyEvent(evt);
        }
    }

    public void doMoveSelection(int modifiers, int offsetx, int offsety, int event) {
        WorksheetDocument doc = this.getDoc();
        if (doc != null && doc.isModifiable()) {
            if (event == 1) {
                if (doc.getUndoManager().isInProgress()) {
                    doc.endTransaction(false);
                    doc.endTransaction(false);
                }
                doc.startTransaction();
            }
            super.doMoveSelection(modifiers, offsetx, offsety, event);
            boolean control = modifiers == this.convertActionToModifiers(1);
            int action = this.getInternalMouseActions();
            boolean copyallowed = (action & 1) != 0;
            boolean copyrequired = action == 1;
            boolean copying = copyrequired | copyallowed & control;
            boolean needJitter = copying && event == 3;
            boolean adjustScrollBars = false;
            Rectangle rect = this.getViewRect();
            JGoSelection sel = this.getSelection();
            JGoListPosition pos = sel.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = sel.getObjectAtPos(pos).getTopLevelObject();
                if (obj instanceof BaseNodeArea || obj instanceof MinerTextNode) {
                    if (needJitter) {
                        this.jitterObject(obj);
                    }
                    if (!adjustScrollBars) {
                        Rectangle objRect = obj.getBoundingRect();
                        boolean contained = rect.contains(objRect);
                        adjustScrollBars = !contained;
                    }
                }
                pos = sel.getNextObjectPos(pos);
            }
            if (adjustScrollBars) {
                this.getVerticalScrollBar().setValue(this.getVerticalScrollBar().getValue() + offsety);
                this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getValue() + offsetx);
            }
            this.updateViewForNodeChanges();
            if (event == 3) {
                if (copying) {
                    doc.endTransaction(this.getEditPresentationName(2));
                } else {
                    doc.endTransaction(this.getEditPresentationName(1));
                }
            }
        } else {
            super.doMoveSelection(modifiers, offsetx, offsety, event);
        }
    }

    public void selectInBox(Rectangle rect) {
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPosAtTop(pos);
                    JGoObject testObject = obj;
                    if (obj instanceof BaseNodeArea) {
                        testObject = ((BaseNodeArea)obj).getIcon();
                    }
                    boolean isVis = obj.isVisible();
                    boolean isCont = this.usableContainsRect(rect, testObject.getBoundingRect());
                    boolean isSele = obj.isSelectable();
                    boolean isChildColl = obj.isGrabChildSelection() && obj instanceof JGoObjectCollection;
                    boolean isRedirSel = true;
                    if (!isVis || !isCont || !isSele && !isChildColl && !isRedirSel) continue;
                    this.getSelection().extendSelection(obj);
                }
            }
            layer = this.getNextLayer(layer);
        }
    }

    public boolean usableContainsRect(Rectangle rect, Rectangle obj) {
        int width = rect.width;
        int height = rect.height;
        int W = obj.width;
        int H = obj.height;
        if (width <= 0 || height <= 0 || W < 0 || H < 0) {
            return false;
        }
        int x = rect.x;
        int y = rect.y;
        int X = obj.x;
        int Y = obj.y;
        return X >= x && Y >= y && X + W <= x + width && Y + H <= y + height;
    }

    public void updateViewForNodeChanges() {
        this.updateViewForNodeChanges(false);
    }

    public void updateViewForNodeChanges(boolean clipWorksheet) {
        int startX = 0;
        int startY = 0;
        int width = 0;
        int height = 0;
        boolean first = true;
        JGoListPosition pos = this.getDoc().getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getDoc().getObjectAtPos(pos);
            if (obj instanceof BaseNodeArea || obj instanceof MinerTextNode) {
                Rectangle rect = obj.getBoundingRect();
                int r_X = rect.x + rect.width + 20;
                int r_Y = rect.y + rect.height + 20;
                if (first) {
                    width = r_X;
                    height = r_Y;
                    startX = rect.x;
                    startY = rect.y;
                    first = false;
                } else {
                    if (r_X > width) {
                        width = r_X;
                    }
                    if (r_Y > height) {
                        height = r_Y;
                    }
                    if (rect.x < startX) {
                        startX = rect.x;
                    }
                    if (rect.y < startY) {
                        startY = rect.y;
                    }
                }
            }
            pos = this.getDoc().getNextObjectPos(pos);
        }
        width += 20;
        height += 20;
        if (clipWorksheet || startX < 0 || startY < 0) {
            int buffer = 5;
            pos = this.getDoc().getFirstObjectPos();
            while (pos != null) {
                boolean isNode;
                JGoObject obj = this.getDoc().getObjectAtPos(pos);
                boolean bl = isNode = obj instanceof BaseNodeArea || obj instanceof MinerTextNode;
                if (isNode || obj instanceof JGoLink) {
                    Rectangle rect = obj.getBoundingRect();
                    int x = startX < 0 || clipWorksheet ? rect.x - startX + buffer : rect.x;
                    int y = startY < 0 || clipWorksheet ? rect.y - startY + buffer : rect.y;
                    obj.setBoundingRect(x, y, rect.width, rect.height);
                    if (isNode && obj.getView() != null) {
                        this.jitterObject(obj);
                        this.snapObject(obj);
                    }
                }
                pos = this.getDoc().getNextObjectPos(pos);
            }
            width -= startX;
            height -= startY;
            startX = 0;
            startY = 0;
        }
        this.updateView(new Rectangle(startX, startY, width, height));
        this.getDoc().setDocumentSize(width, height);
        this.updateScrollbars();
    }

    public JGoObjectSimpleCollection getSelectionFromClipboard(Clipboard clipboard) {
        Transferable contents = clipboard.getContents((Object)this);
        DataFlavor jgoflavor = WorksheetDocument.getLocalJVMDataFlavor();
        if (contents != null && contents.isDataFlavorSupported(jgoflavor)) {
            try {
                JGoDocument doc = this.getDocument();
                if (doc != null) {
                    return (JGoObjectSimpleCollection)contents.getTransferData(jgoflavor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void copy() {
        super.copy();
        this.myCopyOffset.setLocation(25, 25);
    }

    public JGoCopyEnvironment pasteFromClipboard(Clipboard clipboard, Point offset) {
        block12: {
            Transferable contents = clipboard.getContents((Object)this);
            DataFlavor jgoflavor = WorksheetDocument.getLocalJVMDataFlavor();
            if (contents != null && contents.isDataFlavorSupported(jgoflavor)) {
                try {
                    JGoDocument doc = this.getDocument();
                    if (doc == null) break block12;
                    doc.startTransaction();
                    JGoObjectSimpleCollection sel = (JGoObjectSimpleCollection)contents.getTransferData(jgoflavor);
                    if (doc.getDefaultLayer().isModifiable()) {
                        JGoCopyEnvironment env = doc.copyFromCollection(sel, offset, null);
                        JGoSelection selection = this.getSelection();
                        selection.clearSelection();
                        Rectangle selectionRect = null;
                        Iterator keys = env.keySet().iterator();
                        while (keys.hasNext()) {
                            JGoObject obj = ((JGoObject)env.get(keys.next())).getTopLevelObject();
                            selection.extendSelection(obj);
                            Rectangle testRect = obj.getBoundingRect();
                            if (selectionRect == null) {
                                selectionRect = new Rectangle(testRect);
                            } else {
                                int testWidth = testRect.x + testRect.width;
                                int testHeight = testRect.y + testRect.height;
                                if (selectionRect.x > testRect.x) {
                                    selectionRect.x = testRect.x;
                                }
                                if (selectionRect.y > testRect.y) {
                                    selectionRect.y = testRect.y;
                                }
                                if (selectionRect.width > testWidth) {
                                    selectionRect.width = testWidth;
                                }
                                if (selectionRect.height > testHeight) {
                                    selectionRect.height = testHeight;
                                }
                            }
                            if (obj instanceof BaseNodeArea || obj instanceof MinerTextNode) {
                                this.jitterObject(obj);
                                this.snapObject(obj);
                                continue;
                            }
                            if (!(obj instanceof JGoLink)) continue;
                        }
                        this.scrollRectToVisible(selectionRect);
                        doc.endTransaction(this.getEditPresentationName(10));
                        return env;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    void jitterObject(JGoObject obj) {
        obj.setLocationOffset(obj.getLocation(), new Point(1, 1));
        obj.setLocationOffset(obj.getLocation(), new Point(-1, -1));
    }

    public void mouseDrivenPaste() {
        JGoObjectSimpleCollection sel;
        JGoCopyEnvironment env = null;
        Toolkit toolkit = this.getToolkit();
        if (toolkit == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        if ((sel = this.getSelectionFromClipboard(toolkit.getSystemClipboard())) == null) {
            return;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        Point offset = new Point(0, 0);
        Point topLeft = new Point(-1, -1);
        Point temp = null;
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos).getTopLevelObject();
            if (obj instanceof BaseNodeArea || obj instanceof MinerTextNode) {
                temp = obj.getTopLeft();
                if (topLeft.x == -1 || topLeft.x > temp.x) {
                    topLeft.x = temp.x;
                    topLeft.y = temp.y;
                }
            }
            pos = sel.getNextObjectPos(pos);
        }
        offset.setLocation(this.m_popupLocation.x - topLeft.x, this.m_popupLocation.y - topLeft.y);
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        env = this.pasteFromClipboard(toolkit.getSystemClipboard(), offset);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(10));
        }
        this.updateViewForNodeChanges();
        pos = this.getDoc().getFirstObjectPos();
        while (pos != null) {
            boolean isNode;
            JGoObject obj = this.getDoc().getObjectAtPos(pos);
            boolean bl = isNode = obj instanceof BaseNodeArea || obj instanceof MinerTextNode;
            if (isNode) {
                this.jitterObject(obj);
                this.snapObject(obj);
            }
            pos = this.getDoc().getNextObjectPos(pos);
        }
    }

    public void paste() {
        Toolkit toolkit;
        JGoCopyEnvironment env = null;
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        if ((toolkit = this.getToolkit()) == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        env = this.pasteFromClipboard(toolkit.getSystemClipboard(), this.myCopyOffset);
        this.myCopyOffset.setLocation(this.myCopyOffset.x + 25, this.myCopyOffset.y + 25);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(10));
        }
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc) {
        JGoObject obj = this.pickDocObject(dc, true);
        if (obj instanceof MinerTextNode) {
            if (obj != null) {
                this.fireUpdate(10, 0, obj, vc, dc, modifiers);
            }
            JGoSelection sel = new JGoSelection();
            for (JGoObject modObj = sel.extendSelection(obj); modObj != null; modObj = modObj.getParent()) {
                if (!modObj.doMouseClick(modifiers, dc, vc, (JGoView)this)) continue;
                return true;
            }
            this.getSelection().selectObject(obj);
            return false;
        }
        return super.doMouseClick(modifiers, dc, vc);
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc) {
        return super.doMouseDblClick(modifiers, dc, vc);
    }

    public boolean doMouseDown(int modifiers, Point dc, Point vc) {
        JGoSelection sel = this.getSelection();
        JGoObject obj = this.pickDocObject(dc, true);
        if (this.getCurrentMouseEvent() != null && this.getCurrentMouseEvent().isPopupTrigger()) {
            if (sel.getNumObjects() < 2 && obj != null) {
                this.selectObject(obj);
            }
            return this.doPopupMenu(modifiers, dc, vc);
        }
        if (this.pickDocObject(dc, true) == null && (modifiers & 2) == 2) {
            return true;
        }
        return super.doMouseDown(modifiers, dc, vc);
    }

    public boolean doMouseUp(int modifiers, Point dc, Point vc) {
        JGoSelection sel = this.getSelection();
        if (this.getCurrentMouseEvent() != null && this.getCurrentMouseEvent().isPopupTrigger()) {
            JGoObject obj = this.pickDocObject(dc, true);
            if (obj != null && sel.getNumObjects() < 2) {
                this.selectObject(obj);
            }
            return this.doPopupMenu(modifiers, dc, vc);
        }
        return super.doMouseUp(modifiers, dc, vc);
    }

    public boolean doPopupMenu(int modifiers, Point dc, Point vc) {
        JGoObject obj;
        JPopupMenu popup = null;
        JGoSelection selection = this.getSelection();
        boolean onlyText = true;
        boolean onlyLinks = true;
        boolean diagonal = true;
        JGoListPosition pos = selection.getFirstObjectPos();
        while (pos != null) {
            obj = selection.getObjectAtPos(pos);
            pos = selection.getNextObjectPos(pos);
            if (!obj.isTopLevel()) continue;
            boolean isMTN = obj instanceof MinerTextNode;
            if (onlyText) {
                onlyText = isMTN;
            }
            if (obj instanceof JGoLink) {
                if (!diagonal) continue;
                diagonal = !((JGoLink)obj).isOrthogonal();
                continue;
            }
            onlyLinks = false;
        }
        switch (selection.getNumObjects()) {
            case 0: {
                popup = WorksheetView.getEmptySelectionMenu();
                break;
            }
            case 1: {
                obj = selection.getObjectAtPos(selection.getFirstObjectPos());
                if (obj instanceof ActivityNodeArea) {
                    popup = WorksheetView.getActivityNodeSelectionMenu();
                    break;
                }
                if (obj instanceof CollapsedNodeArea) {
                    popup = WorksheetView.getCollapsedNodeSelectionMenu();
                    for (int i = popup.getComponentCount() - 1; i >= 0; --i) {
                        Component comp = popup.getComponent(i);
                        if (!(comp instanceof JMenuItem) || !((JMenuItem)comp).getText().equals("Inner Node Properties")) continue;
                        popup.remove(comp);
                    }
                    JMenu collapsedMenuItem = ((CollapsedNodeArea)obj).getPropertiesMenu("Inner Node Properties");
                    popup.insert(collapsedMenuItem, 3);
                    break;
                }
                if (obj instanceof MinerTextNode) {
                    popup = WorksheetView.getTextNodeSelectionMenu();
                    break;
                }
                if (!(obj instanceof JGoLink)) break;
                popup = WorksheetView.getLinkSelectionMenu();
                break;
            }
            default: {
                popup = onlyText ? WorksheetView.getTextNodeSelectionMenu() : (onlyLinks ? WorksheetView.getLinkSelectionMenu() : WorksheetView.getMultiSelectionMenu());
            }
        }
        if (popup != null) {
            if (onlyLinks) {
                for (int i = popup.getComponentCount() - 1; i >= 0; --i) {
                    Component comp = popup.getComponent(i);
                    if (!(comp instanceof JCheckBoxMenuItem) || ((JCheckBoxMenuItem)comp).getAction() != MinerApp.getOrthoAction()) continue;
                    ((JCheckBoxMenuItem)comp).setSelected(diagonal);
                }
            }
            this.m_popupLocation.setLocation(dc.x, dc.y);
            popup.show((Component)((Object)this), vc.x, vc.y);
        }
        return true;
    }

    public static JPopupMenu getEmptySelectionMenu() {
        return m_emptySelectionMenu;
    }

    public static JPopupMenu getMultiSelectionMenu() {
        return m_multiSelectionMenu;
    }

    public static JPopupMenu getActivityNodeSelectionMenu() {
        return m_activityNodeSelectionMenu;
    }

    public static JPopupMenu getCollapsedNodeSelectionMenu() {
        return m_collapsedNodeSelectionMenu;
    }

    public static JPopupMenu getTextNodeSelectionMenu() {
        return m_textNodeSelectionMenu;
    }

    public static JPopupMenu getLinkSelectionMenu() {
        return m_linkSelectionMenu;
    }

    public void viewChanged(JGoViewEvent e) {
        switch (e.getHint()) {
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                AppAction.updateAllActions();
            }
        }
    }

    public void documentChanged(JGoDocumentEvent evt) {
        int hint = evt.getHint();
        if (hint == 65536 || hint == 8) {
            this.updateTitle();
        }
        super.documentChanged(evt);
    }

    public void updateTitle() {
        JInternalFrame iFrame = this.getInternalFrame();
        if (iFrame != null) {
            WorksheetDocument doc = this.getDoc();
            String name = doc.getName();
            int location = name.indexOf(".imw");
            if (location == name.length() - ".imw".length()) {
                name = name.substring(0, location);
            }
            String title = " " + name;
            if (doc.getIsTemp()) {
                title = title + " [Read-Only]";
            }
            iFrame.setTitle(title);
            iFrame.repaint();
        }
    }

    public void newCollapsedLink(CollapsedLink clink) {
        this.getDoc().newCollapsedLink(clink);
        this.getDoc().endTransaction("Add Link");
    }

    public void newLink(JGoPort from, JGoPort to, boolean completelySpecified) {
        boolean fromPredictor = from instanceof PredictorPort;
        boolean toPredictor = to instanceof PredictorPort;
        if (fromPredictor && toPredictor) {
            PredictorLink pl = new PredictorLink(from, to);
            this.addObjectToDoc((JGoObject)pl, this.getDoc(), true);
        } else {
            if (fromPredictor != toPredictor) {
                this.getDoc().endTransaction(false);
                return;
            }
            this.getDoc().newLink(from, to, completelySpecified);
        }
        this.getDoc().endTransaction("Add Link");
    }

    public void newLink(JGoPort from, JGoPort to) {
        this.newLink(from, to, false);
    }

    public Point getDefaultLocation() {
        if (this.myDefaultLocation != null) {
            this.myDefaultLocation.x += 10;
            this.myDefaultLocation.y += 10;
        }
        return this.myDefaultLocation;
    }

    public void setDefaultLocation(Point loc) {
        this.myDefaultLocation = loc;
    }

    public void drop(DropTargetDropEvent dsde) {
        Transferable transferable = dsde.getTransferable();
        this.getDoc().startTransaction();
        BaseNodeArea area = DragAndDropTree.convertTransferableToArea(transferable);
        if (area == null) {
            dsde.rejectDrop();
            this.getDoc().endTransaction("Add Node");
            return;
        }
        Point selLoc = area.getLocation();
        Point viewCoord = dsde.getLocation();
        Point docCoord = this.viewToDocCoords(viewCoord);
        Point offset = new Point(docCoord.x - selLoc.x, docCoord.y - selLoc.y);
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.copyFromCollection((JGoObjectSimpleCollection)area, offset, (JGoCopyEnvironment)new JGoCopyMap());
        }
        this.completeDrop(dsde, true);
        this.updateViewForNodeChanges();
        Point areaTL = new Point();
        this.findNearestGridPoint(area.getTopLeft().x, area.getTopLeft().y, areaTL);
        area.setTopLeft(areaTL);
        this.grabFocus();
        this.getDoc().endTransaction("Add Node");
    }

    public void copyFromExplorerPane(JGoArea area) {
        this.copyFromExplorerPane(area, null);
    }

    public void copyFromExplorerPane(JGoArea area, Point initialPoint) {
        Point setPoint = new Point(initialPoint == null ? this.myDefaultLocation : initialPoint);
        WorksheetDocument doc = this.getDoc();
        int areaHeight = area.getHeight();
        int areaWidth = area.getWidth();
        int xOffset = 100;
        int midY = areaHeight / 2;
        int midX = areaWidth / 2;
        while (true) {
            JGoListPosition pos = doc.getFirstObjectPos();
            boolean again = false;
            while (pos != null) {
                JGoObject obj = doc.getObjectAtPos(pos).getTopLevelObject();
                Point testPoint = new Point(setPoint);
                Point midPoint = new Point(testPoint.x + midX, testPoint.y + midY);
                if (obj.isPointInObj(midPoint)) {
                    again = true;
                    break;
                }
                if (obj.isPointInObj(testPoint)) {
                    again = true;
                    break;
                }
                testPoint.x += areaWidth;
                if (obj.isPointInObj(testPoint)) {
                    again = true;
                    break;
                }
                testPoint.y += areaHeight;
                if (obj.isPointInObj(testPoint)) {
                    again = true;
                    break;
                }
                testPoint.x -= areaWidth;
                if (obj.isPointInObj(testPoint)) {
                    again = true;
                    break;
                }
                pos = doc.getNextObjectPos(pos);
            }
            if (!again) {
                area.setTopLeft(setPoint);
                doc.startTransaction();
                this.addObjectToDoc((JGoObject)area, doc, false);
                this.getSelection().clearSelection();
                this.getSelection().extendSelection((JGoObject)area);
                this.scrollRectToVisible(area.getBoundingRect());
                if (area instanceof MinerTextNode) {
                    ((MinerTextNode)area).getLabel().doStartEdit((JGoView)this, setPoint);
                }
                doc.endTransaction("Add Node");
                return;
            }
            setPoint.x += xOffset;
        }
    }

    void collapseNodeArea() {
        boolean isCollapsing = this.getDoc().isCollapsing();
        this.getDoc().startTransaction();
        this.getDoc().setCollapseTransaction(true);
        JGoSelection selection = this.getSelection();
        CollapsedNodeArea cn = new CollapsedNodeArea();
        cn.initialize();
        cn.includeLinksInSelection(this.getDoc(), selection);
        Vector inputPorts = new Vector();
        Vector outputPorts = new Vector();
        cn.collectNodes(selection, inputPorts, outputPorts);
        cn.createPorts(inputPorts, outputPorts);
        Vector collapsedLinkList = new Vector();
        cn.collectCollapsedLinks(selection, collapsedLinkList, true);
        cn.collectCollapsedLinks(selection, collapsedLinkList, false);
        cn.collectModelLinks(selection, true);
        cn.collectModelLinks(selection, false);
        this.addObjectToDoc((JGoObject)cn, this.getDoc(), false);
        Point center = cn.getCenterPoint();
        cn.setTopLeft(center);
        for (int i = collapsedLinkList.size() - 1; i >= 0; --i) {
            CollapsedLink clink = (CollapsedLink)((Object)collapsedLinkList.get(i));
            this.getDoc().startTransaction();
            this.newCollapsedLink(clink);
        }
        this.deleteSelection();
        selection.extendSelection((JGoObject)cn);
        this.getDoc().setCollapseTransaction(isCollapsing);
        this.getDoc().endTransaction("Creating Collapsed Nodes");
    }

    public void expandAllCollapsedNodes() {
        WorksheetDocument doc = this.getDoc();
        Vector<JGoObject> expandList = new Vector<JGoObject>();
        boolean runAgain = true;
        JGoListPosition pos = null;
        JGoObject object = null;
        doc.startTransaction();
        while (runAgain) {
            runAgain = false;
            pos = doc.getFirstObjectPos();
            while (pos != null) {
                object = doc.getObjectAtPos(pos);
                if (object instanceof CollapsedNodeArea) {
                    expandList.add(object);
                }
                pos = doc.getNextObjectPos(pos);
            }
            for (int i = expandList.size() - 1; i >= 0; --i) {
                this.selectObject((JGoObject)((CollapsedNodeArea)expandList.get(i)));
                this.expandCollapsedNodes();
                runAgain = true;
            }
            expandList.removeAllElements();
        }
        this.selectAll();
        doc.endTransaction("Expanding All Collapsed Nodes");
    }

    public void expandCollapsedNodes() {
        JGoObject obj;
        JGoSelection finalSelection = new JGoSelection();
        JGoSelection tempSelection = new JGoSelection();
        JGoSelection currentSelection = this.getSelection();
        if (currentSelection.isEmpty()) {
            return;
        }
        this.getDocument().startTransaction();
        boolean isCollapsing = this.getDoc().isCollapsing();
        this.getDoc().setCollapseTransaction(true);
        JGoListPosition pos = currentSelection.getFirstObjectPos();
        while (pos != null) {
            obj = currentSelection.getObjectAtPos(pos);
            pos = currentSelection.getNextObjectPos(pos);
            if (!obj.isTopLevel()) continue;
            if (obj instanceof CollapsedNodeArea) {
                tempSelection = ((CollapsedNodeArea)obj).expand(this.getDoc());
                JGoListPosition pos2 = tempSelection.getFirstObjectPos();
                while (pos2 != null) {
                    JGoObject obj2 = tempSelection.getObjectAtPos(pos2);
                    pos2 = tempSelection.getNextObjectPos(pos2);
                    finalSelection.extendSelection(obj2);
                }
                continue;
            }
            currentSelection.clearSelection(obj);
        }
        this.deleteSelection();
        pos = finalSelection.getFirstObjectPos();
        while (pos != null) {
            obj = finalSelection.getObjectAtPos(pos);
            pos = finalSelection.getNextObjectPos(pos);
            currentSelection.extendSelection(obj);
        }
        this.getDoc().setCollapseTransaction(isCollapsing);
        this.getDocument().endTransaction("Expanding Collapsed Nodes");
    }

    public void editObjectProperties() {
        JGoSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            MinerApp.editWorksheetProperties();
            return;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        Vector<JGoObject> mtns = new Vector<JGoObject>();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            if (!obj.isTopLevel()) continue;
            if (obj instanceof ActivityNodeArea) {
                this.editActivity((ActivityNodeArea)obj);
                continue;
            }
            if (obj instanceof CollapsedNodeArea) {
                this.editCollapsed((CollapsedNodeArea)obj);
                continue;
            }
            if (obj instanceof MinerTextNode) {
                mtns.add(obj);
                continue;
            }
            if (!(obj instanceof JGoLink)) continue;
            this.editFlow((JGoLink)obj);
        }
        if (mtns.size() > 0) {
            MinerTextNode[] mtnsArray = new MinerTextNode[mtns.size()];
            for (int i = 0; i < mtnsArray.length; ++i) {
                mtnsArray[i] = (MinerTextNode)mtns.get(i);
            }
            this.editText(mtnsArray);
        }
    }

    public void showObjectViewer() {
        JGoSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            if (!obj.isTopLevel()) continue;
            if (obj instanceof ActivityNodeArea) {
                ActivityNodeModel model = ((ActivityNodeArea)obj).getNodeModel();
                model.getState().showView(model);
            } else if (obj instanceof Viewable) {
                ((Viewable)obj).showDataViewer(0);
            }
            pos = sel.getNextObjectPos(pos);
        }
    }

    public void showDataViewer() {
        JGoSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            Object obj = sel.getObjectAtPos(pos);
            int initialPortNum = 0;
            if (!obj.isTopLevel()) continue;
            if (obj instanceof BaseLink) {
                initialPortNum = ((BaseLink)((Object)obj)).getFromPortIndex();
                obj = ((BaseLink)((Object)obj)).getFromNode();
            }
            if (obj instanceof ActivityNodeArea) {
                obj = ((ActivityNodeArea)obj).getNodeModel();
            }
            if (obj instanceof Viewable) {
                ((Viewable)obj).showDataViewer(initialPortNum);
            }
            pos = sel.getNextObjectPos(pos);
        }
    }

    void editActivity(ActivityNodeArea snode) {
        ActivityNodeModel model = snode.getNodeModel();
        model.getState().showDialog(model);
    }

    void editText(MinerTextNode[] snode) {
        if (snode.length == 0) {
            return;
        }
        JGoSelection sel = this.getSelection();
        Font initFont = null;
        Color txt = null;
        Color bkg = null;
        initFont = snode[0].getFont();
        txt = snode[0].getTextColor();
        bkg = snode[0].getBackground();
        MinerTextNodeDialog dlg = new MinerTextNodeDialog(initFont, txt, bkg);
        dlg.show();
        if (dlg.ok()) {
            Color bk = dlg.getBackground();
            Color fr = dlg.getForeground();
            Font font = dlg.getFont();
            for (int i = 0; i < snode.length; ++i) {
                snode[i].setBackground(bk);
                snode[i].setTextColor(fr);
                snode[i].setFont(font);
                sel.clearSelection((JGoObject)snode[i]);
                sel.extendSelection((JGoObject)snode[i]);
            }
        }
    }

    void editCollapsed(CollapsedNodeArea cnode) {
        if (CollapsedNodeDialog.alreadyViewing(cnode)) {
            return;
        }
        CollapsedNodeDialog dialog = new CollapsedNodeDialog(cnode);
        dialog.show();
    }

    void editFlow(JGoLink link) {
    }

    public void showGrid() {
        int style = this.getGridStyle();
        if (style == 0) {
            style = 1;
            this.setGridPen(JGoPen.black);
        } else {
            style = 0;
        }
        this.setGridStyle(style);
    }

    public void toggleOrthogonalFlows() {
        WorksheetDocument doc = this.getDoc();
        doc.startTransaction();
        boolean modifiedSome = false;
        JGoSelection sel = this.getSelection();
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoLink bl;
            JGoObject obj = sel.getObjectAtPos(pos);
            pos = sel.getNextObjectPos(pos);
            if (!(obj instanceof JGoLink)) continue;
            bl.setOrthogonal(!(bl = (JGoLink)obj).isOrthogonal());
            modifiedSome = true;
        }
        if (!modifiedSome) {
            doc.toggleOrthogonalFlows();
        }
        doc.endTransaction("Diagonal Links");
    }

    public Rectangle2D.Double getPrintPageRect(Graphics2D g2, PageFormat pf) {
        return new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight() - 20.0);
    }

    public void printDecoration(Graphics2D g2, PageFormat pf, int hpnum, int vpnum) {
        super.printDecoration(g2, pf, hpnum, vpnum);
        String msg = Integer.toString(hpnum);
        msg = msg + ", ";
        msg = msg + Integer.toString(vpnum);
        Paint oldpaint = g2.getPaint();
        g2.setPaint(Color.black);
        Font oldfont = g2.getFont();
        g2.setFont(new Font(JGoText.getDefaultFontFaceName(), 0, 10));
        g2.drawString(msg, (int)(pf.getImageableX() + pf.getImageableWidth() / 2.0), (int)(pf.getImageableY() + pf.getImageableHeight() - 10.0));
        g2.setPaint(oldpaint);
        g2.setFont(oldfont);
    }

    public double getPrintScale(Graphics2D g2, PageFormat pf) {
        return this.getScale();
    }

    public void zoomIn() {
        double newscale = Math.rint(this.getScale() / (double)0.9f * 100.0) / 100.0;
        this.setScale(newscale);
    }

    public void zoomOut() {
        double newscale = Math.rint(this.getScale() * (double)0.9f * 100.0) / 100.0;
        this.setScale(newscale);
    }

    public void zoomNormal() {
        this.setScale(1.0);
    }

    public void zoomToFit() {
        double newscale = 1.0;
        if (!this.getDocument().isEmpty()) {
            double extentWidth = this.getExtentSize().width;
            double printWidth = this.getPrintDocumentSize().width;
            double extentHeight = this.getExtentSize().height;
            double printHeight = this.getPrintDocumentSize().height;
            newscale = Math.min(extentWidth / printWidth, extentHeight / printHeight);
        }
        this.setScale(newscale *= this.getScale());
        this.setViewPosition(0, 0);
    }

    public boolean matchesNodeLabel(ActivityNodeArea node, char c) {
        if (node == null) {
            return false;
        }
        String name = node.getNodeModel().getLabelText();
        return name.length() > 0 && Character.toUpperCase(name.charAt(0)) == c;
    }

    public boolean selectNextNode(char c) {
        ActivityNodeArea pn;
        JGoListPosition pos;
        c = Character.toUpperCase(c);
        JGoDocument doc = this.getDocument();
        ActivityNodeArea startnode = null;
        JGoObject obj = this.getSelection().getPrimarySelection();
        if (obj != null && obj instanceof ActivityNodeArea) {
            startnode = (ActivityNodeArea)obj;
        }
        JGoListPosition startpos = null;
        if (startnode != null) {
            startpos = doc.findObject((JGoObject)startnode);
        }
        if ((pos = startpos) != null) {
            pos = doc.getNextObjectPosAtTop(pos);
        }
        while (pos != null) {
            obj = doc.getObjectAtPos(pos);
            pos = doc.getNextObjectPosAtTop(pos);
            if (!(obj instanceof ActivityNodeArea) || !this.matchesNodeLabel(pn = (ActivityNodeArea)obj, c)) continue;
            this.selectObject((JGoObject)pn);
            this.scrollRectToVisible(pn.getBoundingRect());
            return true;
        }
        pos = doc.getFirstObjectPos();
        while (pos != null && pos != startpos) {
            obj = doc.getObjectAtPos(pos);
            pos = doc.getNextObjectPosAtTop(pos);
            if (!(obj instanceof ActivityNodeArea) || !this.matchesNodeLabel(pn = (ActivityNodeArea)obj, c)) continue;
            this.selectObject((JGoObject)pn);
            this.scrollRectToVisible(pn.getBoundingRect());
            return true;
        }
        return false;
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    public Dimension getPrintDocumentSize() {
        JGoDocument doc = this.getDocument();
        Dimension maxDim = new Dimension(1, 1);
        if (doc == null) {
            return maxDim;
        }
        int minx = 0;
        int miny = 0;
        Rectangle bounds = new Rectangle();
        JGoListPosition pos = doc.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = doc.getObjectAtPos(pos);
            pos = doc.getNextObjectPosAtTop(pos);
            bounds.setBounds(obj.getBoundingRect());
            if (bounds.x < minx) {
                minx = bounds.x;
            }
            if (bounds.y < miny) {
                miny = bounds.y;
            }
            if (bounds.x + bounds.width > maxDim.width) {
                maxDim.width = bounds.x + bounds.width;
            }
            if (bounds.y + bounds.height <= maxDim.height) continue;
            maxDim.height = bounds.y + bounds.height;
        }
        if (this.isIncludingNegativeCoords()) {
            if (minx < 0) {
                maxDim.width -= minx;
            }
            if (miny < 0) {
                maxDim.height -= miny;
            }
        }
        return maxDim;
    }

    protected class PrintThread
    extends Thread {
        private WorksheetView m_view;

        public PrintThread(WorksheetView view) {
            this.m_view = view;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                pj.setPrintable((Printable)((Object)this.m_view), pf);
                boolean wasDblBuff = WorksheetView.this.isDoubleBuffered();
                WorksheetView.this.setDoubleBuffered(false);
                new MinerApp.GenericPrintThread(pj).start();
                WorksheetView.this.setDoubleBuffered(wasDblBuff);
            }
            this.m_view.requestFocusInWindow();
        }
    }
}

