/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NaiveBayesEngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.CategoricalLevelMapper;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class NaiveBayesPredictor
implements CNKProcJavaTransformExec {
    private EngineNode m_engineNode = null;
    private XTProps m_model = null;
    private XTMetaData m_metaData = null;
    private double[][][] m_probabilities = null;
    private double[] m_depProbabilities = null;
    private Vector[] m_indepLevels = null;
    private String m_depColumn;
    private Vector m_depLevels;
    private int m_numIndepColumns;
    private int[] m_indepColumnNums = null;
    private int m_depColumnNum;
    private Vector m_outputSpecs = null;
    private Hashtable m_unknownLevelBehaviors = null;
    private CategoricalLevelMapper m_categoricalLevelMapper = null;
    private String m_outputDir = "";

    public NaiveBayesPredictor(XTProps model, XTMetaData metaData, EngineNode engineNode) {
        this.m_engineNode = engineNode;
        this.m_model = model;
        this.m_metaData = metaData;
        this.m_depColumn = this.m_model.getValue(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
        this.m_depColumnNum = metaData.nameToOrdinal(this.m_depColumn);
        this.m_depLevels = this.m_model.getSubProperties(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
        this.m_depLevels.remove(NaiveBayesEngineNode.TOTAL_ATTRIBUTE_TAG);
        this.m_depLevels.remove(NaiveBayesEngineNode.NAN_STRING);
        Vector indepColumns = this.m_model.getSubProperties(NaiveBayesEngineNode.COUNTS_ATTRIBUTE_TAG);
        this.m_numIndepColumns = indepColumns.size();
        this.m_indepLevels = new Vector[this.m_numIndepColumns];
        this.m_indepColumnNums = new int[this.m_numIndepColumns];
        this.m_probabilities = new double[this.m_depLevels.size()][this.m_numIndepColumns][];
        this.m_depProbabilities = new double[this.m_probabilities.length];
        long[] depLevelCounts = new long[this.m_depProbabilities.length];
        String[] depPath = new String[]{NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG, NaiveBayesEngineNode.TOTAL_ATTRIBUTE_TAG};
        long depTotal = Long.parseLong(model.getValue(depPath, "0")) + (long)this.m_probabilities.length;
        for (int i = 0; i < this.m_depProbabilities.length; ++i) {
            depPath[1] = (String)this.m_depLevels.get(i);
            depLevelCounts[i] = Long.parseLong(model.getValue(depPath, "0")) + 1L;
            this.m_depProbabilities[i] = (double)depLevelCounts[i] / (double)depTotal;
        }
        String[] path = new String[]{NaiveBayesEngineNode.COUNTS_ATTRIBUTE_TAG, "", "", ""};
        String[] levelPath = new String[]{NaiveBayesEngineNode.COUNTS_ATTRIBUTE_TAG, ""};
        for (int i = 0; i < this.m_numIndepColumns; ++i) {
            String indepColumn = (String)indepColumns.get(i);
            this.m_indepColumnNums[i] = metaData.nameToOrdinal(indepColumn);
            if (this.m_indepColumnNums[i] < 0) {
                throw new RuntimeException("Input missing independent column: " + indepColumn);
            }
            levelPath[1] = indepColumn;
            this.m_indepLevels[i] = this.m_model.getSubProperties(levelPath);
            int numIndepLevels = this.m_indepLevels[i].size();
            path[1] = indepColumn;
            for (int j = 0; j < this.m_probabilities.length; ++j) {
                this.m_probabilities[j][i] = new double[numIndepLevels];
                path[3] = (String)this.m_depLevels.get(j);
                for (int k = 0; k < numIndepLevels; ++k) {
                    double count;
                    path[2] = (String)this.m_indepLevels[i].get(k);
                    this.m_probabilities[j][i][k] = count = this.m_model.getDouble(path, 0.0) + 1.0;
                }
            }
        }
        for (int icol = 0; icol < this.m_numIndepColumns; ++icol) {
            int numIndepLevels = this.m_probabilities[0][icol].length;
            for (int ilev = 0; ilev < numIndepLevels; ++ilev) {
                double total = 0.0;
                for (int dlev = 0; dlev < this.m_probabilities.length; ++dlev) {
                    if (depLevelCounts[dlev] != 0L) {
                        double[] dArray = this.m_probabilities[dlev][icol];
                        int n = ilev;
                        dArray[n] = dArray[n] / (double)depLevelCounts[dlev];
                        continue;
                    }
                    this.m_probabilities[dlev][icol][ilev] = total;
                }
            }
        }
    }

    public void setGenerateCCode(String outputDir) {
        this.m_outputDir = outputDir;
    }

    public void resetGenerateCCode() {
        this.m_outputDir = "";
    }

    public void setOutputSpecs(Vector outputSpecs) {
        this.m_outputSpecs = outputSpecs;
    }

    public void setUnknownLevelBehaviors(Hashtable unknownLevelBehaviors) {
        this.m_unknownLevelBehaviors = unknownLevelBehaviors;
    }

    public void execute(CNKProcJavaTransform proc) {
        if (this.m_outputDir.length() == 0) {
            this.predictExecution(proc);
        } else {
            this.generateCExecution(this.m_outputDir);
        }
    }

    private void predictExecution(CNKProcJavaTransform proc) {
        if (this.m_categoricalLevelMapper == null) {
            this.m_categoricalLevelMapper = new CategoricalLevelMapper(proc.getInbuf());
            this.m_categoricalLevelMapper.setUnknownLevelBehaviors(this.m_unknownLevelBehaviors);
            this.m_categoricalLevelMapper.clearUnknownLevelError();
            for (int col = 0; col < this.m_numIndepColumns; ++col) {
                if (this.m_indepColumnNums[col] < 0) continue;
                Vector levelNames = new Vector(this.m_indepLevels[col]);
                this.m_categoricalLevelMapper.setModelLevels(this.m_indepColumnNums[col], levelNames);
            }
        }
        double[][] inbuf = new double[this.m_numIndepColumns][];
        for (int i = 0; i < this.m_numIndepColumns; ++i) {
            inbuf[i] = proc.getChunkInputColumnData(0, this.m_indepColumnNums[i]);
        }
        int numDepLevels = this.m_probabilities.length;
        double[] predictions = new double[numDepLevels];
        int numRows = proc.getChunkInputRows(0);
        double[][] outputLevelProbabilities = new double[numDepLevels][];
        for (int i = 0; i < numDepLevels; ++i) {
            outputLevelProbabilities[i] = new double[numRows];
            predictions[i] = this.m_depProbabilities[i];
        }
        double total = 0.0;
        for (int curRow = 0; curRow < numRows; ++curRow) {
            boolean readNA = false;
            for (int i = 0; i < this.m_numIndepColumns; ++i) {
                double indepLevel = inbuf[i][curRow];
                double mappedDatalevel = this.m_categoricalLevelMapper.mapBufLevelToModelLevel(this.m_indepColumnNums[i], indepLevel);
                if (CNKObj.isDoubleNA(mappedDatalevel)) {
                    readNA = true;
                    continue;
                }
                total = 0.0;
                for (int j = 0; j < numDepLevels; ++j) {
                    int n = j;
                    predictions[n] = predictions[n] * this.m_probabilities[j][i][(int)mappedDatalevel];
                    total += predictions[j];
                }
            }
            if (this.m_categoricalLevelMapper.hasUnknownLevelError()) {
                String msg = "Categorical column " + this.m_categoricalLevelMapper.getUnknownLevelBadColumn() + " contains unknown level: " + this.m_categoricalLevelMapper.getUnknownLevelBadLevel();
                proc.setError(msg);
                return;
            }
            for (int j = 0; j < numDepLevels; ++j) {
                outputLevelProbabilities[j][curRow] = readNA || total == 0.0 ? CNKObj.getDoubleNA() : predictions[j] / total;
                predictions[j] = this.m_depProbabilities[j];
            }
        }
        if (this.m_outputSpecs != null) {
            for (int i = 0; i < this.m_outputSpecs.size(); ++i) {
                PredictEngineNode.OutputSpec os = (PredictEngineNode.OutputSpec)this.m_outputSpecs.get(i);
                if (os.m_role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    if (os.m_inputColNum < 0) continue;
                    proc.copyColumnData(0, i, 0, 0, os.m_inputColNum, 0, numRows);
                    continue;
                }
                if (os.m_role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    if (this.m_depColumnNum < 0) continue;
                    proc.copyColumnData(0, i, 0, 0, this.m_depColumnNum, 0, numRows);
                    continue;
                }
                if (os.m_role.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG) && os.m_glmTag.equals("copy")) {
                    if (os.m_inputColNum < 0) continue;
                    proc.copyColumnData(0, i, 0, 0, os.m_inputColNum, 0, numRows);
                    continue;
                }
                if (os.m_role.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG) && os.m_glmTag.equals("category")) {
                    String[] outputCategories = proc.getChunkOutputColumnStrings(0, i);
                    for (int j = 0; j < numRows; ++j) {
                        String rowCat;
                        double max = -1.0;
                        int index = -1;
                        for (int k = 0; k < outputLevelProbabilities.length; ++k) {
                            double levelProb = outputLevelProbabilities[k][j];
                            if (CNKObj.isDoubleNA(levelProb)) {
                                max = -1.0;
                                index = -1;
                                break;
                            }
                            if (!(levelProb > max)) continue;
                            max = levelProb;
                            index = k;
                        }
                        outputCategories[j] = rowCat = index < 0 ? CNKObj.getStringNA() : (String)this.m_depLevels.get(index);
                    }
                    continue;
                }
                if (os.m_role.equals(XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG) && os.m_glmTag.equals("probability")) {
                    int index = this.m_depLevels.indexOf(os.m_varName);
                    if (index < 0) {
                        String err = "Desired level (\"" + os.m_varName + "\") could not be found in the data.";
                        this.m_engineNode.printError(err);
                        throw new RuntimeException(err);
                    }
                    double[] outputProbabilities = proc.getChunkOutputColumnDoubles(0, i);
                    System.arraycopy(outputLevelProbabilities[index], 0, outputProbabilities, 0, numRows);
                    continue;
                }
                if (!os.m_role.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG) || !os.m_glmTag.equals("agreement")) continue;
                double[] outputAgreement = proc.getChunkOutputColumnDoubles(0, i);
                String[] inputDepCategories = this.m_depColumnNum < 0 ? null : proc.getChunkInputColumnStrings(0, this.m_depColumnNum);
                for (int j = 0; j < numRows; ++j) {
                    String rowCat;
                    double max = -1.0;
                    int index = -1;
                    for (int k = 0; k < outputLevelProbabilities.length; ++k) {
                        double levelProb = outputLevelProbabilities[k][j];
                        if (CNKObj.isDoubleNA(levelProb)) {
                            max = -1.0;
                            index = -1;
                            break;
                        }
                        if (!(levelProb > max)) continue;
                        max = levelProb;
                        index = k;
                    }
                    String string = rowCat = index < 0 ? CNKObj.getStringNA() : (String)this.m_depLevels.get(index);
                    outputAgreement[j] = inputDepCategories == null || CNKObj.isStringNA(rowCat) || CNKObj.isStringNA(inputDepCategories[j]) ? CNKObj.getDoubleNA() : (rowCat.equals(inputDepCategories[j]) ? 1.0 : 0.0);
                }
            }
        }
    }

    private void generateCExecution(String outputDir) {
        long nIndepCols = this.m_indepColumnNums.length;
        long nDepLevels = this.m_depLevels.size();
        long[] nIndepLevels = new long[(int)nIndepCols];
        long maxIndepLevels = 0L;
        for (int i = 0; i < nIndepLevels.length; ++i) {
            nIndepLevels[i] = this.m_indepLevels[i].size();
            if (i == 0) {
                maxIndepLevels = nIndepLevels[i];
                continue;
            }
            if (maxIndepLevels >= nIndepLevels[i]) continue;
            maxIndepLevels = nIndepLevels[i];
        }
        double[] iProbs = new double[(int)nDepLevels];
        int i = 0;
        while ((long)i < nDepLevels) {
            iProbs[i] = this.m_depProbabilities[i];
            ++i;
        }
        double[] pMatrix = new double[(int)(nIndepCols * nDepLevels * maxIndepLevels)];
        int i2 = 0;
        int pos = 0;
        while ((long)i2 < nIndepCols) {
            int j = 0;
            while ((long)j < maxIndepLevels) {
                int k = 0;
                while ((long)k < nDepLevels) {
                    pMatrix[pos++] = (long)j < nIndepLevels[i2] ? this.m_probabilities[k][i2][j] : 0.0;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        String[] depLevels = new String[this.m_depLevels.size()];
        for (int i3 = 0; i3 < depLevels.length; ++i3) {
            depLevels[i3] = (String)this.m_depLevels.get(i3);
        }
        int[] colNums = this.m_indepColumnNums;
        String[] colNames = new String[colNums.length];
        long[] numLevels = new long[colNames.length];
        long maxLevels = 0L;
        long nColumns = colNames.length;
        for (int i4 = 0; i4 < colNames.length; ++i4) {
            colNames[i4] = this.m_metaData.ordinalToName(colNums[i4]);
            numLevels[i4] = this.m_metaData.getCategoricalDataFieldLevels(colNames[i4]).size();
            if (i4 == 0) {
                maxLevels = numLevels[i4];
                continue;
            }
            if (maxLevels >= numLevels[i4]) continue;
            maxLevels = numLevels[i4];
        }
        String[] levelNames = new String[(int)((long)colNames.length * maxLevels)];
        int ln = 0;
        for (int i5 = 0; i5 < colNames.length; ++i5) {
            int j = 0;
            while ((long)j < maxLevels) {
                levelNames[ln] = (long)j < numLevels[i5] ? this.m_metaData.getCategoricalDataFieldLevel(colNums[i5], j) : "";
                ++ln;
                ++j;
            }
        }
        String inputDir = MinerApp.getSprimeHome() + File.separator + "imcsrc";
        System.out.println("naive bayes predictor input dir: " + inputDir);
        String cnkmisc_file = CNKObj.getLibraryFileName("cnkmisc");
        Runtime.getRuntime().load(cnkmisc_file);
        NaiveBayesPredictor.output_model(outputDir, inputDir, nIndepCols, nDepLevels, nIndepLevels, iProbs, pMatrix, depLevels, nColumns, maxLevels, colNames, numLevels, levelNames);
    }

    private static native long output_model(String var0, String var1, long var2, long var4, long[] var6, double[] var7, double[] var8, String[] var9, long var10, long var12, String[] var14, long[] var15, String[] var16);
}

