/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusControlMethods;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusObjectComboBox;
import com.insightful.splus.SplusSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class SplusDataSetComboBox
extends SplusComboBox
implements SplusDataColumnListProvider {
    static String[] dataSetList = null;
    Vector registeredColumnControls = new Vector();
    String[] columnList = new String[]{""};

    public SplusDataSetComboBox() {
        this("Data Set:");
        this.setMnemonic('D');
    }

    public SplusDataSetComboBox(String string, char c) {
        this(string);
        this.setMnemonic(c);
    }

    public SplusDataSetComboBox(String string, int n) {
        this(string);
        this.setMnemonic(n);
    }

    public SplusDataSetComboBox(String string) {
        super(string);
        if (dataSetList == null) {
            SplusDataSetComboBox.updateDataSetList();
        }
        this.setOptionList(dataSetList);
        this.setValue(SplusDataSetComboBox.getCurrentDataSet());
        this.updateColumnList();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SplusDataSetComboBox.this.updateColumnList();
                SplusDataSetComboBox.this.updateRegisteredColumnControls();
            }
        });
    }

    public static final String getCurrentDataSet() {
        return "";
    }

    public static final String[] getDataSetList() {
        if (dataSetList == null) {
            SplusDataSetComboBox.updateDataSetList();
        }
        return dataSetList;
    }

    public static final void updateDataSetList() {
        dataSetList = SplusObjectComboBox.getObjectsOfClass("data.frame", true);
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    private void updateColumnList() {
        String string = this.getValue();
        if (string != null && string != "") {
            String string2 = "if (exists(\"" + string + "\") && inherits(" + string + ",\"data.frame\")){ names(" + string + ")} else { \"\"}";
            try {
                SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string2);
                this.columnList = splusDataResult.getStringData();
            }
            catch (Exception exception) {}
        } else {
            this.columnList = new String[]{""};
        }
    }

    public void registerColumnControl(SplusControlMethods splusControlMethods) {
        this.registeredColumnControls.add(splusControlMethods);
    }

    private void updateRegisteredColumnControls() {
        for (int i = 0; i < this.registeredColumnControls.size(); ++i) {
            SplusControlMethods splusControlMethods = (SplusControlMethods)this.registeredColumnControls.elementAt(i);
            splusControlMethods.setOptionList(this.columnList);
            splusControlMethods.setValue("");
        }
    }
}

