/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusPrintable;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TextPrinter
implements SplusPrintable {
    String m_str;
    List m_aLines;
    long m_cLines;
    int m_cxPage;
    int m_cyPage;
    FontMetrics m_fm;
    Font m_font;
    int m_cCharWidth;
    int m_cCharHeight;
    int m_cLinesPerPage;
    int m_cMaxCharsPerLine;
    private boolean isLinux = System.getProperty("os.name", "").toLowerCase().indexOf("linux") > -1;

    void buildLines(int n) {
        this.m_aLines = new ArrayList();
        this.m_cLines = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_str, "\r\n\f");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            String string = stringTokenizer.nextToken();
            int n4 = string.length();
            if (string.indexOf(9) > -1) {
                n3 = 8;
                StringBuffer stringBuffer = new StringBuffer(1 * string.length());
                for (int i = 0; i < n4; ++i) {
                    char c = string.charAt(i);
                    if (c == '\t') {
                        n2 = n3 - stringBuffer.length() % n3;
                        for (int j = 0; j < n2; ++j) {
                            stringBuffer.append(' ');
                        }
                        continue;
                    }
                    stringBuffer.append(c);
                }
                string = stringBuffer.toString();
                n4 = string.length();
            }
            if ((n4 = string.length()) <= n) {
                this.m_aLines.add(this.escapeSpecialChars(string));
                ++this.m_cLines;
                continue;
            }
            n3 = 0;
            n2 = 0;
            while (n3 < n4) {
                n2 = Math.min(n3 + n, n4);
                this.m_aLines.add(this.escapeSpecialChars(string.substring(n3, n2)));
                ++this.m_cLines;
                n3 = n2;
            }
        }
    }

    private String escapeSpecialChars(String string) {
        if (this.isLinux) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(1 * n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ')' || c == '(' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public int getNumberOfPages() {
        if (this.m_aLines == null) {
            return -1;
        }
        return (int)(this.m_cLines / (long)this.m_cLinesPerPage + 1L);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.m_font != null) {
            graphics.setFont(this.m_font);
        }
        if (this.m_aLines == null || (double)this.m_cxPage != pageFormat.getImageableWidth() || (double)this.m_cyPage != pageFormat.getImageableHeight()) {
            this.m_fm = graphics.getFontMetrics();
            this.m_cxPage = (int)pageFormat.getImageableWidth();
            this.m_cyPage = (int)pageFormat.getImageableHeight();
            this.m_cxPage = Math.min(this.m_cxPage, (int)pageFormat.getWidth() - 36);
            this.m_cyPage = Math.min(this.m_cyPage, (int)pageFormat.getHeight() - 36);
            this.m_cCharWidth = this.m_fm.charWidth('M');
            this.m_cCharHeight = this.m_fm.getHeight();
            this.m_cMaxCharsPerLine = this.m_cxPage / this.m_cCharWidth;
            this.m_cLinesPerPage = this.m_cyPage / this.m_cCharHeight;
            this.buildLines(this.m_cMaxCharsPerLine);
        }
        int n2 = Math.max((int)pageFormat.getImageableX(), 18);
        int n3 = Math.max((int)pageFormat.getImageableY(), 18);
        long l = n * this.m_cLinesPerPage;
        if (l >= this.m_cLines) {
            return 1;
        }
        for (long i = l; i < l + (long)this.m_cLinesPerPage && i < this.m_cLines; ++i) {
            String string = (String)this.m_aLines.get((int)i);
            graphics.drawString(string, n2, (int)((long)n3 + (long)this.m_cCharHeight * (i - l + 1L)));
        }
        return 0;
    }

    public TextPrinter(String string) {
        this.m_str = string;
    }

    public TextPrinter(String string, Font font) {
        this.m_str = string;
        this.m_font = font;
    }
}

