/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class ListBlockLayoutManager
extends BlockStackingLayoutManager {
    private Block curBlockArea;

    public ListBlockLayoutManager(ListBlock node) {
        super(node);
        this.initialize();
    }

    protected ListBlock getListBlockFO() {
        return (ListBlock)this.fobj;
    }

    private void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceBefore).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceAfter).getSpace();
    }

    private int getIPIndents() {
        int iIndents = 0;
        iIndents += this.getListBlockFO().getCommonMarginBlock().startIndent.getValue();
        return iIndents += this.getListBlockFO().getCommonMarginBlock().endIndent.getValue();
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        return super.getChangedKnuthElements(oldList, alignment);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, new MinOptMax(layoutContext.getSpaceBefore()));
        }
        double adjust = layoutContext.getSpaceAdjust();
        this.addBlockSpacing(adjust, this.foSpaceBefore);
        this.foSpaceBefore = null;
        this.getPSLM().addIDToPage(this.getListBlockFO().getId());
        LayoutManager childLM = null;
        LayoutContext lc = new LayoutContext(0);
        LayoutManager firstLM = null;
        LayoutManager lastLM = null;
        Position firstPos = null;
        Position lastPos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            if (!(pos instanceof NonLeafPosition) || pos.getPosition() == null || ((NonLeafPosition)pos).getPosition().getLM() == this) continue;
            positionList.add(((NonLeafPosition)pos).getPosition());
            lastLM = ((NonLeafPosition)pos).getPosition().getLM();
            if (firstLM != null) continue;
            firstLM = lastLM;
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, true, this.isFirst(firstPos), this.isLast(lastPos));
        }
        StackingIter childPosIter = new StackingIter(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setFlags(32, childLM == firstLM);
            lc.setFlags(128, childLM == lastLM);
            lc.setStackLimit(layoutContext.getStackLimit());
            childLM.addAreas(childPosIter, lc);
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, false, this.isFirst(firstPos), this.isLast(lastPos));
        }
        this.flush();
        this.addBlockSpacing(adjust, this.foSpaceAfter);
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getListBlockFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground());
            TraitSetter.addBackground(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground());
            TraitSetter.addMargins(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.getListBlockFO().getCommonMarginBlock());
            TraitSetter.addBreaks(this.curBlockArea, this.getListBlockFO().getBreakBefore(), this.getListBlockFO().getBreakAfter());
            int contentIPD = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(contentIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getListBlockFO().getKeepTogether().getWithinPage().isAuto() || !this.getListBlockFO().getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getListBlockFO().getKeepWithPrevious().getWithinPage().isAuto() || !this.getListBlockFO().getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getListBlockFO().getKeepWithNext().getWithinPage().isAuto() || !this.getListBlockFO().getKeepWithNext().getWithinColumn().isAuto();
    }

    private static class StackingIter
    extends PositionIterator {
        StackingIter(Iterator parentIter) {
            super(parentIter);
        }

        protected LayoutManager getLM(Object nextObj) {
            return ((Position)nextObj).getLM();
        }

        protected Position getPos(Object nextObj) {
            return (Position)nextObj;
        }
    }
}

