/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.tools.anttasks.Fop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.GlobPatternMapper;

class FOPTaskStarter {
    private Fop task;
    private String baseURL = null;
    protected Log logger = null;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    protected Log getLogger() {
        return this.logger;
    }

    FOPTaskStarter(Fop task) throws FOPException {
        this.task = task;
    }

    private int determineRenderer(String format) {
        if (format == null || format.equalsIgnoreCase("application/pdf") || format.equalsIgnoreCase("pdf")) {
            return 1;
        }
        if (format.equalsIgnoreCase("application/postscript") || format.equalsIgnoreCase("ps")) {
            return 6;
        }
        if (format.equalsIgnoreCase("application/vnd.mif") || format.equalsIgnoreCase("mif")) {
            return 3;
        }
        if (format.equalsIgnoreCase("application/msword") || format.equalsIgnoreCase("application/rtf") || format.equalsIgnoreCase("rtf")) {
            return 10;
        }
        if (format.equalsIgnoreCase("application/vnd.hp-PCL") || format.equalsIgnoreCase("pcl")) {
            return 5;
        }
        if (format.equalsIgnoreCase("text/plain") || format.equalsIgnoreCase("txt")) {
            return 7;
        }
        if (format.equalsIgnoreCase("text/xml") || format.equalsIgnoreCase("at") || format.equalsIgnoreCase("xml")) {
            return 9;
        }
        if (format.equalsIgnoreCase("image/tiff") || format.equalsIgnoreCase("tiff") || format.equalsIgnoreCase("tif")) {
            return 11;
        }
        if (format.equalsIgnoreCase("image/png") || format.equalsIgnoreCase("png")) {
            return 12;
        }
        String err = "Couldn't determine renderer to use: " + format;
        throw new BuildException(err);
    }

    private String determineExtension(int renderer) {
        switch (renderer) {
            case 1: {
                return ".pdf";
            }
            case 6: {
                return ".ps";
            }
            case 3: {
                return ".mif";
            }
            case 10: {
                return ".rtf";
            }
            case 5: {
                return ".pcl";
            }
            case 7: {
                return ".txt";
            }
            case 9: {
                return ".xml";
            }
            case 11: {
                return ".tiff";
            }
            case 12: {
                return ".png";
            }
        }
        String err = "Unknown renderer: " + renderer;
        throw new BuildException(err);
    }

    private File replaceExtension(File file, String expectedExt, String newExt) {
        String name = file.getName();
        if (name.toLowerCase().endsWith(expectedExt)) {
            name = name.substring(0, name.length() - expectedExt.length());
        }
        name = name.concat(newExt);
        return new File(file.getParentFile(), name);
    }

    public void run() throws FOPException {
        if (this.task.getUserconfig() != null) {
            // empty if block
        }
        if (this.task.getBasedir() != null) {
            try {
                this.baseURL = this.task.getBasedir().toURL().toExternalForm();
            }
            catch (MalformedURLException mfue) {
                this.logger.error("Error creating base URL from base directory", mfue);
            }
        } else {
            try {
                if (this.task.getFofile() != null) {
                    this.baseURL = this.task.getFofile().getParentFile().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException mfue) {
                this.logger.error("Error creating base URL from XSL-FO input file", mfue);
            }
        }
        this.task.log("Using base URL: " + this.baseURL, 4);
        int rint = this.determineRenderer(this.task.getFormat());
        String newExtension = this.determineExtension(rint);
        int actioncount = 0;
        int skippedcount = 0;
        if (this.task.getFofile() != null && this.task.getFofile().exists()) {
            File outf = this.task.getOutfile();
            if (outf == null) {
                throw new BuildException("outfile is required when fofile is used");
            }
            if (this.task.getOutdir() != null) {
                outf = new File(this.task.getOutdir(), outf.getName());
            }
            if (this.task.getForce() || !outf.exists() || this.task.getFofile().lastModified() > outf.lastModified()) {
                this.render(this.task.getFofile(), outf, rint);
                ++actioncount;
            } else if (outf.exists() && this.task.getFofile().lastModified() <= outf.lastModified()) {
                ++skippedcount;
            }
        }
        GlobPatternMapper mapper = new GlobPatternMapper();
        mapper.setFrom("*.fo");
        mapper.setTo("*" + newExtension);
        for (int i = 0; i < this.task.getFilesets().size(); ++i) {
            FileSet fs = (FileSet)this.task.getFilesets().get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.task.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                File f = new File(fs.getDir(this.task.getProject()), files[j]);
                File outf = null;
                if (this.task.getOutdir() != null && files[j].endsWith(".fo")) {
                    String[] sa = mapper.mapFileName(files[j]);
                    outf = new File(this.task.getOutdir(), sa[0]);
                } else {
                    outf = this.replaceExtension(f, ".fo", newExtension);
                    if (this.task.getOutdir() != null) {
                        outf = new File(this.task.getOutdir(), outf.getName());
                    }
                }
                try {
                    if (this.task.getRelativebase()) {
                        this.baseURL = f.getParentFile().toURL().toExternalForm();
                    }
                    if (this.baseURL == null) {
                        this.baseURL = fs.getDir(this.task.getProject()).toURL().toExternalForm();
                    }
                }
                catch (Exception e) {
                    this.task.log("Error setting base URL", 4);
                }
                if (this.task.getForce() || !outf.exists() || f.lastModified() > outf.lastModified()) {
                    this.render(f, outf, rint);
                    ++actioncount;
                    continue;
                }
                if (!outf.exists() || f.lastModified() > outf.lastModified()) continue;
                ++skippedcount;
            }
        }
        if (actioncount + skippedcount == 0) {
            this.task.log("No files processed. No files were selected by the filesets and no fofile was set.", 1);
        } else if (skippedcount > 0) {
            this.task.log(skippedcount + " xslfo file(s) skipped (no change found" + " since last generation; set force=\"true\" to override).", 2);
        }
    }

    private void render(File foFile, File outFile, int renderer) throws FOPException {
        InputHandler inputHandler = new InputHandler(foFile);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to open " + outFile, (Throwable)ex);
        }
        if (this.task.getLogFiles()) {
            this.task.log(foFile + " -> " + outFile, 2);
        }
        try {
            FOUserAgent userAgent = new FOUserAgent();
            userAgent.setBaseURL(this.baseURL);
            org.apache.fop.apps.Fop fop = new org.apache.fop.apps.Fop(renderer, userAgent);
            fop.setOutputStream(out);
            inputHandler.render(fop);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                this.logger.error("Error closing output file", ioe);
            }
        }
    }
}

