/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.MinOptMax;

public class SpaceVal {
    private final MinOptMax space;
    private final boolean bConditional;
    private final boolean bForcing;
    private final int iPrecedence;

    public SpaceVal(SpaceProperty spaceprop) {
        this.space = new MinOptMax(spaceprop.getMinimum().getLength().getValue(), spaceprop.getOptimum().getLength().getValue(), spaceprop.getMaximum().getLength().getValue());
        this.bConditional = spaceprop.getConditionality().getEnum() == 32;
        Property precProp = spaceprop.getPrecedence();
        if (precProp.getNumber() != null) {
            this.iPrecedence = precProp.getNumber().intValue();
            this.bForcing = false;
        } else {
            this.bForcing = precProp.getEnum() == 53;
            this.iPrecedence = 0;
        }
    }

    public SpaceVal(MinOptMax space, boolean bConditional, boolean bForcing, int iPrecedence) {
        this.space = space;
        this.bConditional = bConditional;
        this.bForcing = bForcing;
        this.iPrecedence = iPrecedence;
    }

    public static SpaceVal makeWordSpacing(Property wordSpacing, SpaceVal letterSpacing, Font fs) {
        if (wordSpacing.getEnum() == 97) {
            int spaceCharIPD = fs.getCharWidth(' ');
            MinOptMax space = new MinOptMax(-spaceCharIPD / 3, 0, spaceCharIPD / 2);
            return new SpaceVal(MinOptMax.add(space, MinOptMax.multiply(letterSpacing.getSpace(), 2.0)), true, true, 0);
        }
        return new SpaceVal(wordSpacing.getSpace());
    }

    public static SpaceVal makeLetterSpacing(Property letterSpacing) {
        if (letterSpacing.getEnum() == 97) {
            return new SpaceVal(new MinOptMax(0), true, true, 0);
        }
        return new SpaceVal(letterSpacing.getSpace());
    }

    public boolean isConditional() {
        return this.bConditional;
    }

    public boolean isForcing() {
        return this.bForcing;
    }

    public int getPrecedence() {
        return this.iPrecedence;
    }

    public MinOptMax getSpace() {
        return this.space;
    }

    public String toString() {
        return "SpaceVal: " + this.getSpace().toString();
    }
}

