/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.cnkjava;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CNKProcJavaTransform
extends CNKProc {
    private CNKProcJavaTransformExec m_exec = null;
    private int m_numInputs = 0;
    private int m_numOutputs = 0;
    private int m_numInputRows = 0;
    private int m_numOutputRows = 0;
    private Object[][] m_inputData = null;
    private Object[][] m_outputData = null;
    private boolean[][] m_inputDataAccessed = null;
    private boolean[][] m_outputDataAccessed = null;
    private long m_nextRowsDone = 0L;
    private int[] m_inputReleaseRows = null;
    private boolean[] m_inputReleaseAll = null;
    private long[] m_nextInputPosition = null;
    private int[] m_outputReleaseRows = null;
    private int m_done = 0;
    private boolean m_resetDynamicOutputs = false;
    private boolean m_resetDynamicOutputsDone = false;
    private boolean m_anyRowsOutput = false;
    private final int UNSET_VALUE = -999;

    public void createPeerObject() {
        this.createCNKObject("cnkjava", new String[]{"CNKProcJavaTransform", "CNKProc", "CNKObj"});
    }

    public CNKProcJavaTransform() {
        this.setProp("java.transform.object", this);
    }

    public CNKProcJavaTransform(CNKProcJavaTransformExec exec) {
        this();
        this.setExecObject(exec);
    }

    public CNKProcJavaTransform(CNKBuf inbuf, CNKBuf outbuf, int numRows, CNKProcJavaTransformExec exec) {
        this();
        this.setInbuf(inbuf);
        this.setOutbuf(outbuf);
        this.setNumRows(numRows);
        this.setOutputNumRows(numRows);
        this.setExecObject(exec);
    }

    public void setExecObject(CNKProcJavaTransformExec exec) {
        this.m_exec = exec;
    }

    public CNKProcJavaTransformExec getExecObject() {
        return this.m_exec;
    }

    public int getChunkInputRows(int inputNum) {
        return this.getIntProp("chunk.input.rows", new Integer(inputNum));
    }

    public int getChunkOutputRows(int outputNum) {
        return this.getIntProp("chunk.output.rows", new Integer(outputNum));
    }

    public long getChunkInputPosition(int inputNum) {
        return this.getLongProp("chunk.input.pos", new Integer(inputNum));
    }

    public long getChunkOutputPosition(int outputNum) {
        return this.getLongProp("chunk.output.pos", new Integer(outputNum));
    }

    public long getChunkInputTotalRows(int inputNum) {
        CNKBuf buf = this.getInbuf(inputNum);
        return buf == null ? -1L : buf.getTotalNumRows();
    }

    public boolean getChunkInputLast(int inputNum) {
        return this.getBooleanProp("chunk.input.last", new Integer(inputNum));
    }

    public double[] getChunkInputColumnData(int inputNum, int colNum) {
        return this.getChunkInputColumnDoubles(inputNum, colNum);
    }

    public double[] getChunkInputColumnDoubles(int inputNum, int colNum) {
        try {
            if (inputNum < 0 || inputNum >= this.m_numInputs || colNum < 0 || colNum >= this.m_inputData[inputNum].length) {
                return null;
            }
            Object data = this.m_inputData[inputNum][colNum];
            if (data == null || !(data instanceof double[]) || ((double[])data).length < this.m_numInputRows) {
                this.m_inputData[inputNum][colNum] = data = (Object)new double[this.m_numInputRows];
                this.m_inputDataAccessed[inputNum][colNum] = false;
            }
            if (!this.m_inputDataAccessed[inputNum][colNum]) {
                this.readInputDoubles(inputNum, colNum, (double[])data);
                this.m_inputDataAccessed[inputNum][colNum] = true;
            }
            return (double[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating input=" + inputNum + ", column=" + colNum);
            return null;
        }
    }

    public double[] getChunkOutputColumnData(int outputNum, int colNum) {
        return this.getChunkOutputColumnDoubles(outputNum, colNum);
    }

    public double[] getChunkOutputColumnDoubles(int outputNum, int colNum) {
        try {
            if (outputNum < 0 || outputNum >= this.m_numOutputs || colNum < 0 || colNum >= this.m_outputData[outputNum].length) {
                return null;
            }
            Object data = this.m_outputData[outputNum][colNum];
            if (data == null || !(data instanceof double[]) || ((double[])data).length < this.m_numOutputRows) {
                this.m_outputData[outputNum][colNum] = data = (Object)new double[this.m_numOutputRows];
            }
            this.m_outputDataAccessed[outputNum][colNum] = true;
            return (double[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating output=" + outputNum + ", column=" + colNum);
            return null;
        }
    }

    public String[] getChunkInputColumnStrings(int inputNum, int colNum) {
        try {
            if (inputNum < 0 || inputNum >= this.m_numInputs || colNum < 0 || colNum >= this.m_inputData[inputNum].length) {
                return null;
            }
            String[] data = this.m_inputData[inputNum][colNum];
            if (data == null || !(data instanceof String[]) || data.length < this.m_numInputRows) {
                this.m_inputData[inputNum][colNum] = data = new String[this.m_numInputRows];
                this.m_inputDataAccessed[inputNum][colNum] = false;
            }
            if (!this.m_inputDataAccessed[inputNum][colNum]) {
                this.readInputStrings(inputNum, colNum, data);
                this.m_inputDataAccessed[inputNum][colNum] = true;
            }
            return data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating input=" + inputNum + ", column=" + colNum);
            return null;
        }
    }

    public String[] getChunkOutputColumnStrings(int outputNum, int colNum) {
        try {
            if (outputNum < 0 || outputNum >= this.m_numOutputs || colNum < 0 || colNum >= this.m_outputData[outputNum].length) {
                return null;
            }
            String[] data = this.m_outputData[outputNum][colNum];
            if (data == null || !(data instanceof String[]) || data.length < this.m_numOutputRows) {
                this.m_outputData[outputNum][colNum] = data = new String[this.m_numOutputRows];
            }
            this.m_outputDataAccessed[outputNum][colNum] = true;
            return data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating output=" + outputNum + ", column=" + colNum);
            return null;
        }
    }

    public int[] getChunkInputColumnLevelNums(int inputNum, int colNum) {
        try {
            if (inputNum < 0 || inputNum >= this.m_numInputs || colNum < 0 || colNum >= this.m_inputData[inputNum].length) {
                return null;
            }
            Object data = this.m_inputData[inputNum][colNum];
            if (data == null || !(data instanceof int[]) || ((int[])data).length < this.m_numInputRows) {
                this.m_inputData[inputNum][colNum] = data = (Object)new int[this.m_numInputRows];
                this.m_inputDataAccessed[inputNum][colNum] = false;
            }
            if (!this.m_inputDataAccessed[inputNum][colNum]) {
                this.readInputLevelNums(inputNum, colNum, (int[])data);
                this.m_inputDataAccessed[inputNum][colNum] = true;
            }
            return (int[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating input=" + inputNum + ", column=" + colNum);
            return null;
        }
    }

    public int[] getChunkOutputColumnLevelNums(int outputNum, int colNum) {
        try {
            if (outputNum < 0 || outputNum >= this.m_numOutputs || colNum < 0 || colNum >= this.m_outputData[outputNum].length) {
                return null;
            }
            Object data = this.m_outputData[outputNum][colNum];
            if (data == null || !(data instanceof int[]) || ((int[])data).length < this.m_numOutputRows) {
                this.m_outputData[outputNum][colNum] = data = (Object)new int[this.m_numOutputRows];
            }
            this.m_outputDataAccessed[outputNum][colNum] = true;
            return (int[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating output=" + outputNum + ", column=" + colNum);
            return null;
        }
    }

    public long[] getChunkInputColumnDateTimes(int inputNum, int colNum) {
        try {
            if (inputNum < 0 || inputNum >= this.m_numInputs || colNum < 0 || colNum >= this.m_inputData[inputNum].length) {
                return null;
            }
            Object data = this.m_inputData[inputNum][colNum];
            if (data == null || !(data instanceof long[]) || ((long[])data).length < this.m_numInputRows) {
                this.m_inputData[inputNum][colNum] = data = (Object)new long[this.m_numInputRows];
                this.m_inputDataAccessed[inputNum][colNum] = false;
            }
            if (!this.m_inputDataAccessed[inputNum][colNum]) {
                this.readInputDateTimes(inputNum, colNum, (long[])data);
                this.m_inputDataAccessed[inputNum][colNum] = true;
            }
            return (long[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating input=" + inputNum + ", column=" + colNum);
            return null;
        }
    }

    public long[] getChunkOutputColumnDateTimes(int outputNum, int colNum) {
        try {
            if (outputNum < 0 || outputNum >= this.m_numOutputs || colNum < 0 || colNum >= this.m_outputData[outputNum].length) {
                return null;
            }
            Object data = this.m_outputData[outputNum][colNum];
            if (data == null || !(data instanceof long[]) || ((long[])data).length < this.m_numOutputRows) {
                this.m_outputData[outputNum][colNum] = data = (Object)new long[this.m_numOutputRows];
            }
            this.m_outputDataAccessed[outputNum][colNum] = true;
            return (long[])data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating output=" + outputNum + ", column=" + colNum);
            return null;
        }
    }

    public Object[] getChunkInputColumnBlobs(int inputNum, int colNum) {
        try {
            if (inputNum < 0 || inputNum >= this.m_numInputs || colNum < 0 || colNum >= this.m_inputData[inputNum].length) {
                return null;
            }
            Object[] data = this.m_inputData[inputNum][colNum];
            if (data == null || !(data instanceof Object[]) || data instanceof String[] || data.length < this.m_numInputRows) {
                this.m_inputData[inputNum][colNum] = data = new Object[this.m_numInputRows];
                this.m_inputDataAccessed[inputNum][colNum] = false;
            }
            if (!this.m_inputDataAccessed[inputNum][colNum]) {
                this.readInputBlobs(inputNum, colNum, data);
                this.m_inputDataAccessed[inputNum][colNum] = true;
            }
            return data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating input=" + inputNum + ", column=" + colNum);
            return null;
        }
    }

    public Object[] getChunkOutputColumnBlobs(int outputNum, int colNum) {
        try {
            if (outputNum < 0 || outputNum >= this.m_numOutputs || colNum < 0 || colNum >= this.m_outputData[outputNum].length) {
                return null;
            }
            Object[] data = this.m_outputData[outputNum][colNum];
            if (data == null || !(data instanceof Object[]) || data instanceof String[] || data.length < this.m_numOutputRows) {
                this.m_outputData[outputNum][colNum] = data = new Object[this.m_numOutputRows];
            }
            this.m_outputDataAccessed[outputNum][colNum] = true;
            return data;
        }
        catch (OutOfMemoryError ex) {
            this.addError("out of memory allocating output=" + outputNum + ", column=" + colNum);
            return null;
        }
    }

    public void setChunkNextRowsDone(long rowsDone) {
        this.m_nextRowsDone = rowsDone;
    }

    public void setChunkInputReleaseRows(int inputNum, int releaseRows) {
        if (inputNum >= 0 && inputNum < this.m_numInputs) {
            this.m_inputReleaseRows[inputNum] = Math.max(0, Math.min(this.getChunkInputRows(inputNum), releaseRows));
        }
    }

    public void setChunkInputReleaseAll(int inputNum) {
        if (inputNum >= 0 && inputNum < this.m_numInputs) {
            this.m_inputReleaseAll[inputNum] = true;
        }
    }

    public void setChunkOutputReleaseRows(int outputNum, int releaseRows) {
        if (outputNum >= 0 && outputNum < this.m_numOutputs) {
            this.m_outputReleaseRows[outputNum] = Math.max(0, Math.min(this.m_numOutputRows, releaseRows));
        }
    }

    public void setChunkNextInputPosition(int inputNum, long pos) {
        if (inputNum >= 0 && inputNum < this.m_numInputs) {
            this.m_nextInputPosition[inputNum] = pos;
        }
    }

    public void setChunkDone(boolean val) {
        this.m_done = val ? 1 : 0;
    }

    public void copyColumnData(int outputNum, int outputFirstCol, int outputFirstRow, int inputNum, int inputFirstCol, int inputFirstRow, int numRows) {
        this.copyData(outputNum, outputFirstCol, outputFirstRow, inputNum, inputFirstCol, inputFirstRow, numRows, 1);
    }

    public void resetDynamicOutputs() {
        this.m_resetDynamicOutputs = true;
    }

    public void copyData(int outputNum, int outputFirstCol, int outputFirstRow, int inputNum, int inputFirstCol, int inputFirstRow, int numRows, int numColumns) {
        this.setProp("copy.data.input", new Object[]{new Integer(inputNum), new Integer(inputFirstCol), new Integer(inputFirstRow)});
        this.setProp("copy.data.output", new Object[]{new Integer(outputNum), new Integer(outputFirstCol), new Integer(outputFirstRow)});
        this.setProp("copy.data", new Object[]{new Integer(numRows), new Integer(numColumns)});
    }

    public void copyData(int outputNum, int outputFirstCol, int outputFirstRow, int inputNum, int inputFirstCol, int[] inputRowNums, int numRows, int numColumns) {
        this.setProp("copy.data.input", new Object[]{new Integer(inputNum), new Integer(inputFirstCol), new Integer(0)});
        this.setProp("copy.data.output", new Object[]{new Integer(outputNum), new Integer(outputFirstCol), new Integer(outputFirstRow)});
        this.setProp("copy.data.input.row.array", new Object[]{new Integer(numRows), new Integer(numColumns), inputRowNums});
    }

    private void processChunk() {
        int colNum;
        int numColumns;
        int i;
        if (this.m_inputData == null || this.m_numInputs != this.getNumInbufs() || this.m_numOutputs != this.getNumOutbufs() || this.m_numInputRows != this.getNumRows() || this.m_numOutputRows != this.getOutputNumRows()) {
            this.m_numInputs = this.getNumInbufs();
            this.m_numOutputs = this.getNumOutbufs();
            this.m_numInputRows = this.getNumRows();
            this.m_numOutputRows = this.getOutputNumRows();
            this.m_inputData = new Object[this.m_numInputs][];
            this.m_inputDataAccessed = new boolean[this.m_numInputs][];
            for (i = 0; i < this.m_numInputs; ++i) {
                numColumns = this.getInbuf(i).getNumColumns();
                this.m_inputData[i] = new Object[numColumns];
                this.m_inputDataAccessed[i] = new boolean[numColumns];
            }
            this.m_outputData = new Object[this.m_numOutputs][];
            this.m_outputDataAccessed = new boolean[this.m_numOutputs][];
            for (i = 0; i < this.m_numOutputs; ++i) {
                numColumns = this.getOutbuf(i).getNumColumns();
                this.m_outputData[i] = new Object[numColumns];
                this.m_outputDataAccessed[i] = new boolean[numColumns];
            }
            this.m_inputReleaseRows = new int[this.m_numInputs];
            this.m_inputReleaseAll = new boolean[this.m_numInputs];
            this.m_outputReleaseRows = new int[this.m_numOutputs];
            this.m_nextInputPosition = new long[this.m_numInputs];
        }
        for (i = 0; i < this.m_numInputs; ++i) {
            this.m_inputReleaseRows[i] = -999;
            this.m_inputReleaseAll[i] = false;
            this.m_nextInputPosition[i] = -999L;
            numColumns = this.getInbuf(i).getNumColumns();
            for (colNum = 0; colNum < numColumns; ++colNum) {
                this.m_inputDataAccessed[i][colNum] = false;
            }
        }
        for (i = 0; i < this.m_numOutputs; ++i) {
            this.m_outputReleaseRows[i] = -999;
            numColumns = this.getOutbuf(i).getNumColumns();
            for (colNum = 0; colNum < numColumns; ++colNum) {
                this.m_outputDataAccessed[i][colNum] = false;
            }
        }
        this.m_nextRowsDone = -999L;
        this.m_done = -999;
        this.m_resetDynamicOutputs = false;
        for (i = 0; i < this.m_numOutputs; ++i) {
            this.writeOutputAllNA(i);
        }
        if (this.m_exec != null) {
            this.m_exec.execute(this);
        }
        if (this.m_resetDynamicOutputs) {
            if (this.m_resetDynamicOutputsDone) {
                this.addError("tried to call resetDynamicOutputs more than once");
                return;
            }
            if (this.m_anyRowsOutput) {
                this.addError("tried to call resetDynamicOutputs after outputting rows");
                return;
            }
            this.setProp("reset.dynamic.outputs", null);
            this.m_resetDynamicOutputsDone = true;
            this.m_inputData = null;
            return;
        }
        long totalInputRelease = 0L;
        boolean allInputsDone = true;
        for (int i2 = 0; i2 < this.m_numInputs; ++i2) {
            boolean thisInputIsDone;
            int inputRelease = this.m_inputReleaseRows[i2];
            boolean inputReleaseAll = this.m_inputReleaseAll[i2];
            if (inputRelease == -999) {
                inputRelease = this.getChunkInputRows(i2);
            }
            if (inputReleaseAll) {
                this.setProp("chunk.input.release.all", new Integer(i2));
            } else {
                this.setProp("chunk.input.release", new Object[]{new Integer(i2), new Integer(inputRelease)});
            }
            totalInputRelease += inputRelease < 0 ? 0L : (long)inputRelease;
            boolean bl = thisInputIsDone = inputReleaseAll || this.getChunkInputLast(i2) && this.getChunkInputRows(i2) <= inputRelease;
            if (!thisInputIsDone) {
                allInputsDone = false;
            }
            long inputPos = this.m_nextInputPosition[i2];
            this.setProp("chunk.next.input.pos", new Object[]{new Integer(i2), new Long(inputPos)});
            if (inputPos == -999L) continue;
            allInputsDone = false;
        }
        if (this.m_nextRowsDone == -999L) {
            this.m_nextRowsDone = this.getRowsDone() + totalInputRelease;
        }
        this.setProp("chunk.next.rows.done", new Long(this.m_nextRowsDone));
        boolean nextDone = this.m_done == -999 ? allInputsDone : this.m_done > 0;
        this.setProp("chunk.next.done", new Boolean(nextDone));
        for (int i3 = 0; i3 < this.m_numOutputs; ++i3) {
            int outputRelease = this.m_outputReleaseRows[i3];
            if (outputRelease == -999) {
                outputRelease = this.m_numOutputRows;
                if (this.m_numInputs > 0) {
                    outputRelease = Math.min(outputRelease, this.getChunkInputRows(0));
                }
            }
            if (outputRelease > 0) {
                this.m_anyRowsOutput = true;
            }
            this.setProp("chunk.output.release", new Object[]{new Integer(i3), new Integer(outputRelease)});
            int numColumns2 = this.getOutbuf(i3).getNumColumns();
            for (int colNum2 = 0; colNum2 < numColumns2; ++colNum2) {
                Object writeObj;
                if (!this.m_outputDataAccessed[i3][colNum2] || (writeObj = this.m_outputData[i3][colNum2]) == null) continue;
                if (writeObj instanceof double[]) {
                    this.writeOutputDoubles(i3, colNum2, (double[])writeObj);
                    continue;
                }
                if (writeObj instanceof int[]) {
                    this.writeOutputLevelNums(i3, colNum2, (int[])writeObj);
                    continue;
                }
                if (writeObj instanceof long[]) {
                    this.writeOutputDateTimes(i3, colNum2, (long[])writeObj);
                    continue;
                }
                if (writeObj instanceof String[]) {
                    this.writeOutputStrings(i3, colNum2, (String[])writeObj);
                    continue;
                }
                if (!(writeObj instanceof Object[])) continue;
                this.writeOutputBlobs(i3, colNum2, (Object[])writeObj, outputRelease);
            }
        }
    }

    private void readInputDoubles(int inputNum, int colNum, double[] data) {
        this.setProp("read.input.doubles", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputDoubles(int outputNum, int colNum, double[] data) {
        this.setProp("write.output.doubles", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private void readInputLevelNums(int inputNum, int colNum, int[] data) {
        this.setProp("read.input.level.nums", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputLevelNums(int outputNum, int colNum, int[] data) {
        this.setProp("write.output.level.nums", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private void readInputDateTimes(int inputNum, int colNum, long[] data) {
        this.setProp("read.input.time.dates", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputDateTimes(int outputNum, int colNum, long[] data) {
        this.setProp("write.output.time.dates", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private void readInputStrings(int inputNum, int colNum, String[] data) {
        this.setProp("read.input.strings", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputStrings(int outputNum, int colNum, String[] data) {
        this.setProp("write.output.strings", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private boolean openBatchReadBlob(int inputNum, int colNum) {
        boolean ok = this.getBooleanProp("open.batch.read.blob", new Object[]{new Integer(inputNum), new Integer(colNum)});
        return ok;
    }

    private int readBatchBlobData(byte[] bytes, int offset, int len) {
        int val = this.getIntProp("read.batch.blob.data", new Object[]{bytes, new Integer(offset), new Integer(len)});
        return val;
    }

    private boolean closeBatchReadBlob() {
        boolean val = this.getBooleanProp("close.batch.read.blob", null);
        return val;
    }

    private void readInputBlobOffsets(int inputNum, int colNum, long[] data) {
        this.setProp("read.input.blob.offsets", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputBlobOffsets(int outputNum, int colNum, long[] data) {
        this.setProp("write.output.blob.offsets", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private void readInputBlobLengths(int inputNum, int colNum, long[] data) {
        this.setProp("read.input.blob.lengths", new Object[]{new Integer(inputNum), new Integer(colNum), data});
    }

    private void writeOutputBlobLengths(int outputNum, int colNum, long[] data) {
        this.setProp("write.output.blob.lengths", new Object[]{new Integer(outputNum), new Integer(colNum), data});
    }

    private void readInputBlobs(int inputNum, int colNum, Object[] data) {
        try {
            int chunkRows = this.m_numInputRows;
            long[] blobOffsets = new long[chunkRows];
            long[] blobLengths = new long[chunkRows];
            int availableRows = this.getChunkInputRows(inputNum);
            this.readInputBlobOffsets(inputNum, colNum, blobOffsets);
            this.readInputBlobLengths(inputNum, colNum, blobLengths);
            boolean ok = this.openBatchReadBlob(inputNum, colNum);
            if (!ok) {
                return;
            }
            CNKBuf buf = this.getInbuf(inputNum);
            String blobClassName = buf == null ? null : buf.getColumnBlobClassName(colNum);
            CNKBlobClassHandler classHandler = CNKBlobClassHandler.getClassHandler(blobClassName);
            BatchBlobInputStream bbris = new BatchBlobInputStream();
            BufferedInputStream bis = new BufferedInputStream(bbris, 8192);
            BlobFilterInputStream bfis = new BlobFilterInputStream(bis);
            for (int rowNum = 0; rowNum < availableRows; ++rowNum) {
                if (blobOffsets[rowNum] < 0L || blobLengths[rowNum] < 0L) {
                    data[rowNum] = null;
                    continue;
                }
                bfis.startReadingBlob((int)blobLengths[rowNum]);
                Object obj = classHandler.readBlobObject(bfis);
                bfis.finishReadingBlob();
                data[rowNum] = obj;
            }
            this.closeBatchReadBlob();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writeOutputBlobs(int outputNum, int colNum, Object[] data, int outputRows) {
        try {
            int chunkRows = this.m_numOutputRows;
            long[] blobOffsets = new long[chunkRows];
            long[] blobLengths = new long[chunkRows];
            boolean ok = this.openBatchWriteBlob(outputNum);
            if (!ok) {
                return;
            }
            CNKBuf buf = this.getOutbuf(outputNum);
            String blobClassName = buf == null ? null : buf.getColumnBlobClassName(colNum);
            CNKBlobClassHandler classHandler = CNKBlobClassHandler.getClassHandler(blobClassName);
            long blobFileOffset = this.getBatchWriteBlobOffset(outputNum);
            BatchBlobOutputStream bbros = new BatchBlobOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bbros, 8192);
            BlobFilterOutputStream bfos = new BlobFilterOutputStream(bos, blobFileOffset);
            for (int rowNum = 0; rowNum < outputRows; ++rowNum) {
                if (data[rowNum] == null) {
                    blobOffsets[rowNum] = -1L;
                    blobLengths[rowNum] = -1L;
                    continue;
                }
                classHandler.writeBlobObject(bfos, data[rowNum]);
                bfos.finishBlobData();
                blobOffsets[rowNum] = bfos.getLastBlobOffset();
                blobLengths[rowNum] = bfos.getLastBlobLength();
            }
            bos.flush();
            this.closeBatchWriteBlob();
            this.writeOutputBlobOffsets(outputNum, colNum, blobOffsets);
            this.writeOutputBlobLengths(outputNum, colNum, blobLengths);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean getBlobNA(int inputNum, int colNum, int rowNum) {
        boolean val = this.getBooleanProp("blob.na", new Object[]{new Integer(inputNum), new Integer(colNum), new Integer(rowNum)});
        return val;
    }

    private long getBlobLength(int inputNum, int colNum, int rowNum) {
        long val = this.getLongProp("blob.length", new Object[]{new Integer(inputNum), new Integer(colNum), new Integer(rowNum)});
        return val;
    }

    private void setBlobNA(int outputNum, int colNum, int rowNum) {
        this.setProp("blob.na", new Object[]{new Integer(outputNum), new Integer(colNum), new Integer(rowNum)});
    }

    private boolean openReadBlob(int inputNum, int colNum, int rowNum) {
        boolean val = this.getBooleanProp("open.read.blob", new Object[]{new Integer(inputNum), new Integer(colNum), new Integer(rowNum)});
        return val;
    }

    private int readBlobData(byte[] bytes, int offset, int len) {
        int val = this.getIntProp("read.blob.data", new Object[]{bytes, new Integer(offset), new Integer(len)});
        return val;
    }

    private boolean closeReadBlob() {
        boolean val = this.getBooleanProp("close.read.blob", null);
        return val;
    }

    private boolean openWriteBlob(int outputNum, int colNum, int rowNum) {
        boolean val = this.getBooleanProp("open.write.blob", new Object[]{new Integer(outputNum), new Integer(colNum), new Integer(rowNum)});
        return val;
    }

    private int writeBlobData(byte[] bytes, int offset, int len) {
        int val = this.getIntProp("write.blob.data", new Object[]{bytes, new Integer(offset), new Integer(len)});
        return val;
    }

    private boolean closeWriteBlob() {
        boolean val = this.getBooleanProp("close.write.blob", null);
        return val;
    }

    private boolean openBatchWriteBlob(int outputNum) {
        boolean val = this.getBooleanProp("open.batch.write.blob", new Object[]{new Integer(outputNum)});
        return val;
    }

    private int writeBatchBlobData(byte[] bytes, int offset, int len) {
        int val = this.getIntProp("write.batch.blob.data", new Object[]{bytes, new Integer(offset), new Integer(len)});
        return val;
    }

    private boolean closeBatchWriteBlob() {
        boolean val = this.getBooleanProp("close.batch.write.blob", null);
        return val;
    }

    private long getBatchWriteBlobOffset(int outputNum) {
        long val = this.getLongProp("batch.write.blob.offset", new Object[]{new Integer(outputNum)});
        return val;
    }

    private void writeOutputColumnNA(int outputNum, int colNum) {
        this.setProp("write.output.column.na", new Object[]{new Integer(outputNum), new Integer(colNum)});
    }

    private void writeOutputAllNA(int outputNum) {
        this.setProp("write.output.all.na", new Object[]{new Integer(outputNum)});
    }

    public InputStream openReadBlobStream(int inputNum, int colNum, int rowNum) {
        boolean ok = this.openReadBlob(inputNum, colNum, rowNum);
        if (!ok) {
            return null;
        }
        return new BlobInputStream();
    }

    public boolean closeReadBlobStream() {
        return this.closeReadBlob();
    }

    public OutputStream openWriteBlobStream(int outputNum, int colNum, int rowNum) {
        boolean ok = this.openWriteBlob(outputNum, colNum, rowNum);
        if (!ok) {
            return null;
        }
        return new BlobOutputStream();
    }

    public boolean closeWriteBlobStream() {
        return this.closeWriteBlob();
    }

    private class BlobFilterOutputStream
    extends BlobOutputStream {
        private long m_fileOffset;
        private boolean m_writingBlob;
        private long m_blobLength;
        private long m_blobOffset;
        private long m_lastBlobLength;
        private long m_lastBlobOffset;
        private OutputStream m_out;
        final byte[] headerString;
        final byte[] trailerString;
        private byte[] longBytes;

        public BlobFilterOutputStream(OutputStream out, long currentOffset) {
            this.m_fileOffset = 0L;
            this.m_writingBlob = false;
            this.m_blobLength = 0L;
            this.m_blobOffset = 0L;
            this.m_lastBlobLength = 0L;
            this.m_lastBlobOffset = 0L;
            this.m_out = null;
            this.headerString = new byte[]{66, 76, 66, 0};
            this.trailerString = new byte[]{69, 76, 66, 0};
            this.longBytes = new byte[8];
            this.m_out = out;
            this.m_fileOffset = currentOffset;
        }

        private void setBytesFromLong(byte[] b, long val) {
            for (int i = 7; i >= 0; --i) {
                b[i] = (byte)(val & 0xFFL);
                val >>= 8;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (!this.m_writingBlob) {
                this.m_blobOffset = this.m_fileOffset;
                this.m_blobLength = 0L;
                this.m_out.write(this.headerString, 0, this.headerString.length);
                this.m_fileOffset += (long)this.headerString.length;
                this.setBytesFromLong(this.longBytes, this.m_blobOffset);
                this.m_out.write(this.longBytes, 0, this.longBytes.length);
                this.m_fileOffset += (long)this.longBytes.length;
                this.m_writingBlob = true;
            }
            this.m_out.write(b, off, len);
            this.m_fileOffset += (long)len;
            this.m_blobLength += (long)len;
        }

        public void finishBlobData() throws IOException {
            if (this.m_writingBlob) {
                this.setBytesFromLong(this.longBytes, this.m_blobLength);
                this.m_out.write(this.longBytes, 0, this.longBytes.length);
                this.m_fileOffset += (long)this.longBytes.length;
                this.m_out.write(this.trailerString, 0, this.trailerString.length);
                this.m_fileOffset += (long)this.trailerString.length;
            }
            this.m_lastBlobLength = this.m_blobLength;
            this.m_lastBlobOffset = this.m_blobOffset;
            this.m_writingBlob = false;
        }

        public long getLastBlobOffset() {
            return this.m_lastBlobOffset;
        }

        public long getLastBlobLength() {
            return this.m_lastBlobLength;
        }
    }

    private class BatchBlobOutputStream
    extends BlobOutputStream {
        private BatchBlobOutputStream() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int val = CNKProcJavaTransform.this.writeBatchBlobData(b, off, len);
            if (val < len) {
                throw new IOException("error writing blob data");
            }
        }
    }

    private class BlobOutputStream
    extends OutputStream {
        BlobOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] barray = new byte[]{(byte)b};
            this.write(barray, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b == null ? 0 : b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int val = CNKProcJavaTransform.this.writeBlobData(b, off, len);
        }
    }

    private class BlobFilterInputStream
    extends BlobInputStream {
        private int m_blobLength;
        private int m_blobBytesRead;
        private InputStream m_in;

        public BlobFilterInputStream(InputStream in) {
            this.m_blobLength = 0;
            this.m_blobBytesRead = 0;
            this.m_in = null;
            this.m_in = in;
        }

        public void startReadingBlob(int len) {
            this.m_blobLength = len;
            this.m_blobBytesRead = 0;
        }

        public void finishReadingBlob() throws IOException {
            block1: {
                if (this.m_blobBytesRead >= this.m_blobLength) break block1;
                byte[] buf = new byte[1000];
                while (this.m_blobBytesRead < this.m_blobLength && this.read(buf, 0, 1000) >= 1) {
                }
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.m_blobBytesRead >= this.m_blobLength) {
                return -1;
            }
            int val = this.m_in.read(b, off, len = Math.min(len, this.m_blobLength - this.m_blobBytesRead));
            if (val < 1) {
                return -1;
            }
            this.m_blobBytesRead += val;
            return val;
        }
    }

    private class BatchBlobInputStream
    extends BlobInputStream {
        private BatchBlobInputStream() {
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int val = CNKProcJavaTransform.this.readBatchBlobData(b, off, len);
            if (val < 1) {
                return -1;
            }
            return val;
        }
    }

    private class BlobInputStream
    extends InputStream {
        BlobInputStream() {
        }

        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int val = this.read(bytes, 0, 1);
            if (val < 1) {
                return -1;
            }
            int c = bytes[0];
            if (c < 0) {
                c += 256;
            }
            return c;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b == null ? 0 : b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int val = CNKProcJavaTransform.this.readBlobData(b, off, len);
            if (val < 1) {
                return -1;
            }
            return val;
        }
    }
}

