/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AppAction;
import com.insightful.miner.CreateBinsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MultiSlider;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SelectColumnsPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CreateCategoriesDialog
extends NodeDialog
implements ChangeListener {
    private SelectColumnsPanel m_selectColumnsPanel;
    private JTextField m_numBinsTextField;
    private JTextField m_binSuffixTextField;
    private JCheckBox m_addNewColumns;
    private static int FOR_ALL = 0;
    private static int NUM_BIN = 1;
    private static int STURGES = 2;
    private static int FREEDMAN = 3;
    private static int SCOTT = 4;
    private static int PER_COL = 5;
    private JRadioButton[] m_numBinsRadioButtons;
    private JRadioButton[] m_binSizeRadioButtons;
    private JTextField m_kValueTextField;
    private HashMap m_binOptionsHashTable;
    private int[] m_lastSelectedIndices;
    private boolean m_stateChangeSetText = false;
    private boolean m_radioButtonChange = false;
    private boolean m_userTypedSetValue = false;
    private XTMetaData m_metaData;
    private MultiSlider m_multiSlider;
    private JTextField m_sliderTextualRepresentation;
    private JButton m_updateSliderFromTextField;
    private JButton m_setBinOptions;
    private JButton m_setNumBins;
    private JRadioButton[] m_userDefNumBinsRadioButtons;
    private JTextField m_userDefNumBinsTextField;
    private NodeDialog.DNDListModel m_binOptionsListModel;
    private JList m_binOptionsList;
    private JRadioButton[] m_userDefBinSizeRadioButtons;
    private static CreateCategoriesDialog m_instance = null;

    public static CreateCategoriesDialog getInstance() {
        if (m_instance == null) {
            m_instance = new CreateCategoriesDialog();
        }
        return m_instance;
    }

    private CreateCategoriesDialog() {
        this.setResizable(true);
        Dimension dim = new Dimension(600, 525);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.m_selectColumnsPanel.restoreProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        try {
            this.m_metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            this.m_metaData = null;
            e.printStackTrace();
            return;
        }
        String numBins = props.getValue(CreateBinsEngineNode.NUM_BINS_ATTRIBUTE_TAG, "");
        this.m_numBinsTextField.setText(numBins);
        this.m_addNewColumns.setSelected(!props.getBoolean(CreateBinsEngineNode.REPLACE_ATTRIBUTE_TAG, true));
        this.m_binSuffixTextField.setEnabled(this.m_addNewColumns.isSelected());
        this.m_binSuffixTextField.setText(props.getValue(CreateBinsEngineNode.SUFFIX_ATTRIBUTE_TAG, "bin"));
        this.m_kValueTextField.setText(props.getValue(CreateBinsEngineNode.K_VALUE_ATTRIBUTE_TAG, Integer.toString(CreateBinsEngineNode.DEFAULT_K_VALUE)));
        boolean equalCounts = props.getBoolean(CreateBinsEngineNode.EQUAL_COUNTS_ATTRIBUTE_TAG, false);
        int ind = equalCounts ? 1 : 0;
        this.m_binSizeRadioButtons[ind].setSelected(true);
        this.m_binSizeRadioButtons[ind].doClick();
        int numBinsIndex = NUM_BIN;
        for (int i = 0; i < this.m_numBinsRadioButtons.length; ++i) {
            this.m_numBinsRadioButtons[i].setSelected(false);
        }
        if (props.getBoolean(CreateBinsEngineNode.STURGES_ATTRIBUTE_TAG, false)) {
            numBinsIndex = STURGES;
        } else if (props.getBoolean(CreateBinsEngineNode.FREEDMAN_ATTRIBUTE_TAG, false)) {
            numBinsIndex = FREEDMAN;
        } else if (props.getBoolean(CreateBinsEngineNode.SCOTT_ATTRIBUTE_TAG, false)) {
            numBinsIndex = SCOTT;
        }
        this.m_numBinsRadioButtons[numBinsIndex].setSelected(true);
        this.m_numBinsRadioButtons[numBinsIndex].doClick();
        numBinsIndex = FOR_ALL;
        if (props.getBoolean(CreateBinsEngineNode.USER_DEFINED_ATTRIBUTE_TAG, false)) {
            numBinsIndex = PER_COL;
        }
        this.m_numBinsRadioButtons[numBinsIndex].setSelected(true);
        this.m_numBinsRadioButtons[numBinsIndex].doClick();
        Object[] inputCols = this.m_selectColumnsPanel.getInputColumns();
        Object[] outputCols = this.m_selectColumnsPanel.getOutputColumns();
        String[] boPath = new String[]{CreateBinsEngineNode.USER_DEFINED_ATTRIBUTE_TAG, "", ""};
        this.m_binOptionsHashTable.clear();
        for (int array = 0; array < 2; ++array) {
            Object[] cols = array == 0 ? inputCols : outputCols;
            for (int i = 0; i < cols.length; ++i) {
                NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)cols[i];
                BinOptions bo = new BinOptions(obj);
                boPath[1] = obj.getText();
                boPath[2] = CreateBinsEngineNode.EQUAL_COUNTS_ATTRIBUTE_TAG;
                bo.setEqualCounts(props.getBoolean(boPath, false));
                boPath[2] = CreateBinsEngineNode.EQUAL_RANGE_ATTRIBUTE_TAG;
                bo.setEqualRange(props.getBoolean(boPath, false));
                boPath[2] = CreateBinsEngineNode.RANGE_SPECS_ATTRIBUTE_TAG;
                double[] edges = this.convertStringToArray(props.getValue(boPath));
                if (edges != null && edges.length > 0) {
                    bo.setEdgeList(edges);
                }
                boPath[2] = CreateBinsEngineNode.NUM_BINS_ATTRIBUTE_TAG;
                bo.setBinCount(props.getInt(boPath, 2));
                boPath[2] = CreateBinsEngineNode.K_VALUE_ATTRIBUTE_TAG;
                bo.setKValue(props.getInt(boPath, CreateBinsEngineNode.DEFAULT_K_VALUE));
                boPath[2] = CreateBinsEngineNode.STURGES_ATTRIBUTE_TAG;
                bo.setSturges(props.getBoolean(boPath, false));
                boPath[2] = CreateBinsEngineNode.FREEDMAN_ATTRIBUTE_TAG;
                bo.setFreedman(props.getBoolean(boPath, false));
                boPath[2] = CreateBinsEngineNode.SCOTT_ATTRIBUTE_TAG;
                bo.setScott(props.getBoolean(boPath, false));
                this.m_binOptionsHashTable.put(boPath[1], bo);
            }
        }
        this.m_binOptionsListModel.removeAllElements();
        for (int i = 0; i < outputCols.length; ++i) {
            NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)outputCols[i];
            this.m_binOptionsListModel.addElement(this.m_binOptionsHashTable.get(obj.getText()));
        }
        this.m_lastSelectedIndices = null;
        this.m_binOptionsList.setSelectedIndex(-1);
        this.enableUserDefControls(false);
        this.enableApply();
    }

    public void saveProperties() throws NodeDialog.DialogException {
        this.doApply();
        super.saveProperties();
        this.m_selectColumnsPanel.saveProperties(this.getNodeModel());
        XTProps props = this.getNodeModel().getXTProps();
        boolean addNew = this.m_addNewColumns.isSelected();
        String suffix = this.m_binSuffixTextField.getText();
        if (this.m_metaData != null && addNew) {
            Vector selectCols = props.getSubProperties("outgoingColumns");
            for (int i = 0; i < selectCols.size(); ++i) {
                String name = selectCols.get(i) + "." + suffix;
                if (this.m_metaData.nameToOrdinal(name) == -1) continue;
                throw new NodeDialog.DialogException(MinerApp.getText("CreateCategoriesDialog_uniqueError1") + name + " " + MinerApp.getText("CreateCategoriesDialog_uniqueError2"));
            }
        }
        try {
            int numBins = Integer.parseInt(this.m_numBinsTextField.getText());
            props.set(CreateBinsEngineNode.NUM_BINS_ATTRIBUTE_TAG, numBins);
        }
        catch (Exception e) {
            throw new NodeDialog.DialogException(MinerApp.getText("CreateCategoriesDialog_numBinsError"));
        }
        props.set(CreateBinsEngineNode.REPLACE_ATTRIBUTE_TAG, !addNew);
        props.set(CreateBinsEngineNode.SUFFIX_ATTRIBUTE_TAG, suffix);
        props.set(CreateBinsEngineNode.K_VALUE_ATTRIBUTE_TAG, this.m_kValueTextField.getText());
        props.set(CreateBinsEngineNode.EQUAL_COUNTS_ATTRIBUTE_TAG, this.m_binSizeRadioButtons[1].isSelected());
        props.removeProperty(new String[]{CreateBinsEngineNode.USER_DEFINED_ATTRIBUTE_TAG});
        props.set(CreateBinsEngineNode.STURGES_ATTRIBUTE_TAG, this.m_numBinsRadioButtons[STURGES].isSelected());
        props.set(CreateBinsEngineNode.FREEDMAN_ATTRIBUTE_TAG, this.m_numBinsRadioButtons[FREEDMAN].isSelected());
        props.set(CreateBinsEngineNode.SCOTT_ATTRIBUTE_TAG, this.m_numBinsRadioButtons[SCOTT].isSelected());
        props.set(CreateBinsEngineNode.USER_DEFINED_ATTRIBUTE_TAG, this.m_numBinsRadioButtons[PER_COL].isSelected());
        Object[] cols = this.m_binOptionsHashTable.keySet().toArray();
        String[] boPath = new String[]{CreateBinsEngineNode.USER_DEFINED_ATTRIBUTE_TAG, "", ""};
        for (int i = 0; i < cols.length; ++i) {
            String obj = (String)cols[i];
            BinOptions bo = (BinOptions)this.m_binOptionsHashTable.get(obj);
            boPath[1] = obj;
            boPath[2] = CreateBinsEngineNode.EQUAL_COUNTS_ATTRIBUTE_TAG;
            props.set(boPath, bo.getEqualCounts());
            boPath[2] = CreateBinsEngineNode.EQUAL_RANGE_ATTRIBUTE_TAG;
            props.set(boPath, bo.getEqualRange());
            boPath[2] = CreateBinsEngineNode.RANGE_SPECS_ATTRIBUTE_TAG;
            double[] edges = bo.getEdgeList();
            if (edges != null && edges.length > 0) {
                props.set(boPath, this.convertArrayToString(edges));
            }
            boPath[2] = CreateBinsEngineNode.NUM_BINS_ATTRIBUTE_TAG;
            props.set(boPath, Integer.toString(bo.getBinCount()));
            boPath[2] = CreateBinsEngineNode.K_VALUE_ATTRIBUTE_TAG;
            props.set(boPath, Integer.toString(bo.getKValue()));
            boPath[2] = CreateBinsEngineNode.STURGES_ATTRIBUTE_TAG;
            props.set(boPath, bo.getSturges());
            boPath[2] = CreateBinsEngineNode.FREEDMAN_ATTRIBUTE_TAG;
            props.set(boPath, bo.getFreedman());
            boPath[2] = CreateBinsEngineNode.SCOTT_ATTRIBUTE_TAG;
            props.set(boPath, bo.getScott());
        }
    }

    public JPanel createOptionsPanel() {
        this.m_binOptionsHashTable = new HashMap();
        this.m_selectColumnsPanel = new SelectColumnsPanel(this.okAction){

            public void updateLists() {
                Enumeration enumeration = this.outgoingListModel.elements();
                Vector newList = new Vector();
                while (enumeration.hasMoreElements()) {
                    NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)enumeration.nextElement();
                    newList.add(CreateCategoriesDialog.this.m_binOptionsHashTable.get(obj.getText()));
                }
                CreateCategoriesDialog.this.m_binOptionsListModel.removeAllElements();
                CreateCategoriesDialog.this.m_binOptionsListModel.addElements(newList.toArray());
            }
        };
        this.m_selectColumnsPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.m_selectColumnsPanel.setExcludedColumnType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_selectColumnsPanel, "Center");
        panel.add((Component)this.getOptionsPanel(), "South");
        return panel;
    }

    private void enableUserDefinedAction() {
        boolean userSel = this.m_numBinsRadioButtons[PER_COL].isSelected();
        boolean numBins = this.m_numBinsRadioButtons[NUM_BIN].isSelected();
        this.m_binSizeRadioButtons[0].setEnabled(!userSel);
        this.m_binSizeRadioButtons[1].setEnabled(!userSel);
        this.m_numBinsTextField.setEditable(numBins);
        this.m_numBinsTextField.setEnabled(numBins);
        this.m_numBinsRadioButtons[NUM_BIN].setEnabled(!userSel);
        this.m_numBinsRadioButtons[STURGES].setEnabled(!userSel);
        this.m_numBinsRadioButtons[FREEDMAN].setEnabled(!userSel);
        this.m_numBinsRadioButtons[SCOTT].setEnabled(!userSel);
        this.tabbedPane.setEnabledAt(1, userSel);
    }

    private void enableNewColumnAction() {
        boolean white = this.m_addNewColumns.isSelected();
        this.m_binSuffixTextField.setEnabled(white);
        this.m_binSuffixTextField.setEditable(white);
    }

    private void enableKValueAction() {
    }

    private JPanel getOptionsPanel() {
        this.m_numBinsRadioButtons = new JRadioButton[6];
        this.m_numBinsRadioButtons[CreateCategoriesDialog.FOR_ALL] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_forAllColumns"));
        this.m_numBinsRadioButtons[FOR_ALL].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsRadioButtons[CreateCategoriesDialog.NUM_BIN] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_numBins"));
        this.m_numBinsRadioButtons[NUM_BIN].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsRadioButtons[CreateCategoriesDialog.STURGES] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_sturges"));
        this.m_numBinsRadioButtons[STURGES].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsRadioButtons[CreateCategoriesDialog.FREEDMAN] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_freedmanDiaconis"));
        this.m_numBinsRadioButtons[FREEDMAN].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsRadioButtons[CreateCategoriesDialog.SCOTT] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_scott"));
        this.m_numBinsRadioButtons[SCOTT].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsRadioButtons[CreateCategoriesDialog.PER_COL] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_userDefined"));
        this.m_numBinsRadioButtons[PER_COL].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedAction();
            }
        });
        this.m_numBinsTextField = new JTextField(10);
        this.m_numBinsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.m_numBinsRadioButtons[FOR_ALL].setMnemonic(MinerApp.getText("CreateCategoriesDialog_forAllColumnsHotkey").charAt(0));
        this.m_numBinsRadioButtons[NUM_BIN].setMnemonic(MinerApp.getText("CreateCategoriesDialog_numBinsHotkey").charAt(0));
        this.m_numBinsRadioButtons[STURGES].setMnemonic(MinerApp.getText("CreateCategoriesDialog_sturgesHotkey").charAt(0));
        this.m_numBinsRadioButtons[FREEDMAN].setMnemonic(MinerApp.getText("CreateCategoriesDialog_freedmanDiaconisHotkey").charAt(0));
        this.m_numBinsRadioButtons[SCOTT].setMnemonic(MinerApp.getText("CreateCategoriesDialog_scottHotkey").charAt(0));
        this.m_numBinsRadioButtons[PER_COL].setMnemonic(MinerApp.getText("CreateCategoriesDialog_userDefinedHotkey").charAt(0));
        JLabel binSuffixLabel = new JLabel(MinerApp.getText("CreateCategoriesDialog_binSuffix"));
        this.m_binSuffixTextField = new JTextField(10);
        binSuffixLabel.setLabelFor(this.m_binSuffixTextField);
        binSuffixLabel.setDisplayedMnemonic(MinerApp.getText("CreateCategoriesDialog_binSuffixHotkey").charAt(0));
        this.m_addNewColumns = new JCheckBox(MinerApp.getText("CreateCategoriesDialog_addNewBinColumn"));
        this.m_addNewColumns.setMnemonic(MinerApp.getText("CreateCategoriesDialog_addNewBinColumnHotkey").charAt(0));
        this.m_addNewColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableNewColumnAction();
            }
        });
        JLabel kValueLabel = new JLabel(MinerApp.getText("CreateCategoriesDialog_kValue"));
        this.m_kValueTextField = new JTextField(10);
        this.m_kValueTextField.setDocument(new NodeDialog.InputIntegerDoc());
        kValueLabel.setLabelFor(this.m_kValueTextField);
        kValueLabel.setDisplayedMnemonic(MinerApp.getText("CreateCategoriesDialog_kValueHotkey").charAt(0));
        this.m_binSizeRadioButtons = new JRadioButton[2];
        this.m_binSizeRadioButtons[0] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_equalRange"));
        this.m_binSizeRadioButtons[0].setMnemonic(MinerApp.getText("CreateCategoriesDialog_equalRangeHotkey").charAt(0));
        this.m_binSizeRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableKValueAction();
            }
        });
        this.m_binSizeRadioButtons[1] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_equalCount"));
        this.m_binSizeRadioButtons[1].setMnemonic(MinerApp.getText("CreateCategoriesDialog_equalCountHotkey").charAt(0));
        this.m_binSizeRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableKValueAction();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_binSizeRadioButtons[0]);
        bg.add(this.m_binSizeRadioButtons[1]);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.m_numBinsRadioButtons[NUM_BIN]);
        bg2.add(this.m_numBinsRadioButtons[STURGES]);
        bg2.add(this.m_numBinsRadioButtons[FREEDMAN]);
        bg2.add(this.m_numBinsRadioButtons[SCOTT]);
        ButtonGroup bg3 = new ButtonGroup();
        bg3.add(this.m_numBinsRadioButtons[FOR_ALL]);
        bg3.add(this.m_numBinsRadioButtons[PER_COL]);
        Insets noInset = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(3, 15, 0, 0);
        Insets dblIndent = new Insets(3, 30, 0, 0);
        JPanel numBinsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        numBinsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateCategoriesDialog_setNumBins")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = noInset;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[FOR_ALL], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets = indent;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[NUM_BIN], gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        numBinsPanel.add((Component)this.m_numBinsTextField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets = indent;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[STURGES], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets = indent;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[FREEDMAN], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets = indent;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[SCOTT], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.insets = noInset;
        numBinsPanel.add((Component)this.m_numBinsRadioButtons[PER_COL], gbc);
        JPanel kValPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        kValPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateCategoriesDialog_kValPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = noInset;
        gbc.fill = 2;
        kValPanel.add((Component)kValueLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridwidth = 0;
        kValPanel.add((Component)this.m_kValueTextField, gbc);
        JPanel binSizePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        binSizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateCategoriesDialog_binSize")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc.anchor = 18;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = noInset;
        gbc.fill = 2;
        binSizePanel.add((Component)this.m_binSizeRadioButtons[0], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        binSizePanel.add((Component)this.m_binSizeRadioButtons[1], gbc);
        JPanel outputPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        outputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateCategoriesDialog_output")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = noInset;
        outputPanel.add((Component)this.m_addNewColumns, gbc);
        ++gbc.gridy;
        gbc.insets = dblIndent;
        outputPanel.add((Component)binSuffixLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        outputPanel.add((Component)this.m_binSuffixTextField, gbc);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(numBinsPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(binSizePanel);
        rightPanel.add(kValPanel);
        rightPanel.add(outputPanel);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        optionsPanel.add((Component)leftPanel, constraints);
        ++constraints.gridx;
        optionsPanel.add((Component)rightPanel, constraints);
        return optionsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        JPanel userDefPanel = this.createUserDefinedPanel();
        userDefPanel.setName(MinerApp.getText("CreateCategoriesDialog_userDefined"));
        panels.add(userDefPanel);
        return panels;
    }

    public int getColumnNumForDateDetermination() {
        Object[] bos = this.m_binOptionsList.getSelectedValues();
        int columnNum = 0;
        for (int i = 0; i < bos.length; ++i) {
            String colName = ((BinOptions)bos[i]).getText();
            columnNum = this.m_metaData.nameToOrdinal(colName);
            if (!this.m_metaData.isDateTimeColumn(colName)) break;
        }
        return columnNum;
    }

    void enableUserDefControls(boolean active) {
        int i;
        this.m_userDefNumBinsTextField.setEnabled(active);
        for (i = 0; i < this.m_userDefNumBinsRadioButtons.length; ++i) {
            this.m_userDefNumBinsRadioButtons[i].setEnabled(active);
        }
        for (i = 0; i < this.m_userDefBinSizeRadioButtons.length; ++i) {
            this.m_userDefBinSizeRadioButtons[i].setEnabled(active);
        }
        this.m_multiSlider.setEnabled(active);
        this.m_sliderTextualRepresentation.setEnabled(active);
        this.m_setBinOptions.setEnabled(active);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.m_userTypedSetValue) {
            return;
        }
        double[] edges = this.m_multiSlider.getEdgeValues();
        int columnNum = this.getColumnNumForDateDetermination();
        if (edges != null) {
            String newValue;
            boolean changed;
            String previousValue = this.m_sliderTextualRepresentation.getText();
            boolean bl = changed = !previousValue.equals(newValue = this.convertArrayToString(this.m_metaData, columnNum, edges));
            if (changed) {
                this.m_stateChangeSetText = true;
                this.m_sliderTextualRepresentation.setText(newValue);
                if (!this.m_radioButtonChange) {
                    this.m_userDefNumBinsRadioButtons[0].setSelected(true);
                    this.enableUserDefinedTextField();
                }
                this.m_stateChangeSetText = false;
            }
        }
        this.enableApply();
    }

    private void listBoxSelectionChanged(ListSelectionEvent e) {
        boolean noEdges;
        this.doApply();
        double min = 0.0;
        double max = 0.0;
        double[] edges = null;
        boolean range = false;
        boolean count = false;
        boolean spec = false;
        int maxKValue = 0;
        int[] sel = this.m_binOptionsList.getSelectedIndices();
        this.enableUserDefControls(sel.length > 0);
        boolean isDate = true;
        for (int i = 0; i < sel.length; ++i) {
            BinOptions bo = (BinOptions)this.m_binOptionsListModel.elementAt(sel[i]);
            String name = bo.getText();
            double cmin = this.m_metaData.getColumnMin(name);
            double cmax = this.m_metaData.getColumnMax(name);
            boolean bl = isDate = isDate && this.m_metaData.isDateTimeColumn(name);
            if (bo.getEqualCounts()) {
                count = true;
            } else if (bo.getEqualRange()) {
                range = true;
            } else {
                spec = true;
            }
            if (maxKValue < bo.getKValue()) {
                maxKValue = bo.getKValue();
            }
            if (i == 0) {
                min = cmin;
                max = cmax;
                edges = bo.getEdgeList();
                continue;
            }
            if (cmin < min) {
                min = cmin;
                continue;
            }
            if (!(cmax > max)) continue;
            max = cmax;
        }
        boolean bl = noEdges = edges == null || edges.length == 0;
        if (noEdges) {
            edges = new double[]{min};
        }
        double tmin = 0.0;
        double tmax = 0.0;
        for (int i = 0; i < edges.length; ++i) {
            if (i == 0) {
                tmin = tmax = edges[i];
                continue;
            }
            if (edges[i] < tmin) {
                tmin = edges[i];
                continue;
            }
            if (!(edges[i] > tmax)) continue;
            tmax = edges[i];
        }
        double extra = (tmax - tmin) * 0.1;
        if (min == max) {
            max = tmax + extra;
            min = tmin - extra;
        }
        this.m_multiSlider.setDateLabels(isDate);
        this.m_multiSlider.resetSlider(min, max, edges);
        if (noEdges) {
            this.m_multiSlider.spreadThumbs();
        }
        this.m_multiSlider.addChangeListener(this);
        this.stateChanged(null);
        this.enableUserSpecifiedBinning(min != max);
        this.m_userTypedSetValue = true;
        int nbins = edges == null ? 1 : edges.length + 1;
        this.m_userDefNumBinsTextField.setText(Integer.toString(nbins));
        this.m_userTypedSetValue = false;
        int index = count && !range && !spec ? 1 : (!count && range && !spec ? 0 : (!count && !range && spec ? 2 : 0));
        this.m_userDefBinSizeRadioButtons[index].setSelected(true);
        this.m_userDefBinSizeRadioButtons[index].doClick();
        this.enableUserDefType();
        if (sel.length > 0) {
            BinOptions bo = (BinOptions)this.m_binOptionsListModel.elementAt(sel[0]);
            boolean sturges = bo.getSturges();
            boolean freedman = bo.getFreedman();
            boolean scott = bo.getScott();
            this.m_radioButtonChange = true;
            this.m_userDefNumBinsRadioButtons[0].setSelected(!sturges && !freedman && !scott);
            this.m_userDefNumBinsRadioButtons[1].setSelected(sturges);
            this.m_userDefNumBinsRadioButtons[2].setSelected(freedman);
            this.m_userDefNumBinsRadioButtons[3].setSelected(scott);
            this.m_radioButtonChange = false;
            this.enableUserDefinedTextField();
        }
        this.m_lastSelectedIndices = sel;
    }

    private void doApply() {
        if (this.m_lastSelectedIndices == null || this.m_binOptionsListModel.isEmpty()) {
            return;
        }
        double[] edges = this.m_multiSlider.getEdgeValues();
        int[] sel = this.m_lastSelectedIndices;
        for (int i = 0; i < sel.length; ++i) {
            BinOptions bo = (BinOptions)this.m_binOptionsListModel.elementAt(sel[i]);
            if (edges != null) {
                bo.setEdgeList(edges);
            }
            bo.setEqualRange(this.m_userDefBinSizeRadioButtons[0].isSelected());
            bo.setEqualCounts(this.m_userDefBinSizeRadioButtons[1].isSelected());
            String str = this.m_userDefNumBinsTextField.getText();
            if (str.length() > 0) {
                bo.setBinCount(Integer.parseInt(str));
            }
            if ((str = this.m_kValueTextField.getText()).length() > 0) {
                bo.setKValue(Integer.parseInt(str));
            }
            bo.setSturges(this.m_userDefNumBinsRadioButtons[1].isSelected());
            bo.setFreedman(this.m_userDefNumBinsRadioButtons[2].isSelected());
            bo.setScott(this.m_userDefNumBinsRadioButtons[3].isSelected());
        }
        this.enableApply();
    }

    public void adjustSliderFromText() {
        NodeDialog.ColumnInformationObject obj;
        int columnNum = this.getColumnNumForDateDetermination();
        double[] edges = this.convertStringToArray(this.m_metaData, columnNum, this.m_sliderTextualRepresentation.getText());
        if (edges.length > 0) {
            this.m_userTypedSetValue = true;
            this.m_userDefNumBinsTextField.setText(Integer.toString(edges.length + 1));
            this.m_userTypedSetValue = false;
        }
        double max = Double.NaN;
        double min = Double.NaN;
        for (int i = edges.length - 1; i >= 0; --i) {
            if (Double.isNaN(max)) {
                max = edges[i];
            }
            if (!Double.isNaN(edges[i])) {
                min = edges[i];
                continue;
            }
            edges[i] = min;
        }
        if (!Double.isNaN(min) && (obj = (NodeDialog.ColumnInformationObject)this.m_binOptionsList.getSelectedValue()) != null) {
            String name = obj.getText();
            double metaDataMax = this.m_metaData.getColumnMax(name);
            double metaDataMin = this.m_metaData.getColumnMin(name);
            double extra = (max - min) * 0.1;
            min = metaDataMax == metaDataMin || min < metaDataMin ? min - extra : metaDataMin;
            max = metaDataMax == metaDataMin || max > metaDataMax ? max + extra : metaDataMax;
            this.m_userTypedSetValue = true;
            this.m_multiSlider.resetSlider(min, max, edges);
            this.m_multiSlider.addChangeListener(this);
            this.m_userTypedSetValue = false;
            this.enableApply();
        }
    }

    private void enableApply() {
        double[] edges = this.m_multiSlider.getEdgeValues();
        boolean equalCounts = this.m_userDefBinSizeRadioButtons[1].isSelected();
        int[] sel = this.m_binOptionsList.getSelectedIndices();
        boolean same = true;
        for (int i = 0; same && i < sel.length; ++i) {
            String txtStr;
            String boStr;
            BinOptions bo = (BinOptions)this.m_binOptionsListModel.elementAt(sel[i]);
            boolean bl = same = bo.equalCounts == equalCounts;
            if (!same) break;
            boolean bl2 = same = bo.edgeList.length == edges.length;
            if (!same) break;
            String num = this.m_kValueTextField.getText();
            if (num.length() > 0) {
                boolean bl3 = same = bo.kValue == Integer.parseInt(num);
            }
            if (!same) break;
            for (int j = 0; j < edges.length && (same = (boStr = MinerApp.formatDouble(bo.edgeList[j])).equals(txtStr = MinerApp.formatDouble(edges[j]))); ++j) {
            }
        }
        this.m_setBinOptions.setEnabled(!same);
    }

    private void enableUserDefType() {
        boolean sel = this.m_userDefBinSizeRadioButtons[2].isSelected();
        this.m_multiSlider.setEnabled(sel);
        this.m_sliderTextualRepresentation.setEnabled(sel);
        this.m_sliderTextualRepresentation.setEditable(sel);
    }

    private void enableUserDefinedTextField() {
        this.enableUserDefType();
        boolean sturges = this.m_userDefNumBinsRadioButtons[1].isSelected();
        boolean freedman = this.m_userDefNumBinsRadioButtons[2].isSelected();
        boolean scott = this.m_userDefNumBinsRadioButtons[3].isSelected();
        this.m_radioButtonChange = true;
        if (sturges || scott) {
            int numBins = CreateBinsEngineNode.sturges(this.m_metaData);
            if (scott) {
                NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)this.m_binOptionsList.getSelectedValue();
                numBins = obj != null ? CreateBinsEngineNode.scott(this.m_metaData, obj.getText()) : 1;
            }
            if (numBins > 0) {
                this.m_userDefNumBinsTextField.setText(Integer.toString(numBins));
                this.adjustSliderFromText();
            }
        } else if (freedman) {
            this.m_userDefNumBinsTextField.setText("");
            this.m_stateChangeSetText = true;
            this.m_sliderTextualRepresentation.setText("");
            this.m_stateChangeSetText = false;
            this.m_multiSlider.createThumbs(0);
            this.enableApply();
        }
        this.m_radioButtonChange = false;
    }

    private JPanel createUserDefinedPanel() {
        this.m_multiSlider = new MultiSlider(0, 0.0, 0.0, new double[]{0.0});
        this.m_multiSlider.setPaintLabels(true);
        this.m_multiSlider.setPaintTicks(true);
        this.m_multiSlider.setPaintTrack(true);
        this.m_sliderTextualRepresentation = new JTextField();
        Dimension dim = new Dimension(this.m_multiSlider.getPreferredSize().width, this.m_sliderTextualRepresentation.getPreferredSize().height);
        this.m_sliderTextualRepresentation.setPreferredSize(dim);
        this.m_sliderTextualRepresentation.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_stateChangeSetText) {
                    CreateCategoriesDialog.this.adjustSliderFromText();
                    CreateCategoriesDialog.this.m_userDefNumBinsRadioButtons[0].setSelected(true);
                    CreateCategoriesDialog.this.enableUserDefinedTextField();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_stateChangeSetText) {
                    CreateCategoriesDialog.this.adjustSliderFromText();
                    CreateCategoriesDialog.this.m_userDefNumBinsRadioButtons[0].setSelected(true);
                    CreateCategoriesDialog.this.enableUserDefinedTextField();
                }
            }

            public void changedUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_stateChangeSetText) {
                    CreateCategoriesDialog.this.adjustSliderFromText();
                    CreateCategoriesDialog.this.m_userDefNumBinsRadioButtons[0].setSelected(true);
                    CreateCategoriesDialog.this.enableUserDefinedTextField();
                }
            }
        });
        this.m_multiSlider.addChangeListener(this);
        this.m_binOptionsListModel = new NodeDialog.DNDListModel();
        this.m_binOptionsList = new JList(this.m_binOptionsListModel);
        this.m_binOptionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CreateCategoriesDialog.this.listBoxSelectionChanged(e);
            }
        });
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.m_binOptionsList.setCellRenderer(renderer);
        this.m_binOptionsList.setSelectionMode(2);
        this.m_userDefNumBinsTextField = new JTextField(10);
        this.m_userDefNumBinsTextField.setDocument(new PositiveIntegerDocument());
        this.m_userDefNumBinsTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_userTypedSetValue) {
                    CreateCategoriesDialog.this.changeNumBins();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_userTypedSetValue) {
                    CreateCategoriesDialog.this.changeNumBins();
                }
            }

            public void changedUpdate(DocumentEvent e) {
                if (!CreateCategoriesDialog.this.m_userTypedSetValue) {
                    CreateCategoriesDialog.this.changeNumBins();
                }
            }
        });
        this.m_userDefNumBinsRadioButtons = new JRadioButton[4];
        this.m_userDefNumBinsRadioButtons[0] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_numBins"));
        this.m_userDefNumBinsRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedTextField();
            }
        });
        this.m_userDefNumBinsRadioButtons[1] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_sturges"));
        this.m_userDefNumBinsRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedTextField();
            }
        });
        this.m_userDefNumBinsRadioButtons[2] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_freedmanDiaconis"));
        this.m_userDefNumBinsRadioButtons[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedTextField();
            }
        });
        this.m_userDefNumBinsRadioButtons[3] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_scott"));
        this.m_userDefNumBinsRadioButtons[3].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefinedTextField();
            }
        });
        this.m_userDefNumBinsRadioButtons[0].setMnemonic(MinerApp.getText("CreateCategoriesDialog_numBinsHotkey").charAt(0));
        this.m_userDefNumBinsRadioButtons[1].setMnemonic(MinerApp.getText("CreateCategoriesDialog_sturgesHotkey").charAt(0));
        this.m_userDefNumBinsRadioButtons[2].setMnemonic(MinerApp.getText("CreateCategoriesDialog_freedmanDiaconisHotkey").charAt(0));
        this.m_userDefNumBinsRadioButtons[3].setMnemonic(MinerApp.getText("CreateCategoriesDialog_scottHotkey").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_userDefNumBinsRadioButtons[0]);
        bg.add(this.m_userDefNumBinsRadioButtons[1]);
        bg.add(this.m_userDefNumBinsRadioButtons[2]);
        bg.add(this.m_userDefNumBinsRadioButtons[3]);
        this.m_userDefBinSizeRadioButtons = new JRadioButton[3];
        this.m_userDefBinSizeRadioButtons[0] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_byRange"));
        this.m_userDefBinSizeRadioButtons[0].setMnemonic(MinerApp.getText("CreateCategoriesDialog_byRangeHotkey").charAt(0));
        this.m_userDefBinSizeRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefType();
                CreateCategoriesDialog.this.enableApply();
            }
        });
        this.m_userDefBinSizeRadioButtons[1] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_byEqualCount"));
        this.m_userDefBinSizeRadioButtons[1].setMnemonic(MinerApp.getText("CreateCategoriesDialog_byEqualCountHotkey").charAt(0));
        this.m_userDefBinSizeRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefType();
                CreateCategoriesDialog.this.enableApply();
            }
        });
        this.m_userDefBinSizeRadioButtons[2] = new JRadioButton(MinerApp.getText("CreateCategoriesDialog_specified"));
        this.m_userDefBinSizeRadioButtons[2].setMnemonic(MinerApp.getText("CreateCategoriesDialog_specifiedHotkey").charAt(0));
        this.m_userDefBinSizeRadioButtons[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.enableUserDefType();
                CreateCategoriesDialog.this.enableApply();
            }
        });
        this.m_setNumBins = new JButton(new AppAction(MinerApp.getText("CreateCategoriesDialog_change")){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.changeNumBins();
            }
        });
        this.m_setNumBins.setMnemonic(MinerApp.getText("CreateCategoriesDialog_changeHotkey").charAt(0));
        bg = new ButtonGroup();
        bg.add(this.m_userDefBinSizeRadioButtons[0]);
        bg.add(this.m_userDefBinSizeRadioButtons[1]);
        bg.add(this.m_userDefBinSizeRadioButtons[2]);
        this.m_setBinOptions = new JButton(new AppAction(MinerApp.getText("CreateCategoriesDialog_setOptions")){

            public void actionPerformed(ActionEvent e) {
                CreateCategoriesDialog.this.doApply();
            }
        });
        this.m_setBinOptions.setMnemonic(MinerApp.getText("CreateCategoriesDialog_setOptionsHotkey").charAt(0));
        JPanel columnListPanel = new JPanel(new BorderLayout());
        NodeDialog.SortingScrollPane sp = new NodeDialog.SortingScrollPane(this.m_binOptionsList);
        columnListPanel.add((Component)sp, "Center");
        Insets sep = new Insets(10, 0, 10, 0);
        Insets minorSep = new Insets(3, 0, 0, 0);
        Insets indent = new Insets(3, 15, 0, 0);
        Insets dblIndent = new Insets(3, 30, 0, 0);
        JPanel numBinsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = minorSep;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        numBinsPanel.add((Component)this.m_userDefNumBinsRadioButtons[0], gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        numBinsPanel.add((Component)this.m_userDefNumBinsTextField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        numBinsPanel.add((Component)this.m_userDefNumBinsRadioButtons[1], gbc);
        ++gbc.gridy;
        numBinsPanel.add((Component)this.m_userDefNumBinsRadioButtons[2], gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        numBinsPanel.add((Component)this.m_userDefNumBinsRadioButtons[3], gbc);
        JPanel edgePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = sep;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        edgePanel.add((Component)new JSeparator(0), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = indent;
        gbc.weightx = 1.0;
        edgePanel.add((Component)this.m_userDefBinSizeRadioButtons[0], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = indent;
        gbc.weightx = 1.0;
        edgePanel.add((Component)this.m_userDefBinSizeRadioButtons[1], gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = indent;
        gbc.fill = 0;
        edgePanel.add((Component)this.m_userDefBinSizeRadioButtons[2], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = dblIndent;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        edgePanel.add((Component)this.m_multiSlider, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = dblIndent;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        JPanel sliderTextPanel = new JPanel();
        sliderTextPanel.setLayout(new BoxLayout(sliderTextPanel, 0));
        sliderTextPanel.add(this.m_sliderTextualRepresentation);
        edgePanel.add((Component)sliderTextPanel, gbc);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = minorSep;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        optionsPanel.add((Component)columnListPanel, gbc);
        ++gbc.gridx;
        optionsPanel.add((Component)numBinsPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        optionsPanel.add((Component)edgePanel, gbc);
        return optionsPanel;
    }

    private void changeNumBins() {
        String str = this.m_userDefNumBinsTextField.getText();
        if (str.length() > 0) {
            try {
                int n = Integer.parseInt(str);
                if (n > 0) {
                    if (n == 1) {
                        this.m_multiSlider.createThumbs(1);
                        this.m_multiSlider.setDoubleValueAt(this.m_multiSlider.getDoubleMaximum(), 0);
                        this.m_multiSlider.updateUI();
                    } else {
                        this.m_multiSlider.createThumbs(n - 1);
                    }
                    this.m_multiSlider.addChangeListener(this);
                    this.stateChanged(null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void enableUserSpecifiedBinning(boolean enable) {
    }

    public String getRoundedString(XTMetaData md, int column, double val) {
        if (md.isDateTimeColumn(column)) {
            return MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(val);
        }
        return MinerApp.getWorksheetPropertiesManager().formatDouble(val);
    }

    public double parseRoundedString(XTMetaData md, int column, String str) {
        if (md.isDateTimeColumn(column)) {
            double val = MinerApp.getWorksheetPropertiesManager().getDateParser().convertStringToTimeDate(str);
            return val / 8.64E7;
        }
        return MinerApp.getWorksheetPropertiesManager().parseDouble(str);
    }

    public String convertArrayToString(double[] edges) {
        return this.convertArrayToString(null, 0, edges, false);
    }

    public String convertArrayToString(XTMetaData md, int columnNum, double[] edges) {
        return this.convertArrayToString(md, columnNum, edges, true);
    }

    private String convertArrayToString(XTMetaData md, int columnNum, double[] edges, boolean convert) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < edges.length; ++i) {
            if (i > 0) {
                buff.append("; ");
            }
            if (convert) {
                buff.append(this.getRoundedString(md, columnNum, edges[i]));
                continue;
            }
            buff.append(Double.toString(edges[i]));
        }
        return buff.toString();
    }

    public double[] convertStringToArray(String stringList) {
        return this.convertStringToArray(null, 0, stringList, false);
    }

    public double[] convertStringToArray(XTMetaData md, int columnNum, String stringList) {
        return this.convertStringToArray(md, columnNum, stringList, true);
    }

    private double[] convertStringToArray(XTMetaData md, int columnNum, String stringList, boolean convert) {
        String n;
        String grouping = String.valueOf(MinerApp.getWorksheetPropertiesManager().getThousandsSeparator());
        String str = stringList.replaceAll(grouping, "").trim();
        Vector<String> numbers = new Vector<String>();
        int comma = str.indexOf(59);
        int len = str.length();
        int beg = 0;
        while (comma > 0) {
            n = str.substring(beg, comma).trim().replace('e', 'E');
            if (n.length() > 0 && !n.equals("-")) {
                numbers.add(n);
            }
            beg = comma + 1;
            comma = str.indexOf(59, beg);
        }
        if (beg < len && (n = str.substring(beg, len).trim().replace('e', 'E')).length() > 0 && !n.equals("-")) {
            numbers.add(n);
        }
        double[] tedges = new double[numbers.size()];
        int badNumbers = 0;
        for (int i = 0; i < tedges.length; ++i) {
            try {
                tedges[i - badNumbers] = convert ? this.parseRoundedString(md, columnNum, (String)numbers.get(i)) : Double.parseDouble((String)numbers.get(i));
                if (!Double.isInfinite(tedges[i - badNumbers]) && !Double.isNaN(tedges[i - badNumbers])) continue;
                ++badNumbers;
                continue;
            }
            catch (NumberFormatException e) {
                ++badNumbers;
            }
        }
        double[] edges = new double[tedges.length - badNumbers];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = tedges[i];
        }
        Arrays.sort(edges);
        return edges;
    }

    public static class BinOptions
    extends NodeDialog.ColumnInformationObject {
        private double[] edgeList;
        private boolean sturges;
        private boolean freedman;
        private boolean scott;
        private boolean equalCounts;
        private boolean equalRange;
        private int binCount;
        private int kValue;

        public BinOptions(NodeDialog.ColumnInformationObject ciObj) {
            super(ciObj.getText(), ciObj.getType(), ciObj.getRole(), ciObj.isInteraction(), ciObj.getIndex());
            this.setEdgeList(new double[0]);
        }

        public BinOptions(NodeDialog.ColumnInformationObject ciObj, double[] edges) {
            super(ciObj.getText(), ciObj.getType(), ciObj.getRole(), ciObj.isInteraction(), ciObj.getIndex());
            this.setEdgeList(edges);
        }

        public String getText() {
            return super.getText();
        }

        public int getKValue() {
            return this.kValue;
        }

        public void setKValue(int kv) {
            this.kValue = kv;
        }

        public int getBinCount() {
            return this.binCount;
        }

        public void setBinCount(int bc) {
            this.binCount = bc;
        }

        public boolean getEqualCounts() {
            return this.equalCounts;
        }

        public void setEqualCounts(boolean ec) {
            this.equalCounts = ec;
        }

        public boolean getEqualRange() {
            return this.equalRange;
        }

        public void setEqualRange(boolean er) {
            this.equalRange = er;
        }

        public double[] getEdgeList() {
            return this.edgeList;
        }

        public void setEdgeList(double[] edges) {
            if (this.edgeList == null || this.edgeList.length != edges.length) {
                this.edgeList = new double[edges.length];
            }
            for (int i = 0; i < edges.length; ++i) {
                this.edgeList[i] = edges[i];
            }
        }

        public boolean getSturges() {
            return this.sturges;
        }

        public boolean getFreedman() {
            return this.freedman;
        }

        public boolean getScott() {
            return this.scott;
        }

        public void setSturges(boolean b) {
            this.sturges = b;
        }

        public void setFreedman(boolean b) {
            this.freedman = b;
        }

        public void setScott(boolean b) {
            this.scott = b;
        }
    }

    private class PositiveIntegerDocument
    extends PlainDocument {
        private PositiveIntegerDocument() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                String pre = this.getText(0, offset);
                String post = this.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (!full.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                    Integer.parseInt(full);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            super.insertString(offset, s, attributeSet);
        }
    }
}

