/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GridViewerComposite;
import com.insightful.miner.GridViewerRowNumberModel;
import com.insightful.miner.GridViewerTable;
import com.insightful.miner.LongScrollBar;
import com.insightful.miner.Retrievable;
import com.insightful.miner.XTMetaData;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class GridViewerModel
extends AbstractTableModel {
    protected Retrievable dataSource = null;
    protected int[] columnWidths = null;
    protected Object[][] accessibleData = null;
    protected int accessibleNumRows;
    protected int accessibleNumCols;
    protected long absoluteRowPos;
    protected int absoluteColPos;
    protected long totalNumRows;
    protected int totalNumCols;
    protected int deltaRowPos;
    protected int deltaColPos;
    public DefaultTableCellRenderer m_cellRenderer = null;
    public DefaultTableCellRenderer m_stringRenderer = null;
    protected boolean adjustingNow = false;

    public GridViewerModel() {
    }

    public GridViewerModel(int visibleRows, int visibleCols, Retrievable getDataFrom) {
        int i;
        this.dataSource = getDataFrom;
        this.totalNumRows = getDataFrom.getTotalRows();
        this.totalNumCols = getDataFrom.getTotalColumns();
        this.accessibleNumRows = visibleRows;
        this.accessibleNumCols = visibleCols;
        this.deltaRowPos = 0;
        this.deltaColPos = 0;
        this.columnWidths = new int[this.totalNumCols];
        for (i = 0; i < this.totalNumCols; ++i) {
            this.columnWidths[i] = -1;
        }
        this.accessibleData = new Object[this.accessibleNumRows][this.accessibleNumCols];
        for (i = 0; i < this.accessibleNumRows; ++i) {
            for (int j = 0; j < this.accessibleNumCols; ++j) {
                this.accessibleData[i][j] = this.dataSource.getData(i, j);
            }
        }
    }

    protected int getRelativeColumnWidth(int numColumn) {
        int absoluteColNum = this.absoluteColPos + numColumn;
        if (this.columnWidths[absoluteColNum] == -1) {
            this.columnWidths[absoluteColNum] = this.dataSource.getColumnWidth(absoluteColNum);
        }
        return this.columnWidths[absoluteColNum];
    }

    protected int getAbsoluteColumnWidth(int numColumn) {
        if (this.columnWidths[numColumn] == -1) {
            this.columnWidths[numColumn] = this.dataSource.getColumnWidth(numColumn);
        }
        return this.columnWidths[numColumn];
    }

    protected void positionChangeNotification(long actualDataLocY, int actualDataLocX) {
        this.deltaColPos = actualDataLocX - this.absoluteColPos;
        this.deltaRowPos = (int)(actualDataLocY - this.absoluteRowPos);
    }

    protected boolean isDataInMemoryNow(long absoluteCoordinateY, int absoluteCoordinateX) {
        boolean inRange = this.isColumnInMemoryNow(absoluteCoordinateY, absoluteCoordinateX);
        inRange = inRange && this.isRowInMemoryNow(absoluteCoordinateY, absoluteCoordinateX);
        return inRange;
    }

    protected boolean isColumnInMemoryNow(long absoluteCoordinateY, int absoluteCoordinateX) {
        boolean inRange = absoluteCoordinateX >= this.absoluteColPos && absoluteCoordinateX < this.absoluteColPos + this.accessibleNumCols;
        return inRange;
    }

    protected boolean isRowInMemoryNow(long absoluteCoordinateY, int absoluteCoordinateX) {
        boolean inRange = absoluteCoordinateY >= this.absoluteRowPos && absoluteCoordinateY < this.absoluteRowPos + (long)this.accessibleNumRows;
        return inRange;
    }

    public void gridViewerAdjustment(GridViewerTable gridViewerTable, GridViewerRowNumberModel gridViewerRowNumberModel, JTable gridViewerRowNumberTable, LongScrollBar horizontalScrollBar, LongScrollBar verticalScrollBar, int actualDataLocX, long actualDataLocY) {
        if (gridViewerTable == null || gridViewerRowNumberModel == null || gridViewerRowNumberTable == null || verticalScrollBar == null || horizontalScrollBar == null) {
            return;
        }
        if (this.adjustingNow) {
            return;
        }
        this.adjustingNow = true;
        this.positionChangeNotification(actualDataLocY, actualDataLocX);
        int currentNumColumns = gridViewerTable.getColumnCount();
        int[] existingColumnWidths = new int[currentNumColumns];
        for (int i = 0; i < currentNumColumns; ++i) {
            existingColumnWidths[i] = gridViewerTable.getColumnModel().getColumn(i).getPreferredWidth();
        }
        this.storeCurrentColumnWidths(existingColumnWidths, existingColumnWidths.length);
        Rectangle rect = gridViewerTable.getBounds();
        int width = (int)rect.getWidth();
        int visibleRows = (int)(rect.getHeight() / (double)GridViewerComposite.CELL_HEIGHT);
        int visibleCols = this.findVisibleColumnRange(actualDataLocX, actualDataLocY, width, existingColumnWidths);
        int boundaryX = this.getTotalColCount();
        long boundaryY = this.getTotalRowCount();
        if (actualDataLocX + visibleCols > boundaryX) {
            actualDataLocX = boundaryX - visibleCols > 0 ? boundaryX - visibleCols : 0;
            horizontalScrollBar.setLongValue(actualDataLocX);
            this.positionChangeNotification(actualDataLocY, actualDataLocX);
        }
        if (actualDataLocY + (long)visibleRows > boundaryY) {
            actualDataLocY = boundaryY - (long)visibleRows > 0L ? boundaryY - (long)visibleRows : 0L;
            verticalScrollBar.setLongValue(actualDataLocY);
            this.positionChangeNotification(actualDataLocY, actualDataLocX);
        }
        if (visibleCols > boundaryX) {
            visibleCols = boundaryX;
        }
        if ((long)visibleRows > boundaryY) {
            visibleRows = (int)boundaryY;
        }
        this.changeGridViewerModel(gridViewerTable, actualDataLocX, actualDataLocY, visibleRows, visibleCols);
        gridViewerRowNumberModel.changeGridViewerModel(actualDataLocX, actualDataLocY, visibleRows, visibleCols);
        gridViewerRowNumberTable.getColumnModel().getColumn(0).setCellRenderer(gridViewerTable.getPrimaryTableHeader().getDefaultRenderer());
        this.setTableCellRenderer(gridViewerTable);
        verticalScrollBar.initialize(this.getTotalRowCount());
        verticalScrollBar.setLongMaximum(this.getTotalRowCount());
        verticalScrollBar.setUnitIncrement(1);
        verticalScrollBar.setMinimum(0);
        verticalScrollBar.setBlockIncrement(visibleRows);
        verticalScrollBar.getModel().setExtent(visibleRows);
        verticalScrollBar.setVisible(this.totalNumRows > (long)visibleRows);
        horizontalScrollBar.initialize(this.getTotalColCount());
        horizontalScrollBar.setLongMaximum(this.getTotalColCount());
        horizontalScrollBar.setUnitIncrement(1);
        horizontalScrollBar.setMinimum(0);
        horizontalScrollBar.setBlockIncrement(visibleCols);
        horizontalScrollBar.getModel().setExtent(visibleCols);
        horizontalScrollBar.setVisible(this.totalNumCols > visibleCols);
        this.adjustingNow = false;
    }

    public void setStringLeftAlignment(JTable table, boolean left) {
        if (this.m_stringRenderer != null) {
            this.m_stringRenderer.setHorizontalAlignment(left ? 2 : 4);
            table.updateUI();
        }
    }

    public void setTableCellRenderer(JTable table) {
        if (this.m_cellRenderer == null) {
            this.m_cellRenderer = new DefaultTableCellRenderer();
            this.m_cellRenderer.setHorizontalAlignment(4);
            this.m_stringRenderer = new DefaultTableCellRenderer();
            this.m_stringRenderer.setHorizontalAlignment(4);
        }
        for (int i = table.getColumnCount() - 1; i >= 0; --i) {
            String type = this.getAbsoluteColumnType(i);
            if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                table.getColumnModel().getColumn(i).setCellRenderer(this.m_stringRenderer);
                continue;
            }
            table.getColumnModel().getColumn(i).setCellRenderer(this.m_cellRenderer);
        }
    }

    protected int[] getAppropriateColumnWidths(int actualDataLocY, int actualDataLocX, int visibleColumns, int[] existingColumnWidths) {
        int[] newColumnWidths = new int[visibleColumns];
        for (int i = 0; i < visibleColumns; ++i) {
            newColumnWidths[i] = this.isColumnInMemoryNow(actualDataLocY, actualDataLocX + i) ? existingColumnWidths[i + this.deltaColPos] : this.getAbsoluteColumnWidth(actualDataLocX + i);
        }
        return newColumnWidths;
    }

    public void storeCurrentColumnWidths(int[] currentWidths, int numColumns) {
        for (int i = 0; i < numColumns; ++i) {
            this.columnWidths[this.absoluteColPos + i] = currentWidths[i];
        }
    }

    public int findVisibleColumnRange(int actualDataLocX, long actualDataLocY, int availableWidth, int[] currentWidths) {
        int actualVisibleCols = 0;
        int accruedWidth = 0;
        int i = 0;
        while (true) {
            if (actualDataLocX + i == this.totalNumCols) {
                return actualVisibleCols;
            }
            accruedWidth = this.isColumnInMemoryNow(actualDataLocY, actualDataLocX + i) ? (accruedWidth += currentWidths[this.deltaColPos + i++]) : (accruedWidth += this.getAbsoluteColumnWidth(actualDataLocX + i++));
            if (accruedWidth < availableWidth) {
                ++actualVisibleCols;
                continue;
            }
            if (accruedWidth >= availableWidth) {
                return actualVisibleCols + 1;
            }
            if (actualVisibleCols == 0) break;
        }
        return 2;
    }

    protected void changeGridViewerModel(GridViewerTable table, int actualDataLocX, long actualDataLocY, int visibleRows, int visibleCols) {
        if (this.absoluteRowPos == actualDataLocY && this.absoluteColPos == actualDataLocX && this.accessibleNumRows == visibleRows && this.accessibleNumCols == visibleCols) {
            return;
        }
        this.dataSource.updateWindowPosition(actualDataLocY, visibleRows, actualDataLocX, visibleCols);
        if (visibleRows < 0) {
            visibleRows = 0;
        }
        if (visibleCols < 0) {
            visibleCols = 0;
        }
        Object[][] oldData = this.accessibleData;
        this.accessibleData = new Object[visibleRows][visibleCols];
        for (int i = 0; i < visibleRows; ++i) {
            for (int j = 0; j < visibleCols; ++j) {
                this.accessibleData[i][j] = this.isDataInMemoryNow(actualDataLocY + (long)i, actualDataLocX + j) ? oldData[i + this.deltaRowPos][j + this.deltaColPos] : this.dataSource.getData(actualDataLocY + (long)i, actualDataLocX + j);
            }
        }
        this.accessibleNumRows = visibleRows;
        this.accessibleNumCols = visibleCols;
        this.absoluteRowPos = actualDataLocY;
        this.absoluteColPos = actualDataLocX;
        if (this.accessibleNumRows != 0 && this.accessibleNumCols != 0) {
            boolean previousBoolean = false;
            previousBoolean = table.setResetSelectionAllowed(false);
            this.fireTableStructureChanged();
            table.setResetSelectionAllowed(previousBoolean);
        }
    }

    protected long getTotalRowCount() {
        return this.totalNumRows;
    }

    public int getTotalColCount() {
        return this.totalNumCols;
    }

    protected long getAbsoluteRowPos() {
        return this.absoluteRowPos;
    }

    protected int getAbsoluteColPos() {
        return this.absoluteColPos;
    }

    protected String getColumnType(int numCol) {
        return this.dataSource.getColumnType(this.absoluteColPos + numCol);
    }

    protected String getColumnDisplayType(int numCol) {
        return this.dataSource.getColumnDisplayType(this.absoluteColPos + numCol);
    }

    protected int getAbsoluteColumnNumber(int relativeColumn) {
        return this.absoluteColPos + relativeColumn;
    }

    protected String getAbsoluteColumnName(int numCol) {
        return this.dataSource.getColumnName(numCol);
    }

    protected String getAbsoluteColumnType(int numCol) {
        return this.dataSource.getColumnType(numCol);
    }

    public Object getAbsoluteValueAt(long absRowIndex, int absColumnIndex) {
        if (absRowIndex < this.getTotalRowCount() && absColumnIndex < this.getTotalColCount()) {
            return this.dataSource.getData(absRowIndex, absColumnIndex);
        }
        return new Object();
    }

    public String getColumnName(int numCol) {
        return this.dataSource.getColumnName(this.absoluteColPos + numCol);
    }

    public int getColumnCount() {
        return this.accessibleNumCols;
    }

    public int getRowCount() {
        return this.accessibleNumRows;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.accessibleNumRows && columnIndex < this.accessibleNumCols) {
            return this.accessibleData[rowIndex][columnIndex];
        }
        return new Object();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

