/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsDefaultHistogramDataset;
import com.insightful.miner.InsHistogramRenderer;
import com.insightful.miner.InsStandardHistogramToolTipGenerator;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.tooltips.ToolTipsCollection;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class InsHistogramPlot
extends Plot
implements VerticalValuePlot,
HorizontalValuePlot {
    protected InsHistogramRenderer renderer;
    protected InsStandardHistogramToolTipGenerator toolTipGenerator;

    public InsHistogramPlot(Axis horizontal, Axis vertical, InsHistogramRenderer renderer) throws AxisNotCompatibleException, PlotNotCompatibleException {
        super(horizontal, vertical);
        this.renderer = renderer;
    }

    public InsHistogramPlot(Axis horizontal, Axis vertical, InsHistogramRenderer renderer, Insets insets, Paint backgroundPaint, Image backgroundImage, float backgroundAlpha, Stroke outlineStroke, Paint outlinePaint, float foregroundAlpha) throws AxisNotCompatibleException, PlotNotCompatibleException {
        super(horizontal, vertical, insets, backgroundPaint, backgroundImage, backgroundAlpha, outlineStroke, outlinePaint, foregroundAlpha);
        this.renderer = renderer;
    }

    public InsDefaultHistogramDataset getDataset() {
        return (InsDefaultHistogramDataset)this.chart.getDataset();
    }

    public VerticalNumberAxis getRangeAxis() {
        return (VerticalNumberAxis)this.verticalAxis;
    }

    public void setVerticalAxis(Axis vAxis) throws AxisNotCompatibleException {
        super.setVerticalAxis(vAxis);
    }

    public HorizontalNumberAxis getDomainAxis() {
        return (HorizontalNumberAxis)this.horizontalAxis;
    }

    public void setHorizontalAxis(Axis axis) throws AxisNotCompatibleException {
        super.setHorizontalAxis(axis);
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalNumberAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, DrawInfo info) {
        ToolTipsCollection tooltips = null;
        if (info != null) {
            info.setPlotArea(plotArea);
            tooltips = info.getToolTipsCollection();
        }
        if (this.insets != null) {
            plotArea = new Rectangle2D.Double(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (plotArea.getWidth() >= 10.0 && plotArea.getHeight() >= 10.0) {
            HorizontalAxis hAxis = this.getHorizontalAxis();
            VerticalAxis vAxis = this.getVerticalAxis();
            double hAxisAreaHeight = hAxis.reserveHeight(g2, (Plot)this, plotArea);
            Rectangle2D vAxisArea = vAxis.reserveAxisArea(g2, (Plot)this, plotArea, hAxisAreaHeight);
            Rectangle2D.Double dataArea = new Rectangle2D.Double(plotArea.getX() + vAxisArea.getWidth(), plotArea.getY(), plotArea.getWidth() - vAxisArea.getWidth(), plotArea.getHeight() - hAxisAreaHeight);
            Shape backgroundPlotArea = this.calculateBackgroundPlotArea(dataArea);
            this.drawOutlineAndBackground(g2, backgroundPlotArea);
            this.getDomainAxis().draw(g2, plotArea, (Rectangle2D)dataArea);
            this.getRangeAxis().draw(g2, plotArea, (Rectangle2D)dataArea);
            this.drawBars(g2, backgroundPlotArea, dataArea, tooltips, info);
        }
    }

    protected Shape calculateBackgroundPlotArea(Rectangle2D plotArea) {
        return plotArea;
    }

    protected void drawBars(Graphics2D g2, Shape backgroundPlotArea, Rectangle2D dataArea, ToolTipsCollection tooltips, DrawInfo info) {
        InsDefaultHistogramDataset data = this.getDataset();
        if (data != null) {
            Shape savedClip = g2.getClip();
            g2.clip(backgroundPlotArea);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            int itemCount = data.getItemCount();
            double itemWidth = dataArea.getWidth() / (double)this.renderer.barWidthsPerBin(data);
            double translatedZero = this.getRangeAxis().translateValueToJava2D(Plot.ZERO.doubleValue(), dataArea);
            for (int item = 0; item < itemCount; ++item) {
                Shape region = this.renderer.drawBar(g2, dataArea, this, (ValueAxis)this.getRangeAxis(), data, item, translatedZero, itemWidth);
                if (info == null || tooltips == null) continue;
                if (this.toolTipGenerator == null) {
                    this.toolTipGenerator = new InsStandardHistogramToolTipGenerator();
                }
                String tip = this.toolTipGenerator.generateToolTip(data, item);
                if (region == null) continue;
                tooltips.addToolTip(tip, region);
            }
            Line2D.Double baseline = new Line2D.Double(dataArea.getX(), translatedZero, dataArea.getMaxX(), translatedZero);
            g2.setStroke(new BasicStroke());
            g2.draw(baseline);
            VerticalNumberAxis vva = this.getRangeAxis();
            if (vva.isCrosshairVisible()) {
                this.drawHorizontalLine(g2, dataArea, vva.getCrosshairValue(), vva.getCrosshairStroke(), vva.getCrosshairPaint());
            }
            g2.setClip(savedClip);
            g2.setComposite(originalComposite);
        }
    }

    public void drawOutlineAndBackground(Graphics2D g2, Shape area) {
        if (this.backgroundPaint != null) {
            g2.setPaint(this.backgroundPaint);
            g2.fill(area);
        }
        if (this.outlineStroke != null && this.outlinePaint != null) {
            g2.setStroke(this.outlineStroke);
            g2.setPaint(this.outlinePaint);
            g2.draw(area);
        }
    }

    public String getPlotType() {
        return "Histogram Plot";
    }

    public Number getMinimumVerticalDataValue() {
        Number result = null;
        Dataset data = this.getChart().getDataset();
        if (data != null) {
            result = DatasetUtilities.getMinimumRangeValue((Dataset)data);
        }
        return result;
    }

    public Number getMinimumHorizontalDataValue() {
        Number result = null;
        Dataset data = this.getChart().getDataset();
        if (data != null) {
            result = DatasetUtilities.getMinimumDomainValue((Dataset)data);
        }
        return result;
    }

    public Number getMaximumVerticalDataValue() {
        Number result = null;
        Dataset data = this.getChart().getDataset();
        if (data != null) {
            result = DatasetUtilities.getMaximumRangeValue((Dataset)data);
        }
        return result;
    }

    public Number getMaximumHorizontalDataValue() {
        Number result = null;
        Dataset data = this.getChart().getDataset();
        if (data != null) {
            result = DatasetUtilities.getMaximumDomainValue((Dataset)data);
        }
        return result;
    }

    public void handleClick(int x, int y, DrawInfo info) {
        VerticalNumberAxis vva = this.getRangeAxis();
        double vvalue = vva.translateJava2DtoValue((float)y, info.getDataArea());
        vva.setAnchorValue(vvalue);
        vva.setCrosshairValue(vvalue);
    }

    private void drawHorizontalLine(Graphics2D g2, Rectangle2D dataArea, double value, Stroke stroke, Paint paint) {
        double yy = this.getRangeAxis().translateValueToJava2D(value, dataArea);
        Line2D.Double line = new Line2D.Double(dataArea.getMinX(), yy, dataArea.getMaxX(), yy);
        g2.setStroke(stroke);
        g2.setPaint(paint);
        g2.draw(line);
    }

    public void zoom(double percent) {
        VerticalNumberAxis rangeAxis = this.getRangeAxis();
        if (percent > 0.0) {
            double range = rangeAxis.getMaximumAxisValue() - rangeAxis.getMinimumAxisValue();
            double scaledRange = range * percent;
            rangeAxis.setAnchoredRange(scaledRange);
        } else {
            rangeAxis.setAutoRange(true);
        }
    }
}

