/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsBasicChartPanel;
import com.insightful.miner.NeuralNetViewer;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class InsNNErrorGraphPanel
extends InsBasicChartPanel {
    private NeuralNetViewer frame = null;
    public static final String ENLARGE_ACTION_COMMAND = "ENLARGE";
    private boolean isEnlarged = false;
    private JMenuItem enlargeMenuItem;
    private int numEpochs = 0;
    private Vector validateVector = null;
    private Vector arrowEpochs = null;

    public InsNNErrorGraphPanel(NeuralNetViewer nnv, JFreeChart chart, int width, int height, double minimumDrawWidth, double minimumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.frame = nnv;
        this.arrowEpochs = new Vector();
        this.arrowEpochs.add(new Double(1.0));
        this.addMenuItems(this.popup);
    }

    public InsNNErrorGraphPanel(NeuralNetViewer nnv, JFreeChart chart) {
        this(nnv, chart, 250, 250, 250.0, 250.0, true, true, true, true, true, true);
    }

    public void resetArrows(Vector v) {
        this.arrowEpochs = v;
    }

    private void handleLeftClick(MouseEvent e) {
    }

    private void handleRightClick(MouseEvent e) {
    }

    private void handleDoubleClick() {
    }

    private void addMenuItems(JPopupMenu popup) {
        this.enlargeMenuItem = new JMenuItem(NeuralNetViewer.getText("nnvis_gui_errorGraph_enlarge"));
        this.enlargeMenuItem.setActionCommand(ENLARGE_ACTION_COMMAND);
        this.enlargeMenuItem.addActionListener(this);
        popup.addSeparator();
        popup.add(this.enlargeMenuItem);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(ENLARGE_ACTION_COMMAND)) {
            this.frame.showEnlargedChart();
        } else {
            super.actionPerformed(event);
        }
    }

    public void addArrow(double epoch) {
        this.arrowEpochs.add(new Double(epoch));
    }

    public Vector getArrowVector() {
        return this.arrowEpochs;
    }

    public void setArrowInfo(double epoch, int num_epochs, Vector vVector) {
        this.numEpochs = num_epochs;
        this.validateVector = vVector;
        if (this.arrowEpochs.size() == 0) {
            this.arrowEpochs.add(new Double(epoch));
        } else {
            this.arrowEpochs.set(0, new Double(epoch));
        }
    }

    public void setIsEnlarged(boolean b) {
        this.isEnlarged = b;
        if (this.isEnlarged) {
            this.enlargeMenuItem.setEnabled(false);
        }
    }

    public boolean getIsEnlarged() {
        return this.isEnlarged;
    }

    public Frame getParentFrame() {
        return this.frame;
    }

    public NumberAxis getRangeAxis() {
        JFreeChart chart = this.getChart();
        return (NumberAxis)chart.getPlot().getVerticalAxis();
    }

    public double getMaxVal() {
        return ((NumberAxis)this.getChart().getPlot().getVerticalAxis()).getMaximumAxisValue();
    }

    public double getMinVal() {
        return 0.0;
    }

    public Point calculateArrowLocation(double epoch) {
        if (epoch < 1.0) {
            return null;
        }
        double insetsLeftWidth = 36.0;
        double insetsRigthWidth = 40.0;
        double insetsTopHeight = 40.0;
        double insetsBottomHeight = 80.0;
        double graphWidth = (double)this.getWidth() - (insetsLeftWidth + insetsRigthWidth);
        double graphHeight = (double)this.getHeight() - (insetsTopHeight + insetsBottomHeight);
        double panelxval = graphWidth / ((double)this.numEpochs * 0.99) * epoch + insetsLeftWidth;
        double panelyval = graphHeight - graphHeight * 0.1 + insetsTopHeight + 10.0;
        Point p = new Point((int)panelxval, (int)panelyval);
        return p;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Point p = null;
        for (int i = 0; i < this.arrowEpochs.size(); ++i) {
            Double epoch = (Double)this.arrowEpochs.elementAt(i);
            p = this.calculateArrowLocation(epoch);
            if (p == null) continue;
            if (i == 0) {
                this.drawArrow(g, p, true);
                continue;
            }
            this.drawArrow(g, p, false);
        }
    }

    private void drawArrow(Graphics g, Point p, boolean best) {
        if (best) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        int[] xpoints = new int[3];
        int[] ypoints = new int[3];
        xpoints[0] = p.x;
        ypoints[0] = p.y;
        xpoints[1] = p.x + 4;
        ypoints[1] = p.y + 8;
        xpoints[2] = p.x - 4;
        ypoints[2] = p.y + 8;
        g.fillPolygon(xpoints, ypoints, 3);
    }
}

