/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.EngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerRandom;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class MissingValuesEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static final String COLUMNS_ATTRIBUTE_TAG = "columns";
    public static final String METHOD_TYPE_ATTRIBUTE_TAG = "methodType";
    public static final String NANSTR_ATTRIBUTE_TAG = "nanString";
    public static final String KEY_ATTRIBUTE_TAG = "key";
    public static String[] m_methodTypes = new String[]{"none", "dropRows", "generateFromDistribution", "replaceWithMean", "replaceWithConstant", "lastObservation"};
    public static int DO_NOTHING = 0;
    public static int DROP_ROWS = 1;
    public static int REPL_DISTR = 2;
    public static int REPL_MEANS = 3;
    public static int REPL_CONST = 4;
    public static int LAST_OBSRV = 5;
    private Vector m_columnNames = null;
    private String[][] m_newLevels = null;
    private boolean[] m_isString = null;
    private boolean[] m_isNumeric = null;
    private MinerRandom m_random = null;
    private double[][] m_histogramPercentages = null;
    private double[][] m_histogramBoundaries = null;
    private ByColumnStatisticAccumulator m_bCS = null;
    private long m_totalRowCount;
    private Object[] m_constants = null;
    private double[] m_means = null;
    private double[] m_distr = null;
    private boolean[] m_drop = null;
    private int m_numColumns = 0;
    private int m_numStringColumns = 0;
    private boolean m_setHistograms = true;
    private Vector m_distrColumn = null;
    private int[] m_keys = null;
    private double[][] m_lastObs = null;
    private String[][] m_lastObsStr = null;
    private double[] m_lastNonMissingVal = null;
    private String[] m_lastNonMissingValStr = null;
    private XTMetaData m_metaData = null;
    private Vector m_prevWarnings = null;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        XTMetaData metaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        this.allocateVariables(props, metaData);
        int maxLevels = this.getNetworkManager().getMaxCategoricalLevels();
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (this.m_newLevels[i] == null || this.m_newLevels[i].length <= maxLevels) continue;
            throw new Exception("can't remove missing values from column " + metaData.ordinalToName(i) + " : would exceed limit of " + maxLevels + " levels");
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        this.loopToOutput(proc);
    }

    private void allocateVariables(XTProps props, XTMetaData md) throws Exception {
        this.m_prevWarnings = null;
        this.m_metaData = md;
        this.m_columnNames = md.getColumnNames();
        this.m_numColumns = md.getNumColumns();
        this.m_constants = new Object[this.m_numColumns];
        this.m_means = new double[this.m_numColumns];
        this.m_distr = new double[this.m_numColumns];
        this.m_drop = new boolean[this.m_numColumns];
        this.m_isString = new boolean[this.m_numColumns];
        this.m_isNumeric = new boolean[this.m_numColumns];
        this.m_keys = new int[this.m_numColumns];
        this.m_lastObs = new double[this.m_numColumns][];
        this.m_lastObsStr = new String[this.m_numColumns][];
        this.m_lastNonMissingVal = new double[this.m_numColumns];
        this.m_lastNonMissingValStr = new String[this.m_numColumns];
        this.m_newLevels = new String[this.m_numColumns][];
        if (props.getValue("randomSeed", "").equals("enterSeed")) {
            long seed = Long.parseLong(props.getValue("randomSeedValue"));
            this.m_random = new MinerRandom(seed);
        } else {
            this.m_random = new MinerRandom();
        }
        this.m_distrColumn = new Vector();
        String[] path = new String[]{COLUMNS_ATTRIBUTE_TAG, "", ""};
        for (int i = 0; i < this.m_numColumns; ++i) {
            this.m_newLevels[i] = null;
            this.m_constants[i] = null;
            this.m_distr[i] = Double.NaN;
            this.m_means[i] = Double.NaN;
            this.m_lastNonMissingVal[i] = Double.NaN;
            this.m_lastNonMissingValStr[i] = CNKProcJavaTransform.getStringNA();
            this.m_drop[i] = false;
            this.m_lastObs[i] = null;
            this.m_lastObsStr[i] = null;
            this.m_keys[i] = -1;
            boolean hasMissing = md.getColumnMissingCount(i) > 0.0;
            boolean isDate = md.isDateTimeColumn(i);
            boolean isLevel = md.isCategoricalColumn(i);
            path[1] = md.ordinalToName(i);
            this.m_isString[i] = md.isStringColumn(i);
            this.m_isNumeric[i] = md.isContinuousColumn(i);
            if (this.m_isString[i]) {
                ++this.m_numStringColumns;
            }
            path[2] = METHOD_TYPE_ATTRIBUTE_TAG;
            String method = props.getValue(path, m_methodTypes[DO_NOTHING]);
            if (!hasMissing) {
                method = m_methodTypes[DO_NOTHING];
            }
            if (!(md.getColumnRowCount(i) != 0.0 || method.equals(m_methodTypes[DO_NOTHING]) || method.equals(m_methodTypes[DROP_ROWS]) || method.equals(m_methodTypes[REPL_CONST]))) {
                this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_all_missing") + md.ordinalToName(i));
                method = m_methodTypes[DO_NOTHING];
            }
            boolean isLCF = method.equals(m_methodTypes[LAST_OBSRV]);
            if (method.equals(m_methodTypes[DO_NOTHING])) continue;
            if (this.m_isString[i] && !isLCF || method.equals(m_methodTypes[REPL_CONST])) {
                path[2] = NANSTR_ATTRIBUTE_TAG;
                String str = props.getValue(path, "");
                if (this.m_isString[i]) {
                    if (method.equals(m_methodTypes[REPL_CONST])) {
                        this.m_constants[i] = str;
                        continue;
                    }
                    if (!method.equals(m_methodTypes[DROP_ROWS])) continue;
                    this.m_drop[i] = true;
                    continue;
                }
                if (isLevel) {
                    Vector existLevels = md.getCategoricalDataFieldLevels(path[1]);
                    int index = existLevels.indexOf(str);
                    if (index == -1) {
                        Object[] array = existLevels.toArray();
                        this.m_newLevels[i] = new String[array.length + 1];
                        for (int l = 0; l < array.length; ++l) {
                            this.m_newLevels[i][l] = (String)array[l];
                        }
                        this.m_newLevels[i][array.length] = str;
                        index = array.length;
                    } else {
                        this.m_newLevels[i] = new String[existLevels.size()];
                        existLevels.copyInto(this.m_newLevels[i]);
                    }
                    this.m_constants[i] = new Double(index);
                    continue;
                }
                if (isDate) {
                    double lng = this.getNetworkManager().getWorksheetPropertiesManager().getDateParser().convertStringToTimeDate(str);
                    double dbl = lng / 8.64E7;
                    this.m_constants[i] = new Double(dbl);
                    continue;
                }
                this.m_constants[i] = new Double(str);
                continue;
            }
            if (method.equals(m_methodTypes[REPL_DISTR])) {
                this.m_distr[i] = md.getColumnMean(i);
                this.m_distrColumn.add(path[1]);
                continue;
            }
            if (method.equals(m_methodTypes[REPL_MEANS])) {
                this.m_means[i] = md.getColumnMean(i);
                continue;
            }
            if (isLCF) {
                path[2] = KEY_ATTRIBUTE_TAG;
                String keyColumn = props.getValue(path, "");
                this.m_keys[i] = md.nameToOrdinal(keyColumn);
                if (this.m_keys[i] != -1 && !md.isCategoricalColumn(keyColumn)) {
                    this.printlnWarning("Key Column (" + keyColumn + ") for column " + path[1] + " will be ignored, because it is not a factor column.");
                    this.m_keys[i] = i;
                    continue;
                }
                if (this.m_keys[i] != -1) {
                    if (this.m_isString[i]) {
                        this.m_lastObsStr[i] = new String[md.getCategoricalDataFieldLevels(keyColumn).size()];
                        for (int v = 0; v < this.m_lastObsStr[i].length; ++v) {
                            this.m_lastObsStr[i][v] = CNKProcJavaTransform.getStringNA();
                        }
                        continue;
                    }
                    this.m_lastObs[i] = new double[md.getCategoricalDataFieldLevels(keyColumn).size()];
                    for (int v = 0; v < this.m_lastObs[i].length; ++v) {
                        this.m_lastObs[i][v] = Double.NaN;
                    }
                    continue;
                }
                if (keyColumn.length() > 0) {
                    this.printlnWarning("Key Column (" + keyColumn + ") for column " + path[1] + " was not found.");
                }
                this.m_keys[i] = i;
                continue;
            }
            if (!method.equals(m_methodTypes[DROP_ROWS])) continue;
            this.m_drop[i] = true;
        }
        Vector oldProperties = props.getSubProperties("outgoingColumns");
        String oldType = props.getValue("method");
        String[] constants = new String[]{props.getValue("numericConstant", ""), props.getValue("categoricalConstant", ""), props.getValue("dateConstant", ""), props.getValue("stringConstant", "")};
        for (int i = 0; i < this.m_numColumns; ++i) {
            String colName = md.ordinalToName(i);
            int colNum = oldProperties.indexOf(colName);
            if (colNum <= -1 || md.getColumnMissingCount(i) == 0.0 || oldType.equals(m_methodTypes[DO_NOTHING])) continue;
            if (this.m_isString[i] || oldType.equals(m_methodTypes[REPL_CONST])) {
                if (this.m_isString[i]) {
                    this.m_constants[i] = constants[3];
                    continue;
                }
                if (md.isDateTimeColumn(i)) {
                    double lng = this.getNetworkManager().getWorksheetPropertiesManager().getDateParser().convertStringToTimeDate(constants[2]);
                    double dbl = lng / 8.64E7;
                    this.m_constants[i] = new Double(dbl);
                    continue;
                }
                if (md.isCategoricalColumn(i)) {
                    Object[] array = md.getCategoricalDataFieldLevels(colName).toArray();
                    this.m_newLevels[i] = new String[array.length + 1];
                    for (int l = 0; l < array.length; ++l) {
                        this.m_newLevels[i][l] = (String)array[l];
                    }
                    this.m_newLevels[i][array.length] = constants[1];
                    this.m_constants[i] = new Double(array.length);
                    continue;
                }
                this.m_constants[i] = new Double(constants[0]);
                continue;
            }
            if (oldType.equals(m_methodTypes[REPL_DISTR])) {
                this.m_distr[i] = md.getColumnMean(i);
                this.m_distrColumn.add(colName);
                continue;
            }
            if (oldType.equals(m_methodTypes[REPL_MEANS])) {
                this.m_means[i] = md.getColumnMean(i);
                continue;
            }
            if (!oldType.equals(m_methodTypes[DROP_ROWS])) continue;
            this.m_drop[i] = true;
        }
        this.m_totalRowCount = md.getNumRows();
        this.m_setHistograms = true;
        if (this.m_distrColumn.size() > 0) {
            try {
                this.m_bCS = new ByColumnStatisticAccumulator(new Vector(), this.m_distrColumn, 4, 100, md);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_histogramPercentages = new double[this.m_numColumns][];
            this.m_histogramBoundaries = new double[this.m_numColumns][];
            for (int col = 0; col < this.m_numColumns; ++col) {
                if (Double.isNaN(this.m_distr[col])) continue;
                int binCount = this.m_bCS.getBinCount();
                if (md.isCategoricalColumn(col)) {
                    binCount = md.getCategoricalDataFieldLevels((String)this.m_columnNames.get(col)).size();
                }
                this.m_histogramPercentages[col] = new double[binCount];
                this.m_histogramBoundaries[col] = new double[binCount + 1];
                double max = md.getColumnMax(col);
                double min = md.getColumnMin(col);
                double increment = (max - min) / (double)binCount;
                for (int bin = 0; bin < binCount; ++bin) {
                    this.m_histogramBoundaries[col][bin] = bin == 0 ? min : this.m_histogramBoundaries[col][bin - 1] + increment;
                }
                this.m_histogramBoundaries[col][binCount] = max;
            }
        }
    }

    private void loopToGetDistrVals(CNKProcJavaTransform proc) throws Exception {
        long curPos = proc.getChunkInputPosition(0);
        int nRowBlock = proc.getChunkInputRows(0);
        int numNonStringCols = this.m_distrColumn.size();
        double[][] actualByColumns = new double[0][0];
        double[][] actualInterestColumns = new double[numNonStringCols][];
        int col = 0;
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (Double.isNaN(this.m_distr[i])) continue;
            actualInterestColumns[col++] = proc.getChunkInputColumnData(0, i);
        }
        this.m_bCS.updateStatistics(actualByColumns, actualInterestColumns, nRowBlock);
        proc.setChunkOutputReleaseRows(0, 0);
        if (curPos + (long)nRowBlock == this.m_totalRowCount) {
            this.m_setHistograms = false;
            proc.setChunkNextInputPosition(0, 0L);
            XTProps histogram = this.m_bCS.outputColumnStats();
            this.m_bCS = null;
            String[] path = new String[]{"", ByColumnStatisticAccumulator.STATS_ATTRIBUTE_TAG, ByColumnStatisticAccumulator.BINS_ATTRIBUTE_TAG, "0", ByColumnStatisticAccumulator.LOW_VALUE_ATTRIBUTE_TAG};
            for (int i = 0; i < this.m_numColumns; ++i) {
                if (Double.isNaN(this.m_distr[i])) continue;
                path[0] = (String)this.m_columnNames.get(i);
                double total = this.getInputMetaData(0).getColumnRowCount(path[0]);
                int binCount = this.m_histogramPercentages[i].length;
                for (int j = 0; j < binCount; ++j) {
                    path[3] = Integer.toString(j);
                    path[4] = ByColumnStatisticAccumulator.COUNT_ATTRIBUTE_TAG;
                    this.m_histogramPercentages[i][j] = j == 0 ? histogram.getDouble(path, 0.0) / total : histogram.getDouble(path, 0.0) / total + this.m_histogramPercentages[i][j - 1];
                }
            }
            histogram = null;
        }
    }

    private double getDistrVal(int columnNum) {
        int binNum;
        if (this.m_distrColumn.size() == 0 || this.m_histogramBoundaries == null) {
            return Double.NaN;
        }
        double randomPercent = this.m_random.nextDouble();
        for (binNum = 0; binNum < this.m_histogramPercentages[columnNum].length && !(this.m_histogramPercentages[columnNum][binNum] >= randomPercent); ++binNum) {
        }
        if (!this.m_isNumeric[columnNum]) {
            return binNum;
        }
        double binMin = this.m_histogramBoundaries[columnNum][binNum];
        double binRange = this.m_histogramBoundaries[columnNum][binNum + 1] - binMin;
        return binMin + this.m_random.nextDouble() * binRange;
    }

    private void loopToOutput(CNKProcJavaTransform proc) {
        int i;
        if (this.m_setHistograms && this.m_distrColumn.size() > 0) {
            try {
                this.loopToGetDistrVals(proc);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numrows = proc.getChunkInputRows(0);
        long pos = proc.getChunkInputPosition(0);
        int outputCount = 0;
        boolean[] isNaN = new boolean[this.m_numColumns];
        double[][] inputData = new double[this.m_numColumns][];
        double[][] outputData = new double[this.m_numColumns][];
        String[][] inputStrData = new String[this.m_numColumns][];
        String[][] outputStrData = new String[this.m_numColumns][];
        for (i = 0; i < this.m_numColumns; ++i) {
            if (this.m_isString[i]) {
                inputStrData[i] = proc.getChunkInputColumnStrings(0, i);
                outputStrData[i] = proc.getChunkOutputColumnStrings(0, i);
                continue;
            }
            inputData[i] = proc.getChunkInputColumnData(0, i);
            outputData[i] = proc.getChunkOutputColumnData(0, i);
        }
        for (int row = 0; row < numrows; ++row) {
            int col;
            boolean drop = false;
            for (col = 0; !drop && col < this.m_numColumns; ++col) {
                isNaN[col] = this.m_isString[col] ? CNKProcJavaTransform.isStringNA(inputStrData[col][row]) : Double.isNaN(inputData[col][row]);
                if (!this.m_drop[col] || !isNaN[col]) continue;
                drop = true;
            }
            if (drop) continue;
            for (col = 0; col < this.m_numColumns; ++col) {
                if (this.m_isString[col]) {
                    outputStrData[col][outputCount] = inputStrData[col][row];
                    if (!isNaN[col]) {
                        this.m_lastNonMissingValStr[col] = inputStrData[col][row];
                    }
                } else {
                    outputData[col][outputCount] = inputData[col][row];
                    if (!isNaN[col]) {
                        this.m_lastNonMissingVal[col] = inputData[col][row];
                    }
                }
                if (isNaN[col]) {
                    if (this.m_constants[col] != null) {
                        if (this.m_isString[col]) {
                            outputStrData[col][outputCount] = this.m_constants[col].toString();
                            continue;
                        }
                        outputData[col][outputCount] = (Double)this.m_constants[col];
                        continue;
                    }
                    if (!Double.isNaN(this.m_means[col])) {
                        outputData[col][outputCount] = this.m_means[col];
                        continue;
                    }
                    if (!Double.isNaN(this.m_distr[col])) {
                        outputData[col][outputCount] = this.getDistrVal(col);
                        continue;
                    }
                    if (this.m_keys[col] == -1) continue;
                    if (this.m_isString[col]) {
                        outputStrData[col][outputCount] = this.getLastObsStr(col, row, inputData, col);
                        continue;
                    }
                    outputData[col][outputCount] = this.getLastObs(col, row, inputData, col);
                    continue;
                }
                if (this.m_lastObs[col] == null && this.m_lastObsStr[col] == null || this.m_keys[col] == -1 || Double.isNaN(inputData[this.m_keys[col]][row])) continue;
                if (this.m_isString[col]) {
                    this.m_lastObsStr[col][(int)inputData[this.m_keys[col]][row]] = inputStrData[col][row];
                    continue;
                }
                this.m_lastObs[col][(int)inputData[this.m_keys[col]][row]] = inputData[col][row];
            }
            ++outputCount;
        }
        if ((long)numrows + pos == this.m_totalRowCount) {
            for (i = 0; i < this.m_numColumns; ++i) {
                if (this.m_newLevels[i] == null) continue;
                proc.getOutbuf().setColumnLevelStrings(i, this.m_newLevels[i]);
            }
        }
        proc.setChunkOutputReleaseRows(0, outputCount);
    }

    private double getLastObs(int column, int row, double[][] input, int first) {
        int keyColumn = this.m_keys[column];
        if (keyColumn == column) {
            double prevValue = this.m_lastNonMissingVal[column];
            if (Double.isNaN(prevValue)) {
                String colName = (String)this.m_columnNames.get(column);
                this.printlnWarning("Unable to replace leading missing values in " + colName);
            }
            return prevValue;
        }
        if (keyColumn == -1 || keyColumn == first) {
            return Double.NaN;
        }
        double keyLevel = input[keyColumn][row];
        if (Double.isNaN(keyLevel)) {
            keyLevel = this.getLastObs(keyColumn, row, input, first);
        }
        if (Double.isNaN(keyLevel)) {
            String colName = (String)this.m_columnNames.get(column);
            String keyName = (String)this.m_columnNames.get(keyColumn);
            this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_noLast1") + colName + MinerApp.getText("MissingValuesEngineNode_msg_missing") + keyName);
            return Double.NaN;
        }
        if (Double.isNaN(this.m_lastObs[column][(int)keyLevel])) {
            String colName = (String)this.m_columnNames.get(column);
            String idLevel = this.m_metaData.getCategoricalDataFieldLevel(keyColumn, (int)input[keyColumn][row]);
            this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_noLast1") + colName + MinerApp.getText("MissingValuesEngineNode_msg_first") + this.m_metaData.ordinalToName(keyColumn) + "=" + idLevel);
        }
        return this.m_lastObs[column][(int)keyLevel];
    }

    private String getLastObsStr(int column, int row, double[][] input, int first) {
        int keyColumn = this.m_keys[column];
        if (keyColumn == column) {
            return this.m_lastNonMissingValStr[column];
        }
        if (keyColumn == column) {
            String prevValue = this.m_lastNonMissingValStr[column];
            if (CNKProcJavaTransform.isStringNA(prevValue)) {
                String colName = (String)this.m_columnNames.get(column);
                this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_noLast1") + colName);
            }
            return prevValue;
        }
        if (keyColumn == -1 || keyColumn == first) {
            return "";
        }
        double keyLevel = input[keyColumn][row];
        if (Double.isNaN(keyLevel)) {
            keyLevel = this.getLastObs(keyColumn, row, input, first);
        }
        if (Double.isNaN(keyLevel)) {
            String colName = (String)this.m_columnNames.get(column);
            String keyName = (String)this.m_columnNames.get(keyColumn);
            this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_noLast1") + colName + MinerApp.getText("MissingValuesEngineNode_msg_missing") + keyName);
            return "";
        }
        if (CNKProcJavaTransform.isStringNA(this.m_lastObsStr[column][(int)keyLevel])) {
            String colName = (String)this.m_columnNames.get(column);
            String idLevel = this.m_metaData.getCategoricalDataFieldLevel(keyColumn, (int)input[keyColumn][row]);
            this.printlnWarning(MinerApp.getText("MissingValuesEngineNode_msg_noLast1") + colName + MinerApp.getText("MissingValuesEngineNode_msg_first") + this.m_metaData.ordinalToName(keyColumn) + "=" + idLevel);
        }
        return this.m_lastObsStr[column][(int)keyLevel];
    }

    public void printlnWarning(String msg) {
        if (this.m_prevWarnings == null) {
            this.m_prevWarnings = new Vector();
        }
        if (msg != null && !this.m_prevWarnings.contains(msg)) {
            super.printlnWarning(msg);
            this.m_prevWarnings.add(msg);
        }
    }
}

