/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ClassificationNeuralNetworkNodeModel;
import com.insightful.miner.NeuralNetworkDialog;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;

public class RegressionNeuralNetworkNodeModel
extends PredictableNodeModel {
    public void showPropertiesDialog(boolean modality) {
        NeuralNetworkDialog dialog = NeuralNetworkDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, 0);
    }

    public String getModelOutputType() {
        return "regression";
    }

    public String getModelAlgorithm() {
        return "NNet";
    }

    public boolean isPropertiesValid() {
        String role;
        int i;
        boolean indepValid = false;
        boolean depValid = false;
        XTProps props = this.getXTProps();
        Vector roleVec = props.getSubPropertyValues("columnRoles");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                Vector columns = props.getSubProperties("columnRoles");
                for (i = columns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)columns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i2 = 0; !(depValid && indepValid || i2 >= roleVec.size()); ++i2) {
            role = (String)roleVec.get(i2);
            if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) {
                depValid = true;
            }
            if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
            indepValid = true;
        }
        if (this.getState() != null && this.isInputValid()) {
            try {
                XTMetaData md = this.getInputMetaData(0);
                if (md != null) {
                    roleVec = md.getColumnRoles();
                    for (i = 0; !(depValid && indepValid || i >= roleVec.size()); ++i) {
                        role = (String)roleVec.get(i);
                        if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role) && md.isContinuousColumn(i)) {
                            depValid = true;
                        }
                        if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
                        indepValid = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return indepValid && depValid;
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                String htmlString = xt.getHtmlString(XMLTree.NEURAL_NETWORK_XSL_FILE, this.getLabelText());
                boolean isRegression = this.getModelOutputType().equals("regression");
                ClassificationNeuralNetworkNodeModel.showNeuralNetViewer(htmlString, this, isRegression);
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

