/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SplusScriptDialog;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SplusPredictableDialog
extends SplusScriptDialog {
    private static SplusPredictableDialog instance = null;
    private JTextArea predictTextArea;
    private JComboBox modelOutputTypeComboBox;
    private static final String[] MODEL_OUTPUT_TYPES = new String[]{"regression", "classification", "cluster", "dimensionReduction", "survival"};

    public static SplusScriptDialog getInstance() {
        if (instance == null) {
            instance = new SplusPredictableDialog();
        }
        return instance;
    }

    private SplusPredictableDialog() {
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.predictTextArea.setText(props.getValue("predictScript"));
        this.predictTextArea.setCaretPosition(0);
        this.modelOutputTypeComboBox.setSelectedItem(props.getValue("modelOutputType"));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set("predictScript", this.predictTextArea.getText());
        props.set("modelOutputType", this.modelOutputTypeComboBox.getSelectedItem().toString());
    }

    public Vector createOtherTabs() {
        Vector vec = super.createOtherTabs();
        vec.add(this.getPredictTab());
        return vec;
    }

    private JPanel getPredictTab() {
        this.predictTextArea = new JTextArea();
        JPanel predictScriptTab = this.getScriptPanel(this.predictTextArea);
        predictScriptTab.setName(MinerApp.getText("SplusPredictableDialog_predictTabLabel"));
        JPanel modelOutputTypePanel = new JPanel(new GridBagLayout());
        modelOutputTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusPredictableDialog_modelOutputTypePanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel modelOutputTypeLabel = new JLabel(MinerApp.getText("SplusPredictableDialog_modelOutputType"));
        this.modelOutputTypeComboBox = new JComboBox<String>(MODEL_OUTPUT_TYPES);
        this.modelOutputTypeComboBox.setEditable(false);
        Insets indent = new Insets(0, 15, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        modelOutputTypePanel.add((Component)modelOutputTypeLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = indent;
        modelOutputTypePanel.add((Component)this.modelOutputTypeComboBox, constraints);
        predictScriptTab.add((Component)modelOutputTypePanel, "South");
        return predictScriptTab;
    }
}

