/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeCreated;
import com.insightful.miner.ActivityNodeLinked;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.GlobalObjectCache;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.TwoDimChartDialog;
import com.insightful.miner.TwoDimChartEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;

public class TwoDimChartNodeModel
extends ActivityNodeModel {
    public TwoDimChartNodeModel(Element elt) {
        super(elt);
    }

    public TwoDimChartNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        this.showPropertiesDialog(modality, false);
    }

    public void showPropertiesDialog(boolean modality, boolean launchedFromTableView) {
        if (MinerApp.isSplusLicensed()) {
            TwoDimChartDialog dlg = TwoDimChartDialog.getInstance();
            if (launchedFromTableView) {
                dlg.getAddButton().setVisible(true);
                dlg.getOKButton().setVisible(false);
                dlg.getCancelButton().setText(MinerApp.getText("NodeDialog_close"));
                dlg.setDeleteOnClose(this);
                dlg.getRootPane().setDefaultButton(dlg.getApplyButton());
            } else {
                dlg.getAddButton().setVisible(false);
                dlg.getOKButton().setVisible(true);
                dlg.getCancelButton().setText(MinerApp.getText("NodeDialog_cancel"));
                dlg.getRootPane().setDefaultButton(dlg.getOKButton());
            }
            dlg.getApplyButton().setVisible(true);
            dlg.setModal(modality);
            dlg.show(this);
        } else {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), "S-PLUS is not available.  Cannot display Properties dialog.", "S-PLUS Not Available", 0);
        }
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        return oldProps.equals(newProps);
    }

    public boolean isPropertiesValid() {
        if (!MinerApp.isSplusLicensed()) {
            return false;
        }
        XTProps props = this.getXTProps();
        Vector xColumns = props.getSubProperties(TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG);
        Vector yColumns = props.getSubProperties(TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG);
        try {
            if (this.isInputValid()) {
                int i;
                XTMetaData md = this.getInputMetaData(0);
                for (i = xColumns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)xColumns.get(i)) != -1) continue;
                    return false;
                }
                for (i = yColumns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)yColumns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return xColumns.size() != 0 && yColumns.size() != 0;
    }

    public void showView(Frame frame) throws OutOfMemoryError {
        Object[] data;
        if (!MinerApp.isSplusLicensed()) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("TwoDimChartNodeModel_msg_splusComponentsNotInstalled"), MinerApp.getText("TwoDimChartNodeModel_msg_viewerNotAvailable"), 0);
            return;
        }
        XTProps dialogProps = this.getXTProps();
        XTMetaData metaData = null;
        XTProps chartStats = null;
        try {
            metaData = this.getInputMetaData(0);
            Object obj = this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{TwoDimChartEngineNode.BIN_COUNT_CACHE_FILENAME});
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            if (obj instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)obj;
            }
            chartStats = (XTProps)obj;
        }
        catch (Exception e) {
            Throwable obj = e.getCause();
            if (obj instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)obj;
            }
            return;
        }
        if (dialogProps.getBoolean(TwoDimChartEngineNode.HEX_BIN_ATTRIBUTE_TAG, true)) {
            data = TwoDimChartNodeModel.getHexBinDataFrame(dialogProps, metaData, chartStats);
            if (data != null) {
                String key = GlobalObjectCache.put(data);
                MinerFrame.setNextSplusGraphTitle(this.getLabelText());
                MinerApp.eval("bd.internal.miner.chart2d.hexbin(\"" + key + "\")");
            }
        } else {
            data = this.getScatterDataFrame(dialogProps, metaData, chartStats);
            if (data != null) {
                String key = GlobalObjectCache.put(data);
                MinerFrame.setNextSplusGraphTitle(this.getLabelText());
                MinerApp.eval("bd.internal.miner.chart2d.xyplot(\"" + key + "\")");
            }
        }
    }

    public static Object[] getHexBinDataFrame(XTProps dialogProps, XTMetaData metaData, XTProps chartStats) {
        Vector xColumns = TwoDimChartNodeModel.getSubProperties(dialogProps, metaData, TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG);
        Vector yColumns = TwoDimChartNodeModel.getSubProperties(dialogProps, metaData, TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG);
        if (xColumns.size() == 0 || yColumns.size() == 0) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("TwoDimChartNodeModel_msg_chartRequiresValidXY"));
            return null;
        }
        double shape = dialogProps.getDouble(TwoDimChartEngineNode.SHAPE_ATTRIBUTE_TAG, 1.0);
        int xBins = dialogProps.getInt(TwoDimChartEngineNode.X_BINS_ATTRIBUTE_TAG, 30);
        int numXCols = xColumns.size();
        int numYCols = yColumns.size();
        int numCharts = numXCols * numYCols;
        Object[] chartData = new Object[6];
        chartData[0] = new String[]{dialogProps.getValue(TwoDimChartEngineNode.STYLE_ATTRIBUTE_TAG, TwoDimChartEngineNode.GRAYSCALE_ATTRIBUTE_TAG)};
        chartData[1] = new Object[3];
        ((Object[])chartData[1])[0] = new String[numCharts];
        ((Object[])chartData[1])[1] = new double[numCharts];
        ((Object[])chartData[1])[2] = new double[numCharts];
        chartData[2] = new Object[3];
        ((Object[])chartData[2])[0] = new String[numCharts];
        ((Object[])chartData[2])[1] = new double[numCharts];
        ((Object[])chartData[2])[2] = new double[numCharts];
        int curChart = 0;
        for (int x = 0; x < numXCols; ++x) {
            String xCol = (String)xColumns.get(x);
            for (int y = 0; y < numYCols; ++y) {
                String yCol;
                ((String[])((Object[])chartData[1])[0])[curChart] = xCol;
                ((double[])((Object[])chartData[1])[1])[curChart] = metaData.getColumnMin(xCol);
                ((double[])((Object[])chartData[1])[2])[curChart] = metaData.getColumnMax(xCol);
                ((String[])((Object[])chartData[2])[0])[curChart] = yCol = (String)yColumns.get(y);
                ((double[])((Object[])chartData[2])[1])[curChart] = metaData.getColumnMin(yCol);
                ((double[])((Object[])chartData[2])[2])[curChart] = metaData.getColumnMax(yCol);
                ++curChart;
            }
        }
        chartData[3] = new double[]{shape};
        chartData[4] = new double[]{xBins};
        chartData[5] = new Object[numCharts][5];
        String[] numBinsPath = new String[]{TwoDimChartEngineNode.CHARTS_ATTRIBUTE_TAG, ""};
        String[] path = new String[]{TwoDimChartEngineNode.CHARTS_ATTRIBUTE_TAG, "", "", ""};
        int iMax = chartStats.getInt(TwoDimChartEngineNode.I_MAX_ATTRIBUTE_TAG, 30);
        int jMax = chartStats.getInt(TwoDimChartEngineNode.J_MAX_ATTRIBUTE_TAG, 30);
        for (int chart = 0; chart < numCharts; ++chart) {
            ((Object[])((Object[])chartData[5])[chart])[0] = new int[]{iMax, jMax};
            numBinsPath[1] = Integer.toString(chart);
            path[1] = numBinsPath[1];
            int numBins = chartStats.getInt(numBinsPath, 0);
            ((Object[])((Object[])chartData[5])[chart])[1] = new int[numBins];
            ((Object[])((Object[])chartData[5])[chart])[2] = new long[numBins];
            ((Object[])((Object[])chartData[5])[chart])[3] = new double[numBins];
            ((Object[])((Object[])chartData[5])[chart])[4] = new double[numBins];
            for (int bin = 0; bin < numBins; ++bin) {
                path[3] = Integer.toString(bin);
                path[2] = TwoDimChartEngineNode.MAPPING_ATTRIBUTE_TAG;
                ((int[])((Object[])((Object[])chartData[5])[chart])[1])[bin] = chartStats.getInt(path, 0);
                path[2] = TwoDimChartEngineNode.COUNTS_ATTRIBUTE_TAG;
                ((long[])((Object[])((Object[])chartData[5])[chart])[2])[bin] = Long.parseLong(chartStats.getValue(path, "0"));
                path[2] = TwoDimChartEngineNode.X_CENTERS_ATTRIBUTE_TAG;
                ((double[])((Object[])((Object[])chartData[5])[chart])[3])[bin] = chartStats.getDouble(path, 0.0);
                path[2] = TwoDimChartEngineNode.Y_CENTERS_ATTRIBUTE_TAG;
                ((double[])((Object[])((Object[])chartData[5])[chart])[4])[bin] = chartStats.getDouble(path, 0.0);
            }
        }
        return chartData;
    }

    public Object[] getScatterDataFrame(XTProps dialogProps, XTMetaData metaData, XTProps chartStats) {
        Vector xColumns = TwoDimChartNodeModel.getSubProperties(dialogProps, metaData, TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG);
        Vector yColumns = TwoDimChartNodeModel.getSubProperties(dialogProps, metaData, TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG);
        if (xColumns.size() == 0 || yColumns.size() == 0) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("TwoDimChartNodeModel_msg_chartRequriesValidXandY"));
            return null;
        }
        int numXCols = xColumns.size();
        int numYCols = yColumns.size();
        int numCharts = numXCols * numYCols;
        Object[] chartData = new Object[3];
        chartData[0] = new Object[3];
        ((Object[])chartData[0])[0] = new String[numCharts];
        ((Object[])chartData[0])[1] = new double[numCharts];
        ((Object[])chartData[0])[2] = new double[numCharts];
        chartData[1] = new Object[3];
        ((Object[])chartData[1])[0] = new String[numCharts];
        ((Object[])chartData[1])[1] = new double[numCharts];
        ((Object[])chartData[1])[2] = new double[numCharts];
        int curChart = 0;
        for (int x = 0; x < numXCols; ++x) {
            String xCol = (String)xColumns.get(x);
            for (int y = 0; y < numYCols; ++y) {
                String yCol;
                ((String[])((Object[])chartData[0])[0])[curChart] = xCol;
                ((double[])((Object[])chartData[0])[1])[curChart] = metaData.getColumnMin(xCol);
                ((double[])((Object[])chartData[0])[2])[curChart] = metaData.getColumnMax(xCol);
                ((String[])((Object[])chartData[1])[0])[curChart] = yCol = (String)yColumns.get(y);
                ((double[])((Object[])chartData[1])[1])[curChart] = metaData.getColumnMin(yCol);
                ((double[])((Object[])chartData[1])[2])[curChart] = metaData.getColumnMax(yCol);
                ++curChart;
            }
        }
        chartData[2] = new Object[numCharts][2];
        String[] path = new String[]{TwoDimChartEngineNode.CHARTS_ATTRIBUTE_TAG, "", ""};
        int numBins = chartStats.getInt(TwoDimChartEngineNode.CHARTS_ATTRIBUTE_TAG, 0);
        block4: for (int chart = 0; chart < numCharts; ++chart) {
            path[1] = Integer.toString(chart);
            ((Object[])((Object[])chartData[2])[chart])[0] = new double[numBins];
            ((Object[])((Object[])chartData[2])[chart])[1] = new double[numBins];
            path[2] = TwoDimChartEngineNode.X_ATTRIBUTE_TAG;
            String xVals = chartStats.getValue(path, "");
            path[2] = TwoDimChartEngineNode.Y_ATTRIBUTE_TAG;
            String yVals = chartStats.getValue(path, "");
            StringTokenizer xTokenizer = new StringTokenizer(xVals, " ");
            StringTokenizer yTokenizer = new StringTokenizer(yVals, " ");
            int pair = 0;
            while (xTokenizer.hasMoreTokens()) {
                try {
                    ((double[])((Object[])((Object[])chartData[2])[chart])[0])[pair] = Double.parseDouble(xTokenizer.nextToken());
                    ((double[])((Object[])((Object[])chartData[2])[chart])[1])[pair] = Double.parseDouble(yTokenizer.nextToken());
                }
                catch (Exception e) {
                    continue block4;
                }
                ++pair;
            }
        }
        return chartData;
    }

    public static Vector getSubProperties(XTProps props, XTMetaData metaData, String name) {
        Vector ret = props.getSubProperties(name);
        for (int i = ret.size() - 1; i >= 0; --i) {
            if (metaData.isContinuousColumn((String)ret.get(i))) continue;
            ret.remove(i);
        }
        return ret;
    }

    protected void setState(ActivityNodeState state) {
        if (!MinerApp.isSplusLicensed() && !state.equals(ActivityNodeCreated.instance())) {
            state = ActivityNodeLinked.instance();
        }
        super.setState(state);
    }
}

