/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.XTProps;
import com.insightful.splus.util.XMLTransformUtilities;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLTree
implements Cloneable,
Serializable {
    protected static String m_cssString = null;
    protected Document m_document = null;
    protected Element m_xml = null;
    private static final boolean m_cacheXslTransformer = System.getProperty("iminer.cache.xsl.transformer", "T").substring(0, 1).toUpperCase().equals("T");
    public static String IMML_NODE_TAG = "IMML";
    public static String DISPLAY_OPTIONS_NODE_TAG = "DisplayOptions";
    public static String CSS_TEXT_NODE_TAG = "CSSText";
    public static String TITLE_ATTRIBUTE_TAG = "title";
    public static String DECIMAL_PATTERN_ATTRIBUTE_TAG = "decimalPattern";
    public static String SCIENTIFIC_PATTERN_ATTRIBUTE_TAG = "scientificPattern";
    public static String CSS_ATTRIBUTE_TAG = "css";
    public static String IMML_VERSION_ATTRIBUTE_TAG = "version";
    public static String CURRENT_VERSION_ATTRIBUTE_TAG = "8.0";
    public static String HEADER_NODE_TAG = "Header";
    public static String HEADER_NAME_ATTRIBUTE_TAG = "name";
    public static String HEADER_COPYRIGHT_ATTRIBUTE_TAG = "copyright";
    public static String HEADER_DESCRIPTION_ATTRIBUTE_TAG = "description";
    public static String APPLICATION_NODE_TAG = "Application";
    public static String APPLICATION_VERSION_ATTRIBUTE_TAG = "version";
    public static String APPLICATION_NAME_ATTRIBUTE_TAG = "name";
    public static String TIMESTAMP_NODE_TAG = "Timestamp";
    public static final String XSL_DIRECTORY = new File(System.getProperty("sprime.home") + (MinerApp.isInBDL() ? "/xml/" : "/splus/library/bigdata/xml/")).getAbsolutePath() + File.separator;
    public static final String META_DATA_XSL_FILE = XSL_DIRECTORY + "XTMetaData.xsl";
    public static final String TREE_XSL_FILE = XSL_DIRECTORY + "Tree.xsl";
    public static final String CSS_FILE = XSL_DIRECTORY + "InsightfulMiner.css";
    public static final String GENERAL_REGRESSION_XSL_FILE = XSL_DIRECTORY + "GeneralRegressionModel.xsl";
    public static final String CLUSTER_XSL_FILE = XSL_DIRECTORY + "cluster.xsl";
    public static final String NEURAL_NETWORK_XSL_FILE = XSL_DIRECTORY + "NeuralNetwork.xsl";
    public static final String PRINCIPLE_COMPONENTS_XSL_FILE = XSL_DIRECTORY + "PrincipalComponents.xsl";
    public static final String SURVIVAL_XSL_FILE = XSL_DIRECTORY + "SurvivalModel.xsl";
    public static final String META_DATA_XSL_FO_FILE = XSL_DIRECTORY + "XTMetaData_FO.xsl";
    public static final String TREE_XSL_FO_FILE = XSL_DIRECTORY + "Tree_FO.xsl";
    public static final String NAIVE_BAYES_XSL_FO_FILE = XSL_DIRECTORY + "NaiveBayes_FO.xsl";
    public static final String GENERAL_REGRESSION_XSL_FO_FILE = XSL_DIRECTORY + "GeneralRegressionModel_FO.xsl";
    public static final String CLUSTER_XSL_FO_FILE = XSL_DIRECTORY + "cluster_FO.xsl";
    public static final String NEURAL_NETWORK_XSL_FO_FILE = XSL_DIRECTORY + "NeuralNetwork_FO.xsl";
    public static final String PRINCIPLE_COMPONENTS_XSL_FO_FILE = XSL_DIRECTORY + "PrincipalComponents_FO.xsl";
    public static final String SURVIVAL_XSL_FO_FILE = XSL_DIRECTORY + "SurvivalModel_FO.xsl";
    public static final String IMML_TO_PMML_XSL_FILE = XSL_DIRECTORY + "IMML_to_PMML.xsl";
    public static final String PMML_TO_IMML_XSL_FILE = XSL_DIRECTORY + "PMML_to_IMML.xsl";
    public static final String PMML_DATA_DICTIONARY_XSL_FILE = XSL_DIRECTORY + "PMML_DataDictionary.xsl";
    protected static HashMap xslTransformerMap;
    protected static TransformerFactory transformerFactory;

    public XMLTree() throws Exception {
        this.m_document = XMLTransformUtilities.getBuilder().newDocument();
        this.m_xml = this.m_document.createElement(IMML_NODE_TAG);
        this.m_xml.setAttribute(IMML_VERSION_ATTRIBUTE_TAG, CURRENT_VERSION_ATTRIBUTE_TAG);
        this.m_document.appendChild(this.m_xml);
    }

    public XMLTree(Element elt) throws Exception {
        this.m_xml = elt;
        this.m_document = elt.getOwnerDocument();
    }

    public XMLTree(XMLTree tree) throws Exception {
        this.m_document = XMLTransformUtilities.getBuilder().newDocument();
        if (!tree.m_xml.getNodeName().equals(IMML_NODE_TAG)) {
            this.m_xml = this.m_document.createElement(IMML_NODE_TAG);
            this.m_xml.setAttribute(IMML_VERSION_ATTRIBUTE_TAG, CURRENT_VERSION_ATTRIBUTE_TAG);
            this.m_document.appendChild(this.m_xml);
            Element element = (Element)this.m_document.importNode(tree.m_xml, true);
            this.m_xml.appendChild(element);
        } else {
            this.m_xml = (Element)this.m_document.importNode(tree.m_xml, true);
            this.m_document.appendChild(this.m_xml);
        }
    }

    public Element getXML() {
        return this.m_xml;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public String getVersion() {
        return this.m_xml.getAttribute(IMML_VERSION_ATTRIBUTE_TAG);
    }

    public boolean isIMMLTagPresent() {
        return this.m_xml.getNodeName().equals(IMML_NODE_TAG);
    }

    public XMLTree copy() {
        try {
            return new XMLTree(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object clone() {
        return this.copy();
    }

    public static void test() {
    }

    public void appendCopyToElement(Element copyTo) {
        Document copyDocument = copyTo.getOwnerDocument();
        Element firstLevelCopy = copyDocument.createElement(this.m_xml.getNodeName());
        NamedNodeMap attributes = this.m_xml.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node attribute = attributes.item(i);
            firstLevelCopy.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        this.recursiveCopy(this.m_xml, firstLevelCopy, copyDocument);
        copyTo.appendChild(firstLevelCopy);
    }

    protected void recursiveCopy(Element copyFrom, Element copyTo, Document copyDocument) {
        NodeList nodeList = copyFrom.getChildNodes();
        int nodeListLength = nodeList.getLength();
        for (int i = 0; i < nodeListLength; ++i) {
            Element thisLevelOrig = (Element)nodeList.item(i);
            Element thisLevelCopy = copyDocument.createElement(thisLevelOrig.getNodeName());
            NamedNodeMap attributes = thisLevelOrig.getAttributes();
            int length = attributes.getLength();
            for (int j = 0; j < length; ++j) {
                Node attribute = attributes.item(j);
                thisLevelCopy.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
            this.recursiveCopy(thisLevelOrig, thisLevelCopy, copyDocument);
            copyTo.appendChild(thisLevelCopy);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof XMLTree) {
            return this.equals((XMLTree)obj);
        }
        return false;
    }

    public boolean equals(XMLTree tree) {
        if (this.m_xml.equals(tree.m_xml)) {
            return true;
        }
        Element thisFirst = null;
        Element treeFirst = null;
        thisFirst = this.m_xml.getNodeName().equals(IMML_NODE_TAG) ? (Element)this.m_xml.getFirstChild() : this.m_xml;
        treeFirst = tree.m_xml.getNodeName().equals(IMML_NODE_TAG) ? (Element)tree.m_xml.getFirstChild() : tree.m_xml;
        return XMLTree.recursiveEqualityTest(thisFirst, treeFirst);
    }

    public static String getCSSText() {
        if (m_cssString == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                String str;
                FileInputStream ins = new FileInputStream(CSS_FILE);
                BufferedReader dis = new BufferedReader(new InputStreamReader(ins));
                while ((str = dis.readLine()) != null) {
                    buffer.append(str);
                }
                dis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            m_cssString = buffer.toString();
        }
        return m_cssString;
    }

    public OutputStream getHtmlOutputStream(String xslFilename, String title) {
        return this.getHtmlOutputStream(xslFilename, title, true);
    }

    public OutputStream getHtmlOutputStream(String xslFilename, String title, boolean bCSS) {
        Element displayOptions = this.m_document.createElement(DISPLAY_OPTIONS_NODE_TAG);
        if (!title.equals("")) {
            displayOptions.setAttribute(TITLE_ATTRIBUTE_TAG, title);
        }
        displayOptions.setAttribute(DECIMAL_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerRoundingPattern());
        displayOptions.setAttribute(SCIENTIFIC_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerScientificRoundingPattern());
        this.m_xml.appendChild(displayOptions);
        Element cssOptions = null;
        if (bCSS) {
            cssOptions = this.m_document.createElement(CSS_TEXT_NODE_TAG);
            Text textChild = this.m_document.createTextNode(XMLTree.getCSSText());
            cssOptions.appendChild(textChild);
            this.m_xml.appendChild(cssOptions);
        }
        ByteArrayOutputStream htmlByteStream = new ByteArrayOutputStream();
        try {
            this.applyXSLTransform(htmlByteStream, xslFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            htmlByteStream = null;
        }
        this.m_xml.removeChild(displayOptions);
        if (cssOptions != null) {
            this.m_xml.removeChild(cssOptions);
        }
        return htmlByteStream;
    }

    public String getHtmlString(String xslFilename, String title) {
        try {
            ByteArrayOutputStream tmp = (ByteArrayOutputStream)this.getHtmlOutputStream(xslFilename, title);
            return tmp.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHtmlStringNoCSS(String xslFilename, String title) {
        try {
            ByteArrayOutputStream tmp = (ByteArrayOutputStream)this.getHtmlOutputStream(xslFilename, title, false);
            return tmp.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHtmlString(String xslFilename) {
        try {
            ByteArrayOutputStream tmp = (ByteArrayOutputStream)this.getHtmlOutputStream(xslFilename, "");
            return tmp.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void applyXSLTransform(OutputStream outStr, String xslFilename) {
        try {
            DOMSource xmlSource = new DOMSource(this.m_xml);
            StreamResult strResult = new StreamResult(outStr);
            Transformer xslTransformer = null;
            if (xslTransformerMap == null) {
                xslTransformerMap = new HashMap();
                transformerFactory = TransformerFactory.newInstance();
            } else {
                xslTransformer = (Transformer)xslTransformerMap.get(xslFilename);
            }
            if (xslTransformer == null) {
                xslTransformer = XMLTransformUtilities.createTransformer((String)xslFilename);
                if (m_cacheXslTransformer) {
                    xslTransformerMap.put(xslFilename, xslTransformer);
                }
            }
            xslTransformer.transform(xmlSource, strResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(String filename) {
        try {
            FileOutputStream outs = new FileOutputStream(filename);
            this.saveToFile(outs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(OutputStream out) {
        try {
            Class<?> outputFormatClass = null;
            Class<?> xmlFormatterClass = null;
            try {
                outputFormatClass = Class.forName("com.sun.org.apache.xml.internal.serialize.OutputFormat");
                xmlFormatterClass = Class.forName("com.sun.org.apache.xml.internal.serialize.XMLSerializer");
            }
            catch (ClassNotFoundException e) {
                outputFormatClass = Class.forName("org.apache.xml.serialize.OutputFormat");
                xmlFormatterClass = Class.forName("org.apache.xml.serialize.XMLSerializer");
            }
            Object of = outputFormatClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            outputFormatClass.getMethod("setEncoding", String.class).invoke(of, "UTF-8");
            outputFormatClass.getMethod("setIndenting", Boolean.TYPE).invoke(of, new Boolean(true));
            outputFormatClass.getMethod("setOmitXMLDeclaration", Boolean.TYPE).invoke(of, new Boolean(false));
            outputFormatClass.getMethod("setPreserveSpace", Boolean.TYPE).invoke(of, new Boolean(true));
            Document xmldoc = null;
            if (this.m_xml == this.m_document.getFirstChild()) {
                xmldoc = this.m_document;
            } else {
                xmldoc = XMLTransformUtilities.getBuilder().newDocument();
                Element xmlNode = (Element)this.m_xml.cloneNode(true);
                xmldoc.appendChild(xmldoc.importNode(xmlNode, true));
            }
            Object slz = xmlFormatterClass.getConstructor(OutputStream.class, outputFormatClass).newInstance(out, of);
            xmlFormatterClass.getMethod("serialize", Document.class).invoke(slz, xmldoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String writeToString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.saveToFile(out);
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XMLTree readFromFile(String filename) throws Exception {
        try {
            FileInputStream ins = new FileInputStream(filename);
            return XMLTree.readFromFile(ins);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("error reading XML file " + filename + ": " + ex);
        }
    }

    public static XMLTree readFromFile(InputStream ins) throws Exception {
        try {
            Element element = null;
            NodeList children = XMLTransformUtilities.getBuilder().parse(ins).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                break;
            }
            XMLTree tree = new XMLTree(element);
            XMLTree.recursiveFormattingWhitespaceRemoval(tree.m_xml);
            System.gc();
            return tree;
        }
        catch (OutOfMemoryError ex) {
            ex.printStackTrace();
            throw new Exception("out of memory while reading XML stream");
        }
    }

    public static XMLTree readFromString(String xmlString) {
        try {
            if (xmlString == null) {
                return null;
            }
            byte[] xmlBytes = xmlString.getBytes("UTF-8");
            ByteArrayInputStream ins = new ByteArrayInputStream(xmlBytes);
            XMLTree tree = XMLTree.readFromFile(ins);
            return tree;
        }
        catch (Exception e) {
            System.out.println("Error reading XML from string: " + e);
            return null;
        }
    }

    public static void recursiveFormattingWhitespaceRemoval(Element elt) {
        XMLTree.nrFormattingWhitespaceRemoval(elt);
    }

    public static void nrFormattingWhitespaceRemoval(Element elt) {
        Vector<Node> nodeList = new Vector<Node>();
        nodeList.add(elt);
        while (nodeList.size() != 0) {
            Node node = (Node)nodeList.get(0);
            NodeList list = node.getChildNodes();
            for (int i = list.getLength() - 1; i >= 0; --i) {
                Node child = list.item(i);
                if (child.getNodeType() == 3) {
                    String str;
                    if (node.getNodeName().equals(XTProps.COMPLEX_NODE_TAG) || !(str = child.getNodeValue().trim()).equals("")) continue;
                    node.removeChild(child);
                    continue;
                }
                nodeList.add(child);
            }
            nodeList.remove(0);
        }
    }

    public static void rFormattingWhitespaceRemoval(Element elt) {
        NodeList list = elt.getChildNodes();
        for (int i = list.getLength() - 1; i >= 0; --i) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) {
                String str;
                if (elt.getNodeName().equals(XTProps.COMPLEX_NODE_TAG) || !(str = node.getNodeValue().trim()).equals("")) continue;
                elt.removeChild(node);
                continue;
            }
            XMLTree.rFormattingWhitespaceRemoval((Element)node);
        }
    }

    protected static boolean recursiveEqualityTest(Node left, Node right) {
        return XMLTree.nrEqualityTest(left, right);
    }

    protected static boolean rEqualityTest(Node left, Node right) {
        try {
            int rightListCount;
            if (!XMLTree.areNodesEqual(left, right)) {
                return false;
            }
            NodeList leftList = left.getChildNodes();
            NodeList rightList = right.getChildNodes();
            int leftListCount = leftList.getLength();
            if (leftListCount != (rightListCount = rightList.getLength())) {
                return false;
            }
            for (int i = 0; i < leftListCount; ++i) {
                Node leftChild = leftList.item(i);
                Node rightChild = rightList.item(i);
                if (rightChild == null) {
                    return false;
                }
                if (XMLTree.recursiveEqualityTest(leftChild, rightChild)) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static boolean nrEqualityTest(Node leftNode, Node rightNode) {
        Vector<Node> rightNodeList = new Vector<Node>();
        Vector<Node> leftNodeList = new Vector<Node>();
        rightNodeList.add(rightNode);
        leftNodeList.add(leftNode);
        while (rightNodeList.size() > 0) {
            int rightListCount;
            Node right = (Node)rightNodeList.get(0);
            Node left = (Node)leftNodeList.get(0);
            if (!XMLTree.areNodesEqual(left, right)) {
                return false;
            }
            NodeList leftList = left.getChildNodes();
            NodeList rightList = right.getChildNodes();
            int leftListCount = leftList.getLength();
            if (leftListCount != (rightListCount = rightList.getLength())) {
                return false;
            }
            for (int i = 0; i < leftListCount; ++i) {
                Node leftChild = leftList.item(i);
                Node rightChild = rightList.item(i);
                if (rightChild == null) {
                    return false;
                }
                rightNodeList.add(rightChild);
                leftNodeList.add(leftChild);
            }
            rightNodeList.remove(0);
            leftNodeList.remove(0);
        }
        return true;
    }

    protected static boolean areNodesEqual(Node left, Node right) {
        String leftString = null;
        String rightString = null;
        leftString = left.getNodeName();
        if (leftString != (rightString = right.getNodeName()) && !leftString.equals(rightString)) {
            return false;
        }
        leftString = left.getNodeValue();
        if (leftString != (rightString = right.getNodeValue()) && !leftString.equals(rightString)) {
            return false;
        }
        NamedNodeMap leftAttributes = left.getAttributes();
        NamedNodeMap rightAttributes = right.getAttributes();
        if (leftAttributes == null || rightAttributes == null) {
            return leftAttributes == rightAttributes;
        }
        int leftAttributeCount = leftAttributes.getLength();
        if (leftAttributeCount != rightAttributes.getLength()) {
            return false;
        }
        for (int i = 0; i < leftAttributeCount; ++i) {
            Node leftAttribute = leftAttributes.item(i);
            Node rightAttribute = rightAttributes.getNamedItem(leftAttribute.getNodeName());
            if (rightAttribute == null) {
                return false;
            }
            if (leftAttribute.getNodeValue().equals(rightAttribute.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.saveToFile(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.m_document = XMLTransformUtilities.getBuilder().parse(in);
            this.m_xml = (Element)this.m_document.getFirstChild();
            XMLTree.recursiveFormattingWhitespaceRemoval(this.m_xml);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            System.out.println("Error reading XML stream: " + e);
        }
    }

    public void transformWithFOP(OutputStream outs, String title, int outputType, String xslFilename) throws Exception {
        Element displayOptions = this.m_document.createElement(DISPLAY_OPTIONS_NODE_TAG);
        if (!title.equals("")) {
            displayOptions.setAttribute(TITLE_ATTRIBUTE_TAG, title);
        }
        displayOptions.setAttribute(DECIMAL_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerRoundingPattern());
        displayOptions.setAttribute(SCIENTIFIC_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerScientificRoundingPattern());
        this.m_xml.appendChild(displayOptions);
        try {
            StreamSource src = new StreamSource(new ByteArrayInputStream(this.writeToString().getBytes("UTF-8")));
            XMLTransformUtilities.transformWithFOP((Source)src, (String)xslFilename, (OutputStream)outs);
            this.m_xml.removeChild(displayOptions);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void transformWithJFOR(OutputStream outs, String title, String xslFilename) throws Exception {
        Element displayOptions = this.m_document.createElement(DISPLAY_OPTIONS_NODE_TAG);
        if (!title.equals("")) {
            displayOptions.setAttribute(TITLE_ATTRIBUTE_TAG, title);
        }
        displayOptions.setAttribute(DECIMAL_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerRoundingPattern());
        displayOptions.setAttribute(SCIENTIFIC_PATTERN_ATTRIBUTE_TAG, MinerApp.getWorksheetPropertiesManager().getViewerScientificRoundingPattern());
        this.m_xml.appendChild(displayOptions);
        try {
            StreamSource src = new StreamSource(new ByteArrayInputStream(this.writeToString().getBytes("UTF-8")));
            OutputStreamWriter output = new OutputStreamWriter(outs);
            XMLTransformUtilities.transformWithJFOR((Source)src, (String)xslFilename, (Writer)output, (int)2);
            this.m_xml.removeChild(displayOptions);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

