/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql.lib;

public class ArrayCounter {
    public static int[] countSegments(int[] array, int segments, int start, int limit) {
        int[] counts = new int[segments];
        long interval = ArrayCounter.calcInterval(segments, start, limit);
        int index = 0;
        int element = 0;
        if (interval <= 0L) {
            return counts;
        }
        for (int i = 0; i < array.length; ++i) {
            element = array[i];
            if (element < start || element >= limit) continue;
            int n = index = (int)((long)(element - start) / interval);
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public static int rank(int[] array, int target, int start, int limit, int margin) {
        int segments = 256;
        int elementCount = 0;
        int currentLimit = limit;
        while (true) {
            long interval = ArrayCounter.calcInterval(256, start, currentLimit);
            int[] counts = ArrayCounter.countSegments(array, 256, start, currentLimit);
            for (int i = 0; i < counts.length && elementCount + counts[i] < target; ++i) {
                elementCount += counts[i];
                start = (int)((long)start + interval);
            }
            if (elementCount + margin >= target) {
                return start;
            }
            if (interval <= 1L) {
                return start;
            }
            currentLimit = (long)start + interval < (long)limit ? (int)((long)start + interval) : limit;
        }
    }

    static long calcInterval(int segments, int start, int limit) {
        long range = limit - start;
        if (range < 0L) {
            return 0L;
        }
        int partSegment = range % (long)segments == 0L ? 0 : 1;
        return range / (long)segments + (long)partSegment;
    }
}

