/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ColorBroker {
    private static Hashtable colors = null;
    private static Color defaultColor = Color.black;
    boolean alreadyChecked = false;
    private static String filename = "ColorSettings.txt";
    private static String path = MinerApp.getSettingsDir();
    private static String filestring = path + "/" + filename;
    private static ColorBroker instance = ColorBroker.getInstance();

    public ColorBroker() {
        this.readSettings();
    }

    private void readSettings() {
        try {
            ColorBroker.readColorSettingsFile();
        }
        catch (Exception e) {
            try {
                ColorBroker.createDefaultColorSettingsFile();
                ColorBroker.readColorSettingsFile();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                AcceleratorOptionPane.showOKDialog(null, MinerApp.getText("ColorBroker_message_createColorSettings"), MinerApp.getText("ColorBroker_message_colorSettings"), 0);
            }
        }
    }

    public static ColorBroker getInstance() {
        if (instance == null) {
            instance = new ColorBroker();
        }
        return instance;
    }

    private static void readColorSettingsFile() throws Exception {
        FileReader fr = null;
        BufferedReader br = null;
        String line = "";
        try {
            fr = new FileReader(filestring);
        }
        catch (FileNotFoundException e) {
            throw new Exception("Can't find color settings file.");
        }
        br = new BufferedReader(fr, 4096);
        StringTokenizer st = null;
        String key = "";
        String val = "";
        colors = new Hashtable();
        String int1 = "";
        String int2 = "";
        String int3 = "";
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, " ");
                key = st.nextToken();
                if (key == null) {
                    throw new Exception("Syntax error in color settings file.");
                }
                if ("#".equals(key)) continue;
                val = st.nextToken();
                if (val == null) {
                    throw new Exception("Syntax error in color settings file.");
                }
                if ("(".equals(val)) {
                    int1 = st.nextToken();
                    int2 = st.nextToken();
                    int3 = st.nextToken();
                    colors.put(key, "( " + int1 + " " + int2 + " " + int3 + " )");
                    continue;
                }
                colors.put(key, val);
            }
        }
        catch (IOException e) {
            throw new Exception("Error reading color settings file");
        }
        try {
            br.close();
        }
        catch (IOException e) {
            throw new Exception("Error closing buffer");
        }
        fr.close();
    }

    public static void createDefaultColorSettingsFile() throws Exception {
        File file = new File(filestring);
        String comment = "# This is the color settings file for classification and \n# regression trees. Color settings can be customized by \n# replacing the appropriate color with a different color. \n# The following colors are supported, typed exactly as follows: \n# black, red, blue, yellow, cyan, magenta, darkGray, lightGray, gray,\n# green, pink, orange, and white. \n# \n# Any color can be made darker or lighter by adding \".darker\" or \".brighter\" . \n# For example, dark blue is: blue.darker \n# \n# Custom colors can be specified by specifying exact red, green, and blue \n# values as numbers between 0 and 255. For example: \n# white is: ( 255 255 255 ) \n# black is: ( 0 0 0 ) \n# blue is: ( 0 0 255 ) \n# red is: ( 255 0 0 ) \n# green is: ( 0 255 0 ) \n# Different shades can be created with different numbers. \n# For examples see: http://users.rcn.com/giant.interport//COLOR/1ColorSpecifier.html \n# Be sure to type in ONLY one of the following: \n#  -  a single color, like \"blue\" \n#  -  a single color with an extension, like \"blue.brighter\" \n#  -  exactly 3 color values in parentheses with white space before and after, like \"( 39 64 139 )\" \n# Any mistakes will result in an unusable file. If the tree visualizer is unable \n# to read in all the colors, you will be prompted to exit the program or \n# re-edit this file. \n";
        String text = "dendrogramBackgroundColor white\ndendrogramSelectedColor red\ntreeSelectionColor red\ntreeBackgroundSelectionColor ( 255 235 255 ) #light pink \ndendrogramLeafSelectionColor ( 255 235 255 )#light pink \ntreeBackgroundColor white\nexplanationColor ( 95 158 160 ) #cadet blue \njTreeShowLevelsColor ( 95 158 160 ) #cadet blue \nnodeDetailsColor ( 16 78 139 ) #bluish \nlegendBackgroundColor white \nlegendLabelsColor black\nlegendTextColor black\nregressionScoreColor blue\nsizeImageColor ( 50 50 50 ) #bluish \nscoreImageClass1 ( 255 128 0 ) #ochre \nscoreImageClass2 ( 0 64 128 ) #dark blue \nscoreImageClass3 ( 169 226 255 ) #light blue \nscoreImageClass4 ( 0 128 0 ) #forest green \nscoreImageClass5 ( 255 209 143 ) #gold \nscoreImageClass6 ( 192 0 0 ) #red \nscoreImageClass7 ( 255 255 195 ) #yellow \nscoreImageClass8 ( 110 110 100 ) #gray \nscoreImageClass9 ( 255 140 138 ) #light red \nscoreImageClass10 ( 128 64 0 ) #brown \nscoreImageClass11 ( 200 255 200 ) #light green \nscoreImageClass12 ( 0 128 255 ) #royal blue \nscoreImageClass13 ( 255 195 255 ) #light violet \nscoreImageClass14 ( 128 0 64 ) #deep red \nscoreImageClass15 ( 198 255 255 ) #light blue \nscoreImageClass16 ( 0 0 0 ) #black \ndefaultScoreImage ( 255 211 155 ) #beige \nchartSeries1 ( 0 128 255 ) #royal blue \nchartSeries2 ( 192 0 0 ) #red \nchartSeries3 ( 255 128 0 ) #ochre \nchartSeries4 ( 0 128 0 ) #forest green \nchartSeries5 ( 255 209 143  ) #gold \nchartSeries6 ( 0 64 128 ) #dark blue \nchartSeries7 ( 72 61 139 ) #purple \nchartSeries8 ( 169 226 255 ) #light blue \nchartSeries9 ( 160 82 45 ) #sienna \nchartSeries10 ( 110 110 100 ) #gray \nchartSeries11 ( 255 140 138 ) #light red \nchartSeries12 ( 128 64 0 ) #brown \nchartSeries13 ( 148 0 211 ) #dark violet \nchartSeries14 ( 128 0 64 ) #deep red \nchartSeries15 ( 255 20 147 ) #deep pink \nchartSeries16 ( 0 0 0 ) #black \nhistogramColor ( 0 64 128 ) #blue \nchartBackgroundColor ( 255 255 255 ) #white \nchartLabelBackgroundColor ( 252 244 225 ) #linen \nchartSelectionColor ( 124 252 0 ) #light green \nchartBorderColor ( 220 220 220 ) #light grey \nchartLabelConditionedByColor ( 140 110 90 ) #dark brown \nstatsTextColor ( 150 120 100 ) \nchartLabelBorderColor ( 222 184 135 ) #burlywood \nchartBoxplotOutlineColor ( 0 0 0 ) #black \nliftChartBackgroundColor ( 255 255 255 ) #white \nliftChartBorderColor ( 0 0 0 ) #black \nliftChartReferenceLineColor ( 180 180 180 ) #light grey \nliftChartMenuColor ( 252 244 225 ) #cornsilk \nliftChartUpdateColor ( 0 128 255 ) #blue \nliftChartLabelForegroundColor ( 140 110 90 ) #dark brown \nliftChartLabelBackgroundColor ( 252 244 225 ) #cornsilk \nneuralNetErrorGraphTrainingColor ( 0 128 255 ) #royal blue \nneuralNetErrorGraphTestColor ( 128 0 64 ) #deep red \nneuralNetworkRepresentationLineColor ( 110 110 100 ) #gray \nneuralNetworkRepresentationWeightBackgroundColor ( 252 244 225 ) #linen \nneuralNetworkRepresentationWeightColor black\nneuralNetworkRepresentationBiasNodeColor ( 90 226 255 ) #light blue \nneuralNetworkTextColor ( 95 158 160 ) #cadet blue \nneuralNetworkRepresentationColor blue\n";
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw, 4096);
            PrintWriter pw = new PrintWriter((Writer)bw, true);
            pw.write(comment + text);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("Error writing color settings file \"" + file.getAbsoluteFile() + "\"");
        }
    }

    public static Color getColor(String color) {
        Color result;
        block9: {
            String col = (String)colors.get(color);
            if (col == null) {
                return defaultColor;
            }
            StringTokenizer st = new StringTokenizer(col, " ");
            String val = st.nextToken();
            if ("(".equals(val)) {
                int redval = Integer.parseInt(st.nextToken());
                int greenval = Integer.parseInt(st.nextToken());
                int blueval = Integer.parseInt(st.nextToken());
                return new Color(redval, greenval, blueval);
            }
            StringTokenizer st2 = new StringTokenizer(val, ".");
            String colorfield = st2.nextToken();
            String changeColor = null;
            if (st2.countTokens() > 0) {
                changeColor = st2.nextToken();
            }
            result = null;
            try {
                result = (Color)Class.forName("java.awt.Color").getField(colorfield).get(null);
                if (changeColor == null) break block9;
                try {
                    Method m = Class.forName("java.awt.Color").getMethod(changeColor, new Class[0]);
                    result = (Color)m.invoke((Object)result, new Object[0]);
                }
                catch (Exception nsme) {
                    System.out.println("no such method: " + nsme.getMessage());
                    return defaultColor;
                }
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("color class not found: " + cnfe.getMessage());
                return defaultColor;
            }
            catch (NoSuchFieldException nsfe) {
                System.out.println("no such field: " + nsfe.getMessage());
                return defaultColor;
            }
            catch (IllegalAccessException iae) {
                System.out.println("illegal access: " + iae.getMessage());
                return defaultColor;
            }
        }
        return result;
    }

    public static Color getNeuralNetLegendColor(int index, int numBoxes, boolean leftToRight) {
        int increment = 255 / numBoxes;
        if (leftToRight) {
            return new Color(255, index * increment, 255);
        }
        return new Color((numBoxes - (index + 1)) * increment, 255, 255);
    }

    public static Color getNeuralNetLegendMiddleColor() {
        return new Color(235, 235, 255);
    }

    public static Color getNeuralNetLineColor(double weight, double maxval) {
        double percentColor = weight / maxval;
        if (Math.abs(percentColor) > 1.0) {
            System.out.println("Warning: color out of range.");
            return new Color(235, 235, 255);
        }
        if (Math.abs(percentColor) < 0.1) {
            return new Color(235, 235, 255);
        }
        int color = 255 - (int)(255.0 * Math.abs(percentColor));
        if (weight >= 0.0) {
            return new Color(color, 255, 255);
        }
        return new Color(255, color, 255);
    }

    public static Color getColorShading(double ratio) {
        int shade = (int)((1.0 - ratio) * 200.0);
        return new Color(shade, shade, shade);
    }

    public static Color getScoreColor(int i) {
        switch (i) {
            case 0: {
                return ColorBroker.getColor("scoreImageClass1");
            }
            case 1: {
                return ColorBroker.getColor("scoreImageClass2");
            }
            case 2: {
                return ColorBroker.getColor("scoreImageClass3");
            }
            case 3: {
                return ColorBroker.getColor("scoreImageClass4");
            }
            case 4: {
                return ColorBroker.getColor("scoreImageClass5");
            }
            case 5: {
                return ColorBroker.getColor("scoreImageClass6");
            }
            case 6: {
                return ColorBroker.getColor("scoreImageClass7");
            }
            case 7: {
                return ColorBroker.getColor("scoreImageClass8");
            }
            case 8: {
                return ColorBroker.getColor("scoreImageClass9");
            }
            case 9: {
                return ColorBroker.getColor("scoreImageClass10");
            }
        }
        return ColorBroker.getRandomColor(i);
    }

    private static Color getRandomColor(int i) {
        switch (i) {
            case 0: {
                return new Color(161, 36, 93);
            }
            case 1: {
                return new Color(57, 253, 146);
            }
            case 2: {
                return new Color(157, 142, 193);
            }
            case 3: {
                return new Color(220, 150, 151);
            }
            case 4: {
                return new Color(98, 54, 189);
            }
            case 5: {
                return new Color(11, 155, 80);
            }
            case 6: {
                return new Color(171, 182, 160);
            }
            case 7: {
                return new Color(100, 3, 8);
            }
            case 8: {
                return new Color(64, 222, 123);
            }
            case 9: {
                return new Color(168, 201, 26);
            }
            case 10: {
                return new Color(165, 29, 145);
            }
            case 11: {
                return new Color(199, 146, 192);
            }
            case 12: {
                return new Color(145, 246, 251);
            }
            case 13: {
                return new Color(44, 135, 117);
            }
            case 14: {
                return new Color(242, 226, 15);
            }
            case 15: {
                return new Color(9, 183, 70);
            }
            case 16: {
                return new Color(175, 176, 59);
            }
            case 17: {
                return new Color(253, 177, 135);
            }
            case 18: {
                return new Color(85, 90, 247);
            }
            case 19: {
                return new Color(203, 132, 240);
            }
            case 20: {
                return new Color(24, 54, 49);
            }
            case 21: {
                return new Color(150, 131, 96);
            }
            case 22: {
                return new Color(183, 32, 141);
            }
            case 23: {
                return new Color(248, 111, 122);
            }
            case 24: {
                return new Color(113, 74, 196);
            }
            case 25: {
                return new Color(51, 59, 4);
            }
            case 26: {
                return new Color(136, 44, 178);
            }
            case 27: {
                return new Color(69, 26, 212);
            }
            case 28: {
                return new Color(232, 145, 240);
            }
            case 29: {
                return new Color(96, 37, 206);
            }
            case 30: {
                return new Color(117, 88, 36);
            }
            case 31: {
                return new Color(93, 164, 67);
            }
            case 32: {
                return new Color(154, 22, 98);
            }
            case 33: {
                return new Color(104, 10, 84);
            }
            case 34: {
                return new Color(132, 73, 129);
            }
            case 35: {
                return new Color(25, 12, 41);
            }
            case 36: {
                return new Color(29, 44, 211);
            }
            case 37: {
                return new Color(196, 71, 51);
            }
            case 38: {
                return new Color(66, 100, 200);
            }
            case 39: {
                return new Color(221, 67, 168);
            }
            case 40: {
                return new Color(196, 206, 186);
            }
            case 41: {
                return new Color(183, 146, 49);
            }
            case 42: {
                return new Color(80, 234, 59);
            }
            case 43: {
                return new Color(234, 15, 220);
            }
            case 44: {
                return new Color(25, 208, 246);
            }
            case 45: {
                return new Color(75, 174, 171);
            }
            case 46: {
                return new Color(235, 118, 78);
            }
            case 47: {
                return new Color(160, 228, 139);
            }
            case 48: {
                return new Color(173, 51, 108);
            }
            case 49: {
                return new Color(5, 162, 69);
            }
            case 50: {
                return new Color(187, 91, 214);
            }
            case 51: {
                return new Color(95, 180, 226);
            }
            case 52: {
                return new Color(2, 15, 27);
            }
            case 53: {
                return new Color(119, 160, 75);
            }
            case 54: {
                return new Color(36, 125, 216);
            }
            case 55: {
                return new Color(204, 102, 199);
            }
            case 56: {
                return new Color(51, 147, 193);
            }
            case 57: {
                return new Color(26, 142, 38);
            }
            case 58: {
                return new Color(140, 124, 104);
            }
            case 59: {
                return new Color(204, 190, 221);
            }
            case 60: {
                return new Color(23, 133, 76);
            }
            case 61: {
                return new Color(120, 51, 165);
            }
            case 62: {
                return new Color(44, 244, 152);
            }
            case 63: {
                return new Color(180, 182, 126);
            }
            case 64: {
                return new Color(9, 168, 68);
            }
            case 65: {
                return new Color(251, 70, 180);
            }
            case 66: {
                return new Color(220, 243, 10);
            }
            case 67: {
                return new Color(139, 212, 29);
            }
            case 68: {
                return new Color(220, 117, 248);
            }
            case 69: {
                return new Color(54, 8, 145);
            }
            case 70: {
                return new Color(192, 114, 129);
            }
            case 71: {
                return new Color(109, 138, 206);
            }
            case 72: {
                return new Color(160, 97, 161);
            }
            case 73: {
                return new Color(163, 201, 57);
            }
            case 74: {
                return new Color(20, 3, 24);
            }
            case 75: {
                return new Color(83, 237, 223);
            }
            case 76: {
                return new Color(70, 203, 145);
            }
            case 77: {
                return new Color(135, 159, 41);
            }
            case 78: {
                return new Color(64, 142, 220);
            }
            case 79: {
                return new Color(205, 202, 97);
            }
            case 80: {
                return new Color(48, 152, 157);
            }
            case 81: {
                return new Color(107, 166, 53);
            }
            case 82: {
                return new Color(16, 51, 47);
            }
            case 83: {
                return new Color(53, 212, 230);
            }
            case 84: {
                return new Color(76, 59, 20);
            }
            case 85: {
                return new Color(123, 130, 150);
            }
            case 86: {
                return new Color(85, 249, 251);
            }
            case 87: {
                return new Color(43, 236, 144);
            }
            case 88: {
                return new Color(203, 191, 30);
            }
            case 89: {
                return new Color(195, 110, 198);
            }
            case 90: {
                return new Color(98, 85, 223);
            }
            case 91: {
                return new Color(51, 155, 170);
            }
            case 92: {
                return new Color(168, 38, 33);
            }
            case 93: {
                return new Color(242, 204, 48);
            }
            case 94: {
                return new Color(148, 208, 101);
            }
            case 95: {
                return new Color(78, 126, 25);
            }
            case 96: {
                return new Color(244, 10, 129);
            }
            case 97: {
                return new Color(14, 82, 2);
            }
            case 98: {
                return new Color(201, 138, 8);
            }
            case 99: {
                return new Color(141, 243, 210);
            }
            case 100: {
                return new Color(148, 97, 120);
            }
            case 101: {
                return new Color(252, 247, 232);
            }
            case 102: {
                return new Color(216, 147, 48);
            }
            case 103: {
                return new Color(117, 145, 140);
            }
            case 104: {
                return new Color(30, 153, 198);
            }
            case 105: {
                return new Color(169, 91, 180);
            }
            case 106: {
                return new Color(47, 74, 53);
            }
            case 107: {
                return new Color(50, 166, 193);
            }
            case 108: {
                return new Color(206, 22, 248);
            }
            case 109: {
                return new Color(178, 232, 33);
            }
            case 110: {
                return new Color(92, 79, 143);
            }
        }
        return ColorBroker.getColor("defaultScoreImage");
    }

    public static Color getSeriesColor(int i) {
        switch (i) {
            case 0: {
                return ColorBroker.getColor("chartSeries1");
            }
            case 1: {
                return ColorBroker.getColor("chartSeries2");
            }
            case 2: {
                return ColorBroker.getColor("chartSeries3");
            }
            case 3: {
                return ColorBroker.getColor("chartSeries4");
            }
            case 4: {
                return ColorBroker.getColor("chartSeries5");
            }
            case 5: {
                return ColorBroker.getColor("chartSeries6");
            }
            case 6: {
                return ColorBroker.getColor("chartSeries7");
            }
            case 7: {
                return ColorBroker.getColor("chartSeries8");
            }
            case 8: {
                return ColorBroker.getColor("chartSeries9");
            }
            case 9: {
                return ColorBroker.getColor("chartSeries10");
            }
            case 10: {
                return ColorBroker.getColor("chartSeries11");
            }
            case 11: {
                return ColorBroker.getColor("chartSeries12");
            }
            case 12: {
                return ColorBroker.getColor("chartSeries13");
            }
            case 13: {
                return ColorBroker.getColor("chartSeries14");
            }
            case 14: {
                return ColorBroker.getColor("chartSeries15");
            }
            case 15: {
                return ColorBroker.getColor("chartSeries16");
            }
        }
        return ColorBroker.getRandomColor(i);
    }
}

