/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.NoSuchElementException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;

public class InlineCharIterator
extends RecursiveCharIterator {
    private boolean bStartBoundary = false;
    private boolean bEndBoundary = false;

    public InlineCharIterator(FObj fobj, CommonBorderPaddingBackground bpb) {
        super(fobj);
        this.checkBoundaries(bpb);
    }

    private void checkBoundaries(CommonBorderPaddingBackground bpb) {
        this.bStartBoundary = bpb.getBorderStartWidth(false) > 0 || bpb.getPaddingStart(false) > 0;
        this.bEndBoundary = bpb.getBorderEndWidth(false) > 0 || bpb.getPaddingEnd(false) > 0;
    }

    public boolean hasNext() {
        if (this.bStartBoundary) {
            return true;
        }
        return super.hasNext() || this.bEndBoundary;
    }

    public char nextChar() throws NoSuchElementException {
        if (this.bStartBoundary) {
            this.bStartBoundary = false;
            return '\u0000';
        }
        try {
            return super.nextChar();
        }
        catch (NoSuchElementException e) {
            if (this.bEndBoundary) {
                this.bEndBoundary = false;
                return '\u0000';
            }
            throw e;
        }
    }
}

