/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.xml.sax.Attributes;

public abstract class PropertyList {
    private int writingMode;
    private static boolean[] inheritableProperty;
    protected PropertyList parentPropertyList = null;
    private FObj fobj = null;
    private static Log log;
    static /* synthetic */ Class class$org$apache$fop$fo$PropertyList;

    public PropertyList(FObj fObjToAttach, PropertyList parentPropertyList) {
        this.fobj = fObjToAttach;
        this.parentPropertyList = parentPropertyList;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public FObj getParentFObj() {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.getFObj();
        }
        return null;
    }

    public PropertyList getParentPropertyList() {
        return this.parentPropertyList;
    }

    public Property getExplicitOrShorthand(int propId) throws PropertyException {
        Property p = this.getExplicit(propId);
        if (p == null) {
            p = this.getShorthand(propId);
        }
        return p;
    }

    public abstract Property getExplicit(int var1);

    public abstract void putExplicit(int var1, Property var2);

    public Property getInherited(int propId) throws PropertyException {
        if (this.isInherited(propId)) {
            return this.getFromParent(propId);
        }
        return this.makeProperty(propId);
    }

    public Property get(int propId) throws PropertyException {
        return this.get(propId, true, true);
    }

    public Property get(int propId, boolean bTryInherit, boolean bTryDefault) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(propId & 0x1FF);
        return propertyMaker.get(propId & 0xFFFFFE00, this, bTryInherit, bTryDefault);
    }

    public Property getNearestSpecified(int propId) throws PropertyException {
        Property p = null;
        PropertyList plist = this;
        while (p == null && plist != null) {
            p = plist.getExplicit(propId);
            plist = plist.parentPropertyList;
        }
        if (p == null) {
            p = this.makeProperty(propId);
        }
        return p;
    }

    public Property getFromParent(int propId) throws PropertyException {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.get(propId);
        }
        return this.makeProperty(propId);
    }

    public void setWritingMode() throws PropertyException {
        FObj p = this.fobj.findNearestAncestorFObj();
        this.writingMode = this.fobj.generatesReferenceAreas() || p == null ? this.get(244).getEnum() : this.getParentPropertyList().getWritingMode();
    }

    public int getWritingMode() {
        return this.writingMode;
    }

    public int getWritingMode(int lrtb, int rltb, int tbrl) {
        switch (this.writingMode) {
            case 79: {
                return lrtb;
            }
            case 121: {
                return rltb;
            }
            case 140: {
                return tbrl;
            }
        }
        return -1;
    }

    public void addAttributesToList(Attributes attributes) {
        String attributeName = "font-size";
        String attributeValue = attributes.getValue(attributeName);
        this.convertAttributeToProperty(attributes, attributeName, attributeValue);
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributeName = attributes.getQName(i);
            attributeValue = attributes.getValue(i);
            this.convertAttributeToProperty(attributes, attributeName, attributeValue);
        }
    }

    private void convertAttributeToProperty(Attributes attributes, String attributeName, String attributeValue) {
        PropertyMaker propertyMaker = null;
        FObj parentFO = this.fobj.findNearestAncestorFObj();
        String basePropertyName = PropertyList.findBasePropertyName(attributeName);
        String subPropertyName = PropertyList.findSubPropertyName(attributeName);
        int propId = FOPropertyMapping.getPropertyId(basePropertyName);
        propertyMaker = this.findMaker(propId);
        if (propertyMaker == null) {
            this.handleInvalidProperty(attributeName);
            return;
        }
        if (attributeValue == null) {
            return;
        }
        try {
            Property prop = null;
            if (subPropertyName == null) {
                if (this.getExplicit(propId) != null) {
                    return;
                }
                prop = propertyMaker.make(this, attributeValue, parentFO);
            } else {
                Property baseProperty = this.findBaseProperty(attributes, parentFO, propId, basePropertyName, propertyMaker);
                int subpropId = FOPropertyMapping.getSubPropertyId(subPropertyName);
                if (subpropId == -1) {
                    this.handleInvalidProperty(attributeName);
                    return;
                }
                prop = propertyMaker.make(baseProperty, subpropId, this, attributeValue, parentFO);
            }
            if (prop != null) {
                this.putExplicit(propId, prop);
            }
        }
        catch (PropertyException e) {
            log.error(e.getMessage());
        }
    }

    private Property findBaseProperty(Attributes attributes, FObj parentFO, int propId, String basePropName, PropertyMaker propertyMaker) throws PropertyException {
        Property baseProperty = this.getExplicit(propId);
        if (baseProperty != null) {
            return baseProperty;
        }
        String basePropertyValue = attributes.getValue(basePropName);
        if (basePropertyValue != null && propertyMaker != null) {
            baseProperty = propertyMaker.make(this, basePropertyValue, parentFO);
            return baseProperty;
        }
        return null;
    }

    private void handleInvalidProperty(String attributeName) {
        if (!attributeName.startsWith("xmlns")) {
            log.error("property '" + attributeName + "' ignored");
        }
    }

    private static String findBasePropertyName(String attributeName) {
        int sepCharIndex = attributeName.indexOf(46);
        String basePropName = attributeName;
        if (sepCharIndex > -1) {
            basePropName = attributeName.substring(0, sepCharIndex);
        }
        return basePropName;
    }

    private static String findSubPropertyName(String attributeName) {
        int sepCharIndex = attributeName.indexOf(46);
        String subPropName = null;
        if (sepCharIndex > -1) {
            subPropName = attributeName.substring(sepCharIndex + 1);
        }
        return subPropName;
    }

    private Property getShorthand(int propId) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(propId);
        if (propertyMaker != null) {
            return propertyMaker.getShorthand(this);
        }
        return null;
    }

    private Property makeProperty(int propId) throws PropertyException {
        PropertyMaker propertyMaker = this.findMaker(propId);
        if (propertyMaker != null) {
            return propertyMaker.make(this);
        }
        return null;
    }

    private boolean isInherited(int propId) {
        if (inheritableProperty == null) {
            inheritableProperty = new boolean[251];
            PropertyMaker maker = null;
            for (int prop = 1; prop <= 250; ++prop) {
                maker = this.findMaker(prop);
                PropertyList.inheritableProperty[prop] = maker != null && maker.isInherited();
            }
        }
        return inheritableProperty[propId];
    }

    private PropertyMaker findMaker(int propId) {
        if (propId < 1 || propId > 250) {
            return null;
        }
        return FObj.propertyListTable[propId];
    }

    public CommonBorderPaddingBackground getBorderPaddingBackgroundProps() throws PropertyException {
        return new CommonBorderPaddingBackground(this, this.getFObj());
    }

    public CommonHyphenation getHyphenationProps() throws PropertyException {
        return new CommonHyphenation(this);
    }

    public CommonMarginBlock getMarginBlockProps() throws PropertyException {
        return new CommonMarginBlock(this);
    }

    public CommonMarginInline getMarginInlineProps() throws PropertyException {
        return new CommonMarginInline(this);
    }

    public CommonAccessibility getAccessibilityProps() throws PropertyException {
        return new CommonAccessibility(this);
    }

    public CommonAural getAuralProps() throws PropertyException {
        CommonAural props = new CommonAural(this);
        return props;
    }

    public CommonRelativePosition getRelativePositionProps() throws PropertyException {
        return new CommonRelativePosition(this);
    }

    public CommonAbsolutePosition getAbsolutePositionProps() throws PropertyException {
        return new CommonAbsolutePosition(this);
    }

    public CommonFont getFontProps() throws PropertyException {
        return new CommonFont(this);
    }

    public CommonTextDecoration getTextDecorationProps() throws PropertyException {
        return CommonTextDecoration.createFromPropertyList(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog(class$org$apache$fop$fo$PropertyList == null ? (class$org$apache$fop$fo$PropertyList = PropertyList.class$("org.apache.fop.fo.PropertyList")) : class$org$apache$fop$fo$PropertyList);
    }
}

