/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.xml.sax.Locator;

public class TableBody
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonRelativePosition commonRelativePosition;
    private int visibility;
    private PropertyList savedPropertyList;
    protected boolean tableRowsFound = false;
    protected boolean tableCellsFound = false;

    public TableBody(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.visibility = pList.get(235).getEnum();
        this.savedPropertyList = pList;
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startBody(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endBody(this);
        if (!this.tableRowsFound && !this.tableCellsFound) {
            if (this.getUserAgent().validateStrictly()) {
                this.missingChildElementError("marker* (table-row+|table-cell+)");
            } else {
                this.getLogger().error("fo:table-body must not be empty. Expected: marker* (table-row+|table-cell+)");
                this.getParent().removeChild(this);
            }
        }
        this.savedPropertyList = null;
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI)) {
            if (localName.equals("marker")) {
                if (this.tableRowsFound || this.tableCellsFound) {
                    this.nodesOutOfOrderError(loc, "fo:marker", "(table-row+|table-cell+)");
                }
            } else if (localName.equals("table-row")) {
                this.tableRowsFound = true;
                if (this.tableCellsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else if (localName.equals("table-cell")) {
                this.tableCellsFound = true;
                if (this.tableRowsFound) {
                    this.invalidChildError(loc, nsURI, localName, "Either fo:table-rows or fo:table-cells may be children of an " + this.getName() + " but not both");
                }
            } else {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    private void convertCellsToRows() throws FOPException {
        ArrayList cells = new ArrayList(this.childNodes);
        this.childNodes.clear();
        Iterator i = cells.iterator();
        TableRow row = null;
        while (i.hasNext()) {
            TableCell cell = (TableCell)i.next();
            if (cell.startsRow() && row != null) {
                this.childNodes.add(row);
                row = null;
            }
            if (row == null) {
                row = new TableRow(this);
                StaticPropertyList pList = new StaticPropertyList(row, this.savedPropertyList);
                pList.setWritingMode();
                row.bind(pList);
            }
            row.addReplacedCell(cell);
            if (!cell.endsRow()) continue;
            this.childNodes.add(row);
            row = null;
        }
        if (row != null) {
            this.childNodes.add(row);
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getName() {
        return "fo:table-body";
    }

    public int getNameId() {
        return 48;
    }

    public boolean isFirst(TableRow obj) {
        return this.childNodes.size() > 0 && this.childNodes.get(0) == obj;
    }

    public boolean isLast(TableRow obj) {
        return this.childNodes.size() > 0 && this.childNodes.get(this.childNodes.size() - 1) == obj;
    }
}

