/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SGraphClear;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGraphIdentify;
import com.insightful.gdevice.SGraphImage;
import com.insightful.gdevice.SGraphLines;
import com.insightful.gdevice.SGraphPoints;
import com.insightful.gdevice.SGraphPolygon;
import com.insightful.gdevice.SGraphSegments;
import com.insightful.gdevice.SGraphText;
import com.insightful.gdevice.SGraphicsDevice;
import com.insightful.gdevice.SGraphicsDeviceFactory;
import com.insightful.gdevice.SGraphicsLocalDeviceFactoryImplementation;
import com.insightful.gdevice.SGraphicsLocalDeviceImplementation;
import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.SplusSessionImpl;
import com.insightful.splus.graph.ExportGraphCommand;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SGraphicsDeviceReceiver {
    private int m_deviceNumber = 0;
    private Properties m_properties = new Properties();
    private boolean m_saveToFile = false;
    private boolean m_saveMultiplePages = false;
    private int m_multiplePageCount = 0;
    private boolean m_multiCanvas = false;
    private SCanvas m_canvas = null;
    private Vector m_canvasVector = null;
    private SGraphicsDevice m_graphicsDevice = null;
    private static SGraphicsDeviceFactory m_graphicsDeviceFactory = null;
    private static Hashtable m_deviceNumberToReceiver = new Hashtable();
    private HashMap m_mapAttributes = new HashMap();
    private static String m_csName = "";
    private static final int COLOR_ROWS = 273;
    private static int[] m_csData = new int[819];
    public static Vector m_standardColorSchemes = new Vector();
    public static Vector m_standardColorSchemeIndexNames = new Vector();
    private static boolean g_legacyGraphicsMode = false;
    public static String BAD_DISPLAY_MSG = "Cannot create an X-display.\nCheck that the specified Xserver allows a connection from this host \nand that DISPLAY is set.\nTo use in headless mode, -headless option.\n";
    private boolean m_useCommandVector = false;
    private Vector m_commandVector = null;
    static FlushThread m_flushThread = null;
    boolean m_waitingForFlushThread = false;
    int m_flushThreadVectorSize = 0;
    int m_flushThreadFlushCount = 0;
    int m_flushCount = 0;

    public static SGraphicsDeviceFactory getSGraphicsDeviceFactory() {
        if (m_graphicsDeviceFactory == null) {
            try {
                if (System.getProperty("splus.session.id") == null) {
                    m_graphicsDeviceFactory = new SGraphicsLocalDeviceFactoryImplementation();
                } else {
                    ClientObjectFactory clientObjectFactory = SplusSessionImpl.getClientObjectFactory();
                    if (clientObjectFactory == null) {
                        throw new Exception("Can't instance ClientObjectFactory");
                    }
                    m_graphicsDeviceFactory = clientObjectFactory.getSGraphicsDeviceFactory();
                }
                if (m_graphicsDeviceFactory == null) {
                    throw new Exception("Can't instance SGraphicsDeviceFactory");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        return m_graphicsDeviceFactory;
    }

    private static void addReceiver(int n, SGraphicsDeviceReceiver sGraphicsDeviceReceiver) {
        m_deviceNumberToReceiver.put(new Integer(n), sGraphicsDeviceReceiver);
    }

    private static void removeReceiver(int n) {
        m_deviceNumberToReceiver.remove(new Integer(n));
    }

    private static SGraphicsDeviceReceiver getReceiver(int n) {
        Object v = m_deviceNumberToReceiver.get(new Integer(n));
        return (SGraphicsDeviceReceiver)v;
    }

    public SGraphicsDeviceReceiver(float f, String string) {
        Object object;
        int n;
        int n2;
        int n3;
        this.m_deviceNumber = (int)f;
        SGraphicsDeviceReceiver.addReceiver(this.m_deviceNumber, this);
        String string2 = string == null ? "" : string;
        int n4 = 0;
        while (n4 < string2.length() && (n3 = string2.indexOf("=", n2 = n4)) >= 0) {
            n = string2.indexOf("\n", n3);
            if (n < 0) {
                n = string2.length();
            }
            object = string2.substring(n2, n3).trim();
            String string3 = string2.substring(n3 + 1, n).trim();
            this.m_properties.setProperty((String)object, string3);
            n4 = n + 1;
        }
        String string4 = this.m_properties.getProperty("file", "");
        this.m_saveToFile = string4.length() != 0;
        this.m_multiCanvas = this.m_saveToFile && ExportGraphCommand.multiCanvasSupported(this.m_properties);
        this.m_saveMultiplePages = this.m_saveToFile && string4.indexOf(35) >= 0;
        this.m_useCommandVector = System.getProperty("splus.session.id") != null && !this.m_saveToFile;
        try {
            n3 = (int)Float.parseFloat(this.m_properties.getProperty("width", "-1"));
            n = (int)Float.parseFloat(this.m_properties.getProperty("height", "-1"));
            object = new Dimension(n3, n);
            if (!this.m_saveToFile) {
                this.m_graphicsDevice = SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().createGraphicsDevice((Dimension)object);
            } else {
                this.m_canvas = new SCanvas();
                this.m_canvasVector = new Vector();
                this.m_graphicsDevice = new SGraphicsLocalDeviceImplementation(this.m_canvas);
            }
            this.m_graphicsDevice.setDeviceNumber(this.m_deviceNumber);
            this.m_graphicsDevice.setUserSize((Dimension)object);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void saveCanvasBitmap(boolean bl) {
        Properties properties;
        block8: {
            properties = (Properties)this.m_properties.clone();
            if (this.m_multiCanvas) {
                this.m_canvasVector.addElement(this.m_canvas);
                if (!bl) {
                    SCanvas sCanvas = new SCanvas();
                    this.m_canvas.setNewActiveCanvas(sCanvas);
                    this.m_canvas = sCanvas;
                } else {
                    ExportGraphCommand.saveMultiCanvas(this.m_canvasVector, properties);
                }
                return;
            }
            if (!bl && !this.m_saveMultiplePages) {
                return;
            }
            String string = this.m_properties.getProperty("file", "");
            int n = string.indexOf(35);
            if (n >= 0) {
                int n2 = 0;
                for (int i = n; i < string.length() && string.charAt(i) == '#'; ++i) {
                    ++n2;
                }
                do {
                    ++this.m_multiplePageCount;
                    String string2 = Integer.toString(this.m_multiplePageCount);
                    while (string2.length() < n2) {
                        string2 = "0" + string2;
                    }
                    String string3 = string.substring(0, n) + string2 + string.substring(n + n2);
                    properties.setProperty("file", string3);
                    if (!new File(string3).exists()) break block8;
                } while (this.m_multiplePageCount <= 10000000);
                return;
            }
        }
        ExportGraphCommand.saveCanvasBitmap(this.m_canvas, properties);
    }

    public void Clear() {
        this.flushCommandVector();
        if (this.m_saveToFile && this.m_canvas != null && !this.m_canvas.isEmpty()) {
            this.saveCanvasBitmap(false);
        }
        try {
            this.sendAttributes();
            this.m_graphicsDevice.Clear();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void SetBackgroundColor() {
        if (this.m_useCommandVector) {
            SGraphClear sGraphClear = new SGraphClear(false, true);
            this.setCommonProperties(sGraphClear);
            this.addToCommandVector(sGraphClear);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.SetBackgroundColor();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Wrap() {
        this.flushCommandVector();
        if (this.m_saveToFile && this.m_canvas != null) {
            this.saveCanvasBitmap(true);
        }
        try {
            this.sendAttributes();
            this.m_graphicsDevice.Wrap();
            this.m_graphicsDevice = null;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        SGraphicsDeviceReceiver.removeReceiver(this.m_deviceNumber);
    }

    public int ReadPen(float[] fArray, float[] fArray2) {
        this.flushCommandVector();
        try {
            if (fArray == null || fArray.length < 1 || fArray2 == null || fArray.length != fArray2.length) {
                return 0;
            }
            int n = fArray.length;
            this.sendAttributes();
            float[][] fArray3 = this.m_graphicsDevice.ReadPen(n);
            if (fArray3 == null || fArray3.length != 2 || fArray3[0] == null || fArray3[1] == null || fArray3[0].length != fArray3[1].length) {
                return 0;
            }
            int n2 = Math.min(n, fArray3[0].length);
            for (int i = 0; i < n2; ++i) {
                fArray[i] = fArray3[0][i];
                fArray2[i] = fArray3[1][i];
            }
            return n2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return 0;
        }
    }

    public void Lines(float[] fArray, float[] fArray2) {
        if (this.m_useCommandVector) {
            SGraphLines sGraphLines = new SGraphLines(fArray, fArray2, (int)this.getAttribute("LineWidth", 1.0f), (int)this.getAttribute("LineDashType", 1.0f));
            this.setCommonProperties(sGraphLines);
            this.addToCommandVector(sGraphLines);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Lines(fArray, fArray2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Segments(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        if (this.m_useCommandVector) {
            SGraphSegments sGraphSegments = new SGraphSegments(fArray, fArray2, fArray3, fArray4, (int)this.getAttribute("LineWidth", 1.0f), (int)this.getAttribute("LineDashType", 1.0f));
            this.setCommonProperties(sGraphSegments);
            this.addToCommandVector(sGraphSegments);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Segments(fArray, fArray2, fArray3, fArray4);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Polygon(float[] fArray, float[] fArray2) {
        if (this.m_useCommandVector) {
            SGraphPolygon sGraphPolygon = new SGraphPolygon(fArray, fArray2);
            this.setCommonProperties(sGraphPolygon);
            this.addToCommandVector(sGraphPolygon);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Polygon(fArray, fArray2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Points(float[] fArray, float[] fArray2) {
        if (this.m_useCommandVector) {
            SGraphPoints sGraphPoints = new SGraphPoints(fArray, fArray2, (char)this.getAttribute("PlotCharacter", 1.0f), this.getAttribute("FontSize", 1.0f), this.getAttribute("SymbolSize", 1.0f), this.getAttribute("FontNumber", 1.0f));
            this.setCommonProperties(sGraphPoints);
            this.addToCommandVector(sGraphPoints);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Points(fArray, fArray2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Text(float f, float f2, String string, float f3) {
        if (this.m_useCommandVector) {
            float f4 = this.getAttribute("StringRotation", 0.0f);
            float f5 = this.getAttribute("FontSize", 1.0f);
            float f6 = this.getAttribute("FontNumber", 1.0f);
            SGraphText sGraphText = new SGraphText(string, f, f2, f4, f3, f5, f6);
            this.setCommonProperties(sGraphText);
            this.addToCommandVector(sGraphText);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Text(f, f2, string, f3);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void FloatImage(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3) {
        if (this.m_useCommandVector) {
            SGraphImage sGraphImage = new SGraphImage(fArray, fArray2, fArray3, f, f2, f3);
            this.setCommonProperties(sGraphImage);
            this.addToCommandVector(sGraphImage);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.FloatImage(fArray, fArray2, fArray3, f, f2, f3);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void FloatImageRGBA(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (this.m_useCommandVector) {
            SGraphImage sGraphImage = new SGraphImage(fArray, fArray2, fArray3, f, f2, f3, byArray, byArray2, byArray3, byArray4);
            this.setCommonProperties(sGraphImage);
            this.addToCommandVector(sGraphImage);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.FloatImageRGBA(fArray, fArray2, fArray3, f, f2, f3, byArray, byArray2, byArray3, byArray4);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Hook(int n, float[] fArray, float[] fArray2) {
        if (this.m_useCommandVector) {
            this.flushCommandVector();
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Hook(n, fArray, fArray2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void Identify(String[] stringArray, String[] stringArray2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, boolean bl, boolean bl2) {
        if (this.m_useCommandVector) {
            SGraphIdentify sGraphIdentify = new SGraphIdentify(fArray, fArray2, fArray3, fArray4, stringArray, stringArray2, bl, bl2);
            this.setCommonProperties(sGraphIdentify);
            this.addToCommandVector(sGraphIdentify);
        } else {
            try {
                this.sendAttributes();
                this.m_graphicsDevice.Identify(stringArray, stringArray2, fArray, fArray2, fArray3, fArray4, bl, bl2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void setPageTitle(String string) {
        this.flushCommandVector();
        try {
            this.m_graphicsDevice.setPageTitle(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void setPageTag(String string) {
        this.flushCommandVector();
        try {
            this.m_graphicsDevice.setPageTag(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public String getPageTitle() {
        this.flushCommandVector();
        try {
            return this.m_graphicsDevice.getPageTitle();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return "";
        }
    }

    public String getPageTag() {
        this.flushCommandVector();
        try {
            return this.m_graphicsDevice.getPageTag();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return "";
        }
    }

    public String[] getSelectedTagArray() {
        this.flushCommandVector();
        try {
            return this.m_graphicsDevice.getSelectedTagArray();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return new String[0];
        }
    }

    public void setSelectedTagArray(String[] stringArray) {
        this.flushCommandVector();
        try {
            this.m_graphicsDevice.setSelectedTagArray(stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void setAttribute(String string, float f) {
        this.m_mapAttributes.put(string.toLowerCase(), new Float(f));
    }

    private void sendAttributes() {
        try {
            this.m_graphicsDevice.setAttributes(this.m_mapAttributes);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
    }

    public static void setColorSchemeName(int n, String string) {
        m_csName = string == null ? "" : string;
    }

    public static void setColorSchemeRow(int n, int n2, int n3, int n4, int n5) {
        int n6 = 3 * (n2 - 1);
        if (n6 >= 0 && n6 + 2 < m_csData.length) {
            SGraphicsDeviceReceiver.m_csData[n6] = n3;
            SGraphicsDeviceReceiver.m_csData[n6 + 1] = n4;
            SGraphicsDeviceReceiver.m_csData[n6 + 2] = n5;
        }
    }

    public static void setColorSchemeCommit(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (n > 0 && sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setColorScheme(m_csName, m_csData);
        } else if (n <= 0) {
            SGraphicsDeviceReceiver.setStandardColorScheme(-n, m_csName, m_csData);
        }
    }

    public static void setColorScheme(int n, String string, int[] nArray) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (n > 0 && sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setColorScheme(string, nArray);
        } else if (n <= 0) {
            SGraphicsDeviceReceiver.setStandardColorScheme(-n, string, nArray);
        }
    }

    public static int[] getColorSchemeInts(int n) {
        int[] nArray = null;
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        nArray = n > 0 && sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getColorSchemeInts() : (n <= 0 ? SGraphicsDeviceReceiver.getStandardColorSchemeInts(-n) : new int[819]);
        return nArray;
    }

    public static String getColorSchemeName(int n) {
        String string = "";
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (n > 0 && sGraphicsDeviceReceiver != null) {
            string = sGraphicsDeviceReceiver.getColorSchemeName();
        } else if (n <= 0) {
            string = SGraphicsDeviceReceiver.getStandardColorSchemeName(-n);
        }
        return string;
    }

    public void setColorScheme(String string, int[] nArray) {
        try {
            this.m_graphicsDevice.setColorScheme(string, nArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public int[] getColorSchemeInts() {
        int[] nArray = null;
        try {
            nArray = this.m_graphicsDevice.getColorSchemeInts();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return nArray == null ? new int[819] : nArray;
    }

    public String getColorSchemeName() {
        try {
            return this.m_graphicsDevice.getColorSchemeName();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return "";
        }
    }

    public static void setStandardColorScheme(int n, String string, int[] nArray) {
        ColorScheme colorScheme = new ColorScheme(string, nArray);
        if (n > SGraphicsDeviceReceiver.getColorSchemeIndexSize()) {
            SGraphicsDeviceReceiver.setColorSchemeIndexSize(n);
        }
        m_standardColorSchemes.set(n - 1, colorScheme);
    }

    public static int[] getStandardColorSchemeInts(int n) {
        ColorScheme colorScheme;
        if (n <= SGraphicsDeviceReceiver.getColorSchemeIndexSize() && (colorScheme = (ColorScheme)m_standardColorSchemes.get(n - 1)) != null) {
            return colorScheme.getInts();
        }
        return new int[819];
    }

    public static String getStandardColorSchemeName(int n) {
        ColorScheme colorScheme;
        if (n <= SGraphicsDeviceReceiver.getColorSchemeIndexSize() && (colorScheme = (ColorScheme)m_standardColorSchemes.get(n - 1)) != null) {
            return colorScheme.getName();
        }
        return "";
    }

    public static void setColorSchemeIndexSize(int n) {
        m_standardColorSchemes.setSize(n);
        m_standardColorSchemeIndexNames.setSize(n);
    }

    public static int getColorSchemeIndexSize() {
        return m_standardColorSchemes.size();
    }

    public static void setColorSchemeIndexName(int n, String string) {
        if (n > SGraphicsDeviceReceiver.getColorSchemeIndexSize()) {
            SGraphicsDeviceReceiver.setColorSchemeIndexSize(n);
        }
        m_standardColorSchemeIndexNames.set(n - 1, string);
    }

    public static String getColorSchemeIndexName(int n) {
        String string;
        if (n <= SGraphicsDeviceReceiver.getColorSchemeIndexSize() && (string = (String)m_standardColorSchemeIndexNames.get(n - 1)) != null) {
            return string;
        }
        return "";
    }

    public static void getColorSchemeClientInfo() {
        try {
            m_standardColorSchemes = SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().getStandardColorSchemes();
            m_standardColorSchemeIndexNames = SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().getStandardColorSchemeIndexNames();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void setColorSchemeClientInfo() {
        try {
            SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().setStandardColorSchemes(m_standardColorSchemes);
            SGraphicsDeviceReceiver.getSGraphicsDeviceFactory().setStandardColorSchemeIndexNames(m_standardColorSchemeIndexNames);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void addIdentifyCommand(int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, String[] stringArray, String[] stringArray2, int n2, int n3) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.Identify(stringArray, stringArray2, fArray, fArray2, fArray3, fArray4, n2 != 0, n3 != 0);
        }
    }

    public static void setPageTitle(int n, String string) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setPageTitle(string);
        }
    }

    public static void setPageTag(int n, String string) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setPageTag(string);
        }
    }

    public static String getPageTitle(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        return sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getPageTitle() : "";
    }

    public static String getPageTag(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        return sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getPageTag() : "";
    }

    public static String[] getSelectedTagArray(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        return sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getSelectedTagArray() : new String[]{};
    }

    public static void setSelectedTagArray(int n, String[] stringArray) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setSelectedTagArray(stringArray);
        }
    }

    public static void setLegacyGraphicsMode(boolean bl) {
        g_legacyGraphicsMode = bl;
    }

    public static boolean isLegacyGraphicsMode() {
        return g_legacyGraphicsMode;
    }

    public static boolean checkServerDisplay() {
        boolean bl = true;
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Exception exception) {
            bl = false;
        }
        catch (Error error) {
            bl = false;
        }
        return bl;
    }

    public static boolean getUseCommandVector(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (n > 0 && sGraphicsDeviceReceiver != null) {
            return sGraphicsDeviceReceiver.m_useCommandVector;
        }
        return false;
    }

    public static void setUseCommandVector(int n, boolean bl) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (n > 0 && sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.m_useCommandVector = bl;
        }
    }

    public synchronized void flushCommandVector() {
        if (!this.m_useCommandVector || this.m_commandVector == null || this.m_commandVector.isEmpty()) {
            return;
        }
        try {
            this.m_graphicsDevice.sendCommandVector(this.m_commandVector);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.m_commandVector.clear();
        ++this.m_flushCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCommandVector(SGraphCommand sGraphCommand) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = this;
        synchronized (sGraphicsDeviceReceiver) {
            if (!this.m_useCommandVector) {
                return;
            }
            if (this.m_commandVector == null) {
                this.m_commandVector = new Vector(300);
            }
            this.m_commandVector.add(sGraphCommand);
            if (this.m_commandVector.size() > 280) {
                this.flushCommandVector();
                return;
            }
        }
        if (!this.m_waitingForFlushThread && !this.m_saveToFile) {
            this.notifyFlushThread();
        }
    }

    public static synchronized FlushThread getFlushThread() {
        if (m_flushThread == null) {
            m_flushThread = new FlushThread();
        }
        return m_flushThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFlushThread() {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = this;
        synchronized (sGraphicsDeviceReceiver) {
            this.m_waitingForFlushThread = true;
            this.m_flushThreadVectorSize = this.m_commandVector.size();
            this.m_flushThreadFlushCount = this.m_flushCount;
        }
        SGraphicsDeviceReceiver.getFlushThread().notifyMe(this);
    }

    public synchronized void notifyFromFlushThread() {
        if (this.m_waitingForFlushThread) {
            if (this.m_flushThreadVectorSize == this.m_commandVector.size() && this.m_flushThreadFlushCount == this.m_flushCount) {
                this.flushCommandVector();
                this.m_waitingForFlushThread = false;
            } else {
                this.m_flushThreadVectorSize = this.m_commandVector.size();
                this.m_flushThreadFlushCount = this.m_flushCount;
            }
        }
    }

    private void setCommonProperties(SGraphCommand sGraphCommand) {
        sGraphCommand.setCommonProperties(this.m_mapAttributes);
    }

    private float getAttribute(String string, float f) {
        Object v = this.m_mapAttributes.get(string.toLowerCase());
        if (v == null) {
            return f;
        }
        Float f2 = (Float)v;
        return f2.floatValue();
    }

    public int getNumberPages() {
        this.flushCommandVector();
        try {
            return this.m_graphicsDevice.getNumberPages();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return 0;
        }
    }

    public static int getNumberPages(int n) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        return sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getNumberPages() : 0;
    }

    public String getPagePropertyAction(int n) {
        this.flushCommandVector();
        try {
            return this.m_graphicsDevice.getPagePropertyAction(n);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return "";
        }
    }

    public static String getPagePropertyAction(int n, int n2) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        return sGraphicsDeviceReceiver != null ? sGraphicsDeviceReceiver.getPagePropertyAction(n2) : "";
    }

    public void setPagePropertyAction(int n, String string) {
        this.flushCommandVector();
        try {
            this.m_graphicsDevice.setPagePropertyAction(n, string);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void setPagePropertyAction(int n, int n2, String string) {
        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = SGraphicsDeviceReceiver.getReceiver(n);
        if (sGraphicsDeviceReceiver != null) {
            sGraphicsDeviceReceiver.setPagePropertyAction(n2, string);
        }
    }

    static class FlushThread
    extends Thread {
        boolean m_threadStarted = false;
        Vector m_notifyReceivers = new Vector();

        FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyMe(SGraphicsDeviceReceiver sGraphicsDeviceReceiver) {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.m_notifyReceivers.add(sGraphicsDeviceReceiver);
                if (!this.m_threadStarted) {
                    this.start();
                    this.m_threadStarted = true;
                }
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.setPriority(1);
            }
            while (true) {
                try {
                    flushThread = this;
                    synchronized (flushThread) {
                        if (this.m_notifyReceivers.isEmpty()) {
                            this.wait();
                        }
                        this.wait(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                flushThread = this;
                synchronized (flushThread) {
                    int n = this.m_notifyReceivers.size();
                    for (int i = 0; i < n; ++i) {
                        SGraphicsDeviceReceiver sGraphicsDeviceReceiver = (SGraphicsDeviceReceiver)this.m_notifyReceivers.elementAt(i);
                        sGraphicsDeviceReceiver.notifyFromFlushThread();
                        if (sGraphicsDeviceReceiver.m_waitingForFlushThread) continue;
                        this.m_notifyReceivers.removeElementAt(i);
                        --n;
                    }
                }
            }
        }
    }
}

