/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.ClientObjectFactoryImpl;
import com.insightful.splus.ClientUtilities;
import com.insightful.splus.ClientUtilitiesImpl;
import com.insightful.splus.FileInputStreamProxy;
import com.insightful.splus.FileInputStreamProxyImpl;
import com.insightful.splus.FileOutputStreamProxy;
import com.insightful.splus.FileOutputStreamProxyImpl;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusFifo;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusLogin;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusSSLClientSocketFactory;
import com.insightful.splus.SplusSSLServerSocketFactory;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionFactoryFloor;
import com.insightful.splus.SplusThread;
import com.insightful.splus.client.ClientLoginDialog;
import com.insightful.splus.eclipse.SplusEclipseSessionImpl;
import com.insightful.splus.util.StringUtilities;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class SplusSessionImpl
extends UnicastRemoteObject
implements SplusSession {
    private SplusFifo stdinPipeO = null;
    private SplusFifo stdoutPipeI = null;
    private SplusFifo stderrPipeI = null;
    private SplusFifo dataToSplus = null;
    private SplusFifo dataToJava = null;
    private Thread sPlus;
    private ThreadGroup splusGroup;
    private static ClientObjectFactory clientObjectFactory = null;
    private final boolean defaultOutput = false;
    private final boolean defaultResult = true;
    private final boolean defaultErrors = true;
    private final boolean defaultWarnings = true;
    private final boolean defaultExpr = false;
    private final int defaultTimeout = 2;
    private final boolean defaultPing = true;
    private final boolean defaultParse = true;
    private static boolean engineBusy = false;
    private int queryTimeout = 0;
    private static boolean g_pendingInterrupt = false;
    static String id = null;
    static boolean remote = true;
    boolean clientExitFlag = true;

    private native int raiseInterrupt();

    public SplusSessionImpl(String[] stringArray, boolean bl) throws RemoteException {
        super(0, new SplusSSLClientSocketFactory(), new SplusSSLServerSocketFactory());
        this.init(stringArray);
    }

    public SplusSessionImpl(String[] stringArray) throws RemoteException {
        this.init(stringArray);
    }

    public SplusSessionImpl() throws RemoteException {
        this(new String[0]);
    }

    public void init(String[] stringArray) throws RemoteException {
        Object object;
        this.queryTimeout = 2;
        try {
            object = System.getProperty("splus.query.timeout", "");
            if (!((String)object).equals("")) {
                this.queryTimeout = Integer.decode((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stdinPipeO = new SplusFifo('w');
            this.stdoutPipeI = new SplusFifo('r');
            this.stderrPipeI = new SplusFifo('r');
            this.dataToSplus = new SplusFifo('w');
            this.dataToJava = new SplusFifo('r');
            try {
                this.stdoutPipeI.open();
                this.stderrPipeI.open();
                this.splusGroup = new ThreadGroup("Engine");
                this.sPlus = new Thread(this.splusGroup, new SplusThread(this.stdinPipeO.getName(), this.stdoutPipeI.getName(), this.stderrPipeI.getName(), this.dataToSplus.getName(), this.dataToJava.getName(), stringArray));
                this.sPlus.setName("S-PLUS: pipes to engine");
                this.sPlus.start();
                this.stdinPipeO.open();
                this.dataToSplus.open();
                this.dataToJava.open();
                if (this.isRemote()) {
                    object = new Thread(new Runnable(){

                        public void run() {
                            boolean bl = true;
                            while (bl) {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(30000L);
                                    if (clientObjectFactory == null) continue;
                                    clientObjectFactory.isAlive();
                                }
                                catch (Exception exception) {
                                    try {
                                        SplusSessionImpl.this.sessionExit();
                                    }
                                    catch (Exception exception2) {}
                                }
                            }
                        }
                    });
                    ((Thread)object).setName("S-PLUS: client health & status");
                    ((Thread)object).start();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeSplusIn(String string) throws RemoteException {
        if (this.stdinPipeO != null) {
            this.stdinPipeO.write(string);
        }
    }

    public void writeSplusData(String string) throws RemoteException {
        if (this.dataToSplus != null) {
            this.dataToSplus.write(string);
        }
    }

    public String readSplusOut() throws RemoteException {
        if (this.stdoutPipeI != null) {
            return this.stdoutPipeI.readString();
        }
        return "";
    }

    public String readSplusErr() throws RemoteException {
        if (this.stderrPipeI != null) {
            return this.stderrPipeI.readString();
        }
        return "";
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        Object object;
        if (engineBusy) {
            throw new SplusEngineBusyException("S-PLUS engine is being pinged.");
        }
        if (bl6) {
            engineBusy = true;
            object = new Thread(new Runnable(){

                public void run() {
                    try {
                        SplusSessionImpl.this.dataToJava.flushDataChan();
                        SplusSessionImpl.this.dataToSplus.write("sjava.send.results(cmd=expression())\n");
                        SplusDataResult splusDataResult = SplusSessionImpl.this.dataToJava.readData();
                    }
                    catch (Exception exception) {
                        String string = exception.toString();
                        System.out.println(string);
                    }
                    engineBusy = false;
                }
            });
            ((Thread)object).setName("S-PLUS: ping engine");
            ((Thread)object).start();
            int n2 = 0;
            int n3 = 1000 * n;
            while (engineBusy) {
                try {
                    Thread.currentThread();
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((n2 += 5) <= n3) continue;
                String string2 = "Query timed out (after " + Integer.toString(n) + " seconds) waiting for engine ping to complete.";
                throw new SplusEngineBusyException(string2);
            }
        }
        object = null;
        String string3 = StringUtilities.escapeSpecialCharacters(string);
        String string4 = "sjava.send.results(cmd=\"" + string3 + "\",";
        string4 = string4 + "Output=" + (bl ? "T," : "F,");
        string4 = string4 + "Result=" + (bl2 ? "T," : "F,");
        string4 = string4 + "Errors=" + (bl3 ? "T," : "F,");
        string4 = string4 + "Warnings=" + (bl4 ? "T," : "F,");
        string4 = string4 + "Expr=" + (bl5 ? "T," : "F,");
        string4 = string4 + ")\n";
        if (bl7) {
            String string5 = "sjava.send.results(cmd=expression(parseClass(parseSome(textConnection('" + string3 + "\n'), n=999))))\n";
            boolean bl8 = true;
            try {
                this.dataToJava.flushDataChan();
                this.dataToSplus.write(string5);
                object = this.dataToJava.readData();
                bl8 = ((SplusDataResult)object).getStringData()[0].equals("complete");
                if (bl8) {
                    this.dataToJava.flushDataChan();
                    this.dataToSplus.write(string4);
                    object = this.dataToJava.readData();
                } else {
                    object = new SplusDataResult(null, null, null, null);
                }
            }
            catch (Exception exception) {
                String string6 = exception.toString();
                System.out.println(string6);
            }
            if (!bl8) {
                throw new SplusIncompleteExpressionException("Incomplete expression.\nCheck for mismatched quotes or parentheses.");
            }
        } else {
            try {
                this.dataToJava.flushDataChan();
                this.dataToSplus.write(string4);
                object = this.dataToJava.readData();
            }
            catch (Exception exception) {
                String string7 = exception.toString();
                System.out.println(string7);
            }
        }
        return object;
    }

    public SplusDataResult evalDataQuery(String string) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, this.queryTimeout, true, true);
    }

    public SplusDataResult evalDataQuery(String string, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, n, true, true);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, this.queryTimeout, bl, bl2);
    }

    public SplusDataResult evalDataQuery(String string, int n, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, false, true, true, true, false, n, bl, bl2);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, this.queryTimeout, true, true);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, n, true, true);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, this.queryTimeout, bl6, bl7);
    }

    public void Interrupt() throws RemoteException {
        if (!g_pendingInterrupt) {
            g_pendingInterrupt = true;
            InterruptThread interruptThread = new InterruptThread();
            interruptThread.setName("S-PLUS: interrupt engine");
            interruptThread.start();
        }
    }

    public void setClientObjectFactory(ClientObjectFactory clientObjectFactory) throws RemoteException {
        SplusSessionImpl.clientObjectFactory = clientObjectFactory;
    }

    public static ClientObjectFactory getClientObjectFactory() {
        ClientObjectFactory clientObjectFactory = SplusEclipseSessionImpl.getClientObjectFactory();
        if (clientObjectFactory != null) {
            return clientObjectFactory;
        }
        return SplusSessionImpl.clientObjectFactory;
    }

    public FileInputStreamProxy getFileInputStream(String string) throws FileNotFoundException, RemoteException {
        return new FileInputStreamProxyImpl(string);
    }

    public FileOutputStreamProxy getFileOutputStream(String string) throws FileNotFoundException, RemoteException {
        return new FileOutputStreamProxyImpl(string);
    }

    public void startPollOutput(final SplusOutputHandler splusOutputHandler) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SplusSessionImpl.this.pollOutput(splusOutputHandler);
            }
        });
        thread.setName("S-PLUS: poll output");
        thread.start();
    }

    public void pollOutput(SplusOutputHandler splusOutputHandler) {
        boolean bl = true;
        String string = "";
        while (true) {
            boolean bl2 = false;
            String string2 = "";
            try {
                if (!bl) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                } else {
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = this.readSplusOut();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            while (string.length() > 0 && string2.length() < 100000) {
                string2 = string2 + string;
                try {
                    string = this.readSplusOut();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            if (string.length() > 0) {
                string2 = string2 + string;
            } else {
                try {
                    string = this.readSplusErr();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                while (string.length() > 0) {
                    if (string.length() > 1) {
                        bl2 = true;
                    }
                    string2 = string2 + string;
                    try {
                        string = this.readSplusErr();
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
            if (string2.length() > 0) {
                bl = true;
                try {
                    if (string2.indexOf("Interrupt") > -1) {
                        g_pendingInterrupt = false;
                    }
                    splusOutputHandler.write(string2, bl2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (this.isRemote()) {
                        this.sessionExit();
                        continue;
                    }
                    System.exit(1);
                }
                continue;
            }
            bl = false;
        }
    }

    public boolean isRemote() {
        if (id == null && ((id = System.getProperty("splus.session.id")) == null || id.length() == 0)) {
            remote = false;
        }
        return remote;
    }

    public void sessionExit(boolean bl) {
        if (!bl) {
            this.clientExitFlag = false;
        }
        if (this.isRemote()) {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void sessionExit() {
        this.sessionExit(true);
    }

    protected void finalize() throws Throwable {
        if (this.isRemote()) {
            String string = System.getProperty("splus.server.rmiport", "1099");
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n != 0) {
                SplusSessionFactoryFloor.getFactory(n).unregisterSession(System.getProperty("splus.session.id"));
            }
            if (this.clientExitFlag) {
                SplusSessionImpl.clientShutdown();
            }
        }
    }

    public static void clientShutdown() {
        try {
            SplusSessionImpl.getClientObjectFactory().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SplusSession getRemoteSession(boolean bl, ClientObjectFactory clientObjectFactory, String[] stringArray) {
        SplusSession splusSession = SplusSessionImpl.loginWithSystemProperties(stringArray);
        if (splusSession == null && !bl) {
            System.out.println("S-PLUS session login using system properties failed.");
            System.out.println("Check settings and network status.");
            System.exit(0);
        }
        if (splusSession == null) {
            ClientLoginDialog clientLoginDialog = new ClientLoginDialog();
            clientLoginDialog.setFactoryArgs(stringArray);
            clientLoginDialog.show();
            splusSession = clientLoginDialog.getSession();
            if (splusSession == null) {
                System.exit(0);
            }
            if (System.getProperty("splus.help.off") == null) {
                System.setProperty("splus.help.off", clientLoginDialog.getHelpOff());
            }
        }
        try {
            if (clientObjectFactory != null) {
                splusSession.setClientObjectFactory(clientObjectFactory);
            } else {
                splusSession.setClientObjectFactory(new ClientObjectFactoryImpl());
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Error in registering ClientObjectFactory");
            remoteException.printStackTrace();
        }
        return splusSession;
    }

    protected static SplusSession loginWithSystemProperties(String[] stringArray) {
        int n;
        String string = System.getProperty("splus.server.host");
        String string2 = System.getProperty("splus.server.username");
        String string3 = System.getProperty("splus.server.password");
        if (string3 == null || string2 == null || string == null) {
            return null;
        }
        String string4 = System.getProperty("splus.server.rmiport", "1099");
        String string5 = System.getProperty("splus.server.cwd", "");
        String string6 = System.getProperty("splus.xserver.display", "");
        String string7 = System.getProperty("splus.server.prompt", "");
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        SplusSession splusSession = null;
        try {
            SplusLogin splusLogin = new SplusLogin();
            splusSession = splusLogin.newSession(string, string2, string3, n, string5, string6, string7, "", stringArray);
        }
        catch (SplusLogin.SplusLoginException splusLoginException) {
            return null;
        }
        catch (SplusLogin.SplusLoginFatalException splusLoginFatalException) {
            return null;
        }
        return splusSession;
    }

    public String getCertFilename() throws RemoteException {
        return SplusSSLServerSocketFactory.getCertfile();
    }

    public char[] getCertAccess() throws RemoteException {
        return SplusSSLServerSocketFactory.getAccess();
    }

    public ClientUtilities getClientUtilities() throws RemoteException {
        return new ClientUtilitiesImpl();
    }

    static {
        String string = System.getProperty("os.name", "unknown").toLowerCase();
        if (string.indexOf("windows") < 0 && !string.startsWith("mac") && !System.getProperty("splus.client.mode", "").equals("true")) {
            System.loadLibrary("SplusExecGui");
        }
    }

    private class InterruptThread
    extends Thread {
        public void run() {
            int n = SplusSessionImpl.this.raiseInterrupt();
            if (n != 0) {
                System.out.println("Error in interrupting SplusSession");
            }
        }
    }
}

