/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.preferences.IRemoteHelpListViewer;

public class RemoteICList {
    private Vector remote_ics = new Vector();
    private Set changeListeners = new HashSet();
    private PreferenceFileHandler prefsFileHandler;

    public RemoteICList() {
        this.loadPreferences();
    }

    private void loadPreferences() {
        this.prefsFileHandler = new PreferenceFileHandler();
        int totalICs = this.prefsFileHandler.getTotalRemoteInfocenters();
        int i = 0;
        while (i < totalICs) {
            String host = this.prefsFileHandler.getHostEntries()[i];
            String name = this.prefsFileHandler.getNameEntries()[i];
            String path = this.prefsFileHandler.getPathEntries()[i];
            String port = this.prefsFileHandler.getPortEntries()[i];
            String enabledDisabled = this.prefsFileHandler.getEnabledEntries()[i];
            boolean currEnabled = enabledDisabled.equals("true");
            RemoteIC initRemoteIC = new RemoteIC(currEnabled, name, host, path, port);
            this.remote_ics.add(initRemoteIC);
            ++i;
        }
    }

    public Vector getRemoteICs() {
        return this.remote_ics;
    }

    public RemoteIC getRemoteICAtIndex(int index) {
        return (RemoteIC)this.remote_ics.get(index);
    }

    public void addRemoteIC(RemoteIC remote_ic) {
        this.remote_ics.add(this.remote_ics.size(), remote_ic);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRemoteHelpListViewer)iterator.next()).addRemoteIC(remote_ic);
        }
    }

    public void removeRemoteIC(RemoteIC remote_ic) {
        this.remote_ics.remove(remote_ic);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRemoteHelpListViewer)iterator.next()).removeRemoteIC(remote_ic);
        }
    }

    public void updateRemoteIC(RemoteIC remote_ic) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRemoteHelpListViewer)iterator.next()).updateRemoteIC(remote_ic);
        }
    }

    public void refreshRemoteIC(RemoteIC remote_ic, int selectedIndex) {
        this.remote_ics.setElementAt(remote_ic, selectedIndex);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRemoteHelpListViewer)iterator.next()).refreshRemoteIC(remote_ic, selectedIndex);
        }
    }

    public void removeAllRemoteICs(Object[] remoteICs) {
        this.remote_ics.clear();
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IRemoteHelpListViewer)iterator.next()).removeAllRemoteICs(remoteICs);
        }
    }

    public void removeChangeListener(IRemoteHelpListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IRemoteHelpListViewer viewer) {
        this.changeListeners.add(viewer);
    }

    public PreferenceFileHandler getPrefsReader() {
        return this.prefsFileHandler;
    }

    public RemoteIC[] getRemoteICArray() {
        RemoteIC[] latestTableEntries = this.remote_ics.toArray(new RemoteIC[this.remote_ics.size()]);
        return latestTableEntries;
    }
}

