/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasHit;
import com.insightful.gdevice.SCanvasHitRegion;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.TagSet;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;

class SGraphIdentify
extends SGraphCommand {
    private float[] m_x1;
    private float[] m_y1;
    private float[] m_x2;
    private float[] m_y2;
    private String[] m_labels;
    private String[] m_actions;
    private boolean m_isPolygons;
    private boolean m_isOneRegion;
    private int m_numRegions;
    private int[][] m_polyRuns;
    private ImageRegionInfo[] m_imageRegionInfo;
    private transient Rectangle[] m_rects = null;
    private transient Polygon[] m_polygons = null;
    private transient String[] m_astrTags = null;
    private transient boolean[] m_tagIgnoresRectSelect = null;
    private transient Rectangle m_totalBounds = null;

    SGraphIdentify(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        int n;
        this.m_isPolygons = bl;
        this.m_isOneRegion = bl2;
        this.m_x1 = fArray == null ? new float[]{} : fArray;
        this.m_y1 = this.resizeFloatArray(fArray2, this.m_x1.length);
        this.m_x2 = this.resizeFloatArray(fArray3, this.m_isPolygons ? 0 : this.m_x1.length);
        this.m_y2 = this.resizeFloatArray(fArray4, this.m_isPolygons ? 0 : this.m_x1.length);
        this.m_numRegions = this.m_x1.length;
        this.m_polyRuns = null;
        if (this.m_isPolygons) {
            this.m_numRegions = 1;
            for (n = 0; n < this.m_x1.length; ++n) {
                if (!Float.isNaN(this.m_x1[n]) && !Float.isNaN(this.m_y1[n])) continue;
                ++this.m_numRegions;
            }
            this.m_polyRuns = new int[this.m_numRegions][2];
            n = 0;
            int n2 = 0;
            for (int i = 0; i < this.m_x1.length; ++i) {
                if (!Float.isNaN(this.m_x1[i]) && !Float.isNaN(this.m_y1[i])) continue;
                this.m_polyRuns[n][0] = n2;
                this.m_polyRuns[n][1] = i - n2;
                ++n;
                n2 = i + 1;
            }
            this.m_polyRuns[n][0] = n2;
            this.m_polyRuns[n][1] = this.m_x1.length - n2;
        }
        if (this.m_isOneRegion) {
            this.m_numRegions = 1;
        }
        this.m_labels = this.resizeStringArrayCutTrailing(stringArray, this.m_numRegions);
        this.m_actions = this.resizeStringArrayCutTrailing(stringArray2, this.m_numRegions);
        this.m_rects = null;
        this.m_polygons = null;
        this.m_astrTags = null;
        this.m_totalBounds = null;
        this.m_imageRegionInfo = null;
        if (!this.m_isPolygons && !this.m_isOneRegion) {
            for (n = 0; n < this.m_actions.length; ++n) {
                if (this.m_actions[n] == null || this.m_actions[n].toUpperCase().indexOf("SHOWIMAGE") < 0) continue;
                XMLElement xMLElement = new XMLElement();
                Object var11_13 = null;
                try {
                    xMLElement.parseString(this.m_actions[n]);
                }
                catch (Exception exception) {
                    continue;
                }
                if (xMLElement.getTagName() == null || !xMLElement.getTagName().equalsIgnoreCase("SHOWIMAGE")) continue;
                String string = xMLElement.getProperty("HREF");
                if (string == null) {
                    string = "";
                }
                if (this.m_imageRegionInfo == null) {
                    this.m_imageRegionInfo = new ImageRegionInfo[this.m_actions.length];
                }
                this.m_imageRegionInfo[n] = new ImageRegionInfo(string, n);
            }
        }
    }

    private float[] resizeFloatArray(float[] fArray, int n) {
        if (fArray != null && fArray.length == n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        if (fArray == null) {
            return fArray2;
        }
        int n2 = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray2[i] = i < n2 ? fArray[i] : Float.NaN;
        }
        return fArray2;
    }

    private String[] resizeStringArrayCutTrailing(String[] stringArray, int n) {
        int n2;
        for (n2 = Math.min(n, stringArray == null ? 0 : stringArray.length); n2 > 0 && (stringArray[n2 - 1] == null || stringArray[n2 - 1].length() < 1); --n2) {
        }
        if (stringArray != null && stringArray.length == n2) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2];
        int n3 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i < n3) {
                stringArray2[i] = stringArray[i];
            }
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "";
        }
        return stringArray2;
    }

    String getRegionLabel(int n) {
        return n < 0 || n >= this.m_labels.length ? "" : this.m_labels[n];
    }

    String getRegionAction(int n) {
        return n < 0 || n >= this.m_actions.length ? "" : this.m_actions[n];
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        if (this.m_imageRegionInfo != null) {
            for (int i = 0; i < this.m_imageRegionInfo.length; ++i) {
                if (this.m_imageRegionInfo[i] == null) continue;
                this.m_imageRegionInfo[i].display(sCanvasAWT, graphics);
            }
        }
    }

    void highlightActiveRegions(SCanvasAWT sCanvasAWT, Graphics graphics, TagSet tagSet) {
        Rectangle rectangle = null;
        if (sCanvasAWT.getClipIdentify()) {
            rectangle = this.setParClip(sCanvasAWT, graphics);
        }
        for (int i = 0; i < this.m_numRegions; ++i) {
            String string = this.getTag(i);
            if (string == null || !tagSet.contains(string)) continue;
            this.drawActiveRegion(sCanvasAWT, graphics, i, true, true);
        }
        if (sCanvasAWT.getClipIdentify()) {
            this.resetClip(sCanvasAWT, graphics, rectangle);
        }
    }

    private void drawActiveRegion(SCanvasAWT sCanvasAWT, Graphics graphics, int n, boolean bl, boolean bl2) {
        if (this.m_isOneRegion) {
            if (n != 0) {
                return;
            }
            int n2 = this.m_isPolygons ? this.m_polyRuns.length : this.m_x1.length;
            for (int i = 0; i < n2; ++i) {
                if (this.m_isPolygons) {
                    this.drawActiveRegionPoly(sCanvasAWT, graphics, i, bl, bl2);
                    continue;
                }
                this.drawActiveRegionRect(sCanvasAWT, graphics, i, bl, bl2);
            }
        } else if (this.m_isPolygons) {
            this.drawActiveRegionPoly(sCanvasAWT, graphics, n, bl, bl2);
        } else {
            this.drawActiveRegionRect(sCanvasAWT, graphics, n, bl, bl2);
        }
    }

    private void drawActiveRegionRect(SCanvasAWT sCanvasAWT, Graphics graphics, int n, boolean bl, boolean bl2) {
        this.updateRects(sCanvasAWT);
        if (n < 0 || n >= this.m_rects.length) {
            return;
        }
        Rectangle rectangle = this.m_rects[n];
        if (rectangle == null) {
            return;
        }
        if (bl2 && (rectangle.width < 10 || rectangle.height < 10)) {
            rectangle = new Rectangle(rectangle);
            if (rectangle.width < 10) {
                rectangle.grow((10 - rectangle.width) / 2, 0);
            }
            if (rectangle.height < 10) {
                rectangle.grow(0, (10 - rectangle.height) / 2);
            }
        }
        if (bl) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void drawActiveRegionPoly(SCanvasAWT sCanvasAWT, Graphics graphics, int n, boolean bl, boolean bl2) {
        this.updatePolygons(sCanvasAWT);
        if (n < 0 || n >= this.m_polygons.length) {
            return;
        }
        Polygon polygon = this.m_polygons[n];
        if (polygon == null) {
            return;
        }
        Rectangle rectangle = polygon.getBounds();
        if (bl2 && (rectangle.width < 10 || rectangle.height < 10)) {
            rectangle = new Rectangle(rectangle);
            if (rectangle.width < 10) {
                rectangle.grow((10 - rectangle.width) / 2, 0);
            }
            if (rectangle.height < 10) {
                rectangle.grow(0, (10 - rectangle.height) / 2);
            }
            if (bl) {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            return;
        }
        if (bl) {
            graphics.fillPolygon(polygon);
        } else {
            graphics.drawPolygon(polygon);
        }
    }

    protected void updateTags() {
        if (this.m_astrTags == null) {
            this.m_tagIgnoresRectSelect = null;
            this.m_astrTags = new String[this.m_numRegions];
            for (int i = 0; i < this.m_numRegions; ++i) {
                XMLElement xMLElement = new XMLElement();
                String string = this.getRegionAction(i);
                if (string == null || string.length() == 0) {
                    this.m_astrTags[i] = null;
                    continue;
                }
                try {
                    xMLElement.parseString(string);
                }
                catch (Exception exception) {
                    this.m_astrTags[i] = null;
                    continue;
                }
                String string2 = xMLElement.getTagName();
                if (string2 != null && string2.equalsIgnoreCase("SELECT")) {
                    this.m_astrTags[i] = xMLElement.getProperty("TAG");
                    String string3 = xMLElement.getProperty("RECT");
                    if (string3 == null || !string3.equalsIgnoreCase("OFF") && !string3.equalsIgnoreCase("F") && !string3.equalsIgnoreCase("FALSE") && !string3.equalsIgnoreCase("NO")) continue;
                    if (this.m_tagIgnoresRectSelect == null) {
                        this.m_tagIgnoresRectSelect = new boolean[this.m_numRegions];
                        for (int j = 0; j < this.m_numRegions; ++j) {
                            this.m_tagIgnoresRectSelect[j] = false;
                        }
                    }
                    this.m_tagIgnoresRectSelect[i] = true;
                    continue;
                }
                this.m_astrTags[i] = null;
            }
        }
    }

    protected boolean getTagIgnoresRectSelect(int n) {
        this.updateTags();
        if (this.m_tagIgnoresRectSelect == null) {
            return false;
        }
        return this.m_tagIgnoresRectSelect[n];
    }

    protected String getTag(int n) {
        this.updateTags();
        return this.m_astrTags[n];
    }

    public boolean canHit() {
        return true;
    }

    void updateRects(SCanvasAWT sCanvasAWT) {
        if (this.m_rects != null || this.m_isPolygons) {
            return;
        }
        int n = this.m_x1.length;
        Rectangle[] rectangleArray = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            if (Float.isNaN(this.m_x1[i]) || Float.isNaN(this.m_y1[i]) || Float.isNaN(this.m_x2[i]) || Float.isNaN(this.m_x2[i])) {
                rectangleArray[i] = null;
                continue;
            }
            int n3 = this.valToWindowX(sCanvasAWT, this.m_x1[i]);
            int n4 = this.valToWindowY(sCanvasAWT, this.m_y1[i]);
            int n5 = this.valToWindowX(sCanvasAWT, this.m_x2[i]);
            int n6 = this.valToWindowY(sCanvasAWT, this.m_y2[i]);
            if (n3 > n5) {
                n2 = n3;
                n3 = n5;
                n5 = n2;
            }
            if (n4 > n6) {
                n2 = n4;
                n4 = n6;
                n6 = n2;
            }
            rectangleArray[i] = new Rectangle(n3, n4, n5 - n3 + 1, n6 - n4 + 1);
        }
        this.m_rects = rectangleArray;
    }

    void updatePolygons(SCanvasAWT sCanvasAWT) {
        if (this.m_polygons != null || !this.m_isPolygons) {
            return;
        }
        int n = this.m_polyRuns.length;
        Polygon[] polygonArray = new Polygon[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_polyRuns[i][0];
            int n3 = this.m_polyRuns[i][1];
            if (n3 < 1) {
                polygonArray[i] = null;
                continue;
            }
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            for (int j = 0; j < n3; ++j) {
                nArray[j] = this.valToWindowX(sCanvasAWT, this.m_x1[n2 + j]);
                nArray2[j] = this.valToWindowY(sCanvasAWT, this.m_y1[n2 + j]);
            }
            polygonArray[i] = new Polygon(nArray, nArray2, n3);
        }
        this.m_polygons = polygonArray;
    }

    public Rectangle getBounds(SCanvasAWT sCanvasAWT) {
        if (this.m_totalBounds != null) {
            return this.m_totalBounds;
        }
        Rectangle rectangle = null;
        if (this.m_isPolygons) {
            this.updatePolygons(sCanvasAWT);
            for (int i = 0; i < this.m_polygons.length; ++i) {
                Polygon polygon = this.m_polygons[i];
                if (polygon == null) continue;
                rectangle = rectangle == null ? new Rectangle(polygon.getBounds()) : rectangle.union(polygon.getBounds());
            }
        } else {
            this.updateRects(sCanvasAWT);
            for (int i = 0; i < this.m_rects.length; ++i) {
                Rectangle rectangle2 = this.m_rects[i];
                if (rectangle2 == null) continue;
                rectangle = rectangle == null ? new Rectangle(rectangle2) : rectangle.union(rectangle2);
            }
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        this.m_totalBounds = rectangle;
        return rectangle;
    }

    public SCanvasHit getHit(SCanvasAWT sCanvasAWT, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        if (sCanvasAWT.getClipIdentify() && !this.getClipBounds(sCanvasAWT).contains(n, n2)) {
            return null;
        }
        if (this.simpleDistanceToRect(n, n2, this.getBounds(sCanvasAWT)) > 10) {
            return null;
        }
        if (this.m_isPolygons) {
            this.updatePolygons(sCanvasAWT);
            int n5 = this.m_polygons.length;
            for (int i = 0; i < n5; ++i) {
                Polygon polygon = this.m_polygons[i];
                if (polygon == null) continue;
                if (polygon.contains(n, n2)) {
                    n3 = i;
                    n4 = 0;
                    break;
                }
                Rectangle rectangle = polygon.getBounds();
                if (rectangle.width >= 10 && rectangle.height >= 10) continue;
                int n6 = this.simpleDistanceToRect(n, n2, rectangle);
                if (n4 >= 0 && n6 >= n4) continue;
                n3 = i;
                n4 = n6;
            }
        } else {
            this.updateRects(sCanvasAWT);
            int n7 = this.m_rects.length;
            boolean bl = this.m_imageRegionInfo != null;
            for (int i = 0; i < n7; ++i) {
                Rectangle rectangle;
                if (bl && this.m_imageRegionInfo[i] != null || (rectangle = this.m_rects[i]) == null) continue;
                if (rectangle.contains(n, n2)) {
                    n3 = i;
                    n4 = 0;
                    break;
                }
                int n8 = this.simpleDistanceToRect(n, n2, rectangle);
                if (n4 >= 0 && n8 >= n4) continue;
                n3 = i;
                n4 = n8;
            }
        }
        if (n3 < 0 || n4 > 10) {
            return null;
        }
        if (this.m_isOneRegion) {
            n3 = 0;
        }
        return new Hit(n3);
    }

    private int simpleDistanceToRect(int n, int n2, Rectangle rectangle) {
        int n3 = 0;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = n4 + rectangle.width;
        int n7 = n5 + rectangle.height;
        if (n < n4) {
            n3 += n4 - n;
        }
        if (n > n6) {
            n3 += n - n6;
        }
        if (n2 < n5) {
            n3 += n5 - n2;
        }
        if (n2 > n7) {
            n3 += n2 - n7;
        }
        return n3;
    }

    public String[] getIntersectingTags(Rectangle rectangle, SCanvasAWT sCanvasAWT) {
        int n;
        Cloneable cloneable;
        if (rectangle == null || rectangle.width < 0 || rectangle.height < 0 || this.m_isOneRegion && this.getTag(0) == null || this.m_isOneRegion && this.getTagIgnoresRectSelect(0)) {
            return new String[0];
        }
        if (sCanvasAWT.getClipIdentify()) {
            cloneable = this.getClipBounds(sCanvasAWT);
            if (!rectangle.intersects((Rectangle)cloneable)) {
                return new String[0];
            }
            rectangle = rectangle.intersection((Rectangle)cloneable);
        }
        cloneable = new Vector();
        if (this.m_isPolygons) {
            this.updatePolygons(sCanvasAWT);
            for (n = 0; n < this.m_numRegions; ++n) {
                String string = this.getTag(n);
                Polygon polygon = this.m_polygons[n];
                if (this.getTagIgnoresRectSelect(n) || string == null || polygon == null || !this.polygonIntersectsRectangle(polygon, rectangle)) continue;
                if (this.m_isOneRegion) {
                    return new String[]{this.getTag(0)};
                }
                ((Vector)cloneable).addElement(string);
            }
        } else {
            this.updateRects(sCanvasAWT);
            for (n = 0; n < this.m_numRegions; ++n) {
                String string = this.getTag(n);
                Rectangle rectangle2 = this.m_rects[n];
                if (this.getTagIgnoresRectSelect(n) || string == null || rectangle2 == null || !rectangle.intersects(rectangle2)) continue;
                if (this.m_isOneRegion) {
                    return new String[]{this.getTag(0)};
                }
                ((Vector)cloneable).addElement(string);
            }
        }
        Object[] objectArray = new String[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto(objectArray);
        return objectArray;
    }

    private boolean polygonIntersectsRectangle(Polygon polygon, Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = polygon.getBounds();
        if (!rectangle2.intersects(rectangle)) {
            return false;
        }
        int n2 = polygon.npoints;
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        for (n = 0; n < n2; ++n) {
            if (!rectangle.contains(nArray[n], nArray2[n])) continue;
            return true;
        }
        if (polygon.contains(rectangle.x, rectangle.y) || polygon.contains(rectangle.x + rectangle.width, rectangle.y) || polygon.contains(rectangle.x, rectangle.y + rectangle.height) || polygon.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
            return true;
        }
        n = nArray[n2 - 1];
        int n3 = nArray2[n2 - 1];
        for (int i = 0; i < n2; ++i) {
            int n4 = nArray[i];
            int n5 = nArray2[i];
            if (this.lineIntersectsRectangle(n, n3, n4, n5, rectangle)) {
                return true;
            }
            n = n4;
            n3 = n5;
        }
        return false;
    }

    private boolean lineIntersectsRectangle(int n, int n2, int n3, int n4, Rectangle rectangle) {
        if (rectangle.contains(n, n2) || rectangle.contains(n3, n4)) {
            return true;
        }
        if (rectangle.x > Math.max(n, n3) || rectangle.y > Math.max(n2, n4) || rectangle.x + rectangle.width < Math.min(n, n3) || rectangle.y + rectangle.height < Math.min(n2, n4)) {
            return false;
        }
        return this.lineIntersectsLine(n, n2, n3, n4, rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height) || this.lineIntersectsLine(n, n2, n3, n4, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y) || this.lineIntersectsLine(n, n2, n3, n4, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height) || this.lineIntersectsLine(n, n2, n3, n4, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    private boolean lineIntersectsLine(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = (n3 - n) * (n8 - n6) - (n4 - n2) * (n7 - n5);
        if (n9 == 0) {
            return false;
        }
        int n10 = (n2 - n6) * (n7 - n5) - (n - n5) * (n8 - n6);
        if (n10 == 0) {
            return true;
        }
        double d = (double)n10 / (double)n9;
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        int n11 = (n2 - n6) * (n3 - n) - (n - n5) * (n4 - n2);
        double d2 = (double)n11 / (double)n9;
        return !(d2 < 0.0) && !(d2 > 1.0);
    }

    void graphSizeChanged() {
        this.m_rects = null;
        this.m_polygons = null;
        this.m_totalBounds = null;
    }

    public String getXMLTag() {
        return "IDENTIFY";
    }

    public void writeXMLContents(PrintWriter printWriter) {
        this.writeXMLBoolean(printWriter, "ONE.REGION", this.m_isOneRegion);
        this.writeXMLBoolean(printWriter, "POLYGONS", this.m_isPolygons);
        XML.writeData(printWriter, "X1", this.m_x1);
        XML.writeData(printWriter, "Y1", this.m_y1);
        XML.writeData(printWriter, "X2", this.m_x2);
        XML.writeData(printWriter, "Y2", this.m_y2);
        XML.writeData(printWriter, "LABELS", this.m_labels);
        XML.writeData(printWriter, "ACTIONS", this.m_actions);
    }

    private void writeXMLBoolean(PrintWriter printWriter, String string, boolean bl) {
        XML.writeData(printWriter, string, new String[]{bl ? "true" : "false"});
    }

    private static boolean readXMLBoolean(XMLElement xMLElement, String string, boolean bl) {
        String[] stringArray = XML.getStringArrayData(xMLElement, string);
        if (stringArray == null || stringArray.length < 1 || stringArray[0] == null) {
            return bl;
        }
        String string2 = stringArray[0].toLowerCase();
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        return bl;
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        boolean bl = SGraphIdentify.readXMLBoolean(xMLElement, "ONE.REGION", false);
        boolean bl2 = SGraphIdentify.readXMLBoolean(xMLElement, "POLYGONS", false);
        float[] fArray = XML.getFloatArrayData(xMLElement, "X1");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y1");
        float[] fArray3 = XML.getFloatArrayData(xMLElement, "X2");
        float[] fArray4 = XML.getFloatArrayData(xMLElement, "Y2");
        String[] stringArray = XML.getStringArrayData(xMLElement, "LABELS");
        String[] stringArray2 = XML.getStringArrayData(xMLElement, "ACTIONS");
        return new SGraphIdentify(fArray, fArray2, fArray3, fArray4, stringArray, stringArray2, bl2, bl);
    }

    public void releaseMemory() {
        this.m_rects = null;
        this.m_polygons = null;
        this.m_astrTags = null;
        this.m_tagIgnoresRectSelect = null;
        this.m_totalBounds = null;
    }

    protected class Hit
    implements SCanvasHitRegion {
        int m_hitRegionNum = 0;

        Hit(int n) {
            this.m_hitRegionNum = n;
        }

        public SGraphCommand getCmd() {
            return SGraphIdentify.this;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Hit)) {
                return false;
            }
            Hit hit = (Hit)object;
            return this.m_hitRegionNum == hit.m_hitRegionNum && this.getCmd() == hit.getCmd();
        }

        public Rectangle getRectangle(SCanvasAWT sCanvasAWT) {
            Rectangle rectangle = null;
            if (SGraphIdentify.this.m_isOneRegion) {
                rectangle = new Rectangle(SGraphIdentify.this.getBounds(sCanvasAWT));
            } else if (SGraphIdentify.this.m_isPolygons) {
                SGraphIdentify.this.updatePolygons(sCanvasAWT);
                rectangle = new Rectangle(SGraphIdentify.this.m_polygons[this.m_hitRegionNum].getBounds());
            } else {
                SGraphIdentify.this.updateRects(sCanvasAWT);
                rectangle = new Rectangle(SGraphIdentify.this.m_rects[this.m_hitRegionNum]);
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            if (sCanvasAWT.getClipIdentify()) {
                Rectangle rectangle2 = SGraphIdentify.this.getClipBounds(sCanvasAWT);
                rectangle = rectangle2.intersects(rectangle) ? rectangle.intersection(rectangle2) : new Rectangle();
            }
            rectangle.grow(8, 8);
            return rectangle;
        }

        public String getLabel() {
            return SGraphIdentify.this.getRegionLabel(this.m_hitRegionNum);
        }

        public String getAction() {
            return SGraphIdentify.this.getRegionAction(this.m_hitRegionNum);
        }

        public void drawRegion(SCanvasAWT sCanvasAWT, Graphics graphics) {
            Rectangle rectangle = null;
            if (sCanvasAWT.getClipIdentify()) {
                rectangle = SGraphIdentify.this.setParClip(sCanvasAWT, graphics);
            }
            SGraphIdentify.this.drawActiveRegion(sCanvasAWT, graphics, this.m_hitRegionNum, false, true);
            if (sCanvasAWT.getClipIdentify()) {
                SGraphIdentify.this.resetClip(sCanvasAWT, graphics, rectangle);
            }
        }

        public void fillRegion(SCanvasAWT sCanvasAWT, Graphics graphics) {
            Rectangle rectangle = null;
            if (sCanvasAWT.getClipIdentify()) {
                rectangle = SGraphIdentify.this.setParClip(sCanvasAWT, graphics);
            }
            SGraphIdentify.this.drawActiveRegion(sCanvasAWT, graphics, this.m_hitRegionNum, true, true);
            if (sCanvasAWT.getClipIdentify()) {
                SGraphIdentify.this.resetClip(sCanvasAWT, graphics, rectangle);
            }
        }

        public boolean drawRegionSupportsXOR() {
            return !SGraphIdentify.this.m_isPolygons && !SGraphIdentify.this.m_isOneRegion;
        }
    }

    protected class ImageRegionInfo {
        private Image m_grabbedImage = null;
        private int m_width = -1;
        private int m_height = -1;
        private String m_location = null;
        private int m_cmdNum = 0;
        private boolean m_failedGettingImage = false;

        ImageRegionInfo(String string, int n) {
            this.m_location = string;
            this.m_cmdNum = n;
        }

        void initImage(SCanvasAWT sCanvasAWT) {
            block6: {
                if (this.m_failedGettingImage) {
                    return;
                }
                if (this.m_grabbedImage != null) {
                    return;
                }
                this.m_failedGettingImage = true;
                this.m_width = -1;
                this.m_height = -1;
                try {
                    URL uRL = new URL(sCanvasAWT.getDocumentBase(), this.m_location);
                    Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                    MediaTracker mediaTracker = new MediaTracker(SGraphCommand.getCreateImageComponent());
                    mediaTracker.addImage(image, 0);
                    mediaTracker.waitForID(0, 1000L);
                    int n = 0;
                    while (true) {
                        this.m_width = image.getWidth(null);
                        this.m_height = image.getHeight(null);
                        if (this.m_width >= 0 && this.m_height >= 0) break;
                        if (n > 3) {
                            throw new Exception("can't access image");
                        }
                        Thread.sleep(100L);
                        ++n;
                    }
                    this.m_grabbedImage = image;
                    this.m_failedGettingImage = false;
                }
                catch (Throwable throwable) {
                    if (!sCanvasAWT.getDebug() && !sCanvasAWT.getInApplet()) break block6;
                    System.out.println("Error retrieving image " + this.m_location + ": " + throwable);
                }
            }
        }

        void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
            this.initImage(sCanvasAWT);
            SGraphIdentify.this.updateRects(sCanvasAWT);
            Rectangle rectangle = SGraphIdentify.this.m_rects[this.m_cmdNum];
            if (rectangle == null) {
                return;
            }
            if (this.m_failedGettingImage || this.m_grabbedImage == null) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(Color.black);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.drawRect(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4, rectangle.width / 2, rectangle.height / 2);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            } else {
                graphics.drawImage(this.m_grabbedImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
        }
    }
}

