/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class ClassificationAssessmentEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    private int m_numInputs = 0;
    private int m_numBins = 0;
    private int[] m_depColumnNum = null;
    private int[] m_predColumnNum = null;
    private double[] m_predictedLevel = null;
    private double[] m_totalCountSum = null;
    private double[] m_totalPositiveSum = null;
    private double[][] m_totalCount = null;
    private double[][] m_positiveCount = null;
    private ByColumnStatisticAccumulator.ByContinuousColumnStats[] m_decileMaker = null;
    private double[][] m_decileBounds = null;
    private boolean[] m_makeDeciles = null;
    private long[] m_totalRows = null;
    public static String TOTAL_COUNT_SUM_ATTRIBUTE_TAG = "totalCountSum";
    public static String POSITIVE_COUNT_SUM_ATTRIBUTE_TAG = "positiveCountSum";
    public static String COUNTS_ATTRIBUTE_TAG = "counts";
    public static String BOUNDARIES_ATTRIBUTE_TAG = "boundaries";
    public static String TOTAL_COUNT_ATTRIBUTE_TAG = "totalCount";
    public static String POSITIVE_COUNT_ATTRIBUTE_TAG = "positiveCount";
    public static String NUM_BINS_ATTRIBUTE_TAG = "numBins";
    public static String ASSESSMENT_NODE_CACHE = "assessment.cache";
    public static String USE_ROLE_INFO_ATTRIBUTE_TAG = "useRole";
    public static String DEPENDENT_COLUMN_ATTRIBUTE_TAG = "depColumn";
    public static String EVAL_COLUMN_ATTRIBUTE_TAG = "evalColumn";
    public static String INPUTS_ATTRIBUTE_TAG = "inputs";
    public static String TITLE_ATTRIBUTE_TAG = "nodeTitle";
    public static String INPUT_PREFIX_TAG = "#";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        try {
            this.m_numInputs = this.getNumInputs();
            this.m_numBins = 10;
            this.m_totalCount = new double[this.m_numInputs][this.m_numBins];
            this.m_positiveCount = new double[this.m_numInputs][this.m_numBins];
            this.m_depColumnNum = new int[this.m_numInputs];
            this.m_predColumnNum = new int[this.m_numInputs];
            this.m_totalCountSum = new double[this.m_numInputs];
            this.m_totalPositiveSum = new double[this.m_numInputs];
            this.m_predictedLevel = new double[this.m_numInputs];
            this.m_decileMaker = new ByColumnStatisticAccumulator.ByContinuousColumnStats[this.m_numInputs];
            this.m_decileBounds = new double[this.m_numInputs][this.m_numBins];
            this.m_makeDeciles = new boolean[this.m_numInputs];
            this.m_totalRows = new long[this.m_numInputs];
            String[] path = new String[]{INPUTS_ATTRIBUTE_TAG, "", ""};
            XTProps props = this.getNodeProperties();
            Vector inputs = props.getSubProperties(INPUTS_ATTRIBUTE_TAG);
            for (int i = inputs.size(); i < this.m_numInputs; ++i) {
                inputs.add("NoData");
            }
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                String inputNodeName = this.getInputNodeName(inputNum);
                String inputNodeID = (String)inputs.get(inputNum);
                XTMetaData md = this.getInputMetaData(inputNum);
                path[1] = inputNodeID;
                path[2] = USE_ROLE_INFO_ATTRIBUTE_TAG;
                boolean useRoles = props.getBoolean(path, true);
                String depName = "";
                if (useRoles) {
                    Vector depVars = md.getDataFieldsWithRole(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
                    depName = depVars.size() < 1 ? "" : (String)depVars.get(0);
                } else {
                    path[2] = DEPENDENT_COLUMN_ATTRIBUTE_TAG;
                    depName = props.getValue(path);
                }
                this.m_depColumnNum[inputNum] = md.nameToOrdinal(depName);
                if (this.m_depColumnNum[inputNum] < 0) {
                    this.printlnWarning(this.getNodeName() + ": the dependent column was not found in input from " + inputNodeName + ".");
                    continue;
                }
                Vector depLevels = md.getCategoricalDataFieldLevels(depName);
                int iAlphabeticallyLastLevel = -1;
                String sAlphabeticallyLastLevel = null;
                for (int i = 0; i < depLevels.size(); ++i) {
                    String level = (String)depLevels.get(i);
                    if (i == 0) {
                        sAlphabeticallyLastLevel = level;
                        iAlphabeticallyLastLevel = 0;
                        continue;
                    }
                    if (sAlphabeticallyLastLevel.compareTo(level) >= 0) continue;
                    sAlphabeticallyLastLevel = level;
                    iAlphabeticallyLastLevel = i;
                }
                if (useRoles) {
                    this.m_predColumnNum[inputNum] = md.nameToOrdinal("PREDICT.prob");
                    if (this.m_predColumnNum[inputNum] == -1) {
                        Vector predVars = md.getDataFieldsWithRole(XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG);
                        this.m_predictedLevel[inputNum] = iAlphabeticallyLastLevel;
                        this.m_predColumnNum[inputNum] = md.nameToOrdinal("Pr(" + sAlphabeticallyLastLevel + ")");
                        if (this.m_predColumnNum[inputNum] == -1) {
                            for (int i = 0; i < predVars.size(); ++i) {
                                String predCol = (String)predVars.get(i);
                                if (!predCol.startsWith("Pr(")) continue;
                                this.m_predColumnNum[inputNum] = md.nameToOrdinal(predCol);
                                String desiredLevel = predCol.substring(3, predCol.length() - 1);
                                this.m_predictedLevel[inputNum] = depLevels.indexOf(desiredLevel);
                                break;
                            }
                        }
                    } else {
                        this.m_predictedLevel[inputNum] = iAlphabeticallyLastLevel;
                    }
                } else {
                    path[2] = EVAL_COLUMN_ATTRIBUTE_TAG;
                    String pred = props.getValue(path);
                    this.m_predColumnNum[inputNum] = md.nameToOrdinal(pred);
                    if (pred.startsWith("Pr(")) {
                        String desiredLevel = pred.substring(3, pred.length() - 1);
                        this.m_predictedLevel[inputNum] = depLevels.indexOf(desiredLevel);
                    } else {
                        this.m_predictedLevel[inputNum] = iAlphabeticallyLastLevel;
                    }
                }
                if (this.m_predColumnNum[inputNum] < 0) {
                    this.printlnWarning(this.getNodeName() + ": probability column not found in " + inputNodeName + ".");
                } else if (!md.getColumnType(this.m_predColumnNum[inputNum]).equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    this.printlnWarning(this.getNodeName() + ": probability column is not continuous in input from " + inputNodeName);
                    this.m_predColumnNum[inputNum] = -1;
                }
                double min = md.getColumnMin(this.m_predColumnNum[inputNum]);
                double max = md.getColumnMax(this.m_predColumnNum[inputNum]);
                long rowCount = md.getNumRows();
                this.m_decileMaker[inputNum] = new ByColumnStatisticAccumulator.ByContinuousColumnStats(1, min, max, rowCount, this.m_numBins, 100);
                this.m_totalRows[inputNum] = md.getNumRows();
                this.m_makeDeciles[inputNum] = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        boolean results = false;
        for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
            if (this.m_depColumnNum[inputNum] < 0 || this.m_predColumnNum[inputNum] < 0) continue;
            results = true;
            double[] depVarData = proc.getChunkInputColumnData(inputNum, this.m_depColumnNum[inputNum]);
            double[] predictVarData = proc.getChunkInputColumnData(inputNum, this.m_predColumnNum[inputNum]);
            int inputRows = proc.getChunkInputRows(inputNum);
            for (int row = 0; row < inputRows; ++row) {
                double dep = depVarData[row];
                double pred = predictVarData[row];
                if (this.m_makeDeciles[inputNum]) {
                    this.m_decileMaker[inputNum].updateBinAndRowCount(pred);
                    continue;
                }
                int binNum = 0;
                for (int decile = this.m_numBins - 1; decile >= 0; --decile) {
                    double boundary = this.m_decileBounds[inputNum][decile];
                    if (!(boundary <= pred)) continue;
                    binNum = decile;
                    break;
                }
                double[] dArray = this.m_totalCount[inputNum];
                int n = binNum;
                dArray[n] = dArray[n] + 1.0;
                int n2 = inputNum;
                this.m_totalCountSum[n2] = this.m_totalCountSum[n2] + 1.0;
                if (dep != this.m_predictedLevel[inputNum]) continue;
                double[] dArray2 = this.m_positiveCount[inputNum];
                int n3 = binNum;
                dArray2[n3] = dArray2[n3] + 1.0;
                int n4 = inputNum;
                this.m_totalPositiveSum[n4] = this.m_totalPositiveSum[n4] + 1.0;
            }
            if (!this.m_makeDeciles[inputNum] || proc.getChunkInputPosition(inputNum) + (long)proc.getChunkInputRows(inputNum) != this.m_totalRows[inputNum]) continue;
            proc.setChunkNextInputPosition(inputNum, 0L);
            for (int decileNum = 1; decileNum < this.m_numBins; ++decileNum) {
                this.m_decileBounds[inputNum][decileNum] = this.m_decileMaker[inputNum].getQuantileBound(decileNum - 1);
            }
            this.m_makeDeciles[inputNum] = false;
        }
        if (proc.getChunkInputPosition(0) == 0L && !results) {
            proc.setError("no classification data was found in input.");
        }
    }

    public void procExtractResults(CNKProc proc) {
        try {
            XTProps props = new XTProps();
            props.set(NUM_BINS_ATTRIBUTE_TAG, this.m_numBins);
            String[] path = new String[3];
            String[] sumPath = new String[2];
            for (int inputNum = 0; inputNum < this.m_numInputs; ++inputNum) {
                path[0] = INPUT_PREFIX_TAG + Integer.toString(inputNum);
                if (this.m_depColumnNum[inputNum] < 0 || this.m_predColumnNum[inputNum] < 0) {
                    props.set(path[0], "");
                    continue;
                }
                props.set(path[0], TITLE_ATTRIBUTE_TAG, this.getInputNodeName(inputNum));
                sumPath[0] = path[0];
                sumPath[1] = TOTAL_COUNT_SUM_ATTRIBUTE_TAG;
                props.set(sumPath, Double.toString(this.m_totalCountSum[inputNum]));
                sumPath[1] = POSITIVE_COUNT_SUM_ATTRIBUTE_TAG;
                props.set(sumPath, Double.toString(this.m_totalPositiveSum[inputNum]));
                for (int i = 0; i < this.m_numBins; ++i) {
                    path[2] = Integer.toString(i);
                    path[1] = TOTAL_COUNT_ATTRIBUTE_TAG;
                    props.set(path, Double.toString(this.m_totalCount[inputNum][i]));
                    path[1] = POSITIVE_COUNT_ATTRIBUTE_TAG;
                    props.set(path, Double.toString(this.m_positiveCount[inputNum][i]));
                    if (i == 0) continue;
                    path[2] = Integer.toString(i - 1);
                    path[1] = BOUNDARIES_ATTRIBUTE_TAG;
                    props.set(path, Double.toString(this.m_decileBounds[inputNum][i]));
                }
            }
            this.setNodeCache(ASSESSMENT_NODE_CACHE, props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

