/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcPrinComp;
import com.insightful.cnkjava.CNKProcPrinCompPredict;
import com.insightful.miner.ColumnDefinitions;
import com.insightful.miner.CorrelationsEngineNode;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class PrincipalComponentEngineNode
extends EngineNode {
    private String m_modelFilePath = null;
    public static final String PERCENT_VARIATION_EXPLAINED_ATTRIBUTE_TAG = "percentVariationExplained";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean hasDynamicOutputs() {
        return true;
    }

    private void eraseModelFilePath() {
        if (this.m_modelFilePath == null) {
            return;
        }
        File modelFile = new File(this.m_modelFilePath);
        if (modelFile.exists()) {
            modelFile.delete();
        }
        this.m_modelFilePath = null;
    }

    public void procExtractResults(CNKProc proc) {
        File modelFile;
        if (!(proc instanceof CNKProcPrinComp)) {
            return;
        }
        this.setNodeCache("model", null);
        this.eraseModelFilePath();
        try {
            modelFile = this.createWorkspaceTempFile("PCA", ".xml");
            this.m_modelFilePath = modelFile.getPath();
        }
        catch (IOException ex) {
            this.printlnError("could not create temporary file name: " + ex);
            return;
        }
        ((CNKProcPrinComp)proc).writeModelToFile(this.m_modelFilePath);
        modelFile = new File(this.m_modelFilePath);
        if (!modelFile.exists()) {
            this.eraseModelFilePath();
            this.printlnDebug("PCA xml file " + this.m_modelFilePath + " doesn't exist");
            return;
        }
        long totalBytes = modelFile.length();
        this.printlnInformation("reading principal component model xml file " + this.m_modelFilePath + " (" + totalBytes + " bytes)");
        XMLTree xt = null;
        try {
            xt = XMLTree.readFromFile(this.m_modelFilePath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.printlnError("error reading PCA model xml file " + this.m_modelFilePath + ": " + ex);
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("out of memory reading cache file " + this.m_modelFilePath + " (" + totalBytes + " bytes)");
        }
        if (xt == null) {
            this.eraseModelFilePath();
        }
        this.setNodeCache("model", xt);
    }

    public Vector getOutputSpecs() {
        try {
            return PredictEngineNode.getDimensionReductionOutputSpecs(this.getInputMetaData(0), this.getNodeProperties(), this.getModel());
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public String getDataDictionaryAsString() throws Exception {
        int i;
        XTProps props = this.getNodeProperties();
        Vector varNames = props.getSubProperties("featureVariables");
        Vector<String> allNames = new Vector<String>(varNames);
        String weights = props.getValue("weightedColumn");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            allNames.add(weights);
        }
        XTMetaData md = this.getInputMetaData(0);
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), ColumnDefinitions.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            for (i = 0; i < varNames.size(); ++i) {
                if (!weights.equals((String)varNames.get(i))) continue;
                throw new Exception("Variable " + weights + " cannot have both the weights and variable roles");
            }
            mdModel.setDataFieldRole(weights, "weights");
        }
        return mdModel.writeToString();
    }

    public boolean executeDataCacheProc() throws Exception {
        XTProps props = this.getNodeProperties();
        Vector vars = props.getSubProperties("featureVariables");
        if (vars.size() <= 0) {
            throw new Exception("Cannot compute principle components: No feature variables selected");
        }
        boolean ok = true;
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        this.eraseModelFilePath();
        CNKProcPrinComp proc1 = new CNKProcPrinComp();
        proc1.setModel(this.getDataDictionaryAsString());
        proc1.setCorrelationsFlag(props.getBoolean(CorrelationsEngineNode.CORRELATIONS_ATTRIBUTE_TAG, true));
        proc1.setPercentVar(props.getInt(PERCENT_VARIATION_EXPLAINED_ATTRIBUTE_TAG, Integer.parseInt("90")));
        this.printlnVerbose("principal component: creating model");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        boolean bl = this.m_modelFilePath != null;
        this.procDelete(proc1);
        if (!(ok &= bl)) {
            return ok;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            this.eraseModelFilePath();
            return ok;
        }
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        this.setOutputMetaData(0, this.calculateOutputMetaData(0));
        CNKProcPrinCompPredict proc2 = new CNKProcPrinCompPredict();
        proc2.setModel(this.m_modelFilePath);
        PredictEngineNode.defineOutputsFromSpecs(proc2, outputSpecs);
        this.printlnVerbose("principal component: predicting from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.eraseModelFilePath();
        this.procDelete(proc2);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }
}

