/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SelectData;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ReorderColumnsDialog
extends NodeDialog {
    private static ReorderColumnsDialog instance = null;
    private int m_rowHeight = 25;
    private int m_iconWidth = 75;
    private static final int g_newOrderColumn = 0;
    private static final int g_origOrderColumn = 2;
    private static final int g_inputNameColumn = 1;
    private JComboBox m_numInputs;
    private ReorderTableModel m_tableModel;
    private NodeDialog.DialogTable m_table;
    private AbstractAction upAction;
    private AbstractAction downAction;
    private AbstractAction topAction;
    private AbstractAction bottomAction;
    private AbstractAction setAction;

    public static ReorderColumnsDialog getInstance() {
        if (instance == null) {
            instance = new ReorderColumnsDialog();
        }
        return instance;
    }

    private ReorderColumnsDialog() {
        Dimension dim = new Dimension(400, 525);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        super.restoreProperties();
        try {
            XTMetaData md = this.getNodeModel().getInputMetaData(0);
            XTProps props = this.getNodeModel().getXTProps();
            this.m_tableModel.clearTable();
            Vector propColNames = props.getSubPropertyValues(SelectData.COL_NAMES_ATTRIBUTE_TAG);
            Vector mdColNames = md.getColumnNames();
            Vector unknownColNames = new Vector(propColNames);
            unknownColNames.removeAll(mdColNames);
            propColNames.removeAll(unknownColNames);
            if (propColNames.size() != mdColNames.size()) {
                for (int i = 0; i < mdColNames.size(); ++i) {
                    String colName = (String)mdColNames.get(i);
                    if (propColNames.contains(colName)) continue;
                    propColNames.add(colName);
                }
            }
            int nRows = propColNames.size();
            for (int i = 0; i < nRows; ++i) {
                Vector<String> row = new Vector<String>();
                row.setSize(3);
                String cName = (String)propColNames.get(i);
                int origLoc = md.nameToOrdinal(cName);
                if (origLoc == -1) continue;
                row.setElementAt(Integer.toString(origLoc + 1), 2);
                row.setElementAt(cName, 1);
                row.setElementAt(Integer.toString(i + 1), 0);
                this.m_tableModel.addRow(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        try {
            XTMetaData md = this.getNodeModel().getInputMetaData(0);
            XTProps props = this.getNodeModel().getXTProps();
            int nRows = this.m_table.getRowCount();
            props.removeProperty(new String[]{SelectData.COL_NAMES_ATTRIBUTE_TAG});
            props.removeProperty(new String[]{SelectData.COL_NUMS_ATTRIBUTE_TAG});
            String[] path = new String[]{"", ""};
            for (int i = 0; i < nRows; ++i) {
                String colName = (String)this.m_tableModel.getValueAt(i, 1);
                String origLoc = (String)this.m_tableModel.getValueAt(i, 2);
                path[1] = Integer.toString(i);
                path[0] = SelectData.COL_NAMES_ATTRIBUTE_TAG;
                props.set(path, colName);
                path[0] = SelectData.COL_NUMS_ATTRIBUTE_TAG;
                props.set(path, origLoc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createActions() {
        super.createActions();
        this.upAction = new AbstractAction(MinerApp.getText("ReorderColumnsDialog_up")){

            public void actionPerformed(ActionEvent e) {
                ReorderColumnsDialog.this.upDownRows(true);
            }
        };
        this.downAction = new AbstractAction(MinerApp.getText("ReorderColumnsDialog_down")){

            public void actionPerformed(ActionEvent e) {
                ReorderColumnsDialog.this.upDownRows(false);
            }
        };
        this.topAction = new AbstractAction(MinerApp.getText("ReorderColumnsDialog_top")){

            public void actionPerformed(ActionEvent e) {
                ReorderColumnsDialog.this.topBottomRows(true);
            }
        };
        this.bottomAction = new AbstractAction(MinerApp.getText("ReorderColumnsDialog_bottom")){

            public void actionPerformed(ActionEvent e) {
                ReorderColumnsDialog.this.topBottomRows(false);
            }
        };
        this.setAction = new AbstractAction(MinerApp.getText("ReorderColumnsDialog_set")){

            public void actionPerformed(ActionEvent e) {
                int[] rows = ReorderColumnsDialog.this.m_table.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    return;
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel("Enter Position: "), "West");
                JTextField pos = new JTextField();
                pos.setDocument(new NodeDialog.InputIntegerDoc());
                panel.add((Component)pos, "Center");
                int ok = AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), panel, "Set Position", 1);
                if (ok == 0) {
                    int newPos = Integer.parseInt(pos.getText()) - 1;
                    if (newPos == rows[0]) {
                        return;
                    }
                    int val = 0;
                    val = newPos < rows[0] ? newPos - rows[0] : newPos - rows[rows.length - 1];
                    ReorderColumnsDialog.this.moveRows(val);
                }
            }
        };
    }

    private void moveRows(int val) {
        int i;
        if (val == 0) {
            return;
        }
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        int nRows = this.m_table.getRowCount();
        int[] rows = this.m_table.getSelectedRows();
        int[] newRows = new int[rows.length];
        if (rows == null || rows.length == 0) {
            return;
        }
        if (val > 0) {
            for (i = rows.length - 1; i >= 0; --i) {
                newRows[i] = rows[i] + val;
                this.m_tableModel.moveRows(rows[i], newRows[i]);
            }
        } else {
            for (i = 0; i < rows.length; ++i) {
                newRows[i] = rows[i] + val;
                this.m_tableModel.moveRows(rows[i], newRows[i]);
            }
        }
        this.m_tableModel.fireTableDataChanged();
        ListSelectionModel model = this.m_table.getSelectionModel();
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            if (newRows[i2] < 0 || newRows[i2] >= nRows) continue;
            model.addSelectionInterval(newRows[i2], newRows[i2]);
        }
    }

    private void topBottomRows(boolean top) {
        int nRows = this.m_table.getRowCount();
        int[] rows = this.m_table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        int val = top ? 0 - rows[0] : nRows - rows[rows.length - 1] - 1;
        this.moveRows(val);
    }

    private void upDownRows(boolean up) {
        this.moveRows(up ? -1 : 1);
    }

    public JPanel createOptionsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        Insets margins = new Insets(5, 5, 5, 5);
        this.m_tableModel = new ReorderTableModel();
        this.m_table = new NodeDialog.DialogTable(this.m_tableModel);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.setTableProperties();
        JScrollPane scrollingTable = new JScrollPane(this.m_table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        JButton up = new JButton(this.upAction);
        JButton down = new JButton(this.downAction);
        JButton top = new JButton(this.topAction);
        JButton bottom = new JButton(this.bottomAction);
        JButton set = new JButton(this.setAction);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = margins;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        buttonsPanel.add((Component)top, gbc);
        gbc.gridy = 1;
        buttonsPanel.add((Component)up, gbc);
        gbc.gridy = 2;
        buttonsPanel.add((Component)set, gbc);
        gbc.gridy = 3;
        buttonsPanel.add((Component)down, gbc);
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        buttonsPanel.add((Component)bottom, gbc);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = margins;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        leftPanel.add((Component)scrollingTable, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        leftPanel.add((Component)buttonsPanel, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = margins;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        panel.add((Component)leftPanel, gbc);
        return panel;
    }

    public void setTableProperties() {
        ActivityNodeModel model = this.getNodeModel();
        if (model != null) {
            this.m_table.setRowHeight(this.m_rowHeight);
        }
        int columnCount = this.m_tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String cName = this.m_table.getColumnName(i);
            TableColumn column = this.m_table.getColumn(cName);
            if (i == 1) {
                column.setPreferredWidth(new JLabel((String)cName).getPreferredSize().width * 4);
            } else {
                column.setPreferredWidth(new JLabel((String)cName).getPreferredSize().width * 2);
            }
            column.setCellRenderer(new CellRenderer());
        }
    }

    private static class CellRenderer
    extends NodeDialog.LeftJustifiedStringRenderer {
        private static Color g_disabledColor = null;

        private CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                if (g_disabledColor == null) {
                    JTextField tf = new JTextField();
                    tf.setEnabled(false);
                    tf.setEditable(false);
                    g_disabledColor = tf.getBackground();
                }
                comp.setBackground(g_disabledColor);
            }
            return comp;
        }
    }

    private class RowNumberModel
    extends AbstractListModel {
        private ReorderTableModel m_model;

        public RowNumberModel(ReorderTableModel model) {
            this.m_model = model;
        }

        public int getSize() {
            return this.m_model.getRowCount();
        }

        public Object getElementAt(int index) {
            return "" + (index + 1);
        }
    }

    private class ReorderTableModel
    extends DefaultTableModel {
        private Vector m_columnNames = new Vector();

        public ReorderTableModel() {
            this.setColumnNames();
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return Integer.toString(row + 1);
            }
            return super.getValueAt(row, col);
        }

        private void setColumnNames() {
            this.m_columnNames.clear();
            this.m_columnNames.setSize(3);
            this.m_columnNames.setElementAt(MinerApp.getText("ReorderColumnsDialog_origOrder"), 2);
            this.m_columnNames.setElementAt(MinerApp.getText("ReorderColumnsDialog_column"), 1);
            this.m_columnNames.setElementAt(MinerApp.getText("ReorderColumnsDialog_newOrder"), 0);
            this.setColumnIdentifiers(this.m_columnNames);
            if (ReorderColumnsDialog.this.m_tableModel != null) {
                ReorderColumnsDialog.this.setTableProperties();
            }
        }

        public void swapRows(int currentRow, int desiredRow) {
            int nRows = this.dataVector.size();
            if (desiredRow < 0 || desiredRow > nRows - 1 || currentRow < 0 || currentRow > nRows - 1) {
                return;
            }
            Vector rowToMove = (Vector)this.dataVector.get(currentRow);
            Vector rowToReplace = (Vector)this.dataVector.get(desiredRow);
            Object newOrderTemp = rowToMove.get(0);
            rowToMove.setElementAt(rowToReplace.get(0), 0);
            rowToReplace.setElementAt(newOrderTemp, 0);
            this.dataVector.setElementAt(rowToMove, desiredRow);
            this.dataVector.setElementAt(rowToReplace, currentRow);
        }

        public void moveRows(int currentRow, int desiredRow) {
            int nRows = this.dataVector.size();
            if (desiredRow < 0 || desiredRow > nRows - 1 || currentRow < 0 || currentRow > nRows - 1) {
                return;
            }
            Vector tmp = (Vector)this.dataVector.get(currentRow);
            int inc = currentRow < desiredRow ? -1 : 1;
            for (int i = desiredRow; i != currentRow; i += inc) {
                Vector v = tmp;
                tmp = (Vector)this.dataVector.get(i);
                Object newOrderTemp = tmp.get(0);
                tmp.setElementAt(v.get(0), 0);
                v.setElementAt(newOrderTemp, 0);
                this.dataVector.setElementAt(v, i);
            }
            this.dataVector.setElementAt(tmp, currentRow);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

