/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.DataPanel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.tree.gui.ColorBroker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class StatsPanel
extends JPanel {
    public static Font statsFont = MinerApp.getFont(0, 9);
    private Vector labelVector = new Vector();
    private DataPanel dataPanel = null;
    private JPanel countPanel = null;
    private JPanel panel = null;
    private int panelSize = 0;
    private JScrollPane textscrollpane = null;
    private ChartBuilder chartBuilder = null;
    JLabel count_label = null;
    JLabel missing_label = null;
    JLabel min_label = null;
    JLabel max_label = null;
    JLabel mean_label = null;
    JLabel stdev_label = null;
    boolean myPrintBegun = false;
    Dimension myPrintDocSize = null;
    Point myPrintDocTopLeft = null;
    Rectangle2D.Double myPrintPageRect = null;
    int myPrintNumPagesAcross = 1;
    int myPrintNumPagesDown = 1;
    double myPrintHorizScale = 1.0;
    double myPrintVertScale = 1.0;

    public StatsPanel(String column, Hashtable conditions, ChartBuilder cb, DataPanel dp) {
        this.dataPanel = dp;
        this.chartBuilder = cb;
        this.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.panel = new JPanel();
        this.panel.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        this.panel.setMinimumSize(new Dimension(80, 55));
        JLabel label = null;
        if (this.chartBuilder.isContinuous(column) || this.chartBuilder.isDate(column)) {
            this.panel.setLayout(new GridLayout(6, 2));
            label = this.createLabel(ChartBuilder.getText("clusterFrame_counts"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.count_label = this.createLabel("", true);
            this.panel.add(this.count_label);
            this.labelVector.add(this.count_label);
            label = this.createLabel(ChartBuilder.getText("clusterFrame_missing"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.missing_label = this.createLabel("", true);
            this.panel.add(this.missing_label);
            this.labelVector.add(this.missing_label);
            label = this.createLabel(ChartBuilder.getText("clusterFrame_max"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.max_label = this.createLabel("", true);
            this.panel.add(this.max_label);
            this.labelVector.add(this.max_label);
            label = this.createLabel(ChartBuilder.getText("clusterFrame_min"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.min_label = this.createLabel("", true);
            this.panel.add(this.min_label);
            this.labelVector.add(this.min_label);
            label = this.createLabel(ChartBuilder.getText("clusterFrame_mean"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.mean_label = this.createLabel("", true);
            this.panel.add(this.mean_label);
            this.labelVector.add(this.mean_label);
            label = this.createLabel(ChartBuilder.getText("clusterFrame_std"), false);
            this.panel.add(label);
            this.labelVector.add(label);
            this.stdev_label = this.createLabel("", true);
            this.panel.add(this.stdev_label);
            this.labelVector.add(this.stdev_label);
            this.setContinuousLabels(column, conditions, this.chartBuilder);
        } else {
            int i;
            this.panel.setLayout(new BorderLayout());
            this.textscrollpane = new JScrollPane();
            this.textscrollpane.setVerticalScrollBarPolicy(20);
            this.textscrollpane.setHorizontalScrollBarPolicy(31);
            this.countPanel = new JPanel();
            this.countPanel.setBackground(ColorBroker.getColor("chartBackgroundColor"));
            Vector levels = (Vector)this.chartBuilder.getLevels(column).clone();
            levels.add("Missing");
            double[] levelcounts = this.chartBuilder.getCounts(column, conditions);
            this.panelSize = levels.size();
            if (this.panelSize < 6) {
                this.panelSize = 6;
            }
            this.countPanel.setLayout(new GridLayout(this.panelSize, 2));
            for (i = 0; i < levels.size(); ++i) {
                label = this.createLabel((String)levels.elementAt(i), false);
                this.countPanel.add(label);
                this.labelVector.add(label);
                label = i == levels.size() - 1 ? this.createLabel(Integer.toString((int)this.chartBuilder.getMissingDataForChart(column, conditions)), true) : this.createLabel(Integer.toString((int)levelcounts[i]), true);
                this.countPanel.add(label);
                this.labelVector.add(label);
            }
            if (levels.size() < 6) {
                for (i = levels.size(); i < 6; ++i) {
                    label = this.createLabel("", false);
                    this.countPanel.add(label);
                    this.labelVector.add(label);
                    label = this.createLabel("", false);
                    this.countPanel.add(label);
                    this.labelVector.add(label);
                }
            }
            if (levels.size() < 5) {
                this.textscrollpane.setBorder(BorderFactory.createEmptyBorder());
                this.textscrollpane.setVerticalScrollBarPolicy(21);
            } else {
                this.textscrollpane.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("statsTextColor")));
                this.countPanel.setPreferredSize(new Dimension(62, this.panelSize * 12));
            }
            JViewport vp = this.textscrollpane.getViewport();
            vp.add(this.countPanel);
            this.panel.add((Component)this.textscrollpane, "Center");
            this.textscrollpane.addMouseListener(new FocusMouseListener());
            this.countPanel.addMouseListener(new FocusMouseListener());
        }
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.panel, gbc);
        this.panel.addMouseListener(new FocusMouseListener());
        this.addMouseListener(new FocusMouseListener());
    }

    private JLabel createLabel(String s, boolean rightAligned) {
        JLabel label = new JLabel(s);
        label.setFont(statsFont);
        label.setForeground(ColorBroker.getColor("statsTextColor"));
        if (rightAligned) {
            label.setHorizontalAlignment(4);
        }
        return label;
    }

    public void rescale(Font f, int panelheight, int panelwidth) {
        for (int i = 0; i < this.labelVector.size(); ++i) {
            JLabel label = (JLabel)this.labelVector.elementAt(i);
            label.setFont(f);
        }
        this.panel.setMinimumSize(new Dimension(panelwidth, panelheight));
        if (this.panelSize < 9 && this.textscrollpane != null) {
            this.textscrollpane.setBorder(BorderFactory.createEmptyBorder());
        }
        this.revalidate();
    }

    public void setContinuousLabels(String column, Hashtable conditions, ChartBuilder chartBuilder) {
        String meanstring;
        String minstring;
        String maxstring;
        boolean date = chartBuilder.isDate(column);
        long counts = chartBuilder.getCountsForContinuousChart(column, conditions);
        this.count_label.setText(Long.toString(counts));
        long missing = (long)chartBuilder.getMissingDataForChart(column, conditions);
        this.missing_label.setText(Long.toString(missing));
        double max = chartBuilder.getMaxForChart(column, conditions);
        String string = maxstring = date ? MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(max) : Double.toString(max);
        if (Double.isNaN(max)) {
            maxstring = "-";
        }
        this.max_label.setText(maxstring);
        double min = chartBuilder.getMinForChart(column, conditions);
        String string2 = minstring = date ? MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(min) : Double.toString(min);
        if (Double.isNaN(min)) {
            minstring = "-";
        }
        this.min_label.setText(minstring);
        double mean = chartBuilder.getMeanForChart(column, conditions);
        String string3 = meanstring = date ? MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(mean) : Double.toString(mean);
        if (Double.isNaN(mean)) {
            meanstring = "-";
        }
        this.mean_label.setText(meanstring);
        double stdev = chartBuilder.getStDevForChart(column, conditions);
        String stdevstring = Double.toString(stdev);
        if (Double.isNaN(stdev)) {
            stdevstring = "-";
        }
        this.stdev_label.setText(stdevstring);
    }

    public void setCategoricalLabels(String column, Hashtable conditions, ChartBuilder chartBuilder) {
        JLabel label = null;
        Vector levels = (Vector)chartBuilder.getLevels(column).clone();
        levels.add("Missing");
        double[] levelcounts = chartBuilder.getCounts(column, conditions);
        for (int i = 0; i < levels.size(); ++i) {
            label = (JLabel)this.labelVector.elementAt(i * 2 + 1);
            if (label == null) continue;
            if (i == levels.size() - 1) {
                label.setText(Integer.toString((int)chartBuilder.getMissingDataForChart(column, conditions)));
                continue;
            }
            label.setText(Integer.toString((int)levelcounts[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics2D g2, PageFormat pf, int pnum, Rectangle2D.Double rect) {
        Point myOrigin = new Point();
        if (!this.myPrintBegun) {
            this.myPrintBegun = true;
            this.myPrintDocTopLeft = new Point((int)this.getAlignmentX(), (int)this.getAlignmentY());
            this.myPrintDocSize = this.panel.getSize();
            int docWidth = this.myPrintDocSize.width;
            int docHeight = this.myPrintDocSize.height;
            this.myPrintPageRect = rect;
            double pageWidth = this.myPrintPageRect.width;
            double pageHeight = this.myPrintPageRect.height;
            this.myPrintVertScale = this.myPrintHorizScale = this.myPrintPageRect.width / (double)this.myPrintDocSize.width;
            this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
            this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        }
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        if (pnum >= this.myPrintNumPagesAcross * this.myPrintNumPagesDown) {
            this.myPrintBegun = false;
            return 1;
        }
        int hpnum = pnum % this.myPrintNumPagesAcross;
        int vpnum = pnum / this.myPrintNumPagesAcross;
        myOrigin = new Point((int)(((double)this.myPrintDocTopLeft.x + (double)hpnum * pageWidth) / this.myPrintHorizScale), (int)(((double)this.myPrintDocTopLeft.y + (double)vpnum * pageHeight) / this.myPrintVertScale));
        g2.clip(this.myPrintPageRect);
        Rectangle clipRect = new Rectangle();
        g2.getClipBounds(clipRect);
        clipRect.x -= (int)pageX;
        clipRect.y -= (int)pageY;
        clipRect.x = (int)((double)clipRect.x / this.myPrintHorizScale) + myOrigin.x;
        clipRect.y = (int)((double)clipRect.y / this.myPrintVertScale) + myOrigin.y;
        clipRect.width = (int)Math.ceil((double)clipRect.width / this.myPrintHorizScale);
        clipRect.height = (int)Math.ceil((double)clipRect.height / this.myPrintVertScale);
        g2.translate(pageX, pageY);
        g2.scale(this.myPrintHorizScale, this.myPrintVertScale);
        g2.translate(-myOrigin.x, -myOrigin.y);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.panel.paint(g2);
        return 0;
    }

    private class FocusMouseListener
    implements MouseListener {
        private FocusMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!StatsPanel.this.hasFocus()) {
                StatsPanel.this.requestFocus();
            }
            if ((e.getModifiers() & 0x10) == 16) {
                if (e.getClickCount() == 2) {
                    StatsPanel.this.dataPanel.handleDoubleClick();
                } else {
                    StatsPanel.this.dataPanel.handleLeftClick(e);
                }
            } else {
                StatsPanel.this.dataPanel.handleRightClick(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }
    }
}

