/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SetSurvivalRolesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SurvivalDialog
extends NodeDialog {
    public static final int COX_REGRESSION = 1;
    private SetSurvivalRolesPanel setRolesPanel;
    private PredictionPanel predictionPanel;
    private JPanel optimizationPanel;
    private JComboBox weightsComboBox;
    private JComboBox strataComboBox;
    private JTextField maxIterationsTextField;
    private JTextField convergenceToleranceTextField;
    private JTextField failureCodeTextField;
    private JTextField censorCodeTextField;
    private JCheckBox timeDependentCovariatesCheckBox;
    private JCheckBox computeBaselineSurvivalCheckBox;
    private AbstractAction computeBaselineSurvivalAction;
    public static String maxIterationsDefault = "10";
    public static String convergenceToleranceDefault = "0.0001";
    public static String failureCodeDefault = "1";
    public static String rightCensorCodeDefault = "0";
    private boolean timeDependentCovariatesDefault = false;
    private boolean computeBaselineSurvivalDefault = true;
    public static String FAILURE_CODE_ATTRIBUTE_TAG = "failureCode";
    public static String RIGHT_CENSOR_CODE_ATTRIBUTE_TAG = "rightCensorCode";
    private static SurvivalDialog instance = null;

    public static SurvivalDialog getInstance() {
        if (instance == null) {
            instance = new SurvivalDialog();
        }
        return instance;
    }

    private SurvivalDialog() {
        this.setSize(510, 500);
        this.setMinimumSize(new Dimension(475, 500));
        this.setResizable(true);
    }

    public void show(ActivityNodeModel newModel, int survModelType) {
        this.show(newModel);
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), 4);
        XTProps props = this.getNodeModel().getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        this.weightsComboBox.removeAllItems();
        this.weightsComboBox.addItem("");
        this.strataComboBox.removeAllItems();
        this.strataComboBox.addItem("");
        Vector columnNames = metaData.getColumnNames();
        int cnSize = columnNames.size();
        for (int i = 0; i < cnSize; ++i) {
            String cName = (String)columnNames.get(i);
            if (metaData.isContinuousColumn(cName)) {
                this.strataComboBox.addItem(cName);
                this.weightsComboBox.addItem(cName);
                continue;
            }
            if (!metaData.isCategoricalColumn(cName)) continue;
            this.strataComboBox.addItem(cName);
        }
        String val = props.getValue("weightedColumn", "");
        this.weightsComboBox.setSelectedItem(val);
        val = props.getValue("strataColumn", "");
        this.strataComboBox.setSelectedItem(val);
        this.failureCodeTextField.setText(props.getValue(FAILURE_CODE_ATTRIBUTE_TAG, failureCodeDefault));
        this.censorCodeTextField.setText(props.getValue(RIGHT_CENSOR_CODE_ATTRIBUTE_TAG, rightCensorCodeDefault));
        this.maxIterationsTextField.setText(props.getValue("maxIterations", maxIterationsDefault));
        this.convergenceToleranceTextField.setText(props.getValue("convergenceTolerance", convergenceToleranceDefault));
        this.timeDependentCovariatesCheckBox.setSelected(props.getBoolean("timeDependentCovariates", false));
        this.computeBaselineSurvivalCheckBox.setSelected(props.getBoolean("computeSurvival", true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), 4);
        XTProps props = this.getNodeModel().getXTProps();
        props.set("weightedColumn", (String)this.weightsComboBox.getSelectedItem());
        props.set("strataColumn", (String)this.strataComboBox.getSelectedItem());
        props.set(FAILURE_CODE_ATTRIBUTE_TAG, this.failureCodeTextField.getText());
        props.set(RIGHT_CENSOR_CODE_ATTRIBUTE_TAG, this.censorCodeTextField.getText());
        props.set("maxIterations", this.maxIterationsTextField.getText());
        props.set("convergenceTolerance", this.convergenceToleranceTextField.getText());
        props.set("timeDependentCovariates", this.timeDependentCovariatesCheckBox.isSelected());
        props.set("computeSurvival", this.computeBaselineSurvivalCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.computeBaselineSurvivalAction = new AbstractAction(MinerApp.getText("SurvivalDialog_compute_baseline_survival")){

            public void actionPerformed(ActionEvent e) {
                SurvivalDialog.this.predictionPanel.setEnabledSurvival(SurvivalDialog.this.computeBaselineSurvivalCheckBox.isSelected());
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.setRolesPanel = new SetSurvivalRolesPanel();
        this.setRolesPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridy = 0;
        JLabel label1 = new JLabel(MinerApp.getText("SurvivalDialog_Strata_text"));
        this.strataComboBox = new JComboBox();
        label1.setDisplayedMnemonic('s');
        label1.setLabelFor(this.strataComboBox);
        optionsPanel.add((Component)label1, constraints);
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.weightx = 1.0;
        constraints.gridwidth = 5;
        constraints.gridx = -1;
        optionsPanel.add((Component)this.strataComboBox, constraints);
        JLabel label2 = new JLabel(MinerApp.getText("RegressionDialog_weights"));
        this.weightsComboBox = new JComboBox();
        label2.setDisplayedMnemonic('w');
        label2.setLabelFor(this.weightsComboBox);
        constraints.insets = new Insets(0, 20, 0, 0);
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        optionsPanel.add((Component)label2, constraints);
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.weightx = 1.0;
        constraints.gridwidth = 5;
        optionsPanel.add((Component)this.weightsComboBox, constraints);
        panel.add((Component)this.setRolesPanel, "Center");
        panel.add((Component)optionsPanel, "South");
        return panel;
    }

    public void eventVariableChanged(String name) {
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        this.optimizationPanel = this.createOptimizationPanel();
        this.setRolesPanel.addPropertyChangeListener("eventVariableChange", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SurvivalDialog.this.eventVariableChanged((String)e.getNewValue());
            }
        });
        panels.add(this.optimizationPanel);
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }

    protected JPanel createOptimizationPanel() {
        this.optimizationPanel = new JPanel(new GridBagLayout());
        this.optimizationPanel.setName(MinerApp.getText("RegressionDialog_options"));
        this.optimizationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("RegressionDialog_fittingOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        JLabel label = new JLabel(MinerApp.getText("RegressionDialog_maximumIterations"));
        this.maxIterationsTextField = new JTextField(10);
        this.maxIterationsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        label.setDisplayedMnemonic('m');
        label.setLabelFor(this.maxIterationsTextField);
        this.optimizationPanel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.maxIterationsTextField, constraints);
        label = new JLabel(MinerApp.getText("RegressionDialog_convergenceTolerance"));
        this.convergenceToleranceTextField = new JTextField(10);
        this.convergenceToleranceTextField.setDocument(new NodeDialog.InputDoubleDoc());
        label.setDisplayedMnemonic('t');
        label.setLabelFor(this.convergenceToleranceTextField);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.convergenceToleranceTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(5, 0, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)new JLabel(MinerApp.getText("SurvivalDialog_event_codes")), constraints);
        label = new JLabel(MinerApp.getText("SurvivalDialog_failure_death"));
        this.failureCodeTextField = new JTextField(10);
        this.failureCodeTextField.setDocument(new NodeDialog.InputIntegerDoc());
        label.setDisplayedMnemonic('f');
        label.setLabelFor(this.failureCodeTextField);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 10, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.failureCodeTextField, constraints);
        label = new JLabel(MinerApp.getText("SurvivalDialog_censored"));
        this.censorCodeTextField = new JTextField(10);
        this.censorCodeTextField.setDocument(new NodeDialog.InputIntegerDoc());
        label.setDisplayedMnemonic('c');
        label.setLabelFor(this.censorCodeTextField);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(0, 10, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.weightx = 1.0;
        this.optimizationPanel.add((Component)this.censorCodeTextField, constraints);
        this.timeDependentCovariatesCheckBox = new JCheckBox(MinerApp.getText("SurvivalDialog_time_dependent_covariate"));
        this.timeDependentCovariatesCheckBox.setMnemonic('t');
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        this.optimizationPanel.add((Component)this.timeDependentCovariatesCheckBox, constraints);
        this.computeBaselineSurvivalCheckBox = new JCheckBox(this.computeBaselineSurvivalAction);
        this.computeBaselineSurvivalCheckBox.setMnemonic('s');
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.insets = new Insets(0, 0, 175, 0);
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.optimizationPanel.add((Component)this.computeBaselineSurvivalCheckBox, constraints);
        return this.optimizationPanel;
    }
}

