/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.WideFileChooser;
import com.insightful.splus.PrintCommand;
import com.insightful.splus.PrintSetupCommand;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.TextPrinter;
import com.insightful.splus.util.FileUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextFrame
extends ModifiableViewerFrame
implements SplusPrintable,
SaveAsable {
    private int WINDOW_WIDTH = 600;
    private int WINDOW_HEIGHT = 400;
    JTextArea m_textArea;
    JScrollPane m_scrollPane;
    TextPrinter m_printer;

    public TextFrame(String title, String text) {
        super(title);
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        this.m_textArea = new JTextArea(text);
        this.m_textArea.setCaretPosition(0);
        this.m_textArea.setEditable(false);
        this.m_textArea.setFont(new Font("Monospaced", 0, 12));
        this.m_scrollPane = new JScrollPane(this.m_textArea);
        this.getContentPane().add(this.m_scrollPane);
        this.setSize(this.WINDOW_WIDTH, this.WINDOW_HEIGHT);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        menu.add(this.newMenuItem("Save As...", 'A', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                TextFrame.this.saveAs(TextFrame.this, SplusSystem.getCwd());
            }
        }));
        menu.add(this.newMenuItem("Print...", 'P', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                new PrintCommand((JFrame)TextFrame.this, (SplusPrintable)TextFrame.this).doExecute();
            }
        }));
        menu.add(this.newMenuItem("Print Setup...", 'U', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                new PrintSetupCommand().doExecute();
            }
        }));
        menu.addSeparator();
        menu.add(this.newMenuItem("Close", 'C', new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                TextFrame.this.dispose();
            }
        }));
        this.setJMenuBar(menuBar);
        this.setLocation(MinerApp.getMainFrame().getNextWindowLocation());
    }

    JMenuItem newMenuItem(String text, char mnemonic, ActionListener actionListener) {
        JMenuItem menuItem = this.newMenuItem(text, actionListener);
        menuItem.setMnemonic(mnemonic);
        return menuItem;
    }

    JMenuItem newMenuItem(String text, ActionListener actionListener) {
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    public File saveAs(Frame fr, File fiCurrentDirectory) {
        WideFileChooser jfc = new WideFileChooser(fiCurrentDirectory, SplusSystem.getServerFileHandler().getServerFileSystemView());
        jfc.setDialogType(1);
        jfc.setDialogTitle("Save As");
        while (jfc.showSaveDialog(fr) == 0) {
            File selectedFile = jfc.getSelectedFile();
            String fileName = selectedFile.getAbsolutePath();
            if (!FileUtilities.confirmSaveAs((Component)fr, (String)fileName)) continue;
            try {
                FileOutputStream fos = SplusSystem.getServerFileHandler().getServerFileOutputStream(fileName);
                fos.write(this.m_textArea.getText().getBytes());
                fos.close();
                SplusSystem.setCwd((File)selectedFile);
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(fr, MinerApp.getText("TextFrame_msg_problemSavingFile") + "\n" + e.getMessage(), MinerApp.getText("TextFrame_msg_fileSaveError"), 2);
            }
            return jfc.getCurrentDirectory();
        }
        return fiCurrentDirectory;
    }

    public void save() {
    }

    public int getNumberOfPages() {
        if (this.m_printer == null) {
            this.m_printer = new TextPrinter(this.m_textArea.getText(), this.m_textArea.getFont());
        }
        return this.m_printer.getNumberOfPages();
    }

    public int print(Graphics g, PageFormat pf, int iPage) {
        if (this.m_printer == null) {
            this.m_printer = new TextPrinter(this.m_textArea.getText(), this.m_textArea.getFont());
        }
        return this.m_printer.print(g, pf, iPage);
    }
}

