/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeMetaData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XTMetaData
extends XMLTreeMetaData {
    private Vector m_columnNames = null;
    private Vector m_columnRoles = null;
    private Vector m_columnTypes = null;
    private HashMap m_hash = null;
    private int m_numColumns = 0;
    private long m_numRows = 0L;
    private String m_lastName = "";
    private ColumnDetails m_lastDetails = null;

    public XTMetaData() throws Exception {
        this.m_columnNames = new Vector();
        this.m_columnRoles = new Vector();
        this.m_columnTypes = new Vector();
        this.m_hash = new HashMap();
    }

    public XTMetaData(XMLTreeMetaData metaData) throws Exception {
        this.init(metaData);
    }

    public XTMetaData(XMLTree tree) throws Exception {
        if (tree instanceof XMLTreeMetaData) {
            this.init((XMLTreeMetaData)tree);
        } else {
            XMLTreeMetaData md = new XMLTreeMetaData(tree);
            this.init(md);
        }
    }

    public XTMetaData(Element el) throws Exception {
        this.init(new XMLTreeMetaData(el));
    }

    public XTMetaData(XTMetaData ema) throws Exception {
        this.init(ema);
    }

    public static XTMetaData createXTMetaData(Element el) {
        try {
            return new XTMetaData(new XMLTreeMetaData(el));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XTMetaData createXTMetaData(String filename) {
        try {
            return XTMetaData.readXTMetaDataFromFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String writeToString() {
        try {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "UTF-8");
            this.outputXML(writer, false);
            return outs.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void outputXML(Writer writer) throws IOException {
        this.outputXML(writer, false);
    }

    private void outputXML(Writer writer, boolean displayOptions) throws IOException {
        int ii;
        int numLevels;
        String xmlColName;
        String javaColName;
        int i;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<" + XMLTree.IMML_NODE_TAG + " " + XMLTree.IMML_VERSION_ATTRIBUTE_TAG + "=\"" + XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG + "\">\n");
        writer.write("\t<" + META_DATA_NODE_TAG + ">\n");
        writer.write("\t\t<" + DATA_DICTIONARY_NODE_TAG + " " + FIELD_COUNT_ATTRIBUTE_TAG + "=\"" + this.m_numColumns + "\">\n");
        for (i = 0; i < this.m_numColumns; ++i) {
            javaColName = (String)this.m_columnNames.get(i);
            xmlColName = this.convertToXML(javaColName);
            if (!this.getColumn(javaColName)) continue;
            if (this.m_lastDetails.type.equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                numLevels = this.m_lastDetails.levelNames.size();
                if (numLevels == 0) {
                    if (this.m_lastDetails.role != null) {
                        writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CATEGORICAL_TYPE_ATTRIBUTE_TAG + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\" />\n");
                        continue;
                    }
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CATEGORICAL_TYPE_ATTRIBUTE_TAG + "\" />\n");
                    continue;
                }
                if (this.m_lastDetails.role != null) {
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CATEGORICAL_TYPE_ATTRIBUTE_TAG + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\">\n");
                } else {
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CATEGORICAL_TYPE_ATTRIBUTE_TAG + "\">\n");
                }
                for (ii = 0; ii < numLevels; ++ii) {
                    writer.write("\t\t\t\t<" + LEVEL_NODE_TAG + " " + VALUE_ATTRIBUTE_TAG + "=\"" + this.convertToXML((String)this.m_lastDetails.levelNames.get(ii)) + "\"/>\n");
                }
                writer.write("\t\t\t</" + DATA_FIELD_NODE_TAG + ">\n");
                continue;
            }
            if (this.m_lastDetails.type.equals(CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                if (this.m_lastDetails.role != null) {
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CONTINUOUS_TYPE_ATTRIBUTE_TAG + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\"/>\n");
                    continue;
                }
                writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + CONTINUOUS_TYPE_ATTRIBUTE_TAG + "\"/>\n");
                continue;
            }
            if (this.m_lastDetails.type.equals(DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                if (this.m_lastDetails.role != null) {
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + DATE_TIME_TYPE_ATTRIBUTE_TAG + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\"/>\n");
                    continue;
                }
                writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + DATE_TIME_TYPE_ATTRIBUTE_TAG + "\"/>\n");
                continue;
            }
            if (this.m_lastDetails.type.equals(BLOB_TYPE_ATTRIBUTE_TAG)) {
                if (this.m_lastDetails.role != null) {
                    writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + BLOB_TYPE_ATTRIBUTE_TAG + "\" " + BLOB_CLASS_NAME_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.blobClassName + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\"/>\n");
                    continue;
                }
                writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + BLOB_TYPE_ATTRIBUTE_TAG + "\" " + BLOB_CLASS_NAME_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.blobClassName + "\"/>\n");
                continue;
            }
            if (this.m_lastDetails.role != null) {
                writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + STRING_TYPE_ATTRIBUTE_TAG + "\" " + WIDTH_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.stringWidth + "\" " + ROLE_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.role + "\"/>\n");
                continue;
            }
            writer.write("\t\t\t<" + DATA_FIELD_NODE_TAG + " " + NAME_ATTRIBUTE_TAG + "=\"" + xmlColName + "\" " + TYPE_ATTRIBUTE_TAG + "=\"" + STRING_TYPE_ATTRIBUTE_TAG + "\" " + WIDTH_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.stringWidth + "\"/>\n");
        }
        writer.write("\t\t</" + DATA_DICTIONARY_NODE_TAG + ">\n");
        if (this.m_numRows > 0L) {
            writer.write("\t\t<" + DATA_STATS_NODE_TAG + ">\n");
            writer.write("\t\t\t<" + TABLE_STATS_NODE_TAG + " " + ROW_COUNT_ATTRIBUTE_TAG + "=\"" + this.m_numRows + "\"/>\n");
            for (i = 0; i < this.m_numColumns; ++i) {
                javaColName = (String)this.m_columnNames.get(i);
                xmlColName = this.convertToXML(javaColName);
                if (!this.getColumn(javaColName)) continue;
                writer.write("\t\t\t<" + UNIVARIATE_STATS_NODE_TAG + " " + FIELD_ATTRIBUTE_TAG + "=\"" + xmlColName + "\">\n");
                if (this.m_lastDetails.quantileLimits == null) {
                    writer.write("\t\t\t\t<" + NUMERIC_INFO_NODE_TAG + " " + MEAN_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.mean + "\" " + MINIMUM_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.min + "\" " + MAXIMUM_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.max + "\" " + STANDARD_DEVIATION_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.stdDev + "\" " + MEDIAN_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.median + "\" " + IQR_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.iqr + "\" />\n");
                } else {
                    writer.write("\t\t\t\t<" + NUMERIC_INFO_NODE_TAG + " " + MEAN_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.mean + "\" " + MINIMUM_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.min + "\" " + MAXIMUM_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.max + "\" " + STANDARD_DEVIATION_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.stdDev + "\" " + MEDIAN_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.median + "\" " + IQR_ATTRIBUTE_TAG + "=\"" + this.m_lastDetails.iqr + "\">\n");
                    int numQuantiles = this.m_lastDetails.quantileLimits.size();
                    for (ii = 0; ii < numQuantiles; ++ii) {
                        String qLimit = (String)this.m_lastDetails.quantileLimits.get(ii);
                        String qValue = (String)this.m_lastDetails.quantileValues.get(ii);
                        writer.write("\t\t\t\t\t<" + QUANTILE_NODE_TAG + " " + QUANTILE_LIMIT_ATTRIBUTE_TAG + "=\"" + qLimit + "\" " + QUANTILE_VALUE_ATTRIBUTE_TAG + "=\"" + qValue + "\" />\n");
                    }
                    writer.write("\t\t\t\t</" + NUMERIC_INFO_NODE_TAG + ">\n");
                }
                if (this.m_lastDetails.levelCounts == null) {
                    writer.write("\t\t\t\t<" + COUNTS_NODE_TAG + " " + TOTAL_FREQUENCY_ATTRIBUTE_TAG + "=\"" + (long)this.m_lastDetails.validCount + "\" " + MISSING_FREQUENCY_ATTRIBUTE_TAG + "=\"" + (long)this.m_lastDetails.missingCount + "\" />\n");
                } else {
                    numLevels = this.m_lastDetails.levelCounts.size();
                    writer.write("\t\t\t\t<" + COUNTS_NODE_TAG + " " + TOTAL_FREQUENCY_ATTRIBUTE_TAG + "=\"" + (long)this.m_lastDetails.validCount + "\" " + MISSING_FREQUENCY_ATTRIBUTE_TAG + "=\"" + (long)this.m_lastDetails.missingCount + "\">\n");
                    for (ii = 0; ii < numLevels; ++ii) {
                        String xmlLevelName = this.convertToXML((String)this.m_lastDetails.levelNames.get(ii));
                        long levelCount = Long.parseLong((String)this.m_lastDetails.levelCounts.get(ii));
                        writer.write("\t\t\t\t\t<" + CATEGORY_NODE_TAG + " " + VALUE_ATTRIBUTE_TAG + "=\"" + xmlLevelName + "\" " + FREQUENCY_ATTRIBUTE_TAG + "=\"" + levelCount + "\" />\n");
                    }
                    writer.write("\t\t\t\t</" + COUNTS_NODE_TAG + ">\n");
                }
                writer.write("\t\t\t</" + UNIVARIATE_STATS_NODE_TAG + ">\n");
            }
            writer.write("\t\t</" + DATA_STATS_NODE_TAG + ">\n");
        } else {
            writer.write("\t\t<" + DATA_STATS_NODE_TAG + " />\n");
        }
        writer.write("\t</" + META_DATA_NODE_TAG + ">\n");
        if (displayOptions) {
            writer.write("\t<" + DISPLAY_OPTIONS_NODE_TAG + " " + DECIMAL_PATTERN_ATTRIBUTE_TAG + "=\"" + this.convertToXML(MinerApp.getWorksheetPropertiesManager().getViewerRoundingPattern()) + "\" " + SCIENTIFIC_PATTERN_ATTRIBUTE_TAG + "=\"" + this.convertToXML(MinerApp.getWorksheetPropertiesManager().getViewerScientificRoundingPattern()) + "\" " + CSS_ATTRIBUTE_TAG + "=\"" + CSS_FILE + "\" />\n");
        }
        writer.write("</" + XMLTree.IMML_NODE_TAG + ">\n");
        writer.flush();
    }

    public OutputStream getHtmlOutputStream(String xslFilename, String title) {
        ByteArrayOutputStream htmlByteStream = new ByteArrayOutputStream();
        try {
            File xmlFile = File.createTempFile("xml", "tmp");
            String filename = xmlFile.getAbsolutePath();
            this.saveToFile(filename, true);
            xmlFile.deleteOnExit();
            InputSource is = new InputSource(new FileInputStream(xmlFile));
            SAXSource xmlSource = new SAXSource(is);
            StreamResult htmlResult = new StreamResult(htmlByteStream);
            Transformer xslTransformer = null;
            if (xslTransformerMap == null) {
                xslTransformerMap = new HashMap();
                transformerFactory = TransformerFactory.newInstance();
            } else {
                xslTransformer = (Transformer)xslTransformerMap.get(xslFilename);
            }
            if (xslTransformer == null) {
                StreamSource xslStream = new StreamSource(xslFilename);
                xslTransformer = transformerFactory.newTransformer(xslStream);
                xslTransformerMap.put(xslFilename, xslTransformer);
            }
            xslTransformer.transform(xmlSource, htmlResult);
            xmlFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            htmlByteStream = null;
        }
        return htmlByteStream;
    }

    public static XTMetaData readXTMetaDataFromFile(String filename) {
        try {
            FileInputStream ins = new FileInputStream(filename);
            return XTMetaData.readXTMetaDataFromFile(ins);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static XTMetaData readXTMetaDataFromFile(InputStream ins) {
        try {
            XTMetaData emd = new XTMetaData();
            MDSaxHandler customHandler = new MDSaxHandler(emd);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(ins, (DefaultHandler)customHandler);
            return emd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveToFile(String filename) {
        this.saveToFile(filename, false);
    }

    private void saveToFile(String filename, boolean displayOptions) {
        try {
            FileOutputStream outs = new FileOutputStream(filename);
            this.saveToFile(outs, displayOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(FileOutputStream outs) {
        this.saveToFile(outs, false);
    }

    private void saveToFile(FileOutputStream outs, boolean displayOptions) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outs, "UTF-8");
            this.outputXML(writer, displayOptions);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLTreeMetaData getXMLTreeMetaData() {
        XMLTreeMetaData ret = null;
        try {
            ret = new XMLTreeMetaData();
            ret.setTableStats(this.m_numRows);
            for (int i = 0; i < this.m_numColumns; ++i) {
                int ii;
                String name = (String)this.m_columnNames.get(i);
                if (!this.getColumn(name)) continue;
                if (this.m_lastDetails.type.equals(XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendCategoricalDataField(name, this.m_lastDetails.levelNames);
                    ret.appendUnivariateStats(name);
                    ret.appendNumericInfo(name, this.m_lastDetails.mean, this.m_lastDetails.min, this.m_lastDetails.max, this.m_lastDetails.stdDev, this.m_lastDetails.median, this.m_lastDetails.iqr);
                    ret.appendCounts(name, (long)this.m_lastDetails.validCount, (long)this.m_lastDetails.missingCount);
                    int numLevels = this.m_lastDetails.levelNames.size();
                    String[] categories = new String[numLevels];
                    long[] counts = new long[numLevels];
                    for (ii = 0; ii < numLevels; ++ii) {
                        counts[ii] = Long.parseLong((String)this.m_lastDetails.levelCounts.get(ii));
                        categories[ii] = (String)this.m_lastDetails.levelNames.get(ii);
                    }
                    if (numLevels > 0) {
                        ret.appendCountsCategories(name, categories, counts);
                    }
                } else if (this.m_lastDetails.type.equals(CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendContinousDataField(name);
                    ret.appendUnivariateStats(name);
                    ret.appendNumericInfo(name, this.m_lastDetails.mean, this.m_lastDetails.min, this.m_lastDetails.max, this.m_lastDetails.stdDev, this.m_lastDetails.median, this.m_lastDetails.iqr);
                    ret.appendCounts(name, (long)this.m_lastDetails.validCount, (long)this.m_lastDetails.missingCount);
                    if (this.m_lastDetails.quantileLimits != null) {
                        int numQuantiles = this.m_lastDetails.quantileLimits.size();
                        double[] limits = new double[numQuantiles];
                        double[] values = new double[numQuantiles];
                        for (ii = 0; ii < numQuantiles; ++ii) {
                            limits[ii] = Double.parseDouble((String)this.m_lastDetails.quantileLimits.get(ii));
                            values[ii] = Double.parseDouble((String)this.m_lastDetails.quantileValues.get(ii));
                        }
                        ret.appendQuantiles(name, limits, values);
                    }
                } else if (this.m_lastDetails.type.equals(DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendDateTimeDataField(name);
                    ret.appendUnivariateStats(name);
                    ret.appendNumericInfo(name, this.m_lastDetails.mean, this.m_lastDetails.min, this.m_lastDetails.max, this.m_lastDetails.stdDev, this.m_lastDetails.median, this.m_lastDetails.iqr);
                    ret.appendCounts(name, (long)this.m_lastDetails.validCount, (long)this.m_lastDetails.missingCount);
                } else if (this.m_lastDetails.type.equals(BLOB_TYPE_ATTRIBUTE_TAG)) {
                    ret.appendBlobDataField(name, this.m_lastDetails.blobClassName);
                    ret.appendUnivariateStats(name);
                    ret.appendNumericInfo(name, this.m_lastDetails.mean, this.m_lastDetails.min, this.m_lastDetails.max, this.m_lastDetails.stdDev, this.m_lastDetails.median, this.m_lastDetails.iqr);
                    ret.appendCounts(name, (long)this.m_lastDetails.validCount, (long)this.m_lastDetails.missingCount);
                } else {
                    ret.appendStringDataField(name, this.m_lastDetails.stringWidth);
                    ret.appendUnivariateStats(name);
                    ret.appendNumericInfo(name, this.m_lastDetails.mean, this.m_lastDetails.min, this.m_lastDetails.max, this.m_lastDetails.stdDev, this.m_lastDetails.median, this.m_lastDetails.iqr);
                    ret.appendCounts(name, (long)this.m_lastDetails.validCount, (long)this.m_lastDetails.missingCount);
                }
                if (this.m_lastDetails.role == null) {
                    this.m_lastDetails.role = INFORMATION_ROLE_ATTRIBUTE_TAG;
                }
                ret.setDataFieldRole(name, this.m_lastDetails.role);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Vector getColumnNames() {
        return (Vector)this.m_columnNames.clone();
    }

    public Vector getColumnRoles() {
        return (Vector)this.m_columnRoles.clone();
    }

    public Vector getColumnTypes() {
        return (Vector)this.m_columnTypes.clone();
    }

    public double getColumnRowCount(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.validCount;
        }
        return Double.NaN;
    }

    public double getColumnRowCount(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.validCount;
        }
        return Double.NaN;
    }

    public double getColumnMissingCount(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.missingCount;
        }
        return Double.NaN;
    }

    public double getColumnMissingCount(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.missingCount;
        }
        return Double.NaN;
    }

    public double getColumnMean(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.mean;
        }
        return Double.NaN;
    }

    public double getColumnMean(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.mean;
        }
        return Double.NaN;
    }

    public double getColumnMin(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.min;
        }
        return Double.NaN;
    }

    public double getColumnMin(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.min;
        }
        return Double.NaN;
    }

    public double getColumnMax(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.max;
        }
        return Double.NaN;
    }

    public double getColumnMax(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.max;
        }
        return Double.NaN;
    }

    public double getColumnStandardDeviation(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.stdDev;
        }
        return Double.NaN;
    }

    public double getColumnStandardDeviation(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.stdDev;
        }
        return Double.NaN;
    }

    public boolean isDateTimeColumn(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type.equals(DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isDateTimeColumn(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type.equals(DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isBlobColumn(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type.equals(BLOB_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isBlobColumn(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type.equals(BLOB_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isContinuousColumn(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type.equals(CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isContinuousColumn(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type.equals(CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isCategoricalColumn(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type.equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isCategoricalColumn(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type.equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isStringColumn(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type.equals(STRING_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isStringColumn(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type.equals(STRING_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public String getColumnType(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.type == null ? "" : this.m_lastDetails.type;
        }
        return "";
    }

    public String getColumnType(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.type == null ? "" : this.m_lastDetails.type;
        }
        return "";
    }

    public String getColumnRole(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.role == null ? "" : this.m_lastDetails.role;
        }
        return "";
    }

    public String getColumnRole(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.role == null ? "" : this.m_lastDetails.role;
        }
        return "";
    }

    public int getStringDataFieldWidth(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.stringWidth;
        }
        return 0;
    }

    public int getStringDataFieldWidth(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.stringWidth;
        }
        return 0;
    }

    public String getBlobDataFieldClassName(String name) {
        if (this.getColumn(name)) {
            return this.m_lastDetails.blobClassName;
        }
        return null;
    }

    public String getBlobDataFieldClassName(int num) {
        if (this.getColumn(num)) {
            return this.m_lastDetails.blobClassName;
        }
        return null;
    }

    public String getCategoricalDataFieldLevel(int column, int level) {
        try {
            if (this.getColumn(column)) {
                return (String)this.m_lastDetails.levelNames.get(level);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public Vector getCategoricalDataFieldLevels(String name) {
        if (this.getColumn(name)) {
            if (this.m_lastDetails.levelNames == null) {
                return new Vector();
            }
            return (Vector)this.m_lastDetails.levelNames.clone();
        }
        return new Vector();
    }

    public Vector getSortedCategoricalDataFieldLevels(String name) {
        if (this.getColumn(name)) {
            Vector levels = (Vector)this.m_lastDetails.levelNames.clone();
            List list = levels.subList(0, levels.size());
            Collections.sort(list);
            Vector ret = new Vector(list);
            return ret;
        }
        return new Vector();
    }

    public Vector getSortedCategoricalDataFieldLevelIndices(String name) {
        if (this.getColumn(name)) {
            int size = this.m_lastDetails.levelNames.size();
            Vector<IndexTracker> sortable = new Vector<IndexTracker>(size);
            for (int i = 0; i < size; ++i) {
                sortable.add(new IndexTracker((String)this.m_lastDetails.levelNames.get(i), i));
            }
            List list = sortable.subList(0, size);
            Collections.sort(list);
            Vector<Integer> ret = new Vector<Integer>(size);
            for (int i = 0; i < size; ++i) {
                ret.add(new Integer(((IndexTracker)list.get((int)i)).origPos));
            }
            return ret;
        }
        return new Vector();
    }

    public String getLevelCount(String name, String level) {
        try {
            if (this.getColumn(name)) {
                int index = this.m_lastDetails.levelNames.indexOf(level);
                return (String)this.m_lastDetails.levelCounts.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    public int getNumColumns() {
        return this.m_numColumns;
    }

    public int nameToOrdinal(String columnName) {
        if (this.getColumn(columnName)) {
            return this.m_lastDetails.number;
        }
        return -1;
    }

    public String ordinalToName(int ordinal) {
        try {
            return (String)this.m_columnNames.get(ordinal);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean containsColumn(String columnName) {
        return this.getColumn(columnName);
    }

    public long getNumRows() {
        return this.m_numRows;
    }

    public boolean appendCategoricalDataField(String name, List levels) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = CATEGORICAL_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.levelNames = new Vector(levels);
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.name = name;
            newDF.type = CATEGORICAL_TYPE_ATTRIBUTE_TAG;
            newDF.levelNames = new Vector(levels);
            newDF.number = this.m_numColumns;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appendCategoricalDataField(String name, String[] levels) {
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < levels.length; ++i) {
            vec.add(levels[i]);
        }
        return this.appendCategoricalDataField(name, vec);
    }

    public boolean removeDataFieldLevels(String name) {
        try {
            if (this.getColumn(name)) {
                if (this.m_lastDetails.levelNames != null) {
                    this.m_lastDetails.levelNames.removeAllElements();
                }
                if (this.m_lastDetails.levelCounts != null) {
                    this.m_lastDetails.levelCounts.removeAllElements();
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean removeDataFieldLevels(int num) {
        try {
            if (this.getColumn(num)) {
                if (this.m_lastDetails.levelNames != null) {
                    this.m_lastDetails.levelNames.removeAllElements();
                }
                if (this.m_lastDetails.levelCounts != null) {
                    this.m_lastDetails.levelCounts.removeAllElements();
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendCategoricalLevel(String name, String level) {
        Vector<String> levels = new Vector<String>();
        levels.add(level);
        return this.appendCategoricalDataField(name, levels);
    }

    public boolean reorderCategoricalLevels(String name, Vector levels) {
        try {
            if (!this.getColumn(name) || this.m_lastDetails.levelCounts == null || this.m_lastDetails.levelCounts.size() == 0) {
                this.setCategoricalLevels(name, levels);
            } else if (this.m_lastDetails.type.equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                Vector counts = new Vector();
                for (int i = 0; i < levels.size(); ++i) {
                    int k = this.m_lastDetails.levelNames.indexOf(levels.get(i));
                    if (k < 0) {
                        throw new Exception();
                    }
                    counts.add(this.m_lastDetails.levelCounts.get(k));
                }
                this.m_lastDetails.levelNames = levels;
                this.m_lastDetails.levelCounts = counts;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean setCategoricalLevels(String name, Vector levels) {
        String[] list = new String[levels.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (String)levels.get(i);
        }
        return this.setCategoricalLevels(name, list);
    }

    public boolean setCategoricalLevels(String name, String[] levels) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = CATEGORICAL_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.levelNames = new Vector();
                for (int i = 0; i < levels.length; ++i) {
                    this.m_lastDetails.levelNames.add(levels[i]);
                }
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.name = name;
            newDF.type = CATEGORICAL_TYPE_ATTRIBUTE_TAG;
            newDF.number = this.m_numColumns;
            newDF.levelNames = new Vector();
            for (int i = 0; i < levels.length; ++i) {
                this.m_lastDetails.levelNames.add(levels[i]);
            }
            this.m_columnNames.add(name);
            this.m_columnTypes.add(CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appendContinousDataField(String name) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.levelNames = null;
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.type = CONTINUOUS_TYPE_ATTRIBUTE_TAG;
            newDF.name = name;
            newDF.number = this.m_numColumns;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appendDateTimeDataField(String name) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = DATE_TIME_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.levelNames = null;
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.type = DATE_TIME_TYPE_ATTRIBUTE_TAG;
            newDF.name = name;
            newDF.number = this.m_numColumns;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(DATE_TIME_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appendStringDataField(String name, int width) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = STRING_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.stringWidth = width;
                this.m_lastDetails.levelNames = null;
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.type = STRING_TYPE_ATTRIBUTE_TAG;
            newDF.stringWidth = width;
            newDF.name = name;
            newDF.number = this.m_numColumns;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(STRING_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appendBlobDataField(String name, String blobClassName) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.type = BLOB_TYPE_ATTRIBUTE_TAG;
                this.m_columnTypes.set(this.m_lastDetails.number, this.m_lastDetails.type);
                this.m_lastDetails.blobClassName = blobClassName;
                this.m_lastDetails.levelNames = null;
                this.m_lastDetails.levelCounts = null;
                return true;
            }
            ColumnDetails newDF = new ColumnDetails();
            newDF.type = BLOB_TYPE_ATTRIBUTE_TAG;
            newDF.blobClassName = blobClassName;
            newDF.name = name;
            newDF.number = this.m_numColumns;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(BLOB_TYPE_ATTRIBUTE_TAG);
            this.m_columnRoles.add("");
            this.m_hash.put(name, newDF);
            this.m_lastName = name;
            this.m_lastDetails = newDF;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeDataField(String name) {
        if (this.getColumn(name)) {
            int index = this.m_lastDetails.number;
            this.m_columnNames.remove(index);
            this.m_columnTypes.remove(index);
            this.m_columnRoles.remove(index);
            ColumnDetails rem = (ColumnDetails)this.m_hash.remove(name);
            this.m_numColumns = this.m_hash.size();
            int i = rem.number;
            while (i < this.m_numColumns) {
                ColumnDetails cd = (ColumnDetails)this.m_hash.get(this.m_columnNames.get(i));
                cd.number = i++;
            }
            this.m_lastName = "";
            this.m_lastDetails = null;
            return true;
        }
        return false;
    }

    public boolean setDataFieldRole(String name, String role) {
        if (this.getColumn(name)) {
            this.m_lastDetails.role = role;
            this.m_columnRoles.set(this.m_lastDetails.number, role);
            return true;
        }
        return false;
    }

    public boolean setDataFieldRole(int num, String role) {
        if (this.getColumn(num)) {
            this.m_lastDetails.role = role;
            this.m_columnRoles.set(num, role);
            return true;
        }
        return false;
    }

    public boolean setDataFieldRoleDependent(String name) {
        return this.setDataFieldRole(name, DEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRoleIndependent(String name) {
        return this.setDataFieldRole(name, INDEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRoleInformation(String name) {
        return this.setDataFieldRole(name, INFORMATION_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRolePrediction(String name) {
        return this.setDataFieldRole(name, PREDICTION_ROLE_ATTRIBUTE_TAG);
    }

    public Vector getDataFieldsWithType(String type) {
        Vector ret = new Vector();
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (!this.m_columnTypes.get(i).equals(type)) continue;
            ret.add(this.m_columnNames.get(i));
        }
        return ret;
    }

    public Vector getDataFieldsWithRole(String role) {
        Vector ret = new Vector();
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (!this.m_columnRoles.get(i).equals(role)) continue;
            ret.add(this.m_columnNames.get(i));
        }
        return ret;
    }

    public boolean setNumRows(long numRows) {
        this.m_numRows = numRows;
        return true;
    }

    public boolean setTableStats(long numRows) {
        return this.setNumRows(numRows);
    }

    public boolean appendUnivariateStats(String name) {
        return false;
    }

    public boolean removeUnivariateStats(String name) {
        return this.removeDataField(name);
    }

    public boolean appendCounts(String name, long totalFreq, long missingFreq) {
        if (this.getColumn(name)) {
            this.m_lastDetails.validCount = totalFreq;
            this.m_lastDetails.missingCount = missingFreq;
            return true;
        }
        return false;
    }

    public boolean appendCountsCategories(String name, String[] values, long[] frequencies) {
        try {
            if (this.getColumn(name)) {
                int i;
                this.m_lastDetails.type = XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
                if (this.m_lastDetails.levelNames == null) {
                    this.m_lastDetails.levelNames = new Vector();
                    for (i = 0; i < values.length; ++i) {
                        this.m_lastDetails.levelNames.add(values[i]);
                    }
                }
                if (this.m_lastDetails.levelCounts == null) {
                    this.m_lastDetails.levelCounts = new Vector();
                }
                for (i = 0; i < values.length; ++i) {
                    this.m_lastDetails.levelCounts.add(Long.toString(frequencies[i]));
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendCountsCategory(String name, String value, long frequency) {
        if (value != null && this.getColumn(name)) {
            int index;
            this.m_lastDetails.type = XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
            if (this.m_lastDetails.levelNames == null) {
                this.m_lastDetails.levelNames = new Vector();
            }
            if (this.m_lastDetails.levelCounts == null) {
                this.m_lastDetails.levelCounts = new Vector();
            }
            if ((index = this.m_lastDetails.levelNames.indexOf(value)) == -1) {
                this.m_lastDetails.levelNames.add(value);
                this.m_lastDetails.levelCounts.add(Long.toString(frequency));
            } else if (this.m_lastDetails.levelCounts.size() <= index) {
                this.m_lastDetails.levelCounts.add(Long.toString(frequency));
            } else {
                this.m_lastDetails.levelCounts.set(index, Long.toString(frequency));
            }
            return true;
        }
        return false;
    }

    public boolean appendNumericInfo(String name, double mean, double min, double max, double stdDev, double median, double iqr) {
        try {
            if (this.getColumn(name)) {
                this.m_lastDetails.mean = mean;
                this.m_lastDetails.min = min;
                this.m_lastDetails.max = max;
                this.m_lastDetails.stdDev = stdDev;
                this.m_lastDetails.iqr = iqr;
                this.m_lastDetails.median = median;
                return true;
            }
            ColumnDetails cd = new ColumnDetails();
            cd.type = CONTINUOUS_TYPE_ATTRIBUTE_TAG;
            cd.number = this.m_numColumns;
            cd.mean = mean;
            cd.min = min;
            cd.max = max;
            cd.stdDev = stdDev;
            cd.iqr = iqr;
            cd.median = median;
            this.m_columnNames.add(name);
            this.m_columnTypes.add(cd.type);
            this.m_columnRoles.add("");
            this.m_hash.put(name, cd);
            this.m_lastName = name;
            this.m_lastDetails = cd;
            this.m_numColumns = this.m_hash.size();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean replaceNumericInfo(String name, double mean, double min, double max, double stdDev, double median, double iqr) {
        return this.appendNumericInfo(name, mean, min, max, stdDev, median, iqr);
    }

    public boolean appendQuantiles(String name, double[] limits, double[] values) {
        return false;
    }

    public boolean appendQuantile(String name, double limit, double value) {
        return false;
    }

    public boolean modifyColumnName(String oldName, String newName) {
        if (this.getColumn(oldName)) {
            this.m_columnNames.set(this.m_lastDetails.number, newName);
            this.m_hash.remove(oldName);
            this.m_lastDetails.name = newName;
            this.m_lastName = newName;
            this.m_hash.put(newName, this.m_lastDetails);
            return true;
        }
        return false;
    }

    public XTMetaData selectiveClone(Vector preservedColumnNames) {
        if (this.m_numColumns > 20) {
            XTMetaData md = this.additiveClone(preservedColumnNames);
            if (md == null) {
                return this.reductiveClone(preservedColumnNames);
            }
            return md;
        }
        return this.reductiveClone(preservedColumnNames);
    }

    private XTMetaData reductiveClone(Vector preservedColumnNames) {
        XTMetaData clonedMetaData = (XTMetaData)this.copy();
        for (int i = this.m_numColumns - 1; i >= 0; --i) {
            String col = (String)this.m_columnNames.get(i);
            if (preservedColumnNames.contains(col)) continue;
            clonedMetaData.removeDataField(col);
        }
        return clonedMetaData;
    }

    private XTMetaData additiveClone(Vector preservedColumnNames) {
        try {
            XTMetaData clonedMetaData = new XTMetaData();
            int i = 0;
            while (i < preservedColumnNames.size()) {
                String col = (String)preservedColumnNames.get(i);
                ColumnDetails cd = (ColumnDetails)this.m_hash.get(col);
                ColumnDetails newCD = cd.copy();
                newCD.number = i++;
                clonedMetaData.m_hash.put(col, newCD);
                clonedMetaData.m_columnNames.add(col);
                clonedMetaData.m_columnRoles.add(this.m_columnRoles.get(cd.number));
                clonedMetaData.m_columnTypes.add(this.m_columnTypes.get(cd.number));
                ++clonedMetaData.m_numColumns;
            }
            clonedMetaData.m_numRows = this.m_numRows;
            return clonedMetaData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public XMLTree copy() {
        try {
            return new XTMetaData(this.m_hash, this.m_columnNames, this.m_columnTypes, this.m_columnRoles, this.m_numColumns, this.m_numRows);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object clone() {
        try {
            return this.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(XTMetaData emd) {
        return this.m_numRows == emd.m_numRows && this.m_numColumns == emd.m_numColumns && XTMetaData.nullCognizantCompare(this.m_columnNames, emd.m_columnNames) && XTMetaData.nullCognizantCompare(this.m_columnRoles, emd.m_columnRoles) && XTMetaData.nullCognizantCompare(this.m_columnTypes, emd.m_columnTypes) && this.m_hash.equals(emd.m_hash);
    }

    public static void test() {
    }

    private XTMetaData(HashMap hash, Vector cNames, Vector cTypes, Vector cRoles, int cols, long rows) throws Exception {
        this.m_columnNames = new Vector(cNames);
        this.m_columnTypes = new Vector(cTypes);
        this.m_columnRoles = new Vector(cRoles);
        this.m_hash = this.copyHashMap(hash, true);
        this.m_numColumns = cols;
        this.m_numRows = rows;
    }

    private void init(XMLTreeMetaData metaData) {
        this.m_columnNames = metaData.getColumnNames();
        this.m_columnTypes = metaData.getColumnTypes();
        this.m_columnRoles = metaData.getColumnRoles();
        this.m_numColumns = metaData.getNumColumns();
        this.m_numRows = metaData.getNumRows();
        this.m_hash = new HashMap();
        int numColumns = this.m_columnNames.size();
        for (int i = 0; i < numColumns; ++i) {
            String colName = (String)this.m_columnNames.get(i);
            ColumnDetails cd = new ColumnDetails(metaData, colName);
            this.m_hash.put(colName, cd);
        }
    }

    private void init(XTMetaData emd) {
        this.m_columnNames = emd.getColumnNames();
        this.m_columnTypes = emd.getColumnTypes();
        this.m_columnRoles = emd.getColumnRoles();
        this.m_numColumns = emd.getNumColumns();
        this.m_numRows = emd.getNumRows();
        this.m_hash = this.copyHashMap(emd.m_hash, true);
    }

    public static boolean nullCognizantCompare(Object v1, Object v2) {
        boolean emdNull;
        boolean thisNull = v1 == null;
        boolean bl = emdNull = v2 == null;
        if (thisNull != emdNull) {
            return false;
        }
        if (!thisNull) {
            return v1.equals(v2);
        }
        return true;
    }

    private HashMap copyHashMap(HashMap orig, boolean deep) {
        if (!deep) {
            return new HashMap(orig);
        }
        HashMap<String, ColumnDetails> copy = new HashMap<String, ColumnDetails>();
        Set keys = orig.keySet();
        for (String key : keys) {
            ColumnDetails cd = (ColumnDetails)orig.get(key);
            copy.put(key, cd.copy());
        }
        return copy;
    }

    private boolean getColumn(int colNum) {
        try {
            String colName = (String)this.m_columnNames.get(colNum);
            if (colName.equals(this.m_lastName)) {
                return true;
            }
            this.m_lastName = colName;
            this.m_lastDetails = (ColumnDetails)this.m_hash.get(colName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean getColumn(String colName) {
        try {
            if (colName.length() > 0 && colName.equals(this.m_lastName)) {
                return true;
            }
            Object obj = this.m_hash.get(colName);
            if (obj != null) {
                this.m_lastName = colName;
                this.m_lastDetails = (ColumnDetails)obj;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String convertToXML(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public boolean appendCopyDataField(XTMetaData fromMD, int fromColumn, String newName) {
        return this.appendCopyDataField(fromMD, fromColumn, newName, null, null, -1);
    }

    public boolean appendCopyDataField(XTMetaData fromMD, int fromColumn, String newName, String newRole, String newDataType, int newStringWidth) {
        try {
            if (newName == null) {
                newName = fromMD.ordinalToName(fromColumn);
            }
            if (newRole == null) {
                newRole = fromMD.getColumnRole(fromColumn);
            }
            if (newDataType == null) {
                newDataType = fromMD.getColumnType(fromColumn);
            }
            if (newStringWidth < 0) {
                newStringWidth = fromMD.getStringDataFieldWidth(fromColumn);
            }
            if (newDataType.equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                this.appendCategoricalDataField(newName, new String[0]);
            } else if (newDataType.equals(STRING_TYPE_ATTRIBUTE_TAG)) {
                this.appendStringDataField(newName, newStringWidth);
            } else if (newDataType.equals(DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                this.appendDateTimeDataField(newName);
            } else if (newDataType.equals(BLOB_TYPE_ATTRIBUTE_TAG)) {
                this.appendBlobDataField(newName, fromMD.getBlobDataFieldClassName(fromColumn));
            } else {
                this.appendContinousDataField(newName);
            }
            this.setDataFieldRole(newName, newRole);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static class MDSaxHandler
    extends DefaultHandler {
        private XTMetaData m_metaData = null;
        private String m_currentColumn = null;
        private Object m_attribute = null;

        public MDSaxHandler(XTMetaData md) {
            this.m_metaData = md;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals(XMLTreeMetaData.DATA_FIELD_NODE_TAG)) {
                this.m_currentColumn = attributes.getValue(XMLTreeMetaData.NAME_ATTRIBUTE_TAG);
                String type = attributes.getValue(XMLTreeMetaData.TYPE_ATTRIBUTE_TAG);
                String role = attributes.getValue(XMLTreeMetaData.ROLE_ATTRIBUTE_TAG);
                if (type.equals(XMLTreeMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    this.m_attribute = new Vector();
                    this.m_metaData.appendCategoricalDataField(this.m_currentColumn, (Vector)this.m_attribute);
                } else if (type.equals(XMLTreeMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    int stringWidth = Integer.parseInt(attributes.getValue(XMLTreeMetaData.WIDTH_ATTRIBUTE_TAG));
                    this.m_metaData.appendStringDataField(this.m_currentColumn, stringWidth);
                } else if (type.equals(XMLTreeMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                    String blobClassName = attributes.getValue(XMLTreeMetaData.BLOB_CLASS_NAME_ATTRIBUTE_TAG);
                    this.m_metaData.appendBlobDataField(this.m_currentColumn, blobClassName);
                } else if (type.equals(XMLTreeMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    this.m_metaData.appendDateTimeDataField(this.m_currentColumn);
                } else {
                    this.m_metaData.appendContinousDataField(this.m_currentColumn);
                }
                if (role != null) {
                    this.m_metaData.setDataFieldRole(this.m_currentColumn, role);
                }
            } else if (qName.equals(XMLTreeMetaData.LEVEL_NODE_TAG)) {
                ((Vector)this.m_attribute).add(attributes.getValue(XMLTreeMetaData.VALUE_ATTRIBUTE_TAG));
            } else if (qName.equals(XMLTreeMetaData.TABLE_STATS_NODE_TAG)) {
                long numRows = Long.parseLong(attributes.getValue(XMLTreeMetaData.ROW_COUNT_ATTRIBUTE_TAG));
                this.m_metaData.setTableStats(numRows);
            } else if (qName.equals(XMLTreeMetaData.UNIVARIATE_STATS_NODE_TAG)) {
                this.m_currentColumn = attributes.getValue(XMLTreeMetaData.FIELD_ATTRIBUTE_TAG);
            } else if (qName.equals(XMLTreeMetaData.NUMERIC_INFO_NODE_TAG)) {
                this.m_metaData.appendNumericInfo(this.m_currentColumn, Double.parseDouble(attributes.getValue(XMLTreeMetaData.MEAN_ATTRIBUTE_TAG)), Double.parseDouble(attributes.getValue(XMLTreeMetaData.MINIMUM_ATTRIBUTE_TAG)), Double.parseDouble(attributes.getValue(XMLTreeMetaData.MAXIMUM_ATTRIBUTE_TAG)), Double.parseDouble(attributes.getValue(XMLTreeMetaData.STANDARD_DEVIATION_ATTRIBUTE_TAG)), Double.parseDouble(attributes.getValue(XMLTreeMetaData.MEDIAN_ATTRIBUTE_TAG)), Double.parseDouble(attributes.getValue(XMLTreeMetaData.IQR_ATTRIBUTE_TAG)));
                this.m_attribute = new Vector[2];
                ((Object[])this.m_attribute)[0] = new Vector();
                ((Object[])this.m_attribute)[1] = new Vector();
            } else if (qName.equals(XMLTreeMetaData.QUANTILE_NODE_TAG)) {
                String limit = attributes.getValue(XMLTreeMetaData.QUANTILE_LIMIT_ATTRIBUTE_TAG);
                String value = attributes.getValue(XMLTreeMetaData.QUANTILE_VALUE_ATTRIBUTE_TAG);
                ((Vector)((Object[])this.m_attribute)[0]).add(limit);
                ((Vector)((Object[])this.m_attribute)[1]).add(value);
            } else if (qName.equals(XMLTreeMetaData.COUNTS_NODE_TAG)) {
                this.m_metaData.appendCounts(this.m_currentColumn, Long.parseLong(attributes.getValue(XMLTreeMetaData.TOTAL_FREQUENCY_ATTRIBUTE_TAG)), Long.parseLong(attributes.getValue(XMLTreeMetaData.MISSING_FREQUENCY_ATTRIBUTE_TAG)));
                this.m_attribute = new Vector[2];
                ((Object[])this.m_attribute)[0] = new Vector();
                ((Object[])this.m_attribute)[1] = new Vector();
            } else if (qName.equals(XMLTreeMetaData.CATEGORY_NODE_TAG)) {
                String value = attributes.getValue(XMLTreeMetaData.VALUE_ATTRIBUTE_TAG);
                String freq = attributes.getValue(XMLTreeMetaData.FREQUENCY_ATTRIBUTE_TAG);
                ((Vector)((Object[])this.m_attribute)[0]).add(value);
                ((Vector)((Object[])this.m_attribute)[1]).add(freq);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(XMLTreeMetaData.DATA_FIELD_NODE_TAG)) {
                if (this.m_attribute != null && this.m_attribute instanceof Vector) {
                    this.m_metaData.appendCategoricalDataField(this.m_currentColumn, (Vector)this.m_attribute);
                }
                this.m_attribute = null;
            } else if (qName.equals(XMLTreeMetaData.NUMERIC_INFO_NODE_TAG)) {
                Vector limitVec = (Vector)((Object[])this.m_attribute)[0];
                Vector valueVec = (Vector)((Object[])this.m_attribute)[1];
                int num = limitVec.size();
                if (num > 0) {
                    double[] limits = new double[num];
                    double[] values = new double[num];
                    for (int i = 0; i < num; ++i) {
                        limits[i] = Double.parseDouble((String)limitVec.get(i));
                        values[i] = Double.parseDouble((String)valueVec.get(i));
                    }
                    this.m_metaData.appendQuantiles(this.m_currentColumn, limits, values);
                }
                this.m_attribute = null;
            } else if (qName.equals(XMLTreeMetaData.COUNTS_NODE_TAG)) {
                Vector nameVec = (Vector)((Object[])this.m_attribute)[0];
                Vector countVec = (Vector)((Object[])this.m_attribute)[1];
                int num = nameVec.size();
                if (num > 0) {
                    String[] levels = new String[num];
                    long[] counts = new long[num];
                    for (int i = 0; i < num; ++i) {
                        levels[i] = (String)nameVec.get(i);
                        counts[i] = Long.parseLong((String)countVec.get(i));
                    }
                    this.m_metaData.appendCountsCategories(this.m_currentColumn, levels, counts);
                }
                this.m_attribute = null;
            }
        }
    }

    private static class ColumnDetails {
        public int number = 0;
        public String name = null;
        public String type = null;
        public String role = null;
        public double mean = 0.0;
        public double min = 0.0;
        public double max = 0.0;
        public double stdDev = 0.0;
        public double iqr = Double.NaN;
        public double median = Double.NaN;
        public double validCount = 0.0;
        public double missingCount = 0.0;
        public int stringWidth = 0;
        public String blobClassName = null;
        public Vector levelNames = null;
        public Vector levelCounts = null;
        public Vector quantileLimits = null;
        public Vector quantileValues = null;

        public ColumnDetails() {
        }

        public ColumnDetails(XMLTreeMetaData md, String cn) {
            this.name = cn;
            this.number = md.nameToOrdinal(this.name);
            this.type = md.getColumnType(cn);
            this.role = md.getColumnRole(cn);
            if (this.role.equals("")) {
                this.role = null;
            }
            if (md.isCategoricalColumn(cn)) {
                this.levelNames = md.getCategoricalDataFieldLevels(cn);
                int numLevels = this.levelNames.size();
                for (int i = 0; i < numLevels; ++i) {
                    if (i == 0 && this.levelCounts == null) {
                        this.levelCounts = new Vector();
                    }
                    this.levelCounts.add(md.getLevelCount(cn, (String)this.levelNames.get(i)));
                }
            } else if (md.isStringColumn(cn)) {
                this.stringWidth = md.getStringDataFieldWidth(cn);
            } else if (md.isBlobColumn(cn)) {
                this.blobClassName = md.getBlobDataFieldClassName(cn);
            } else {
                this.quantileLimits = md.getQuantileLimits(cn);
                if (this.quantileLimits.size() == 0) {
                    this.quantileLimits = null;
                }
                this.quantileValues = md.getQuantileValues(cn);
                if (this.quantileValues.size() == 0) {
                    this.quantileValues = null;
                }
            }
            this.mean = md.getColumnMean(cn);
            this.min = md.getColumnMin(cn);
            this.max = md.getColumnMax(cn);
            this.stdDev = md.getColumnStandardDeviation(cn);
            this.validCount = md.getColumnRowCount(cn);
            this.missingCount = md.getColumnMissingCount(cn);
        }

        public ColumnDetails copy() {
            ColumnDetails newCD = new ColumnDetails();
            newCD.name = this.name;
            newCD.number = this.number;
            newCD.type = this.type;
            newCD.role = this.role;
            if (this.levelNames != null) {
                newCD.levelNames = (Vector)this.levelNames.clone();
            }
            if (this.levelCounts != null) {
                newCD.levelCounts = (Vector)this.levelCounts.clone();
            }
            if (this.quantileLimits != null) {
                newCD.quantileLimits = (Vector)this.quantileLimits.clone();
            }
            if (this.quantileValues != null) {
                newCD.quantileValues = (Vector)this.quantileValues.clone();
            }
            newCD.stringWidth = this.stringWidth;
            newCD.blobClassName = this.blobClassName;
            newCD.mean = this.mean;
            newCD.min = this.min;
            newCD.max = this.max;
            newCD.stdDev = this.stdDev;
            newCD.validCount = this.validCount;
            newCD.missingCount = this.missingCount;
            return newCD;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnDetails) {
                return this.equals((ColumnDetails)obj);
            }
            return false;
        }

        public boolean equals(ColumnDetails cd) {
            if (cd == this) {
                return true;
            }
            return cd.number == this.number && cd.stringWidth == this.stringWidth && cd.mean == this.mean && cd.min == this.min && cd.max == this.max && cd.stdDev == this.stdDev && cd.validCount == this.validCount && cd.missingCount == this.missingCount && XTMetaData.nullCognizantCompare(cd.blobClassName, this.blobClassName) && XTMetaData.nullCognizantCompare(cd.name, this.name) && XTMetaData.nullCognizantCompare(cd.type, this.type) && XTMetaData.nullCognizantCompare(cd.role, this.role) && XTMetaData.nullCognizantCompare(this.levelCounts, cd.levelCounts) && XTMetaData.nullCognizantCompare(this.levelNames, cd.levelNames) && XTMetaData.nullCognizantCompare(this.quantileLimits, cd.quantileLimits) && XTMetaData.nullCognizantCompare(this.quantileValues, cd.quantileValues);
        }
    }

    private class IndexTracker
    implements Comparable {
        public String level;
        public int origPos;

        public IndexTracker(String str, int pos) {
            this.level = str;
            this.origPos = pos;
        }

        public String toString() {
            return this.level;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IndexTracker) {
                return this.level.equals(((IndexTracker)obj).level);
            }
            return false;
        }

        public int compareTo(Object obj) {
            if (obj instanceof IndexTracker) {
                return this.level.compareTo(((IndexTracker)obj).level);
            }
            return -1;
        }
    }
}

