/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.expression;

import com.insightful.miner.expression.ExpressionParser;
import com.insightful.miner.expression.ExpressionParserTreeConstants;
import com.insightful.miner.expression.Node;
import com.insightful.miner.expression.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected ExpressionParser parser;
    public Token m_first_token = null;
    public String m_value = null;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(ExpressionParser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public String getName() {
        return ExpressionParserTreeConstants.jjtNodeName[this.id];
    }

    public String getValue() {
        return this.m_value;
    }

    public Token getFirstToken() {
        return this.m_first_token;
    }

    public String toString() {
        String name = this.getName();
        String val = this.getValue();
        if (val != null) {
            name = name + "[" + val + "]";
        }
        if (this.m_first_token != null) {
            name = name + " {" + this.m_first_token.beginLine + "," + this.m_first_token.beginColumn + "}";
        }
        return name;
    }
}

