/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerLabelBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTextField;

public class MinerTextField
extends MinerLabelBox
implements MinerControlMethods {
    JTextField textField;
    Vector listeners = new Vector();

    public MinerTextField(String text, char mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerTextField(String text) {
        super(text);
        this.textField = new JTextField();
        this.textField.setPreferredSize(labelDimension);
        this.textField.setMinimumSize(labelDimension);
        this.textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    MinerTextField.this.fireEvent(new ActionEvent(MinerTextField.this.textField, 1001, MinerTextField.this.textField.getText()));
                }
            }
        });
        this.setActionControl(this.textField);
    }

    public String getValue() {
        String value = this.textField.getText();
        if (value.endsWith("\\") && !value.endsWith("\\\\")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public void setValue(String value) {
        this.textField.setText(value);
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] listData) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
        this.setLabelEnabled(b);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void fireEvent(ActionEvent ae) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) == null) continue;
                ((ActionListener)this.listeners.get(i)).actionPerformed(ae);
            }
        }
    }
}

