/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.XTMetaData;
import com.insightful.miner.sql.CompiledStatement;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Parser;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.Token;
import com.insightful.miner.sql.Tokenizer;
import com.insightful.miner.sql.Trace;
import java.util.Hashtable;

public class DatabaseCommandInterpreter {
    Tokenizer tokenizer = new Tokenizer();
    XTMetaData metaData = null;

    public DatabaseCommandInterpreter(XTMetaData md) {
        this.metaData = md;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(String sql) {
        Result result = null;
        int cmd = -1;
        try {
            this.tokenizer.reset(sql);
            Parser parser = new Parser(new Hashtable(), this.tokenizer);
            while (true) {
                this.tokenizer.setPartMarker();
                String token = this.tokenizer.getString();
                if (token.length() == 0) return result == null ? new Result(1) : result;
                cmd = Token.get(token);
                if (cmd == 320) continue;
                result = this.executePart(cmd, token, parser);
                if (result.iMode == 2) return result == null ? new Result(1) : result;
            }
        }
        catch (Throwable t) {
            result = new Result(t, this.tokenizer.getLastPart());
        }
        return result == null ? new Result(1) : result;
    }

    private Result executePart(int cmd, String token, Parser parser) throws Throwable {
        Result result = new Result(1);
        switch (cmd) {
            case 193: {
                CompiledStatement cStatement = parser.compileSelectStatement(false);
                if (cStatement.parameters.length == 0) break;
                Trace.doAssert(false, Trace.getMessage(165));
                break;
            }
            case 112: {
                CompiledStatement cStatement = parser.compileInsertStatement();
                if (cStatement.parameters.length == 0) break;
                Trace.doAssert(false, Trace.getMessage(165));
                break;
            }
            case 222: {
                CompiledStatement cStatement = parser.compileUpdateStatement();
                if (cStatement.parameters.length == 0) break;
                Trace.doAssert(false, Trace.getMessage(165));
                break;
            }
            case 62: {
                CompiledStatement cStatement = parser.compileDeleteStatement();
                if (cStatement.parameters.length == 0) break;
                Trace.doAssert(false, Trace.getMessage(165));
                break;
            }
            case 23: {
                CompiledStatement cStatement = parser.compileCallStatement();
                if (cStatement.parameters.length == 0) break;
                Trace.doAssert(false, Trace.getMessage(165));
                break;
            }
            case 196: {
                break;
            }
            case 35: {
                break;
            }
            case 184: {
                break;
            }
            case 188: {
                break;
            }
            case 41: {
                break;
            }
            case 4: {
                break;
            }
            case 70: {
                break;
            }
            case 96: {
                break;
            }
            case 182: {
                break;
            }
            case 37: {
                break;
            }
            case 66: {
                break;
            }
            case 318: {
                break;
            }
            case 322: {
                break;
            }
            case 303: {
                break;
            }
            case 304: {
                break;
            }
            case 176: {
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
        return result;
    }

    private void processCreate() throws HsqlException {
        String token = this.tokenizer.getString();
        boolean isTemp = false;
        if (token.equals("TEMP")) {
            isTemp = true;
            token = this.tokenizer.getString();
            switch (Token.get(token)) {
                case 213: 
                case 309: 
                case 325: {
                    break;
                }
                default: {
                    throw Trace.error(11, token);
                }
            }
        }
        boolean unique = false;
        boolean tableType = false;
        switch (Token.get(token)) {
            case 300: {
                break;
            }
            case 321: {
                break;
            }
            case 224: {
                break;
            }
            case 223: {
                break;
            }
            case 326: {
                break;
            }
            case 228: {
                unique = true;
                this.tokenizer.getThis("INDEX");
            }
            case 306: {
                break;
            }
            default: {
                throw Trace.error(11, token);
            }
        }
    }

    public static void checkBooleanDefault(String s, int type) throws HsqlException {
        if (type != 16 || s == null) {
            return;
        }
        if ((s = s.toUpperCase()).equals("TRUE") || s.equals("FALSE")) {
            return;
        }
        if (s.equals("0") || s.equals("1")) {
            return;
        }
        throw Trace.error(46, s);
    }
}

