/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.model;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKObj;
import java.util.Hashtable;
import java.util.Vector;

public class CategoricalLevelMapper {
    private CNKBuf m_buf = null;
    private int m_numColumns = 0;
    private Vector[] m_modelLevels = null;
    private Hashtable[] m_levelMap = null;
    private Hashtable m_unknownLevelBehaviors = null;
    private String m_unknownLevelBadColumn = null;
    private String m_unknownLevelBadLevel = null;

    public CategoricalLevelMapper(CNKBuf buf) {
        this.m_buf = buf;
        this.m_numColumns = buf == null ? 0 : buf.getNumColumns();
        this.m_modelLevels = new Vector[this.m_numColumns];
        this.m_levelMap = new Hashtable[this.m_numColumns];
        this.clearUnknownLevelError();
    }

    public void setModelLevels(int col, Vector levelNames) {
        this.m_modelLevels[col] = levelNames;
        this.m_levelMap[col] = new Hashtable();
    }

    public void setUnknownLevelBehaviors(Hashtable unknownLevelBehaviors) {
        this.m_unknownLevelBehaviors = unknownLevelBehaviors;
    }

    public double mapBufLevelToModelLevel(int col, double bufLevel) {
        if (CNKBuf.isDoubleNA(bufLevel)) {
            return bufLevel;
        }
        Double bufLevelDouble = new Double(bufLevel);
        Double modelLevelDouble = (Double)this.m_levelMap[col].get(bufLevelDouble);
        if (modelLevelDouble != null) {
            return modelLevelDouble;
        }
        String bufLevelString = this.m_buf.mapDoubleToLevel(col, bufLevel);
        int modelIndex = this.m_modelLevels[col].indexOf(bufLevelString);
        double modelLevel = modelIndex;
        if (modelIndex < 0) {
            String colName = this.m_buf.getColumnName(col);
            String unknownLevelBehavior = null;
            if (this.m_unknownLevelBehaviors != null) {
                unknownLevelBehavior = (String)this.m_unknownLevelBehaviors.get(colName);
            }
            if (unknownLevelBehavior == null || CNKObj.isStringNA(unknownLevelBehavior)) {
                modelLevel = CNKObj.getDoubleNA();
            } else if (unknownLevelBehavior.equals("")) {
                if (!this.hasUnknownLevelError()) {
                    this.m_unknownLevelBadColumn = colName;
                    this.m_unknownLevelBadLevel = bufLevelString;
                }
                modelLevel = CNKObj.getDoubleNA();
            } else {
                int subLevelIndex = this.m_modelLevels[col].indexOf(unknownLevelBehavior);
                modelLevel = subLevelIndex < 0 ? CNKObj.getDoubleNA() : (double)subLevelIndex;
            }
        }
        this.m_levelMap[col].put(bufLevelDouble, new Double(modelLevel));
        return modelLevel;
    }

    public void clearUnknownLevelError() {
        this.m_unknownLevelBadColumn = null;
        this.m_unknownLevelBadLevel = null;
    }

    public boolean hasUnknownLevelError() {
        return this.m_unknownLevelBadColumn != null;
    }

    public String getUnknownLevelBadColumn() {
        return this.m_unknownLevelBadColumn;
    }

    public String getUnknownLevelBadLevel() {
        return this.m_unknownLevelBadLevel;
    }
}

