/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.chart.event.TitleChangeListener;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTitle
implements Cloneable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int MIDDLE = 4;
    public static final int DEFAULT_POSITION = 0;
    public static final int DEFAULT_HORIZONTAL_ALIGNMENT = 4;
    public static final int DEFAULT_VERTICAL_ALIGNMENT = 4;
    public static final Spacer DEFAULT_SPACER = new Spacer(0, 0.05, 0.3, 0.05, 0.15);
    protected boolean notify;
    protected int position;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected Spacer spacer;
    protected List listeners;

    protected AbstractTitle() {
        this(0, 4, 4, DEFAULT_SPACER);
    }

    protected AbstractTitle(int n, int n2, int n3) {
        this(n, n2, n3, DEFAULT_SPACER);
    }

    protected AbstractTitle(int n, int n2, int n3, Spacer spacer) {
        if (!this.isValidPosition(n)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid position.");
        }
        if (!AbstractTitle.isValidHorizontalAlignment(n2)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid horizontal alignment.");
        }
        if (!AbstractTitle.isValidVerticalAlignment(n3)) {
            throw new IllegalArgumentException("AbstractTitle(): Invalid vertical alignment.");
        }
        this.position = n;
        this.horizontalAlignment = n2;
        this.verticalAlignment = n3;
        this.spacer = spacer;
        this.listeners = new ArrayList();
        this.notify = true;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        if (this.position != n) {
            this.position = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (this.horizontalAlignment != n) {
            this.horizontalAlignment = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (this.verticalAlignment != n) {
            this.verticalAlignment = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public void setSpacer(Spacer spacer) {
        if (!this.spacer.equals(spacer)) {
            this.spacer = spacer;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public abstract boolean isValidPosition(int var1);

    public abstract double getPreferredWidth(Graphics2D var1);

    public abstract double getPreferredHeight(Graphics2D var1);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Object clone() {
        AbstractTitle abstractTitle = null;
        try {
            abstractTitle = (AbstractTitle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("AbstractTitle.clone()");
        }
        return abstractTitle;
    }

    public void addChangeListener(TitleChangeListener titleChangeListener) {
        this.listeners.add(titleChangeListener);
    }

    public void removeChangeListener(TitleChangeListener titleChangeListener) {
        this.listeners.remove(titleChangeListener);
    }

    protected void notifyListeners(TitleChangeEvent titleChangeEvent) {
        if (this.notify) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                TitleChangeListener titleChangeListener = (TitleChangeListener)iterator.next();
                titleChangeListener.titleChanged(titleChangeEvent);
            }
        }
    }

    protected static boolean isValidHorizontalAlignment(int n) {
        switch (n) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isValidVerticalAlignment(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }
}

