/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected double candleWidth;
    protected Paint upPaint;
    protected Paint downPaint;
    protected boolean drawVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true);
    }

    public CandlestickRenderer(double d, boolean bl) {
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            Double d2 = new Double(this.candleWidth);
            this.candleWidth = d;
            this.firePropertyChanged("CandleStickRenderer.candleWidth", d2, new Double(d));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.upPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.upPaint", paint2, paint);
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.downPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.downPaint", paint2, paint);
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.firePropertyChanged("CandlestickRenderer.drawVolume", null, new Boolean(bl));
        }
    }

    public Shape drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, double d, CrosshairInfo crosshairInfo) {
        Rectangle2D.Double double_ = null;
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n, n2);
        Number number2 = highLowDataset.getHighValue(n, n2);
        Number number3 = highLowDataset.getLowValue(n, n2);
        Number number4 = highLowDataset.getOpenValue(n, n2);
        Number number5 = highLowDataset.getCloseValue(n, n2);
        double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d3 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d5 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
        double d6 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D);
        double d7 = this.candleWidth;
        double d8 = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int n3 = highLowDataset.getItemCount(n);
            d7 = (rectangle2D.getMaxX() - rectangle2D.getMinX()) / (double)n3 * 4.5 / 7.0;
            if (d7 < 1.0) {
                d7 = 1.0;
            }
            if ((d8 = d7) < 3.0) {
                d8 = 3.0;
            }
        }
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n4 = highLowDataset.getVolumeValue(n, n2).intValue();
            int n5 = 1;
            int n6 = highLowDataset.getItemCount(n);
            int n7 = 0;
            while (n7 < n6) {
                int n8 = highLowDataset.getVolumeValue(n, n7).intValue();
                if (n8 > n5) {
                    n5 = n8;
                }
                ++n7;
            }
            double d9 = (double)n4 / (double)n5;
            double d10 = rectangle2D.getMinY();
            double d11 = rectangle2D.getMaxY();
            double d12 = d9 * (d11 - d10);
            graphics2D.setPaint(Color.gray);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(new Rectangle2D.Double(d2 - d7 / 2.0, d11 - d12, d7, d12));
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
        if (d3 < d5 && d3 < d6) {
            graphics2D.draw(new Line2D.Double(d2, d3, d2, Math.min(d5, d6)));
        }
        if (d4 > d5 && d4 > d6) {
            graphics2D.draw(new Line2D.Double(d2, d4, d2, Math.max(d5, d6)));
        }
        Rectangle2D.Double double_2 = null;
        if (d5 > d6) {
            double_2 = new Rectangle2D.Double(d2 - d8 / 2.0, d6, d8, d5 - d6);
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_2);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(double_2);
        } else {
            double_2 = new Rectangle2D.Double(d2 - d8 / 2.0, d5, d8, d6 - d5);
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_2);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_2);
        }
        double_ = double_2;
        return double_;
    }
}

