/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

final class ExtremaOpImage
extends StatisticsOpImage {
    private double[][] extrema = null;
    private PixelAccessor srcPA;
    private int srcPixelType;

    public ExtremaOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, int n5, int n6) {
        super(renderedImage, rOI, n, n2, n3, n4, n5, n6);
        this.srcPA = new PixelAccessor(renderedImage);
        this.srcPixelType = this.srcPA.pixelType == -1 ? 0 : this.srcPA.pixelType;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        LinkedList linkedList;
        Rectangle rectangle = this.source0.getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n = rectangle2.x;
            int n2 = rectangle2.y;
            rectangle2.x = this.startPosition(n, this.xStart, this.xPeriod);
            rectangle2.y = this.startPosition(n2, this.yStart, this.yPeriod);
            rectangle2.width = n + rectangle2.width - rectangle2.x;
            rectangle2.height = n2 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            if (this.extrema == null) {
                this.extrema = new double[2][this.srcPA.numBands];
                raster.getPixel(rectangle2.x, rectangle2.y, this.extrema[0]);
                int n3 = 0;
                while (n3 < this.srcPA.numBands) {
                    this.extrema[1][n3] = this.extrema[0][n3];
                    ++n3;
                }
            }
            UnpackedPixelData unpackedPixelData = this.srcPA.getData(raster, rectangle2, this.srcPixelType, false);
            switch (unpackedPixelData.dataType) {
                case 0: {
                    this.accumulateStatisticsByte(unpackedPixelData);
                    break;
                }
                case 1: {
                    this.accumulateStatisticsUShort(unpackedPixelData);
                    break;
                }
                case 2: {
                    this.accumulateStatisticsShort(unpackedPixelData);
                    break;
                }
                case 3: {
                    this.accumulateStatisticsInt(unpackedPixelData);
                    break;
                }
                case 4: {
                    this.accumulateStatisticsFloat(unpackedPixelData);
                    break;
                }
                case 5: {
                    this.accumulateStatisticsDouble(unpackedPixelData);
                    break;
                }
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        byte[][] byArray = unpackedPixelData.getByteData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            byte[] byArray2 = byArray[n5];
            int n8 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n9 = unpackedPixelData.offsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = byArray2[n11] & 0xFF;
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsDouble(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        double[][] dArray = unpackedPixelData.getDoubleData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            double d = this.extrema[0][n5];
            double d2 = this.extrema[1][n5];
            double[] dArray2 = dArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    double d3 = dArray2[n9];
                    if (d3 < d) {
                        d = d3;
                    } else if (d3 > d2) {
                        d2 = d3;
                    }
                    n9 += n4;
                }
                n7 += n3;
            }
            this.extrema[0][n5] = d;
            this.extrema[1][n5] = d2;
            ++n5;
        }
    }

    private void accumulateStatisticsFloat(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        float[][] fArray = unpackedPixelData.getFloatData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            float f = (float)this.extrema[0][n5];
            float f2 = (float)this.extrema[1][n5];
            float[] fArray2 = fArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    float f3 = fArray2[n9];
                    if (f3 < f) {
                        f = f3;
                    } else if (f3 > f2) {
                        f2 = f3;
                    }
                    n9 += n4;
                }
                n7 += n3;
            }
            this.extrema[0][n5] = f;
            this.extrema[1][n5] = f2;
            ++n5;
        }
    }

    private void accumulateStatisticsInt(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        int[][] nArray = unpackedPixelData.getIntData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            int[] nArray2 = nArray[n5];
            int n8 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n9 = unpackedPixelData.offsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = nArray2[n11];
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            short[] sArray2 = sArray[n5];
            int n8 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n9 = unpackedPixelData.offsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = sArray2[n11];
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    private void accumulateStatisticsUShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int n6 = (int)this.extrema[0][n5];
            int n7 = (int)this.extrema[1][n5];
            short[] sArray2 = sArray[n5];
            int n8 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n9 = unpackedPixelData.offsets[n5];
            while (n9 < n8) {
                int n10 = n9 + rectangle.width * n2;
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = sArray2[n11] & 0xFFFF;
                    if (n12 < n6) {
                        n6 = n12;
                    } else if (n12 > n7) {
                        n7 = n12;
                    }
                    n11 += n4;
                }
                n9 += n3;
            }
            this.extrema[0][n5] = n6;
            this.extrema[1][n5] = n7;
            ++n5;
        }
    }

    protected Object createStatistics(String string) {
        Object object = null;
        object = string.equalsIgnoreCase("extrema") ? new double[2][this.srcPA.numBands] : (string.equalsIgnoreCase("minimum") || string.equalsIgnoreCase("maximum") ? (Object)new double[this.srcPA.numBands] : (Object)Image.UndefinedProperty);
        return object;
    }

    public Object getProperty(String string) {
        Object object;
        int n;
        Object object2;
        if (this.extrema == null) {
            object2 = this;
            synchronized (object2) {
                int n2 = this.source0.getMinTileX();
                int n3 = this.source0.getMaxTileX();
                int n4 = this.source0.getMinTileY();
                n = this.source0.getMaxTileY();
                int n5 = n4;
                while (n5 <= n) {
                    int n6 = n2;
                    while (n6 <= n3) {
                        if (this.tileIntersectsROI(n6, n5)) {
                            this.accumulateStatistics(string, this.getTile(n6, n5), this.extrema);
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        if ((object = ((Hashtable)(object2 = this.getProperties())).get(string)) == null || object.equals(Image.UndefinedProperty)) {
            ExtremaOpImage extremaOpImage = this;
            synchronized (extremaOpImage) {
                object = this.createStatistics(string);
                if (string.equalsIgnoreCase("extrema")) {
                    double[][] dArray = (double[][])object;
                    n = 0;
                    while (n < this.srcPA.numBands) {
                        dArray[0][n] = this.extrema[0][n];
                        dArray[1][n] = this.extrema[1][n];
                        ++n;
                    }
                } else if (string.equalsIgnoreCase("minimum")) {
                    double[] dArray = (double[])object;
                    n = 0;
                    while (n < this.srcPA.numBands) {
                        dArray[n] = this.extrema[0][n];
                        ++n;
                    }
                } else if (string.equalsIgnoreCase("maximum")) {
                    double[] dArray = (double[])object;
                    n = 0;
                    while (n < this.srcPA.numBands) {
                        dArray[n] = this.extrema[1][n];
                        ++n;
                    }
                }
                this.setProperty(string, object);
                this.properties.put(string, object);
            }
        }
        return object;
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"extrema", "maximum", "minimum"};
        return stringArray;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }
}

