/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.opimage.CRIFImpl;
import com.sun.media.jai.opimage.FilterCRIF;
import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderableImageOp;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;

public class IIPCRIF
extends CRIFImpl {
    private static final int MASK_FILTER = 1;
    private static final int MASK_COLOR_TWIST = 2;
    private static final int MASK_CONTRAST = 4;
    private static final int MASK_ROI_SOURCE = 8;
    private static final int MASK_TRANSFORM = 16;
    private static final int MASK_ASPECT_RATIO = 32;
    private static final int MASK_ROI_DESTINATION = 64;
    private static final int MASK_ROTATION = 128;
    private static final int MASK_MIRROR_AXIS = 256;
    private static final int MASK_ICC_PROFILE = 512;
    private static final int MASK_JPEG_QUALITY = 1024;
    private static final int MASK_JPEG_TABLE = 2048;
    private static final int VENDOR_HP = 0;
    private static final int VENDOR_LIVE_PICTURE = 1;
    private static final int VENDOR_KODAK = 2;
    private static final int VENDOR_UNREGISTERED = 255;
    private static final int VENDOR_EXPERIMENTAL = 999;
    private static final int SERVER_CVT_JPEG = 1;
    private static final int SERVER_CVT_FPX = 2;
    private static final int SERVER_CVT_MJPEG = 4;
    private static final int SERVER_CVT_MFPX = 8;
    private static final int SERVER_CVT_M2JPEG = 16;
    private static final int SERVER_CVT_M2FPX = 32;
    private static final int SERVER_CVT_JTL = 64;
    private static final int SERVER_JPEG_PARTIAL = 5;
    private static final int SERVER_JPEG_FULL = 21;
    private static final int SERVER_FPX_PARTIAL = 10;
    private static final int SERVER_FPX_FULL = 42;
    private static final double[][] YCCA_TO_RGBA;
    private static final double[][] YCCA_TO_RGBA_CONST;
    private static final double[][] RGBA_TO_YCCA;
    private static final double[][] RGBA_TO_YCCA_CONST;
    private static final double[][] YCC_TO_RGB;
    private static final double[][] YCC_TO_RGB_CONST;
    private static final double[][] RGB_TO_YCC;
    private static final double[][] RGB_TO_YCC_CONST;

    static {
        double[][] dArrayArray = new double[4][];
        double[] dArray = new double[4];
        dArray[0] = 1.3584;
        dArray[2] = 1.8215;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[4];
        dArray2[0] = 1.3584;
        dArray2[1] = -0.4303;
        dArray2[2] = -0.9271;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[4];
        dArray3[0] = 1.3584;
        dArray3[1] = 2.2179;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[4];
        dArray4[3] = 1.0;
        dArrayArray[3] = dArray4;
        YCCA_TO_RGBA = dArrayArray;
        YCCA_TO_RGBA_CONST = new double[][]{{-249.55}, {194.14}, {-345.99}, new double[1]};
        double[][] dArrayArray2 = new double[4][];
        double[] dArray5 = new double[4];
        dArray5[0] = 0.220018;
        dArray5[1] = 0.432276;
        dArray5[2] = 0.083867;
        dArrayArray2[0] = dArray5;
        double[] dArray6 = new double[4];
        dArray6[0] = -0.134755;
        dArray6[1] = -0.264756;
        dArray6[2] = 0.399511;
        dArrayArray2[1] = dArray6;
        double[] dArray7 = new double[4];
        dArray7[0] = 0.384918;
        dArray7[1] = -0.322373;
        dArray7[2] = -0.062544;
        dArrayArray2[2] = dArray7;
        double[] dArray8 = new double[4];
        dArray8[3] = 1.0;
        dArrayArray2[3] = dArray8;
        RGBA_TO_YCCA = dArrayArray2;
        RGBA_TO_YCCA_CONST = new double[][]{{5.726E-4}, {155.9984}, {137.0022}, new double[1]};
        double[][] dArrayArray3 = new double[3][];
        double[] dArray9 = new double[3];
        dArray9[0] = 1.3584;
        dArray9[2] = 1.8215;
        dArrayArray3[0] = dArray9;
        dArrayArray3[1] = new double[]{1.3584, -0.4303, -0.9271};
        double[] dArray10 = new double[3];
        dArray10[0] = 1.3584;
        dArray10[1] = 2.2179;
        dArrayArray3[2] = dArray10;
        YCC_TO_RGB = dArrayArray3;
        YCC_TO_RGB_CONST = new double[][]{{-249.55}, {194.14}, {-345.99}};
        RGB_TO_YCC = new double[][]{{0.220018, 0.432276, 0.083867}, {-0.134755, -0.264756, 0.399511}, {0.384918, -0.322373, -0.062544}};
        RGB_TO_YCC_CONST = new double[][]{{5.726E-4}, {155.9984}, {137.0022}};
    }

    public IIPCRIF() {
        super("IIP");
    }

    private static boolean canDecode(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        URL uRL = null;
        InputStream inputStream = null;
        RenderedImage renderedImage = null;
        boolean bl = false;
        try {
            stringBuffer.append(string2);
            uRL = new URL(stringBuffer.toString());
            inputStream = uRL.openStream();
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)string3, (InputStream)inputStream, null);
            renderedImage = imageDecoder.decodeAsRenderedImage();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private RenderedImage clientProc(RenderContext renderContext, ParameterBlock parameterBlock, int n, RenderedImage renderedImage) {
        Object object;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        int[] nArray2 = (int[])renderedImage.getProperty("max-size");
        int n5 = nArray2[0];
        int n6 = nArray2[1];
        int n7 = (Integer)renderedImage.getProperty("resolution-number");
        float f = (float)n5 / (float)n6;
        float f2 = (n & 0x20) != 0 ? parameterBlock.getFloatParameter(7) : f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f2, 1.0f);
        if (affineTransform.isIdentity()) {
            cloneable = (AffineTransform)parameterBlock.getObjectParameter(6);
            Rectangle2D rectangle2D = ((AffineTransform)cloneable).createTransformedShape(float_).getBounds2D();
            double d = (double)n6 * rectangle2D.getHeight();
            double d2 = (double)n6 * rectangle2D.getWidth();
            double d3 = Math.max(d, d2 / (double)f);
            n4 = (int)(d3 + 0.5);
            n3 = (int)((double)f * d3 + 0.5);
            affineTransform = AffineTransform.getScaleInstance(n3, n4);
            renderContext = (RenderContext)renderContext.clone();
            renderContext.setTransform(affineTransform);
        } else {
            cloneable = affineTransform.createTransformedShape(float_).getBounds();
            n3 = ((Rectangle)cloneable).width;
            n4 = ((Rectangle)cloneable).height;
        }
        int n8 = n7 - 1;
        int n9 = n6;
        while (n8 > 0) {
            if ((n9 = (int)(((float)n9 + 1.0f) / 2.0f)) < n4) break;
            --n8;
        }
        int n10 = n2 = (nArray = (int[])parameterBlock.getObjectParameter(1)).length < n8 + 1 ? 0 : nArray[n8];
        if (n2 < 0) {
            n2 = 0;
        }
        ParameterBlock parameterBlock2 = new ParameterBlock();
        parameterBlock2.add(parameterBlock.getObjectParameter(0)).add(n8).add(n2);
        RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
        Vector<RenderedOp> vector = new Vector<RenderedOp>(1);
        vector.add(renderedOp);
        RenderableImage renderableImage = new MultiResolutionRenderableImage(vector, 0.0f, 0.0f, 1.0f);
        if ((n & 1) != 0) {
            float f3 = parameterBlock.getFloatParameter(2);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(f3);
            renderableImage = new RenderableImageOp(new FilterCRIF(), parameterBlock2);
        }
        int n11 = renderedOp.getSampleModel().getNumBands();
        if ((n & 2) != 0) {
            object = IIPCRIF.getColorTwistMatrix(renderedOp.getColorModel(), parameterBlock);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(object);
            renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            n11 = ((double[][])object).length;
        }
        if ((n & 4) != 0) {
            boolean bl;
            int n12 = renderedOp.getColorModel().getColorSpace().getType();
            boolean bl2 = bl = n12 != 6 && n12 != 5;
            if (bl) {
                double[][] dArray = n11 == 3 ? IIPCRIF.composeMatrices(YCC_TO_RGB, YCC_TO_RGB_CONST) : IIPCRIF.composeMatrices(YCCA_TO_RGBA, YCCA_TO_RGBA_CONST);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(dArray);
                renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            }
            float f4 = parameterBlock.getFloatParameter(4);
            LookupTableJAI lookupTableJAI = IIPCRIF.createContrastLUT(f4, n11);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(lookupTableJAI);
            renderableImage = JAI.createRenderable("lookup", parameterBlock2);
            if (bl) {
                double[][] dArray = n11 == 3 ? IIPCRIF.composeMatrices(RGB_TO_YCC, RGB_TO_YCC_CONST) : IIPCRIF.composeMatrices(RGBA_TO_YCCA, RGBA_TO_YCCA_CONST);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(dArray);
                renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            }
        }
        if ((n & 8) != 0) {
            object = (Rectangle2D)parameterBlock.getObjectParameter(5);
            if (!((Rectangle2D)object).intersects(0.0, 0.0, f, 1.0)) {
                throw new RuntimeException(JaiI18N.getString("IIPCRIF5"));
            }
            Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, 0.0f, f, 1.0f);
            if (!((Rectangle2D)object).equals(float_2)) {
                object = ((Rectangle2D)object).createIntersection(float_2);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage);
                parameterBlock2.add((float)((RectangularShape)object).getMinX()).add((float)((RectangularShape)object).getMinY());
                parameterBlock2.add((float)((RectangularShape)object).getWidth()).add((float)((RectangularShape)object).getHeight());
                renderableImage = JAI.createRenderable("crop", parameterBlock2);
            }
        }
        if ((n & 0x10) != 0) {
            object = (AffineTransform)parameterBlock.getObjectParameter(6);
            try {
                object = ((AffineTransform)object).createInverse();
            }
            catch (Exception exception) {}
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(object);
            if (renderingHints != null && renderingHints.containsKey(JAI.KEY_INTERPOLATION)) {
                parameterBlock2.add(renderingHints.get(JAI.KEY_INTERPOLATION));
            }
            renderableImage = JAI.createRenderable("affine", parameterBlock2);
        }
        if (((RectangularShape)(object = (Object)((n & 0x40) != 0 ? (Rectangle2D)parameterBlock.getObjectParameter(8) : float_))).isEmpty()) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF3"));
        }
        Rectangle2D.Float float_3 = new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        if (!((Rectangle2D)object).equals(float_3)) {
            object = ((Rectangle2D)object).createIntersection(float_3);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage);
            parameterBlock2.add((float)((RectangularShape)object).getMinX()).add((float)((RectangularShape)object).getMinY());
            parameterBlock2.add((float)((RectangularShape)object).getWidth()).add((float)((RectangularShape)object).getHeight());
            renderableImage = JAI.createRenderable("crop", parameterBlock2);
        }
        return renderableImage.createRendering(renderContext);
    }

    private static final double[][] composeMatrices(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF1"));
        }
        if (dArray2[0].length != 1) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF2"));
        }
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2 + 1];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray3[n3][n4] = dArray[n3][n4];
                ++n4;
            }
            dArray3[n3][n2] = dArray2[n3][0];
            ++n3;
        }
        return dArray3;
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderableOp renderableOp = JAI.createRenderable("iip", parameterBlock);
        return renderableOp.createDefaultRendering();
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        Object object;
        int n = IIPCRIF.getOperationMask(parameterBlock);
        ParameterBlock parameterBlock2 = new ParameterBlock();
        int[] nArray = (int[])parameterBlock.getObjectParameter(1);
        parameterBlock2.add(parameterBlock.getObjectParameter(0)).add(0).add(nArray[0]);
        RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
        int n2 = IIPCRIF.getServerCapabilityMask((String)parameterBlock.getObjectParameter(0), renderedOp);
        RenderedImage renderedImage = null;
        if ((n2 & 0x15) == 21 || (n2 & 0x2A) == 42 || (n2 & 5) == 5 || (n2 & 0xA) == 10) {
            renderedImage = this.serverProc(n2, renderContext, parameterBlock, n, renderedOp);
        } else {
            renderedImage = this.clientProc(renderContext, parameterBlock, n, renderedOp);
            if ((n & 8) != 0) {
                object = (Rectangle2D)parameterBlock.getObjectParameter(5);
                AffineTransform affineTransform = (AffineTransform)((AffineTransform)parameterBlock.getObjectParameter(6)).clone();
                if (!affineTransform.isIdentity()) {
                    try {
                        affineTransform = affineTransform.createInverse();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(JaiI18N.getString("IIPCRIF6"));
                    }
                }
                affineTransform.preConcatenate(renderContext.getTransform());
                ROIShape rOIShape = new ROIShape(affineTransform.createTransformedShape((Shape)object));
                TiledImage tiledImage = new TiledImage(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset(), renderedImage.getSampleModel(), renderedImage.getColorModel());
                tiledImage.set(renderedImage, rOIShape);
                parameterBlock2 = new ParameterBlock();
                parameterBlock2.add((float)tiledImage.getWidth());
                parameterBlock2.add((float)tiledImage.getHeight());
                Byte[] byteArray = new Byte[tiledImage.getSampleModel().getNumBands()];
                int n3 = 0;
                while (n3 < byteArray.length) {
                    byteArray[n3] = new Byte(-1);
                    ++n3;
                }
                parameterBlock2.add(byteArray);
                ImageLayout imageLayout = new ImageLayout();
                imageLayout.setSampleModel(tiledImage.getSampleModel());
                RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
                RenderedOp renderedOp2 = JAI.create("constant", parameterBlock2, renderingHints);
                ROI rOI = new ROIShape(tiledImage.getBounds()).subtract(rOIShape);
                int n4 = tiledImage.getMaxTileY();
                int n5 = tiledImage.getMaxTileX();
                int n6 = tiledImage.getMinTileY();
                while (n6 <= n4) {
                    int n7 = tiledImage.getMinTileX();
                    while (n7 <= n5) {
                        if (!rOIShape.intersects(tiledImage.getTileRect(n7, n6))) {
                            tiledImage.setData(((PlanarImage)renderedOp2).getTile(n7, n6), rOI);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                renderedImage = tiledImage;
            }
        }
        if ((n2 & 0x15) != 21 && (n2 & 0x2A) != 42) {
            if ((n & 0x80) != 0) {
                int n8 = 0;
                switch (parameterBlock.getIntParameter(9)) {
                    case 90: {
                        n8 = 6;
                        break;
                    }
                    case 180: {
                        n8 = 5;
                        break;
                    }
                    case 270: {
                        n8 = 4;
                        break;
                    }
                }
                if (n8 != 0) {
                    renderedImage = JAI.create("transpose", renderedImage, n8);
                }
            }
            if ((n & 0x100) != 0) {
                object = (String)parameterBlock.getObjectParameter(10);
                int n9 = ((String)object).equalsIgnoreCase("x") ? 0 : 1;
                renderedImage = JAI.create("transpose", renderedImage, n9);
            }
        }
        return renderedImage;
    }

    private static final LookupTableJAI createContrastLUT(float f, int n) {
        byte[] byArray = new byte[256];
        double d = 0.43f;
        int n2 = 0;
        while (n2 < 256) {
            float f2 = ((float)n2 - 127.5f) / 255.0f;
            float f3 = 0.0f;
            if (f2 < 0.0f) {
                f3 = (float)(-d * Math.pow((double)(-f2) / d, f));
            } else if (f2 > 0.0f) {
                f3 = (float)(d * Math.pow((double)f2 / d, f));
            }
            int n3 = (int)(f3 * 255.0f + 127.5f);
            byArray[n2] = n3 < 0 ? 0 : (n3 > 255 ? -1 : (byte)(n3 & 0xFF));
            ++n2;
        }
        byte[][] byArray2 = new byte[n][];
        if (n % 2 == 1) {
            int n4 = 0;
            while (n4 < n) {
                byArray2[n4] = byArray;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n - 1) {
                byArray2[n5] = byArray;
                ++n5;
            }
            byArray2[n - 1] = new byte[256];
            byte[] byArray3 = byArray2[n - 1];
            int n6 = 0;
            while (n6 < 256) {
                byArray3[n6] = (byte)n6;
                ++n6;
            }
        }
        return new LookupTableJAI(byArray2);
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        float f;
        int n = IIPCRIF.getOperationMask(parameterBlock);
        if ((n & 0x40) != 0) {
            return (Rectangle2D)parameterBlock.getObjectParameter(8);
        }
        if ((n & 0x20) != 0) {
            f = parameterBlock.getFloatParameter(7);
        } else {
            ParameterBlock parameterBlock2 = new ParameterBlock();
            int[] nArray = (int[])parameterBlock.getObjectParameter(1);
            parameterBlock2.add(parameterBlock.getObjectParameter(0));
            parameterBlock2.add(0).add(nArray[0]);
            RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
            int[] nArray2 = (int[])renderedOp.getProperty("max-size");
            f = (float)nArray2[0] / (float)nArray2[1];
        }
        return new Rectangle2D.Float(0.0f, 0.0f, f, 1.0f);
    }

    private static final double[][] getColorTwistMatrix(ColorModel colorModel, ParameterBlock parameterBlock) {
        float[] fArray = (float[])parameterBlock.getObjectParameter(3);
        double[][] dArray = new double[4][4];
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 4) {
                dArray[n2][n3] = fArray[n++];
                ++n3;
            }
            ++n2;
        }
        double[][] dArray2 = null;
        Object object = null;
        int n4 = colorModel.getColorSpace().getType();
        if (n4 == 6 || n4 == 5) {
            dArray2 = IIPCRIF.matrixMultiply(IIPCRIF.matrixMultiply(YCCA_TO_RGBA, dArray), RGBA_TO_YCCA);
            object = YCCA_TO_RGBA_CONST;
        } else {
            dArray2 = dArray;
            object = new double[][]{new double[1], new double[1], new double[1], new double[1]};
        }
        double[][] dArrayArray = null;
        double[][] dArrayArray2 = null;
        if (n4 == 6) {
            if (colorModel.hasAlpha()) {
                double[][] dArrayArray3 = new double[4][];
                double[] dArray3 = new double[2];
                dArray3[0] = 1.0;
                dArrayArray3[0] = dArray3;
                double[] dArray4 = new double[2];
                dArray4[0] = 1.0;
                dArrayArray3[1] = dArray4;
                double[] dArray5 = new double[2];
                dArray5[0] = 1.0;
                dArrayArray3[2] = dArray5;
                double[] dArray6 = new double[2];
                dArray6[1] = 1.0;
                dArrayArray3[3] = dArray6;
                dArrayArray = dArrayArray3;
                dArrayArray2 = new double[][]{new double[1], new double[1], new double[1], new double[1]};
            } else {
                dArrayArray = new double[][]{{1.0}, {1.0}, {1.0}, new double[1]};
                dArrayArray2 = new double[][]{new double[1], new double[1], new double[1], {255.0}};
            }
        } else if (!colorModel.hasAlpha()) {
            double[][] dArrayArray4 = new double[4][];
            double[] dArray7 = new double[3];
            dArray7[0] = 1.0;
            dArrayArray4[0] = dArray7;
            double[] dArray8 = new double[3];
            dArray8[1] = 1.0;
            dArrayArray4[1] = dArray8;
            double[] dArray9 = new double[3];
            dArray9[2] = 1.0;
            dArrayArray4[2] = dArray9;
            dArrayArray4[3] = new double[3];
            dArrayArray = dArrayArray4;
            dArrayArray2 = new double[][]{new double[1], new double[1], new double[1], {255.0}};
        } else {
            double[][] dArrayArray5 = new double[4][];
            double[] dArray10 = new double[4];
            dArray10[0] = 1.0;
            dArrayArray5[0] = dArray10;
            double[] dArray11 = new double[4];
            dArray11[1] = 1.0;
            dArrayArray5[1] = dArray11;
            double[] dArray12 = new double[4];
            dArray12[2] = 1.0;
            dArrayArray5[2] = dArray12;
            double[] dArray13 = new double[4];
            dArray13[3] = 1.0;
            dArrayArray5[3] = dArray13;
            dArrayArray = dArrayArray5;
            dArrayArray2 = new double[][]{new double[1], new double[1], new double[1], new double[1]};
        }
        boolean bl = false;
        if (n4 == 6 && fArray[4] == 0.0f && fArray[7] == 0.0f && fArray[8] == 0.0f && fArray[11] == 0.0f) {
            bl = true;
        }
        boolean bl2 = false;
        if (!colorModel.hasAlpha() && fArray[15] == 1.0f) {
            bl2 = true;
        }
        double[][] dArrayArray6 = null;
        if (bl2 && bl) {
            double[][] dArrayArray7 = new double[1][];
            double[] dArray14 = new double[4];
            dArray14[0] = 1.0;
            dArrayArray7[0] = dArray14;
            dArrayArray6 = dArrayArray7;
        } else if (bl) {
            double[][] dArrayArray8 = new double[2][];
            double[] dArray15 = new double[4];
            dArray15[0] = 1.0;
            dArrayArray8[0] = dArray15;
            double[] dArray16 = new double[4];
            dArray16[3] = 1.0;
            dArrayArray8[1] = dArray16;
            dArrayArray6 = dArrayArray8;
        } else if (bl2) {
            double[][] dArrayArray9 = new double[3][];
            double[] dArray17 = new double[4];
            dArray17[0] = 1.0;
            dArrayArray9[0] = dArray17;
            double[] dArray18 = new double[4];
            dArray18[1] = 1.0;
            dArrayArray9[1] = dArray18;
            double[] dArray19 = new double[4];
            dArray19[2] = 1.0;
            dArrayArray9[2] = dArray19;
            dArrayArray6 = dArrayArray9;
        } else {
            double[][] dArrayArray10 = new double[4][];
            double[] dArray20 = new double[4];
            dArray20[0] = 1.0;
            dArrayArray10[0] = dArray20;
            double[] dArray21 = new double[4];
            dArray21[1] = 1.0;
            dArrayArray10[1] = dArray21;
            double[] dArray22 = new double[4];
            dArray22[2] = 1.0;
            dArrayArray10[2] = dArray22;
            double[] dArray23 = new double[4];
            dArray23[3] = 1.0;
            dArrayArray10[3] = dArray23;
            dArrayArray6 = dArrayArray10;
        }
        double[][] dArray24 = IIPCRIF.matrixMultiply(dArrayArray6, dArray2);
        double[][] dArray25 = IIPCRIF.matrixMultiply(dArray24, dArrayArray);
        double[][] dArray26 = IIPCRIF.matrixMultiply(dArray24, dArrayArray2);
        double[][] dArray27 = IIPCRIF.matrixMultiply(dArray24, object);
        double[][] dArray28 = IIPCRIF.matrixMultiply(dArrayArray6, object);
        int n5 = 0;
        while (n5 < dArray26.length) {
            int n6 = 0;
            while (n6 < dArray26[n5].length) {
                double[] dArray29 = dArray26[n5];
                int n7 = n6;
                dArray29[n7] = dArray29[n7] + (dArray28[n5][n6] - dArray27[n5][n6]);
                ++n6;
            }
            ++n5;
        }
        return IIPCRIF.composeMatrices(dArray25, dArray26);
    }

    private static final int getOperationMask(ParameterBlock parameterBlock) {
        AffineTransform affineTransform;
        int n = 0;
        if (parameterBlock.getFloatParameter(2) != 0.0f) {
            n |= 1;
        }
        if (parameterBlock.getObjectParameter(3) != null) {
            n |= 2;
        }
        if (Math.abs(parameterBlock.getFloatParameter(4) - 1.0f) > 0.01f) {
            n |= 4;
        }
        if (parameterBlock.getObjectParameter(5) != null) {
            n |= 8;
        }
        if (!(affineTransform = (AffineTransform)parameterBlock.getObjectParameter(6)).isIdentity()) {
            n |= 0x10;
        }
        if (parameterBlock.getObjectParameter(7) != null) {
            n |= 0x20;
        }
        if (parameterBlock.getObjectParameter(8) != null) {
            n |= 0x40;
        }
        if (parameterBlock.getIntParameter(9) != 0) {
            n |= 0x80;
        }
        if (parameterBlock.getObjectParameter(10) != null) {
            n |= 0x100;
        }
        if (parameterBlock.getObjectParameter(11) != null) {
            n |= 0x200;
        }
        if (parameterBlock.getObjectParameter(12) != null) {
            n |= 0x400;
        }
        if (parameterBlock.getObjectParameter(13) != null) {
            n |= 0x800;
        }
        return n;
    }

    private static final int getServerCapabilityMask(String string, RenderedImage renderedImage) {
        Object object;
        int n = 255;
        int n2 = 0;
        if (renderedImage.getProperty("iip-server") != null && renderedImage.getProperty("iip-server") != Image.UndefinedProperty) {
            object = (String)renderedImage.getProperty("iip-server");
            int n3 = ((String)object).indexOf(".");
            n = Integer.valueOf(((String)object).substring(0, n3));
            n2 = Integer.valueOf(((String)object).substring(n3 + 1));
        }
        if (n2 != 127 && n != 0 && n != 1 && n != 2) {
            object = (int[])renderedImage.getProperty("max-size");
            String string2 = "&RGN=0.0,0.0," + 64.0f / (float)object[0] + "," + 64.0f / (float)object[1];
            if (IIPCRIF.canDecode(string, "&CNT=0.9&WID=64&CVT=JPEG", "JPEG")) {
                n2 = 21;
            } else if (IIPCRIF.canDecode(string, "&CNT=0.9&WID=64&CVT=FPX", "FPX")) {
                n2 = 42;
            } else if (IIPCRIF.canDecode(string, String.valueOf(string2) + "&CVT=JPEG", "JPEG")) {
                n2 = 5;
            } else if (IIPCRIF.canDecode(string, String.valueOf(string2) + "&CVT=FPX", "FPX")) {
                n2 = 10;
            }
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        double[][] dArray = IIPCRIF.matrixMultiply(RGBA_TO_YCCA, YCCA_TO_RGBA);
        n2 = dArray.length;
        n3 = dArray[0].length;
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                System.out.print(String.valueOf(dArray[n4][n]) + " ");
                ++n;
            }
            System.out.println("");
            ++n4;
        }
        System.out.println("");
        dArray = IIPCRIF.matrixMultiply(RGB_TO_YCC, YCC_TO_RGB);
        n2 = dArray.length;
        n3 = dArray[0].length;
        n = 0;
        while (n < n2) {
            int n5 = 0;
            while (n5 < n3) {
                System.out.print(String.valueOf(dArray[n][n5]) + " ");
                ++n5;
            }
            System.out.println("");
            ++n;
        }
        System.out.println("");
        double[][] dArrayArray = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}};
        double[][] dArray2 = IIPCRIF.composeMatrices(YCCA_TO_RGBA, dArrayArray);
        n2 = dArray2.length;
        n3 = dArray2[0].length;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                System.out.print(String.valueOf(dArray2[n6][n7]) + " ");
                ++n7;
            }
            System.out.println("");
            ++n6;
        }
        System.out.println("");
        double[][] dArray3 = IIPCRIF.matrixMultiply(RGBA_TO_YCCA, YCCA_TO_RGBA_CONST);
        n2 = dArray3.length;
        n3 = dArray3[0].length;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n3) {
                System.out.print(String.valueOf(-dArray3[n8][n9]) + " ");
                ++n9;
            }
            System.out.println("");
            ++n8;
        }
        System.out.println("");
        double[][] dArray4 = IIPCRIF.matrixMultiply(RGB_TO_YCC, YCC_TO_RGB_CONST);
        n2 = dArray4.length;
        n3 = dArray4[0].length;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            while (n11 < n3) {
                System.out.print(String.valueOf(-dArray4[n10][n11]) + " ");
                ++n11;
            }
            System.out.println("");
            ++n10;
        }
        System.out.println("");
    }

    private static final double[][] matrixMultiply(double[][] dArray, double[][] dArray2) {
        if (dArray[0].length != dArray2.length) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF0"));
        }
        int n = dArray.length;
        int n2 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2];
        int n3 = dArray[0].length;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                dArray3[n4][n5] = 0.0;
                int n6 = 0;
                while (n6 < n3) {
                    double[] dArray4 = dArray3[n4];
                    int n7 = n5;
                    dArray4[n7] = dArray4[n7] + dArray[n4][n6] * dArray2[n6][n5];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return dArray3;
    }

    private RenderedImage serverProc(int n, RenderContext renderContext, ParameterBlock parameterBlock, int n2, RenderedImage renderedImage) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        if ((n & 0x15) != 21 && (n & 0x2A) != 42 && (n & 5) != 5 && (n & 0xA) != 10) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        if ((n & 0x15) == 21) {
            bl2 = true;
            bl = true;
        } else if ((n & 0x2A) == 42) {
            bl = false;
            bl2 = true;
        } else if ((n & 5) == 5) {
            bl = true;
            bl2 = false;
        }
        StringBuffer stringBuffer = new StringBuffer((String)parameterBlock.getObjectParameter(0));
        if ((n2 & 1) != 0) {
            stringBuffer.append("&FTR=" + parameterBlock.getFloatParameter(2));
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append("&CTW=");
            object4 = (float[])parameterBlock.getObjectParameter(3);
            int n3 = 0;
            while (n3 < ((float[])object4).length) {
                stringBuffer.append(object4[n3]);
                if (n3 != ((Object)object4).length - 1) {
                    stringBuffer.append(",");
                }
                ++n3;
            }
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("&CNT=" + parameterBlock.getFloatParameter(4));
        }
        if ((n2 & 8) != 0) {
            object4 = (Rectangle2D)parameterBlock.getObjectParameter(5);
            stringBuffer.append("&ROI=" + ((RectangularShape)object4).getX() + "," + ((RectangularShape)object4).getY() + "," + ((RectangularShape)object4).getWidth() + "," + ((RectangularShape)object4).getHeight());
        }
        object4 = new AffineTransform();
        AffineTransform affineTransform = (AffineTransform)renderContext.getTransform().clone();
        if (affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0) {
            ((AffineTransform)object4).setToTranslation(affineTransform.getTranslateX(), affineTransform.getTranslateY());
            object3 = new double[6];
            affineTransform.getMatrix((double[])object3);
            affineTransform.setTransform(object3[0], object3[1], object3[2], object3[3], 0.0, 0.0);
        }
        object3 = null;
        if ((n2 & 0x40) != 0) {
            object3 = (Rectangle2D)parameterBlock.getObjectParameter(8);
        } else {
            float f = 1.0f;
            f = (n2 & 0x20) != 0 ? parameterBlock.getFloatParameter(7) : ((Float)renderedImage.getProperty("aspect-ratio")).floatValue();
            object3 = new Rectangle2D.Float(0.0f, 0.0f, f, 1.0f);
        }
        Rectangle rectangle = affineTransform.createTransformedShape((Shape)object3).getBounds();
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(rectangle.getWidth() / ((RectangularShape)object3).getWidth(), rectangle.getHeight() / ((RectangularShape)object3).getHeight());
        try {
            affineTransform.preConcatenate(affineTransform2.createInverse());
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF6"));
        }
        AffineTransform affineTransform3 = (AffineTransform)parameterBlock.getObjectParameter(6);
        try {
            affineTransform3.preConcatenate(affineTransform.createInverse());
        }
        catch (Exception exception) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF6"));
        }
        if (bl2) {
            stringBuffer.append("&WID=" + rectangle.width + "&HEI=" + rectangle.height);
        }
        double[] dArray = new double[6];
        affineTransform3.getMatrix(dArray);
        stringBuffer.append("&AFN=" + dArray[0] + "," + dArray[2] + ",0," + dArray[4] + "," + dArray[1] + "," + dArray[3] + ",0," + dArray[5] + ",0,0,1,0,0,0,0,1");
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("&RAR=" + parameterBlock.getFloatParameter(7));
        }
        if ((n2 & 0x40) != 0) {
            object2 = (Rectangle2D)parameterBlock.getObjectParameter(8);
            stringBuffer.append("&RGN=" + ((RectangularShape)object2).getX() + "," + ((RectangularShape)object2).getY() + "," + ((RectangularShape)object2).getWidth() + "," + ((RectangularShape)object2).getHeight());
        }
        if (bl2 && ((n2 & 0x80) != 0 || (n2 & 0x100) != 0)) {
            stringBuffer.append("&RFM=" + parameterBlock.getIntParameter(9));
            if ((n2 & 0x100) != 0) {
                object2 = (String)parameterBlock.getObjectParameter(10);
                if (((String)object2).equalsIgnoreCase("x")) {
                    stringBuffer.append(",0");
                } else {
                    stringBuffer.append(",90");
                }
            }
        }
        if (bl) {
            if ((n2 & 0x400) != 0) {
                stringBuffer.append("&QLT=" + parameterBlock.getIntParameter(12));
            }
            if ((n2 & 0x800) != 0) {
                stringBuffer.append("&CIN=" + parameterBlock.getIntParameter(13));
            }
        }
        object2 = bl ? "JPEG" : "FPX";
        stringBuffer.append("&CVT=" + (String)object2);
        InputStream inputStream = null;
        RenderedOp renderedOp = null;
        try {
            serializable = new URL(stringBuffer.toString());
            inputStream = serializable.openStream();
            object = new MemoryCacheSeekableStream(inputStream);
            renderedOp = JAI.create((String)object2, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(String.valueOf(exception.getClass())) + " " + exception.getMessage());
        }
        if (!bl2) {
            ((AffineTransform)object4).scale(rectangle.getWidth() / (double)renderedOp.getWidth(), rectangle.getHeight() / (double)renderedOp.getHeight());
        }
        if (!((AffineTransform)object4).isIdentity()) {
            serializable = Interpolation.getInstance(0);
            object = renderContext.getRenderingHints();
            if (object != null && ((RenderingHints)object).containsKey(JAI.KEY_INTERPOLATION)) {
                serializable = (Interpolation)((RenderingHints)object).get(JAI.KEY_INTERPOLATION);
            }
            renderedOp = JAI.create("affine", (RenderedImage)renderedOp, object4, (Object)serializable);
        }
        return renderedOp;
    }
}

