/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWhitespaceDetector;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWordDetector;
import com.insightful.splus.eclipse.editors.spluseditor.util.IColorManager;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusColorProvider;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SplusCodeScanner
extends RuleBasedScanner {
    static String[] fgKeywords = new String[]{"break", "else", "for", "function", "if", "in", "next", "repeat", "while"};
    private static String[] fgTypes = new String[]{"logical", "character", "numeric", "complex"};
    private static String[] fgConstants = new String[]{"F", "NULL", "NA", "T"};
    private static String[] fgUserDefined = new String[0];
    private Token fUserToken = null;
    private WholeWordRule fUserDef = null;
    private Vector fRulesType = new Vector();
    private Vector fRulesToken = new Vector();
    private IColorManager fColorManager;

    public SplusCodeScanner(SplusColorProvider splusColorProvider) {
        this.fColorManager = splusColorProvider;
        Token token = new Token((Object)new TextAttribute(splusColorProvider.getColor(splusColorProvider.KEYWORD)));
        Token token2 = new Token((Object)new TextAttribute(splusColorProvider.getColor(splusColorProvider.TYPE)));
        Token token3 = new Token((Object)new TextAttribute(splusColorProvider.getColor(splusColorProvider.CONSTANT)));
        Token token4 = new Token((Object)new TextAttribute(splusColorProvider.getColor(splusColorProvider.DEFAULT)));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new WhitespaceRule((IWhitespaceDetector)new SplusWhitespaceDetector()));
        this.fRulesType.add("splus_default");
        this.fRulesToken.add(token4);
        WholeWordRule wholeWordRule = new WholeWordRule(new SplusWordDetector());
        for (int i = 0; i < fgTypes.length; ++i) {
            wholeWordRule.addWord(fgTypes[i], (IToken)token2);
        }
        arrayList.add((Object)wholeWordRule);
        this.fRulesType.add("splus_type");
        this.fRulesToken.add(token2);
        WholeWordRule wholeWordRule2 = new WholeWordRule(new SplusWordDetector());
        for (int i = 0; i < fgConstants.length; ++i) {
            wholeWordRule2.addWord(fgConstants[i], (IToken)token3);
        }
        arrayList.add((Object)wholeWordRule2);
        this.fRulesType.add("splus_constant");
        this.fRulesToken.add(token3);
        WholeWordRule wholeWordRule3 = new WholeWordRule(new SplusWordDetector());
        for (int i = 0; i < fgKeywords.length; ++i) {
            wholeWordRule3.addWord(fgKeywords[i], (IToken)token);
        }
        arrayList.add((Object)wholeWordRule3);
        this.fRulesType.add("splus_keyword");
        this.fRulesToken.add(token);
        this.updateUserDefRule();
        arrayList.add((Object)this.fUserDef);
        this.fRulesType.add("user_defined");
        this.fRulesToken.add(this.fUserToken);
        IRule[] iRuleArray = new IRule[arrayList.size()];
        arrayList.toArray(iRuleArray);
        this.setRules(iRuleArray);
        this.setDefaultReturnToken((IToken)token4);
    }

    public void updateUserDefRule() {
        if (this.fUserDef == null) {
            this.fUserDef = new WholeWordRule(new SplusWordDetector());
        } else {
            this.fUserDef.clear();
        }
        if (this.fUserToken == null) {
            this.fUserToken = new Token((Object)new TextAttribute(this.fColorManager.getColor(((SplusColorProvider)this.fColorManager).USER)));
        }
        fgUserDefined = SplusEditorPreferencePage.getUserHighlightedText();
        for (int i = 0; i < fgUserDefined.length; ++i) {
            this.fUserDef.addWord(fgUserDefined[i], (IToken)this.fUserToken);
        }
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        return string.startsWith("splus_constant") || string.startsWith("splus_type") || string.startsWith("splus_default") || string.startsWith("splus_quote_string") || string.startsWith("splus_dbl_quote_string") || string.startsWith("splus_keyword") || string.startsWith("splus_comment_task_tag") || string.startsWith("user_defined") || string.startsWith("editorCustomHighlightedText");
    }

    private Token[] getTokens(String string) {
        Vector vector = new Vector();
        for (int i = 0; i < this.fRules.length; ++i) {
            String string2 = (String)this.fRulesType.get(i);
            if (!string.startsWith(string2)) continue;
            vector.add(this.fRulesToken.get(i));
        }
        Object[] objectArray = new Token[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.startsWith("editorCustomHighlightedText")) {
            this.updateUserDefRule();
        }
        Token[] tokenArray = this.getTokens(string);
        for (int i = 0; i < tokenArray.length; ++i) {
            this.adaptToColorChange(tokenArray[i], propertyChangeEvent);
            this.adaptToStyleChange(tokenArray[i], propertyChangeEvent, 1);
            this.adaptToStyleChange(tokenArray[i], propertyChangeEvent, 2);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            Object object2;
            String string = propertyChangeEvent.getProperty();
            if (this.fColorManager instanceof SplusColorProvider) {
                object2 = (SplusColorProvider)this.fColorManager;
                ((SplusColorProvider)object2).unbindColor(string);
                ((SplusColorProvider)object2).bindColor(string, rGB);
            }
            if ((object2 = token.getData()) instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(string), textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent, int n) {
        boolean bl = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if ("true".equals(object)) {
            bl = true;
        }
        Object object2 = token.getData();
        if (object2 instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object2;
            boolean bl3 = bl2 = (textAttribute.getStyle() & n) == n;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n));
            }
        }
    }

    private class WholeWordRule
    extends WordRule {
        public WholeWordRule(IWordDetector iWordDetector) {
            super(iWordDetector);
        }

        public void clear() {
            this.fWords.clear();
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            if (iCharacterScanner.getColumn() != 0) {
                iCharacterScanner.unread();
                int n = iCharacterScanner.read();
                if (this.fDetector.isWordStart((char)n)) {
                    return this.fDefaultToken;
                }
            }
            return super.evaluate(iCharacterScanner);
        }
    }
}

