/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;

public abstract class SplusIncrementalBuilder
extends IncrementalProjectBuilder {
    public static final String Q_EXT = "Q";
    public static final String SSC_EXT = "SSC";
    public static final String T_EXT = "T";
    public static final String DOT_DATA = ".Data";
    public static final String[] fDefaultExtensions = new String[]{"Q", "SSC", "T"};
    private static String[] fExtensions = null;
    private IProgressMonitor fMonitor = null;

    public void initialize() {
        SplusIncrementalBuilder.getBuildableExtensions();
    }

    public static void getBuildableExtensions() {
        if (fExtensions == null) {
            IFileEditorMapping[] iFileEditorMappingArray = SplusEditorPlugin.getDefault().getWorkbench().getEditorRegistry().getFileEditorMappings();
            Vector<String> vector = new Vector<String>();
            block0: for (int i = 0; i < iFileEditorMappingArray.length; ++i) {
                IEditorDescriptor[] iEditorDescriptorArray = iFileEditorMappingArray[i].getEditors();
                for (int j = 0; j < iEditorDescriptorArray.length; ++j) {
                    if (!iEditorDescriptorArray[j].getId().equals("org.eclipse.ui.SplusEditor")) continue;
                    vector.add(iFileEditorMappingArray[i].getExtension().toUpperCase());
                    continue block0;
                }
            }
            fExtensions = new String[vector.size()];
            vector.toArray(fExtensions);
        }
    }

    protected boolean checkCancel() {
        if (this.fMonitor == null) {
            return false;
        }
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this.isInterrupted();
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.fMonitor = iProgressMonitor;
        if (this.checkCancel()) {
            return null;
        }
        if (this.shouldInvoke(n)) {
            this.initialize();
            this.doBuildAction(iProgressMonitor);
        }
        return null;
    }

    protected boolean shouldInvoke(int n) {
        if (n == 6) {
            return true;
        }
        IResourceDelta iResourceDelta = this.getDelta(this.getProject());
        if (iResourceDelta == null) {
            return false;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        return iResourceDeltaArray.length != 0;
    }

    protected void doBuildAction(IProgressMonitor iProgressMonitor) {
        try {
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            this.fMonitor = iProgressMonitor;
            if (this.checkCancel()) {
                return;
            }
            if (iResourceDelta == null) {
                this.getProject().accept(this.getFullVisitor());
            } else {
                iResourceDelta.accept(this.getIncrementalVisitor());
            }
            SplusEditorPlugin.getDefault().updateResourceNavigator();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected abstract IResourceVisitor getFullVisitor();

    protected abstract IResourceDeltaVisitor getIncrementalVisitor();

    protected static boolean inStringList(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildable(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toUpperCase();
        return SplusIncrementalBuilder.inStringList(string2, fExtensions);
    }

    public static boolean ignoreChildren(IResource iResource) {
        boolean bl = iResource.getType() == 2 && iResource.getName().equals(DOT_DATA);
        return bl;
    }

    public static void addBuilderToProject(IProject iProject, String string) {
        IProjectDescription iProjectDescription;
        if (!iProject.isOpen()) {
            return;
        }
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return;
        }
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        for (int i = 0; i < iCommandArray.length; ++i) {
            if (!iCommandArray[i].getBuilderName().equals(string)) continue;
            return;
        }
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(string);
        ArrayList<ICommand> arrayList = new ArrayList<ICommand>();
        arrayList.addAll(Arrays.asList(iCommandArray));
        arrayList.add(iCommand);
        iProjectDescription.setBuildSpec(arrayList.toArray(new ICommand[arrayList.size()]));
        try {
            iProject.setDescription(iProjectDescription, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void removeBuilderFromProject(IProject iProject, String string) {
        IProjectDescription iProjectDescription;
        if (!iProject.isOpen()) {
            return;
        }
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return;
        }
        int n = -1;
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        for (int i = 0; i < iCommandArray.length; ++i) {
            if (!iCommandArray[i].getBuilderName().equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        ArrayList<ICommand> arrayList = new ArrayList<ICommand>();
        arrayList.addAll(Arrays.asList(iCommandArray));
        arrayList.remove(n);
        iProjectDescription.setBuildSpec(arrayList.toArray(new ICommand[arrayList.size()]));
        try {
            iProject.setDescription(iProjectDescription, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

