/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.util.StringUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class SplusFormatter
extends Action
implements IViewActionDelegate {
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    private int m_pos = 0;
    private SplusEditor m_editor = null;
    private static boolean g_createFunction = true;
    private StructuredSelection fSelection = null;

    public SplusFormatter(SplusEditor splusEditor) {
        this.m_editor = splusEditor;
    }

    public void run() {
        new Job("Formatting S-PLUS Code"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Formatting S-PLUS Code", 0);
                SplusFormatter.this.formatDocument(SplusFormatter.this.m_editor, iProgressMonitor);
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private String doFormatting(String string) {
        String string2 = this.doJavaParserFormat(string);
        if (string2 == null || string2.length() == 0) {
            string2 = this.doTextScannerFormat(string);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = this.doSplusFormat(string);
        }
        return string2;
    }

    private String doSplusFormat(String string) {
        SplusDataResult splusDataResult = null;
        String string2 = "";
        try {
            int n;
            CharSequence charSequence;
            File file = File.createTempFile("eclipse.format", "tmp");
            file.deleteOnExit();
            if (g_createFunction) {
                g_createFunction = false;
                charSequence = "\"eclipse.internal.format\"<-function(scode, file=tempfile(\"eclipse\"))\n{\nuSink <- sink(file)\nprint(parse(text=scode))\nsink(unsink.to=uSink)\ninvisible(NULL)\n}\n";
                splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery((String)charSequence);
            }
            charSequence = new StringBuffer();
            block10: for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                switch (n) {
                    case 92: {
                        ((StringBuffer)charSequence).append("\\\\");
                        continue block10;
                    }
                    case 39: {
                        ((StringBuffer)charSequence).append("\\'");
                        continue block10;
                    }
                    case 34: {
                        ((StringBuffer)charSequence).append("\\\"");
                        continue block10;
                    }
                    case 10: {
                        ((StringBuffer)charSequence).append("\\n");
                        continue block10;
                    }
                    case 13: {
                        ((StringBuffer)charSequence).append("\\r");
                        continue block10;
                    }
                    case 9: {
                        ((StringBuffer)charSequence).append("\\t");
                        continue block10;
                    }
                    default: {
                        ((StringBuffer)charSequence).append((char)n);
                    }
                }
            }
            String string3 = "eclipse.internal.format(\"{" + ((StringBuffer)charSequence).toString() + "}\", \"" + StringUtilities.escapeSpecialCharacters((String)file.getCanonicalPath()) + "\")";
            splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string3);
            string2 = SplusParseTreeBuilder.toString(file);
            n = string2.indexOf(123);
            int n2 = string2.lastIndexOf(125);
            string2 = string2.substring(n + 1, n2 - 1).replaceAll("\\n\\t", "\n");
            int n3 = 0;
            while (string2.startsWith("\n", n3)) {
                ++n3;
            }
            if (n3 != 0) {
                string2 = string2.substring(n3);
            }
            file.delete();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    private String doJavaParserFormat(String string) {
        return SplusParseTreeBuilder.doPrettyPrint(string);
    }

    private String doTextScannerFormat(String string) {
        return this.format(string);
    }

    private void formatDocument(SplusEditor splusEditor, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName("Formatting " + splusEditor.getTitle());
        }
        final IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
        final String string = iDocument.get();
        final String string2 = this.doFormatting(string);
        SplusEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    iDocument.replace(0, string.length(), string2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    private void formatFile(File file, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setTaskName("Formatting " + file.getName());
        String string = SplusParseTreeBuilder.toString(file);
        String string2 = this.doFormatting(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String format(String string) {
        String string2 = this.normalizeOperatorsSpacing(string);
        String string3 = this.reduceWhitespaceBlocks(string2, false);
        String string4 = this.stripPrecedingNewlines(string3);
        String string5 = this.stripTrailingNewlines(string4);
        String string6 = this.oldformat(string5, 0, 0, string5.length());
        if (!string6.endsWith(LINE_DELIMITER)) {
            return string6 + LINE_DELIMITER;
        }
        return string6;
    }

    private boolean isString(boolean bl, boolean bl2, String string, String string2) {
        return !bl && !bl2 && (!string.equals("\\") || string2.equals("\\"));
    }

    public String normalizeOperatorsSpacing(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            boolean bl5;
            int n;
            char c = string.charAt(i);
            String string4 = String.valueOf(c);
            boolean bl6 = false;
            switch (c) {
                case '#': {
                    if (bl3 || bl2) break;
                    bl = true;
                    break;
                }
                case '\"': {
                    if (!this.isString(bl, bl3, string2, string3)) break;
                    bl2 = !bl2;
                    break;
                }
                case '\'': {
                    if (!this.isString(bl, bl2, string2, string3)) break;
                    bl3 = !bl3;
                    break;
                }
                case '\n': {
                    bl = false;
                    break;
                }
                case '%': {
                    if (bl || bl2 || bl3) break;
                    if (bl4) {
                        stringBuffer.append(c);
                        bl6 = true;
                    }
                    bl4 = !bl4;
                    break;
                }
                case '!': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    if (!bl) {
                        stringBuffer.append(c);
                    }
                }
                case ',': 
                case '?': 
                case '^': 
                case '_': 
                case '~': {
                    bl6 = true;
                }
            }
            if (bl4 && !bl6) {
                stringBuffer.append(c);
                bl6 = true;
            }
            if (bl || bl3 || bl2) {
                n = stringBuffer.length();
                boolean bl7 = bl5 = n == 1 && stringBuffer.charAt(0) == c;
                if (n != 0) {
                    stringBuffer2.append(stringBuffer);
                    stringBuffer.setLength(0);
                }
                if (!bl5) {
                    stringBuffer2.append(c);
                }
            } else if (bl6) {
                if (stringBuffer.length() == 0) {
                    stringBuffer2.append(LINE_DELIMITER);
                    stringBuffer2.append(c);
                    stringBuffer2.append(LINE_DELIMITER);
                }
            } else {
                n = stringBuffer.length();
                if (n != 0) {
                    boolean bl8;
                    bl5 = n == 1 && stringBuffer.charAt(0) == '!';
                    boolean bl9 = bl8 = n == 1 && (stringBuffer.charAt(0) == '-' || stringBuffer.charAt(0) == '+');
                    if (!bl5 && !bl8) {
                        stringBuffer2.append(LINE_DELIMITER);
                    }
                    stringBuffer2.append(stringBuffer);
                    if (!bl5 && !bl8) {
                        stringBuffer2.append(LINE_DELIMITER);
                    }
                    stringBuffer.setLength(0);
                }
                stringBuffer2.append(c);
            }
            string3 = string2;
            string2 = string4;
        }
        return stringBuffer2.toString();
    }

    public String reduceWhitespaceBlocks(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string4;
            boolean bl6;
            char c = string.charAt(i);
            if (c == '\r') continue;
            String string5 = String.valueOf(c);
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            switch (c) {
                case '#': {
                    if (bl5 || bl4) break;
                    bl3 = true;
                    break;
                }
                case '\"': {
                    if (!this.isString(bl3, bl5, string2, string3)) break;
                    bl4 = !bl4;
                    break;
                }
                case '\'': {
                    if (!this.isString(bl3, bl4, string2, string3)) break;
                    bl5 = !bl5;
                    break;
                }
                case '{': {
                    if (bl3 || bl5 || bl4) break;
                    bl10 = true;
                    break;
                }
                case ' ': {
                    bl7 = true;
                    break;
                }
                case '\t': {
                    bl8 = !bl;
                    break;
                }
                case ';': {
                    if (bl3 || bl4 || bl5) break;
                    bl9 = true;
                    break;
                }
                case '\n': {
                    bl3 = false;
                    bl9 = true;
                }
            }
            boolean bl11 = bl6 = bl7 || bl8 || bl9 || bl10;
            if (bl3 || bl5 || bl4) {
                if (stringBuffer.length() != 0) {
                    string4 = stringBuffer.toString();
                    if (string4.indexOf("{") != -1) {
                        stringBuffer2.append(LINE_DELIMITER + "{");
                    } else if (string4.indexOf("\n") != -1) {
                        stringBuffer2.append(LINE_DELIMITER);
                    } else if (string4.indexOf(";") != -1) {
                        stringBuffer2.append(LINE_DELIMITER);
                    }
                    stringBuffer.setLength(0);
                }
                stringBuffer2.append(string5);
                bl6 = false;
            } else if (bl6) {
                if (bl10) {
                    stringBuffer2.append(LINE_DELIMITER + "{");
                    stringBuffer.setLength(0);
                    bl10 = false;
                } else if (bl2) {
                    stringBuffer.append(string5);
                } else {
                    stringBuffer.append(string5);
                }
            } else if (bl2) {
                string4 = stringBuffer.toString();
                if (string4.indexOf("{") != -1) {
                    stringBuffer2.append(LINE_DELIMITER + "{");
                } else if (string4.indexOf("\n") != -1) {
                    stringBuffer2.append(LINE_DELIMITER);
                } else if (string4.indexOf(";") != -1) {
                    stringBuffer2.append(LINE_DELIMITER);
                } else {
                    stringBuffer2.append(" ");
                }
                stringBuffer2.append(string5);
                stringBuffer.setLength(0);
            } else {
                stringBuffer2.append(string5);
            }
            bl2 = bl6;
            string3 = string2;
            string2 = string5;
        }
        return stringBuffer2.toString();
    }

    public String stripPrecedingNewlines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r') continue;
            String string4 = String.valueOf(c);
            boolean bl7 = c == '\n';
            boolean bl8 = c == '{';
            switch (c) {
                case '#': {
                    if (bl5 || bl4) break;
                    bl3 = true;
                    break;
                }
                case '\"': {
                    if (!this.isString(bl3, bl5, string2, string3)) break;
                    bl4 = !bl4;
                    break;
                }
                case '\'': {
                    if (!this.isString(bl3, bl4, string2, string3)) break;
                    bl5 = !bl5;
                    break;
                }
                case '\n': {
                    if (bl3) {
                        bl6 = true;
                    }
                    bl3 = false;
                    break;
                }
                case '!': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '|': 
                case '}': 
                case '~': {
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (bl3 || bl5 || bl4) {
                if (bl) {
                    stringBuffer.append(LINE_DELIMITER);
                }
                stringBuffer.append(c);
            } else if (bl) {
                if (bl2) {
                    if (bl6) {
                        stringBuffer.append(LINE_DELIMITER);
                    } else if (c != '}' && c != ')' && c != ']') {
                        stringBuffer.append(" ");
                    }
                } else {
                    stringBuffer.append(LINE_DELIMITER);
                }
                if (c != '\n') {
                    stringBuffer.append(string4);
                }
            } else if (!bl7) {
                if (bl8) {
                    stringBuffer.append(LINE_DELIMITER);
                }
                stringBuffer.append(string4);
            }
            if (!bl7) {
                bl6 = false;
            }
            bl = bl7;
            string3 = string2;
            string2 = string4;
        }
        return stringBuffer.toString();
    }

    public String stripTrailingNewlines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r') continue;
            String string4 = String.valueOf(c);
            boolean bl7 = c == '\n';
            boolean bl8 = false;
            switch (c) {
                case '#': {
                    if (!bl6 && !bl5) {
                        bl4 = true;
                    }
                    bl2 = false;
                    break;
                }
                case '\"': {
                    if (this.isString(bl4, bl6, string2, string3)) {
                        bl5 = !bl5;
                    }
                    bl2 = false;
                    break;
                }
                case '\'': {
                    if (this.isString(bl4, bl5, string2, string3)) {
                        bl6 = !bl6;
                    }
                    bl2 = false;
                    break;
                }
                case '\n': {
                    bl4 = false;
                    break;
                }
                case '(': 
                case '[': {
                    bl8 = true;
                }
                case '!': 
                case '$': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '^': 
                case '_': 
                case '|': 
                case '~': {
                    bl2 = !bl4;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            stringBuffer.append(string2);
            string3 = string2;
            if (bl4 || bl6 || bl5) {
                string2 = string4;
            } else if (bl7) {
                if (!bl) {
                    stringBuffer.append(LINE_DELIMITER);
                } else if (!bl3) {
                    stringBuffer.append(" ");
                }
                string2 = "";
            } else {
                string2 = string4;
            }
            bl = bl2;
            bl3 = bl8;
        }
        if (!string2.equals("\n") && !string2.equals("\r")) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void addTabs(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
    }

    public String oldformat(String string, int n, int n2, int n3) {
        this.m_pos = n2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        String string3 = "";
        int n4 = 0;
        while (this.m_pos < n3) {
            boolean bl5;
            char c = string.charAt(this.m_pos);
            switch (c) {
                case '#': {
                    if (bl4 || bl3) break;
                    bl2 = true;
                    break;
                }
                case '\"': {
                    if (!this.isString(bl2, bl4, string2, string3)) break;
                    bl3 = !bl3;
                    break;
                }
                case '\'': {
                    if (!this.isString(bl2, bl3, string2, string3)) break;
                    bl4 = !bl4;
                }
            }
            boolean bl6 = bl5 = bl2 || bl4 || bl3;
            if (c == '\n') {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(LINE_DELIMITER);
                    this.addTabs(n + n4, stringBuffer);
                }
                bl = true;
                bl2 = false;
            } else if (c != '\r') {
                if (c == '{' && !bl5) {
                    stringBuffer.append(c);
                    stringBuffer.append(LINE_DELIMITER);
                    this.addTabs(n + 1 + n4, stringBuffer);
                    stringBuffer.append(this.oldformat(string, n + 1 + n4, ++this.m_pos, n3));
                    stringBuffer.append(LINE_DELIMITER);
                    this.addTabs(n + n4, stringBuffer);
                    stringBuffer.append('}');
                    bl = false;
                } else {
                    if (c == '}' && !bl5) break;
                    if (c != ' ' || !bl || bl5) {
                        if (c == '(' && !bl5) {
                            stringBuffer.append(c);
                            n4 += 2;
                        } else if (c == ')' && !bl5) {
                            stringBuffer.append(c);
                            n4 -= 2;
                        } else {
                            stringBuffer.append(c);
                            bl = false;
                        }
                    }
                }
            }
            string3 = string2;
            string2 = String.valueOf(c);
            ++this.m_pos;
        }
        return stringBuffer.toString();
    }

    public SplusFormatter() {
    }

    public void init(IViewPart iViewPart) {
    }

    public void run(IAction iAction) {
        IWorkbenchPage iWorkbenchPage = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        final IAction iAction2 = iAction;
        new Job("Formatting S-PLUS Code"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Format S-PLUS Code", 0);
                SplusFormatter.this.doIActionRun(iAction2, iEditorReferenceArray, iProgressMonitor);
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void doIActionRun(IAction iAction, IEditorReference[] iEditorReferenceArray, IProgressMonitor iProgressMonitor) {
        IFileEditorMapping[] iFileEditorMappingArray = SplusEditorPlugin.getDefault().getWorkbench().getEditorRegistry().getFileEditorMappings();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: for (int i = 0; i < iFileEditorMappingArray.length; ++i) {
            Object object = iFileEditorMappingArray[i].getEditors();
            for (int j = 0; j < ((IEditorDescriptor[])object).length; ++j) {
                if (!object[j].getId().equals("org.eclipse.ui.SplusEditor")) continue;
                String string = iFileEditorMappingArray[i].getExtension().toUpperCase();
                hashMap.put(string, string);
                continue block0;
            }
        }
        for (Object object : this.fSelection) {
            if (!(object instanceof IResource)) continue;
            this.doResourceFormatting((IResource)object, iEditorReferenceArray, iProgressMonitor, hashMap);
        }
    }

    private void doResourceFormatting(IResource iResource, IEditorReference[] iEditorReferenceArray, IProgressMonitor iProgressMonitor, HashMap hashMap) {
        if (iResource instanceof IFile) {
            String string = ((IFile)iResource).getLocation().getFileExtension();
            File file = new File(((IFile)iResource).getLocation().toString());
            if (file.canWrite() && string != null && hashMap.get(string.toUpperCase()) != null) {
                FileEditorInput fileEditorInput = new FileEditorInput((IFile)iResource);
                boolean bl = false;
                for (int i = 0; i < iEditorReferenceArray.length; ++i) {
                    IEditorPart iEditorPart = iEditorReferenceArray[i].getEditor(false);
                    if (iEditorPart == null || !iEditorPart.getEditorInput().equals(fileEditorInput)) continue;
                    this.formatDocument((SplusEditor)iEditorPart, iProgressMonitor);
                    bl = true;
                }
                if (!bl) {
                    this.formatFile(file, iProgressMonitor);
                }
            }
        } else if (iResource instanceof IContainer) {
            try {
                IResource[] iResourceArray = ((IContainer)iResource).members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    this.doResourceFormatting(iResourceArray[i], iEditorReferenceArray, iProgressMonitor, hashMap);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection instanceof StructuredSelection ? (StructuredSelection)iSelection : new StructuredSelection((Object)iSelection);
    }
}

