/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.graph.SWTGraphFrame;
import com.insightful.splus.graph.CanvasTabbedPane;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class SWTGraphView
extends ViewPart {
    public static String ID = "com.insightful.splus.eclipse.graph.SWTGraphView";
    private static int g_secondaryID = 0;
    private static Vector g_views = new Vector();
    private Composite m_viewComposite;
    private SCanvas m_canvas;
    private CanvasTabbedPane m_tabs;
    private SWTGraphFrame.SWTJavaGraphHandler m_handler;

    public static int getNextSecondaryID() {
        return g_secondaryID++;
    }

    private static void addView(SWTGraphView sWTGraphView) {
        g_views.add(sWTGraphView);
    }

    private static void removeView(SWTGraphView sWTGraphView) {
        g_views.remove((Object)sWTGraphView);
    }

    public static void hideViews() {
        int n = g_views.size();
        int n2 = 0;
        while (n2 < g_views.size() && n2 < n) {
            SWTGraphView sWTGraphView = (SWTGraphView)((Object)g_views.get(n2));
            IWorkbenchPage iWorkbenchPage = sWTGraphView.getViewSite().getPage();
            if (iWorkbenchPage != null) {
                iWorkbenchPage.hideView((IViewPart)sWTGraphView);
            }
            if (g_views.size() != n) continue;
            ++n2;
        }
    }

    public SWTGraphView() {
        SWTGraphView.addView(this);
    }

    public void setData(SCanvas sCanvas) {
        this.m_canvas = sCanvas;
        this.setPartName(SWTGraphFrame.SWTJavaGraphHandler.getTitle(null));
        this.m_handler = new SWTJavaGraphViewHandler(this.m_viewComposite.getShell(), this.m_viewComposite, this.m_canvas, this);
        this.m_handler.registerJavaGraph();
    }

    public void setData(SCanvas[] sCanvasArray) {
        this.m_canvas = sCanvasArray[0];
        this.setPartName(SWTGraphFrame.SWTJavaGraphHandler.getTitle(null));
        this.m_handler = new SWTJavaGraphViewHandler(this.m_viewComposite.getShell(), this.m_viewComposite, this.m_canvas, this);
        for (int i = 1; i < sCanvasArray.length; ++i) {
            this.m_handler.addCanvas(sCanvasArray[i]);
        }
        this.m_handler.registerJavaGraph();
    }

    public void dispose() {
        if (this.m_handler != null) {
            this.m_handler.deregisterJavaGraph();
        }
        super.dispose();
        SWTGraphView.removeView(this);
    }

    public void createPartControl(Composite composite) {
        this.m_viewComposite = new Composite(composite, 0x1000000);
        this.m_viewComposite.setLayout((Layout)new GridLayout(1, false));
    }

    public void setFocus() {
        if (this.m_handler != null && this.m_handler.getTabbedPane() != null) {
            this.m_handler.getTabbedPane().grabFocus();
        }
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
    }

    private static class SWTJavaGraphViewHandler
    extends SWTGraphFrame.SWTJavaGraphHandler {
        private SWTGraphView m_view = null;

        public SWTJavaGraphViewHandler(Shell shell, Composite composite, SCanvas sCanvas, SWTGraphView sWTGraphView) {
            super(shell, composite, sCanvas);
            this.m_view = sWTGraphView;
            this.createMenuBar();
        }

        public void doClose() {
            Display display = !this.m_shell.isDisposed() ? this.m_shell.getDisplay() : (Display.getCurrent() != null ? Display.getCurrent() : (Display.getDefault() != null ? Display.getDefault() : SplusEditorPlugin.getDefault().getWorkbench().getDisplay()));
            display.syncExec(new Runnable(){

                public void run() {
                    if (SWTJavaGraphViewHandler.this.m_view != null) {
                        IWorkbenchPage iWorkbenchPage = SWTJavaGraphViewHandler.this.m_view.getViewSite().getPage();
                        iWorkbenchPage.hideView((IViewPart)SWTJavaGraphViewHandler.this.m_view);
                        SWTJavaGraphViewHandler.this.m_view = null;
                    }
                }
            });
        }

        public void shellClosed(ShellEvent shellEvent) {
            if (this.m_view != null) {
                super.shellClosed(shellEvent);
            }
        }

        protected void createMenuBar() {
            int n;
            if (this.m_view == null) {
                return;
            }
            IActionBars iActionBars = this.m_view.getViewSite().getActionBars();
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            MenuManager menuManager = new MenuManager("F&ile", "File");
            iMenuManager.add((IContributionItem)menuManager);
            String[] stringArray = this.getFileStrings();
            String[] stringArray2 = this.getFileAccelerators();
            SelectionAdapter[] selectionAdapterArray = this.getFileAdapters();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("Close")) continue;
                menuManager.add((IAction)new JavaGraphViewMenuAction(stringArray[i], stringArray2[i].charAt(0), selectionAdapterArray[i]));
            }
            menuManager = new MenuManager("V&iew", "View");
            iMenuManager.add((IContributionItem)menuManager);
            MenuManager menuManager2 = new MenuManager("Zoom Graph");
            menuManager.add((IContributionItem)menuManager2);
            stringArray = this.getZoomStrings();
            selectionAdapterArray = this.getZoomAdapters();
            for (n = 0; n < stringArray.length; ++n) {
                menuManager.add((IAction)new JavaGraphViewMenuAction(stringArray[n], selectionAdapterArray[n]));
            }
            menuManager = new MenuManager("Op&tions", "Options");
            iMenuManager.add((IContributionItem)menuManager);
            stringArray = this.getOptionsStrings();
            stringArray2 = this.getOptionsAccelerators();
            selectionAdapterArray = this.getOptionsAdapters();
            for (n = 0; n < stringArray.length; ++n) {
                menuManager.add((IAction)new JavaGraphViewMenuAction(stringArray[n], stringArray2[n].charAt(0), selectionAdapterArray[n]));
            }
            iActionBars.updateActionBars();
        }

        private class JavaGraphViewMenuAction
        extends Action {
            private String m_text;
            private char m_accelerator = '\u0000';
            private SelectionAdapter m_selected;

            public JavaGraphViewMenuAction(String string, SelectionAdapter selectionAdapter) {
                this.m_text = string;
                this.m_selected = selectionAdapter;
            }

            public JavaGraphViewMenuAction(String string, char c, SelectionAdapter selectionAdapter) {
                this(string, selectionAdapter);
                this.m_accelerator = c;
            }

            public int getAccelerator() {
                return this.m_accelerator;
            }

            public String getText() {
                return this.m_text;
            }

            public void run() {
                this.m_selected.widgetSelected(null);
            }
        }
    }
}

