/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.util.ISplusColorConstants;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusColorProvider;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.preferences.util.SplusStringListEditor;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class SplusEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ISplusColorConstants {
    public static final String P_SHOW_LINE_NUM = "lineNumberRuler";
    public static final String P_CUSTOM_HIGHLIGHTED_TEXT = "editorCustomHighlightedText";
    public static final String P_CUSTOM_BACKGROUND = "editorCustomBackground";
    public static final String P_BACKGROUND_COLOR = "editorBackgroundFont";
    public static final String P_HOVER = "splusHover";
    public static final String P_COMMENT_COLOR = "splus_single_line_comment";
    public static final String P_CONSTANT_COLOR = "splus_constant";
    public static final String P_TYPE_COLOR = "splus_type";
    public static final String P_KEYWORD_COLOR = "splus_keyword";
    public static final String P_QUOTE_STRING_COLOR = "splus_quote_string";
    public static final String P_DBL_QUOTE_STRING_COLOR = "splus_dbl_quote_string";
    public static final String P_TASK_COLOR = "splus_comment_task_tag";
    public static final String P_OTHER_COLOR = "splus_default";
    public static final String P_USER_COLOR = "user_defined";
    public static final String P_FORMAT_MARGIN = "editorFormatMargin";
    public static final String P_FORMAT_USE_SPACES = "editorFormatUseSpaces";
    public static final String P_FORMAT_SPACES = "editorFormatSpaces";
    public static final String P_FORMAT_SCOPE_ENCAP = "editorFormatScopeEncapsulation";
    public static final String P_FORMAT_CURLY = "editorFormatCurlyBrace";
    private static final String[] SYNTAX_STRINGS = new String[]{"splus_default", "splus_single_line_comment", "splus_keyword", "splus_quote_string", "splus_dbl_quote_string", "splus_constant", "splus_type", "splus_comment_task_tag", "user_defined"};
    private static final String[] SYNTAX_TYPES = new String[]{"Default", "Comment", "Keyword", "Quoted String", "Dbl Quoted String", "Constant", "Type", "Task", "User"};
    public static boolean m_defaultsCreated = false;
    private FormattingOptions m_formattingOptions;
    private ColorFieldEditor fSyntaxForegroundColorEditor;
    private Composite fSyntaxForegroundColorEditorParent;
    private TableViewer fHighlightingColorListViewer;

    public SplusEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.setDescription("Spotfire S+ Editor options");
        this.initializeDefaults();
    }

    public static boolean showLineNumbers() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        boolean bl = EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_SHOW_LINE_NUM);
        return bl;
    }

    public static int getFormatMargin() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        int n = EditorsPlugin.getDefault().getPluginPreferences().getInt(P_FORMAT_MARGIN);
        return n;
    }

    public static boolean getFormatUseSpaces() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        boolean bl = EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_FORMAT_USE_SPACES);
        return bl;
    }

    public static int getFormatNumSpaces() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        int n = EditorsPlugin.getDefault().getPluginPreferences().getInt(P_FORMAT_SPACES);
        return n;
    }

    public static boolean getFormatScopeEncapsulated() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        boolean bl = EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_FORMAT_SCOPE_ENCAP);
        return bl;
    }

    public static boolean getFormatNewlinePerCurlyBrace() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        boolean bl = EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_FORMAT_CURLY);
        return bl;
    }

    public static Color getBackground() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        if (!EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_CUSTOM_BACKGROUND)) {
            return null;
        }
        String string = EditorsPlugin.getDefault().getPluginPreferences().getString(P_BACKGROUND_COLOR);
        return SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(SplusEditorPreferencePage.stringToRGB(string));
    }

    public static boolean getHoverEvaluation() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        boolean bl = EditorsPlugin.getDefault().getPluginPreferences().getBoolean(P_HOVER);
        return bl;
    }

    public static RGB getRGB(String string) {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        String string2 = EditorsPlugin.getDefault().getPluginPreferences().getString(string);
        String string3 = EditorsPlugin.getDefault().getPluginPreferences().getDefaultString(string);
        return SplusEditorPreferencePage.stringToRGB(string2);
    }

    public static String stripRGB(String string) {
        if (string.startsWith("RGB {")) {
            return string.substring(5, string.length() - 1);
        }
        return string.replaceAll(" ", "");
    }

    public static RGB stringToRGB(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(SplusEditorPreferencePage.stripRGB(string), ",");
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        return new RGB(n, n2, n3);
    }

    public static String[] getUserHighlightedText() {
        if (!m_defaultsCreated) {
            new SplusEditorPreferencePage();
        }
        String string = EditorsPlugin.getDefault().getPluginPreferences().getString(P_CUSTOM_HIGHLIGHTED_TEXT);
        String[] stringArray = SplusPreferencePage.convertFromCommaSepList(string);
        return stringArray;
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(P_SHOW_LINE_NUM, true);
        iPreferenceStore.setDefault(P_CUSTOM_BACKGROUND, false);
        iPreferenceStore.setDefault(P_BACKGROUND_COLOR, "0,0,0");
        iPreferenceStore.setDefault(P_FORMAT_MARGIN, 60);
        iPreferenceStore.setDefault(P_FORMAT_SPACES, 4);
        iPreferenceStore.setDefault(P_FORMAT_CURLY, true);
        iPreferenceStore.setDefault(P_FORMAT_SCOPE_ENCAP, true);
        iPreferenceStore.setDefault(P_FORMAT_USE_SPACES, false);
        iPreferenceStore.setDefault(P_HOVER, true);
        iPreferenceStore.setDefault(P_COMMENT_COLOR, this.rgbToString(new RGB(0, 128, 64)));
        iPreferenceStore.setDefault(P_KEYWORD_COLOR, this.rgbToString(new RGB(0, 0, 128)));
        iPreferenceStore.setDefault(P_TYPE_COLOR, this.rgbToString(new RGB(0, 0, 128)));
        iPreferenceStore.setDefault(P_CONSTANT_COLOR, this.rgbToString(new RGB(0, 0, 128)));
        iPreferenceStore.setDefault(P_QUOTE_STRING_COLOR, this.rgbToString(new RGB(42, 0, 255)));
        iPreferenceStore.setDefault(P_DBL_QUOTE_STRING_COLOR, this.rgbToString(new RGB(42, 0, 255)));
        iPreferenceStore.setDefault(P_TASK_COLOR, this.rgbToString(new RGB(127, 159, 191)));
        iPreferenceStore.setDefault(P_OTHER_COLOR, this.rgbToString(new RGB(0, 0, 0)));
        iPreferenceStore.setDefault(P_USER_COLOR, this.rgbToString(new RGB(128, 0, 0)));
        iPreferenceStore.setDefault(P_CUSTOM_HIGHLIGHTED_TEXT, "");
        m_defaultsCreated = true;
    }

    public String rgbToString(RGB rGB) {
        return Integer.toString(rGB.red) + "," + Integer.toString(rGB.green) + "," + Integer.toString(rGB.blue);
    }

    public void createFieldEditors() {
        Composite composite = new Composite(this.getFieldEditorParent(), 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.createSyntaxPage(composite);
        composite.layout();
        this.createUserDefinedList(composite);
        Composite composite2 = this.createHoverEvaluationOptions(this.getFieldEditorParent());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.m_formattingOptions = this.createAutoFormattingOptions(this.getFieldEditorParent());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.m_formattingOptions.setLayoutData(gridData);
    }

    public boolean performOk() {
        return this.saveSyntaxInfo() && super.performOk();
    }

    public void performApply() {
        this.saveSyntaxInfo();
        super.performApply();
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_formattingOptions.updateFormattedExampleText();
    }

    private Control createSyntaxPage(Composite composite) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Syntax Highlighting");
        Composite composite2 = new Composite((Composite)group, 16);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        this.fHighlightingColorListViewer = new TableViewer(composite4, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)new GridData(768));
        Object[] objectArray = new Object[SYNTAX_TYPES.length];
        for (int i = 0; i < SYNTAX_TYPES.length; ++i) {
            objectArray[i] = new ColorListItem(SYNTAX_TYPES[i], SYNTAX_STRINGS[i], null);
        }
        this.fHighlightingColorListViewer.setInput((Object)objectArray);
        Composite composite5 = new Composite(composite3, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite5.setLayoutData((Object)gridData);
        this.fSyntaxForegroundColorEditor = new ColorFieldEditor("", "Choose Color", composite5);
        this.fSyntaxForegroundColorEditorParent = composite5;
        this.fSyntaxForegroundColorEditor.setPreferenceStore(iPreferenceStore);
        this.fSyntaxForegroundColorEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (!propertyChangeEvent.getOldValue().equals(object)) {
                        ColorListItem colorListItem = SplusEditorPreferencePage.this.getHighlightingColorListItem();
                        colorListItem.color = SplusEditorPlugin.getDefault().getSplusColorProvider().getColor((RGB)object);
                        SplusEditorPreferencePage.this.fHighlightingColorListViewer.refresh();
                    }
                }
            }
        });
        this.fSyntaxForegroundColorEditor.setEnabled(false, composite5);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SplusEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        return group;
    }

    private Composite createUserDefinedList(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        group.setText("User Tokens");
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        HighlightTextList highlightTextList = new HighlightTextList(P_CUSTOM_HIGHLIGHTED_TEXT, "", composite2, this);
        List list = highlightTextList.getListControl(composite2);
        this.addField(highlightTextList);
        GridData gridData = new GridData(768);
        gridData.heightHint = this.fHighlightingColorListViewer.getControl().getSize().y;
        list.setLayoutData((Object)gridData);
        return group;
    }

    private Composite createHoverEvaluationOptions(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        group.setText("Hover");
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.addField((FieldEditor)new BooleanFieldEditor(P_HOVER, "Evaluate expression and display value if engine available", composite2));
        return group;
    }

    private FormattingOptions createAutoFormattingOptions(Composite composite) {
        return new FormattingOptions(this, composite);
    }

    private boolean saveSyntaxInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = this.fHighlightingColorListViewer.getTable().getItemCount();
        for (int i = 0; i < n; ++i) {
            ColorListItem colorListItem = (ColorListItem)this.fHighlightingColorListViewer.getTable().getItem(i).getData();
            String string = this.rgbToString(colorListItem.color.getRGB());
            iPreferenceStore.setValue(colorListItem.id, string);
        }
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.restoreSyntaxDefaults();
    }

    private void restoreSyntaxDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = this.fHighlightingColorListViewer.getTable().getItemCount();
        SplusColorProvider splusColorProvider = SplusEditorPlugin.getDefault().getSplusColorProvider();
        for (int i = 0; i < n; ++i) {
            ColorListItem colorListItem = (ColorListItem)this.fHighlightingColorListViewer.getTable().getItem(i).getData();
            String string = colorListItem.id;
            String string2 = iPreferenceStore.getDefaultString(string);
            colorListItem.color = splusColorProvider.getColor(SplusEditorPreferencePage.stringToRGB(string2));
        }
        this.fHighlightingColorListViewer.refresh();
        this.handleSyntaxColorListSelection();
    }

    private void handleSyntaxColorListSelection() {
        ColorListItem colorListItem = this.getHighlightingColorListItem();
        if (colorListItem != null) {
            this.fSyntaxForegroundColorEditor.setPreferenceName(colorListItem.id);
            this.fSyntaxForegroundColorEditor.getColorSelector().setColorValue(colorListItem.color.getRGB());
            this.fSyntaxForegroundColorEditor.setEnabled(true, this.fSyntaxForegroundColorEditorParent);
        }
    }

    private ColorListItem getHighlightingColorListItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (ColorListItem)iStructuredSelection.getFirstElement();
    }

    private class FormattingOptions
    extends Composite
    implements Listener {
        private Text m_exampleText;
        private ListenableBooleanFieldEditor m_encap;
        private ListenableBooleanFieldEditor m_newline;
        private ListenableBooleanFieldEditor m_spaces;
        private IntegerFieldEditor m_nSpaces;
        private IntegerFieldEditor m_margin;
        private String FORMAT_EXAMPLE;

        public FormattingOptions(FieldEditorPreferencePage fieldEditorPreferencePage, Composite composite) {
            super(composite, 0);
            this.FORMAT_EXAMPLE = "if (x == 1) {\n  print(\"x == 1\")\n} else print(\"x != 1\")";
            this.setLayout((Layout)new GridLayout(1, false));
            this.setLayoutData(new GridData(1808));
            this.createAutoFormattingOptions(this);
        }

        private Composite createAutoFormattingOptions(Composite composite) {
            int n = 2;
            Group group = new Group(composite, 16);
            group.setLayout((Layout)new GridLayout(n, false));
            group.setLayoutData((Object)new GridData(1808));
            Composite composite2 = this.createFieldEditorComposite((Composite)group, n);
            this.m_margin = new IntegerFieldEditor(SplusEditorPreferencePage.P_FORMAT_MARGIN, "Margin Column", composite2);
            SplusEditorPreferencePage.this.addField((FieldEditor)this.m_margin);
            group.setText("Spotfire S+ Format Options");
            Composite composite3 = this.createFieldEditorComposite((Composite)group, n / 2, false);
            Composite composite4 = this.createFieldEditorComposite((Composite)group, n / 2);
            this.m_spaces = new ListenableBooleanFieldEditor(SplusEditorPreferencePage.P_FORMAT_USE_SPACES, "Use Spaces for indentation", composite3);
            this.m_nSpaces = new IntegerFieldEditor(SplusEditorPreferencePage.P_FORMAT_SPACES, "", composite4);
            SplusEditorPreferencePage.this.addField((FieldEditor)this.m_spaces);
            SplusEditorPreferencePage.this.addField((FieldEditor)this.m_nSpaces);
            this.m_encap = new ListenableBooleanFieldEditor(SplusEditorPreferencePage.P_FORMAT_SCOPE_ENCAP, "Encapsulate all scope blocks with {}", this.createFieldEditorComposite((Composite)group, n));
            SplusEditorPreferencePage.this.addField((FieldEditor)this.m_encap);
            this.m_newline = new ListenableBooleanFieldEditor(SplusEditorPreferencePage.P_FORMAT_CURLY, "Start each scope block on a new line", this.createFieldEditorComposite((Composite)group, n));
            SplusEditorPreferencePage.this.addField((FieldEditor)this.m_newline);
            this.m_exampleText = new Text((Composite)group, 2818);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = n;
            this.m_exampleText.setLayoutData((Object)gridData);
            this.m_exampleText.setEditable(false);
            final Text text = this.m_nSpaces.getTextControl(composite4);
            Button button = this.m_spaces.getCheckbox();
            text.setEnabled(SplusEditorPreferencePage.getFormatUseSpaces());
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    boolean bl = ((Button)event.widget).getSelection();
                    text.setEnabled(bl);
                }
            });
            this.m_spaces.getCheckbox().addListener(13, (Listener)this);
            this.m_encap.getCheckbox().addListener(13, (Listener)this);
            this.m_newline.getCheckbox().addListener(13, (Listener)this);
            this.m_nSpaces.getTextControl(composite4).addListener(24, (Listener)this);
            this.m_margin.getTextControl(composite2).addListener(24, (Listener)this);
            this.m_exampleText.setText(this.FORMAT_EXAMPLE);
            return group;
        }

        private Composite createFieldEditorComposite(Composite composite, int n) {
            return this.createFieldEditorComposite(composite, n, true);
        }

        private Composite createFieldEditorComposite(Composite composite, int n, boolean bl) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(n, false));
            if (bl) {
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = n;
                composite2.setLayoutData((Object)gridData);
            }
            return composite2;
        }

        public void handleEvent(Event event) {
            this.updateFormattedExampleText();
        }

        private void updateFormattedExampleText() {
            try {
                boolean bl = this.m_encap.getCheckbox().getSelection();
                boolean bl2 = this.m_newline.getCheckbox().getSelection();
                boolean bl3 = this.m_spaces.getCheckbox().getSelection();
                int n = this.m_nSpaces.getIntValue();
                int n2 = this.m_margin.getIntValue();
                String string = SplusParseTreeBuilder.doPrettyPrint(this.FORMAT_EXAMPLE, n2, bl3, n, bl2, bl);
                this.m_exampleText.setText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class ListenableBooleanFieldEditor
        extends BooleanFieldEditor {
            private Composite m_parent;

            public ListenableBooleanFieldEditor(String string, String string2, Composite composite) {
                super(string, string2, composite);
                this.m_parent = composite;
            }

            public Button getCheckbox() {
                return this.getChangeControl(this.m_parent);
            }
        }
    }

    private static class HighlightTextList
    extends SplusStringListEditor {
        public HighlightTextList(String string, String string2, Composite composite, FieldEditorPreferencePage fieldEditorPreferencePage) {
            super(string, string2, composite, fieldEditorPreferencePage);
        }

        protected String getNewTitle() {
            return "Add Desired S-PLUS Text";
        }

        protected String getNewMessage() {
            return "S-PLUS Text to Highlight";
        }
    }

    private class ColorListItem {
        public String name;
        public String id;
        public Color color;

        public ColorListItem(String string, String string2, Color color) {
            this.id = string2;
            this.name = string;
            this.color = color;
            if (this.color == null) {
                String string3 = EditorsPlugin.getDefault().getPluginPreferences().getString(this.id).replaceAll(" ", "");
                this.color = SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(SplusEditorPreferencePage.stringToRGB(string3));
            }
        }
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object object) {
            return (Object[])object;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object object) {
            return ((ColorListItem)object).name;
        }

        public Color getForeground(Object object) {
            return ((ColorListItem)object).color;
        }

        public Color getBackground(Object object) {
            return null;
        }
    }
}

